/*
 * Decompiled with CFR 0.152.
 */
package com.nomagic.magicdraw.uml2.util;

import com.nomagic.annotation.OpenApiAll;
import com.nomagic.magicdraw.uml2.util.ModelEStoreEList;
import java.util.Collection;
import java.util.Iterator;
import javax.annotation.CheckForNull;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;

@OpenApiAll
public class SubsetSupersetEObjectEStoreEList<E>
extends ModelEStoreEList<E> {
    private static final long serialVersionUID = 1L;
    protected final int[] supersetFeatureIDs;
    protected final int[] subsetFeatureIDs;
    protected Class<?> dataClass;

    public SubsetSupersetEObjectEStoreEList(Class<?> dataClass, InternalEObject owner, int featureID, @CheckForNull int[] supersetFeatureIDs, @CheckForNull int[] subsetFeatureIDs) {
        super(owner, owner.eClass().getEStructuralFeature(featureID));
        this.dataClass = dataClass;
        this.supersetFeatureIDs = supersetFeatureIDs;
        this.subsetFeatureIDs = subsetFeatureIDs;
    }

    protected boolean enforceSubsetConstraints() {
        Resource.Internal eInternalResource = this.owner.eInternalResource();
        return eInternalResource == null || !eInternalResource.isLoading();
    }

    protected void supersetAdd(Object object) {
        if (this.supersetFeatureIDs != null && this.enforceSubsetConstraints()) {
            EClass eClass = this.owner.eClass();
            int i = 0;
            while (i < this.supersetFeatureIDs.length) {
                EList supersetEList;
                EStructuralFeature supersetEStructuralFeature = eClass.getEStructuralFeature(this.supersetFeatureIDs[i]);
                if (supersetEStructuralFeature.isMany() && !(supersetEList = (EList)this.owner.eGet(supersetEStructuralFeature)).contains(object)) {
                    supersetEList.add(object);
                }
                ++i;
            }
        }
    }

    protected void replaceOrAddToSuperset(Object oldObject, Object object) {
        if (oldObject == object) {
            return;
        }
        if (this.supersetFeatureIDs != null && this.enforceSubsetConstraints()) {
            EClass eClass = this.owner.eClass();
            int i = 0;
            while (i < this.supersetFeatureIDs.length) {
                EStructuralFeature supersetEStructuralFeature = eClass.getEStructuralFeature(this.supersetFeatureIDs[i]);
                if (supersetEStructuralFeature.isMany()) {
                    EList supersetEList = (EList)this.owner.eGet(supersetEStructuralFeature);
                    int oldValueIndex = supersetEList.indexOf(oldObject);
                    if (oldValueIndex == -1) {
                        if (!supersetEList.contains(object)) {
                            supersetEList.add(object);
                        }
                    } else {
                        int newValueIndex = supersetEList.indexOf(object);
                        if (newValueIndex == -1) {
                            supersetEList.set(oldValueIndex, object);
                        } else {
                            supersetEList.remove(oldValueIndex);
                            int size = supersetEList.size();
                            int index = oldValueIndex >= size ? size - 1 : oldValueIndex;
                            supersetEList.move(index, object);
                        }
                    }
                }
                ++i;
            }
        }
    }

    protected boolean enforceSupersetConstraints() {
        return true;
    }

    protected void subsetRemove(Object object) {
        if (this.subsetFeatureIDs != null && this.enforceSupersetConstraints()) {
            int i = 0;
            while (i < this.subsetFeatureIDs.length) {
                EStructuralFeature subsetEStructuralFeature = this.owner.eClass().getEStructuralFeature(this.subsetFeatureIDs[i]);
                if (subsetEStructuralFeature.isMany()) {
                    EList list = (EList)this.owner.eGet(subsetEStructuralFeature);
                    list.remove(object);
                } else if (object.equals(this.owner.eGet(subsetEStructuralFeature))) {
                    this.owner.eSet(subsetEStructuralFeature, null);
                }
                ++i;
            }
        }
    }

    public NotificationChain basicAdd(E object, NotificationChain notifications) {
        notifications = super.basicAdd(object, notifications);
        this.supersetAdd(object);
        return notifications;
    }

    public NotificationChain basicSet(int index, E object, NotificationChain notifications) {
        Object oldObject = this.get(index);
        notifications = super.basicSet(index, object, notifications);
        this.supersetAdd(object);
        if (oldObject != object) {
            this.subsetRemove(oldObject);
        }
        return notifications;
    }

    @Override
    public void add(int index, E object) {
        super.add(index, object);
        this.supersetAdd(object);
    }

    public boolean add(E object) {
        boolean result = super.add(object);
        this.supersetAdd(object);
        return result;
    }

    public boolean addAll(Collection<? extends E> collection) {
        boolean result = super.addAll(collection);
        Iterator<E> elements = collection.iterator();
        while (elements.hasNext()) {
            this.supersetAdd(elements.next());
        }
        return result;
    }

    public boolean addAll(int index, Collection<? extends E> collection) {
        boolean result = super.addAll(index, collection);
        Iterator<E> elements = collection.iterator();
        while (elements.hasNext()) {
            this.supersetAdd(elements.next());
        }
        return result;
    }

    public E set(int index, E object) {
        Object result = super.set(index, object);
        this.replaceOrAddToSuperset(result, object);
        if (result != object) {
            this.subsetRemove(result);
        }
        return (E)result;
    }

    protected void didRemove(int index, E oldObject) {
        super.didRemove(index, oldObject);
        this.subsetRemove(oldObject);
    }

    protected EObject resolve(int index, EObject eObject) {
        EObject resolved = this.resolveProxy(eObject);
        if (resolved != eObject) {
            Object oldObject = this.delegateGet(index);
            EObject resolvedElement = resolved;
            this.delegateSet(index, this.validate(index, resolvedElement));
            Object oldElement = oldObject;
            this.didSet(index, resolvedElement, oldElement);
            if (this.isContainment()) {
                EObject element = eObject;
                NotificationChain notificationChain = this.inverseRemove(element, null);
                if (((InternalEObject)resolved).eInternalContainer() == null) {
                    notificationChain = this.inverseAdd(resolvedElement, notificationChain);
                }
                if (notificationChain != null) {
                    notificationChain.dispatch();
                }
            }
            if (this.isNotificationRequired()) {
                this.dispatchNotification((Notification)this.createNotification(9, eObject, resolved, index, false));
            }
            return resolved;
        }
        return eObject;
    }
}

