/*
 * Decompiled with CFR 0.152.
 */
package com.nomagic.magicdraw.uml2.util;

import com.nomagic.annotation.OpenApiAll;
import java.util.concurrent.atomic.AtomicReference;

@OpenApiAll
class SingleThreadLocalMarker {
    private final AtomicReference<Thread> markedThread = new AtomicReference<Object>(null);

    SingleThreadLocalMarker() {
    }

    Thread mark() {
        Thread prevThread = this.markedThread.get();
        if (prevThread != Thread.currentThread()) {
            while (!this.markedThread.compareAndSet(null, Thread.currentThread())) {
                Thread.yield();
            }
            return null;
        }
        return prevThread;
    }

    void reset(Thread previousValue) {
        this.markedThread.set(previousValue);
    }

    boolean isMarked() {
        return this.markedThread.get() == Thread.currentThread();
    }
}

