/*
 * Decompiled with CFR 0.152.
 */
package com.nomagic.magicdraw.uml2.util;

import com.nomagic.annotation.OpenApiAll;
import com.nomagic.magicdraw.foundation.util.AccessGuard;
import com.nomagic.magicdraw.foundation.util.Operation;
import com.nomagic.magicdraw.uml2.util.EventSupporterImpl;
import com.nomagic.magicdraw.uml2.util.SingleThreadLocalMarker;
import com.nomagic.magicdraw.uml2.util.UML2ModelUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.EObjectEList;

@OpenApiAll
public class ModelEObjectEList<E>
extends EObjectEList<E> {
    private static final long serialVersionUID = 1L;
    private static final SingleThreadLocalMarker suppressNotifications = new SingleThreadLocalMarker();

    public ModelEObjectEList(Class<?> dataClass, InternalEObject owner, int featureID) {
        super(dataClass, owner, featureID);
    }

    protected String getPropertyEventName(Object value) {
        return EventSupporterImpl.getInstance().getPropertyEventName((EStructuralFeature.Setting)this, value);
    }

    protected final void beforeChange(String featureName) {
        EventSupporterImpl.getInstance().beforeChange((EStructuralFeature.Setting)this, featureName);
    }

    protected final void afterChange() {
        EventSupporterImpl.getInstance().afterChange((EStructuralFeature.Setting)this);
    }

    protected final void startLogEvents() {
        EventSupporterImpl.getInstance().startLogEvents((EStructuralFeature.Setting)this);
    }

    protected final void stopLogEvents() {
        EventSupporterImpl.getInstance().stopLogEvents((EStructuralFeature.Setting)this);
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue, int index) {
        EventSupporterImpl.getInstance().firePropertyChange((EStructuralFeature.Setting)this, propertyName, oldValue, newValue, index);
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue, int index, List<E> oldValueList) {
        EventSupporterImpl.getInstance().firePropertyChange((EStructuralFeature.Setting)this, propertyName, oldValue, newValue, index, oldValueList);
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue, int index, int newIndex, List<E> oldValueList) {
        EventSupporterImpl.getInstance().firePropertyChange((EStructuralFeature.Setting)this, propertyName, oldValue, newValue, index, newIndex, oldValueList);
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue, int index, int newIndex) {
        EventSupporterImpl.getInstance().firePropertyChange((EStructuralFeature.Setting)this, propertyName, oldValue, newValue, index, newIndex);
    }

    protected final boolean isRawMode() {
        return EventSupporterImpl.getInstance().isRawMode((EStructuralFeature.Setting)this);
    }

    protected final E assign(int index, E object) {
        if (suppressNotifications.isMarked()) {
            return (E)super.assign(index, object);
        }
        String featureName = this.getPropertyEventName(object);
        this.beforeChange(featureName);
        ArrayList oldValueList = null;
        boolean attribute = this.getEStructuralFeature() instanceof EAttribute;
        if (attribute) {
            oldValueList = new ArrayList(this);
        }
        try {
            Object old = this.data[index];
            super.assign(index, object);
            if (old == null ? object != null : !old.equals(object)) {
                if (attribute) {
                    this.firePropertyChange(featureName, old, object, index, oldValueList);
                } else {
                    this.firePropertyChange(featureName, old, null, index);
                    this.firePropertyChange(featureName, null, object, index);
                }
            }
            E e = object;
            return e;
        }
        finally {
            this.afterChange();
        }
    }

    public void addUniqueSuppressNotifications(E object) {
        Thread prevValue = suppressNotifications.mark();
        try {
            super.doAddUnique(object);
        }
        finally {
            suppressNotifications.reset(prevValue);
        }
    }

    protected E doRemove(int index) {
        Object old = this.basicGet(index);
        String featureName = this.getPropertyEventName(old);
        this.beforeChange(featureName);
        ArrayList oldValueList = null;
        boolean attribute = this.getEStructuralFeature() instanceof EAttribute;
        if (attribute) {
            oldValueList = new ArrayList(this);
        }
        try {
            old = super.doRemove(index);
            if (attribute) {
                this.firePropertyChange(featureName, old, null, index, -1, oldValueList);
            } else {
                this.firePropertyChange(featureName, old, null, index, -1);
            }
            Object object = old;
            return object;
        }
        finally {
            this.afterChange();
        }
    }

    public void clear() {
        int s = this.size();
        while (s > 0) {
            this.remove(s - 1);
            int s2 = this.size();
            if (s2 == s) break;
            s = s2;
        }
    }

    protected boolean hasInverse() {
        EStructuralFeature feature = this.getEStructuralFeature();
        if (feature instanceof EReference) {
            EReference reference = (EReference)feature;
            if (reference.isContainment()) {
                return true;
            }
            return reference.getEOpposite() != null;
        }
        return false;
    }

    protected boolean hasNavigableInverse() {
        EStructuralFeature feature = this.getEStructuralFeature();
        if (feature instanceof EReference) {
            EReference reference = (EReference)feature;
            return reference.getEOpposite() != null;
        }
        return false;
    }

    protected boolean hasManyInverse() {
        EReference inverseEReference = this.getInverseEReference();
        return inverseEReference != null && inverseEReference.isMany();
    }

    public void addUnique(final E object) {
        AccessGuard.execute((EObject)this.owner, (Operation)new Operation<Void>(){

            public Void call() {
                try {
                    ModelEObjectEList.this.startLogEvents();
                    ModelEObjectEList.super.addUnique(object);
                }
                finally {
                    ModelEObjectEList.this.stopLogEvents();
                }
                return null;
            }
        });
    }

    protected E validate(int index, E object) {
        super.validate(index, object);
        UML2ModelUtil.checkCompatibility((EObject)this.owner, this.getEStructuralFeature(), object);
        return object;
    }

    public void addUnique(final int index, final E object) {
        AccessGuard.execute((EObject)this.owner, (Operation)new Operation<Void>(){

            public Void call() {
                try {
                    ModelEObjectEList.this.startLogEvents();
                    ModelEObjectEList.super.addUnique(index, object);
                    return null;
                }
                finally {
                    ModelEObjectEList.this.stopLogEvents();
                }
            }
        });
    }

    public E setUnique(final int index, final E object) {
        return (E)AccessGuard.execute((EObject)this.owner, (Operation)new Operation<E>(){

            public E call() {
                try {
                    ModelEObjectEList.this.startLogEvents();
                    Object object2 = ModelEObjectEList.super.setUnique(index, object);
                    return object2;
                }
                finally {
                    ModelEObjectEList.this.stopLogEvents();
                }
            }
        });
    }

    public E move(final int targetIndex, final int sourceIndex) {
        return (E)AccessGuard.execute((EObject)this.owner, (Operation)new Operation<E>(){

            public E call() {
                try {
                    ModelEObjectEList.this.startLogEvents();
                    Object object = ModelEObjectEList.super.move(targetIndex, sourceIndex);
                    return object;
                }
                finally {
                    ModelEObjectEList.this.stopLogEvents();
                }
            }
        });
    }

    public boolean addAllUnique(final int index, final Collection<? extends E> collection) {
        return (Boolean)AccessGuard.execute((EObject)this.owner, (Operation)new Operation<Boolean>(){

            public Boolean call() {
                try {
                    ModelEObjectEList.this.startLogEvents();
                    Boolean bl = ModelEObjectEList.super.addAllUnique(index, collection);
                    return bl;
                }
                finally {
                    ModelEObjectEList.this.stopLogEvents();
                }
            }
        });
    }

    public E remove(final int index) {
        return (E)AccessGuard.execute((EObject)this.owner, (Operation)new Operation<E>(){

            public E call() {
                try {
                    ModelEObjectEList.this.startLogEvents();
                    Object object = ModelEObjectEList.super.remove(index);
                    return object;
                }
                finally {
                    ModelEObjectEList.this.stopLogEvents();
                }
            }
        });
    }

    public boolean removeAll(final Collection<?> collection) {
        return (Boolean)AccessGuard.execute((EObject)this.owner, (Operation)new Operation<Boolean>(){

            public Boolean call() {
                try {
                    ModelEObjectEList.this.startLogEvents();
                    Boolean bl = ModelEObjectEList.super.removeAll(collection);
                    return bl;
                }
                finally {
                    ModelEObjectEList.this.stopLogEvents();
                }
            }
        });
    }

    public E basicGet(final int index) {
        return (E)AccessGuard.execute((EObject)this.owner, (Operation)new Operation<E>(){

            public E call() {
                return ModelEObjectEList.super.basicGet(index);
            }
        });
    }

    public List<E> basicList() {
        return (List)AccessGuard.execute((EObject)this.owner, (Operation)new Operation<List<E>>(){

            public List<E> call() {
                return ModelEObjectEList.super.basicList();
            }
        });
    }

    public Object[] basicToArray() {
        return (Object[])AccessGuard.execute((EObject)this.owner, (Operation)new Operation<Object[]>(){

            public Object[] call() {
                return ModelEObjectEList.super.basicToArray();
            }
        });
    }

    public <T> T[] basicToArray(final T[] array) {
        return (Object[])AccessGuard.execute((EObject)this.owner, (Operation)new Operation<T[]>(){

            public T[] call() {
                return ModelEObjectEList.super.basicToArray(array);
            }
        });
    }

    public int size() {
        return (Integer)AccessGuard.execute((EObject)this.owner, (Operation)new Operation<Integer>(){

            public Integer call() {
                return ModelEObjectEList.super.size();
            }
        });
    }

    public int basicIndexOf(final Object object) {
        return (Integer)AccessGuard.execute((EObject)this.owner, (Operation)new Operation<Integer>(){

            public Integer call() {
                return ModelEObjectEList.super.basicIndexOf(object);
            }
        });
    }

    public int basicLastIndexOf(final Object object) {
        return (Integer)AccessGuard.execute((EObject)this.owner, (Operation)new Operation<Integer>(){

            public Integer call() {
                return ModelEObjectEList.super.basicLastIndexOf(object);
            }
        });
    }

    public boolean basicContains(final Object object) {
        return (Boolean)AccessGuard.execute((EObject)this.owner, (Operation)new Operation<Boolean>(){

            public Boolean call() {
                return ModelEObjectEList.super.basicContains(object);
            }
        });
    }

    public boolean basicContainsAll(final Collection<?> collection) {
        return (Boolean)AccessGuard.execute((EObject)this.owner, (Operation)new Operation<Boolean>(){

            public Boolean call() {
                return ModelEObjectEList.super.basicContainsAll(collection);
            }
        });
    }

    public int indexOf(final Object object) {
        return (Integer)AccessGuard.execute((EObject)this.owner, (Operation)new Operation<Integer>(){

            public Integer call() {
                return ModelEObjectEList.super.indexOf(object);
            }
        });
    }

    public boolean contains(final Object object) {
        return (Boolean)AccessGuard.execute((EObject)this.owner, (Operation)new Operation<Boolean>(){

            public Boolean call() {
                return ModelEObjectEList.super.contains(object);
            }
        });
    }

    public NotificationChain basicAdd(final E object, final NotificationChain notifications) {
        return (NotificationChain)AccessGuard.execute((EObject)this.owner, (Operation)new Operation<NotificationChain>(){

            public NotificationChain call() {
                return ModelEObjectEList.super.basicAdd(object, notifications);
            }
        });
    }

    public E get(final int index) {
        return (E)AccessGuard.execute((EObject)this.owner, (Operation)new Operation<E>(){

            public E call() {
                return ModelEObjectEList.super.get(index);
            }
        });
    }

    public boolean isEmpty() {
        return (Boolean)AccessGuard.execute((EObject)this.owner, (Operation)new Operation<Boolean>(){

            public Boolean call() {
                return ModelEObjectEList.super.isEmpty();
            }
        });
    }

    public int lastIndexOf(final Object object) {
        return (Integer)AccessGuard.execute((EObject)this.owner, (Operation)new Operation<Integer>(){

            public Integer call() {
                return ModelEObjectEList.super.lastIndexOf(object);
            }
        });
    }

    protected E primitiveGet(final int index) {
        return (E)AccessGuard.execute((EObject)this.owner, (Operation)new Operation<E>(){

            public E call() {
                return ModelEObjectEList.super.primitiveGet(index);
            }
        });
    }

    protected E doMove(int targetIndex, int sourceIndex) {
        if (targetIndex >= this.size) {
            throw new IndexOutOfBoundsException("targetIndex=" + targetIndex + ", size=" + this.size);
        }
        if (sourceIndex >= this.size) {
            throw new IndexOutOfBoundsException("sourceIndex=" + sourceIndex + ", size=" + this.size);
        }
        Object source = this.data[sourceIndex];
        String featureName = this.getPropertyEventName(source);
        this.beforeChange(featureName);
        try {
            E object = this.doMoveInternal(targetIndex, sourceIndex);
            this.firePropertyChange(featureName, source, null, sourceIndex);
            this.firePropertyChange(featureName, null, source, targetIndex);
            E e = object;
            return e;
        }
        finally {
            this.afterChange();
        }
    }

    private E doMoveInternal(int targetIndex, int sourceIndex) {
        ++this.modCount;
        Object object = this.data[sourceIndex];
        if (targetIndex != sourceIndex) {
            if (targetIndex < sourceIndex) {
                System.arraycopy(this.data, targetIndex, this.data, targetIndex + 1, sourceIndex - targetIndex);
            } else {
                System.arraycopy(this.data, sourceIndex + 1, this.data, sourceIndex, targetIndex - sourceIndex);
            }
            this.data[targetIndex] = object;
            this.didMove(targetIndex, object, sourceIndex);
            this.didChange();
        }
        return (E)object;
    }
}

