/*
 * Decompiled with CFR 0.152.
 */
package com.nomagic.magicdraw.uml2.util;

import com.nomagic.annotation.OpenApiAll;
import com.nomagic.uml2.ext.magicdraw.classes.mdkernel.LiteralBoolean;
import com.nomagic.uml2.ext.magicdraw.classes.mdkernel.LiteralInteger;
import com.nomagic.uml2.ext.magicdraw.classes.mdkernel.LiteralReal;
import com.nomagic.uml2.ext.magicdraw.classes.mdkernel.LiteralString;
import com.nomagic.uml2.ext.magicdraw.classes.mdkernel.LiteralUnlimitedNatural;
import com.nomagic.uml2.ext.magicdraw.classes.mdkernel.NamedElement;
import org.apache.log4j.or.ObjectRenderer;

@OpenApiAll
public class ElementRenderer
implements ObjectRenderer {
    public String doRender(Object o) {
        String name;
        if (o instanceof LiteralBoolean) {
            String value = Boolean.toString(((LiteralBoolean)o).isValue());
            if (value != null && value.length() > 0) {
                return this.renderWithText(o, value);
            }
        } else if (o instanceof LiteralInteger) {
            String value = Integer.toString(((LiteralInteger)o).getValue());
            if (value != null && value.length() > 0) {
                return this.renderWithText(o, value);
            }
        } else if (o instanceof LiteralString) {
            String value = ((LiteralString)o).getValue();
            if (value != null && value.length() > 0) {
                return this.renderWithText(o, value);
            }
        } else if (o instanceof LiteralReal) {
            String value = Double.toString(((LiteralReal)o).getValue());
            if (value != null && value.length() > 0) {
                return this.renderWithText(o, value);
            }
        } else if (o instanceof LiteralUnlimitedNatural) {
            String value = Integer.toString(((LiteralUnlimitedNatural)o).getValue());
            if (value != null && value.length() > 0) {
                return this.renderWithText(o, value);
            }
        } else if (o instanceof NamedElement && (name = ((NamedElement)o).getName()) != null && name.length() > 0) {
            return this.renderWithText(o, name);
        }
        return o.toString();
    }

    private String renderWithText(Object o, String text) {
        StringBuilder textBuilder = new StringBuilder(text);
        if (textBuilder.length() > 80) {
            textBuilder.setLength(77);
            textBuilder.append("...");
        }
        int i = 0;
        int length = textBuilder.length();
        while (i < length) {
            char ch = textBuilder.charAt(i);
            if (ch < ' ') {
                textBuilder.setCharAt(i, '~');
            }
            ++i;
        }
        return String.valueOf(o.toString()) + "." + textBuilder;
    }
}

