/*
 * Decompiled with CFR 0.152.
 */
package com.nomagic.magicdraw.uml2.util;

import com.nomagic.annotation.OpenApiAll;
import com.nomagic.magicdraw.uml2.util.UML2ModelUtil;
import com.nomagic.uml2.ext.magicdraw.metadata.UMLPackage;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;

@OpenApiAll
final class CompatibilityUtil {
    private CompatibilityUtil() {
    }

    @Nonnull
    public static Collection<EClassifier> getCompatibleTypes(@Nonnull EClass eClass, @Nonnull EStructuralFeature feature) {
        EReference reference;
        EReference opposite;
        if (eClass.getEPackage() != UMLPackage.eINSTANCE) {
            throw new IllegalArgumentException("Only EClass from UMLPackage are supported.");
        }
        if (!eClass.getEAllStructuralFeatures().contains((Object)feature)) {
            throw new IllegalArgumentException("The feature '" + feature.getName() + "' is not contained by the class '" + eClass.getName() + "' or one of it super classes.");
        }
        if (!feature.isChangeable()) {
            throw new IllegalArgumentException("The feature '" + feature.getName() + "' is read-only.");
        }
        if (feature.isDerived()) {
            throw new IllegalArgumentException("The feature '" + feature.getName() + "' is derived.");
        }
        HashSet<EClassifier> compatibleTypes = new HashSet<EClassifier>(CompatibilityUtil.getCompatibleTypesInternal(eClass, feature, new HashSet<EStructuralFeature>()));
        if (feature instanceof EReference && (opposite = (reference = (EReference)feature).getEOpposite()) != null) {
            Iterator iterator = compatibleTypes.iterator();
            while (iterator.hasNext()) {
                EClassifier compatibleType = (EClassifier)iterator.next();
                if (!(compatibleType instanceof EClass)) continue;
                EClass compatibleEClass = (EClass)compatibleType;
                Collection<EClassifier> oppositeCompatibleTypes = CompatibilityUtil.getCompatibleTypesInternal(compatibleEClass, (EStructuralFeature)opposite, new HashSet<EStructuralFeature>());
                boolean compatibleFound = false;
                for (EClassifier oppositeCompatibleType : oppositeCompatibleTypes) {
                    if (!UML2ModelUtil.isAssignableFrom(oppositeCompatibleType, (EClassifier)eClass)) continue;
                    compatibleFound = true;
                    break;
                }
                if (compatibleFound) continue;
                iterator.remove();
            }
        }
        return compatibleTypes;
    }

    @Nonnull
    private static Collection<EClassifier> getCompatibleTypesInternal(@Nonnull EClass eClass, @Nonnull EStructuralFeature feature, @Nonnull Set<EStructuralFeature> visited) {
        EStructuralFeature redefinition1 = UML2ModelUtil.getRedefinition(eClass, feature);
        if (redefinition1 != null && !redefinition1.isDerived()) {
            feature = redefinition1;
        }
        ArrayDeque<EStructuralFeature> forAnalysis = new ArrayDeque<EStructuralFeature>();
        forAnalysis.add(feature);
        HashMap<EStructuralFeature, FeatureNode> nodeMap = new HashMap<EStructuralFeature, FeatureNode>();
        while (!forAnalysis.isEmpty()) {
            boolean derivedUnion;
            EStructuralFeature current = (EStructuralFeature)forAnalysis.poll();
            FeatureNode currentNode = CompatibilityUtil.getFeatureNode(nodeMap, current);
            if (!visited.add(current)) continue;
            EStructuralFeature currentFeatureRedefinition = UML2ModelUtil.getRedefinition(eClass, current);
            if (currentFeatureRedefinition != null && !currentFeatureRedefinition.isDerived()) {
                forAnalysis.add(currentFeatureRedefinition);
                FeatureNode redefinitionNode = CompatibilityUtil.getFeatureNode(nodeMap, currentFeatureRedefinition);
                currentNode.addAnalysisTransition(redefinitionNode, AnalysisTransition.Reason.REDEFINITION);
            }
            if (derivedUnion = UML2ModelUtil.isDerivedUnion(current)) {
                List<EStructuralFeature> list = UML2ModelUtil.getSubsetFeatures(eClass, current, true, true);
                for (EStructuralFeature subsetFeature : list) {
                    forAnalysis.add(subsetFeature);
                    FeatureNode subsetFeatureNode = CompatibilityUtil.getFeatureNode(nodeMap, subsetFeature);
                    currentNode.addAnalysisTransition(subsetFeatureNode, AnalysisTransition.Reason.SUBSET_OF_DERIVED_UNION);
                }
            }
            if (derivedUnion || !(current instanceof EReference) || !UML2ModelUtil.isSubsets((EReference)current)) continue;
            List<EStructuralFeature> list = UML2ModelUtil.getSubsettedFeatures(current);
            for (EStructuralFeature subsettedFeature : list) {
                if (subsettedFeature.isDerived()) continue;
                forAnalysis.add(subsettedFeature);
                FeatureNode subsettedFeatureNode = CompatibilityUtil.getFeatureNode(nodeMap, subsettedFeature);
                currentNode.addAnalysisTransition(subsettedFeatureNode, AnalysisTransition.Reason.SUPERSET_OF_SUBSET);
            }
        }
        FeatureNode root = (FeatureNode)nodeMap.get(feature);
        if (root.transitions == null || root.transitions.isEmpty()) {
            if (feature.isDerived()) {
                return Collections.emptySet();
            }
            return Collections.singleton(feature.getEType());
        }
        HashSet<EClassifier> result = new HashSet<EClassifier>();
        ArrayList<List<AnalysisTransition>> paths = new ArrayList<List<AnalysisTransition>>();
        for (AnalysisTransition transition : root.transitions) {
            CompatibilityUtil.buildPaths(transition, new ArrayList<AnalysisTransition>(), paths);
        }
        boolean mustEndWithMany = root.feature instanceof EReference && UML2ModelUtil.isDerivedUnion(root.feature) && UML2ModelUtil.isContainment((EReference)root.feature) && root.feature.isMany();
        block4: for (List list : paths) {
            EClassifier type = root.feature.getEType();
            EStructuralFeature narrowTypeFeature = null;
            boolean narrowTypeRequired = false;
            boolean narrowTypeFound = false;
            for (AnalysisTransition transition : list) {
                EStructuralFeature currentFeature;
                EStructuralFeature redefinition;
                FeatureNode end = ((AnalysisTransition)list.get(list.size() - 1)).end;
                if (mustEndWithMany && !end.feature.isMany()) continue block4;
                if (transition.reason == AnalysisTransition.Reason.SUBSET_OF_DERIVED_UNION) {
                    narrowTypeRequired = true;
                    narrowTypeFound = false;
                    narrowTypeFeature = null;
                }
                if ((redefinition = UML2ModelUtil.getRedefinition(eClass, currentFeature = transition.end.feature)) != null) {
                    currentFeature = redefinition;
                }
                if (CompatibilityUtil.isSkip(feature, currentFeature)) continue block4;
                EClassifier endType = currentFeature.getEType();
                if (currentFeature.isDerived() || type != null && !UML2ModelUtil.isAssignableFrom(type, endType)) continue;
                type = endType;
                narrowTypeFound = true;
                narrowTypeFeature = currentFeature;
            }
            if (narrowTypeRequired) {
                if (!narrowTypeFound) continue;
                CompatibilityUtil.addToResult(result, type, narrowTypeFeature);
                continue;
            }
            CompatibilityUtil.addToResult(result, type, narrowTypeFeature);
        }
        return result;
    }

    private static void addToResult(@Nonnull Collection<EClassifier> result, @CheckForNull EClassifier type, @CheckForNull EStructuralFeature feature) {
        if (type == null) {
            return;
        }
        if (feature != null && type instanceof EClass) {
            EClass eClass = (EClass)type;
            EReference opposite = null;
            if (feature instanceof EReference) {
                opposite = ((EReference)feature).getEOpposite();
            }
            EList<EClass> eAllSubClasses = UML2ModelUtil.getEAllSubClasses(eClass);
            for (EClass subClass : eAllSubClasses) {
                if (subClass.isAbstract()) continue;
                if (opposite != null) {
                    if (!UML2ModelUtil.isRedefined(subClass, (EStructuralFeature)opposite)) {
                        result.add((EClassifier)subClass);
                        continue;
                    }
                    EStructuralFeature redefinition = UML2ModelUtil.getRedefinition(subClass, (EStructuralFeature)opposite);
                    if (redefinition.getEType() != opposite.getEType()) continue;
                    result.add((EClassifier)subClass);
                    continue;
                }
                result.add((EClassifier)subClass);
            }
        } else {
            result.add(type);
        }
    }

    private static void buildPaths(@Nonnull AnalysisTransition current, @Nonnull List<AnalysisTransition> path, @Nonnull List<List<AnalysisTransition>> paths) {
        path.add(current);
        if (current.end.transitions != null) {
            for (AnalysisTransition transition : current.end.transitions) {
                CompatibilityUtil.buildPaths(transition, path, paths);
            }
        } else {
            paths.add(new ArrayList<AnalysisTransition>(path));
        }
        path.remove(path.size() - 1);
    }

    private static boolean isSkip(EStructuralFeature rootFeature, EStructuralFeature currentFeature) {
        return UML2ModelUtil.isDerivedButNotUnion(currentFeature) || rootFeature instanceof EReference && UML2ModelUtil.isDerivedUnion(rootFeature) && UML2ModelUtil.isContainment((EReference)rootFeature) && !currentFeature.isMany() || rootFeature == UMLPackage.eINSTANCE.getElement_OwnedElement() && currentFeature == UMLPackage.eINSTANCE.getElement_AppliedStereotypeInstance() || rootFeature == UMLPackage.eINSTANCE.getElement_Owner() && currentFeature == UMLPackage.eINSTANCE.getInstanceSpecification_StereotypedElement();
    }

    @Nonnull
    private static FeatureNode getFeatureNode(@Nonnull Map<EStructuralFeature, FeatureNode> nodeMap, @Nonnull EStructuralFeature feature) {
        FeatureNode featureNode = nodeMap.get(feature);
        if (featureNode == null) {
            featureNode = new FeatureNode(feature);
            nodeMap.put(feature, featureNode);
        }
        return featureNode;
    }

    @OpenApiAll
    private static class AnalysisTransition {
        private FeatureNode start;
        private FeatureNode end;
        private Reason reason;

        private AnalysisTransition(FeatureNode start, FeatureNode end, Reason reason) {
            this.start = start;
            this.end = end;
            this.reason = reason;
        }

        @OpenApiAll
        private static enum Reason {
            SUBSET_OF_DERIVED_UNION,
            SUPERSET_OF_SUBSET,
            REDEFINITION;

        }
    }

    @OpenApiAll
    private static class FeatureNode {
        private EStructuralFeature feature;
        private List<AnalysisTransition> transitions;

        public FeatureNode(EStructuralFeature feature) {
            this.feature = feature;
        }

        public void addAnalysisTransition(FeatureNode endNode, AnalysisTransition.Reason reason) {
            AnalysisTransition transition = new AnalysisTransition(this, endNode, reason);
            this.addAnalysisTransition(transition);
        }

        private void addAnalysisTransition(AnalysisTransition transition) {
            if (this.transitions == null) {
                this.transitions = new ArrayList<AnalysisTransition>();
            }
            this.transitions.add(transition);
        }
    }
}

