/*
 * Decompiled with CFR 0.152.
 */
package com.nomagic.esi.api.messages.locking;

import com.nomagic.esi.api.messages.locking.AnnotationTarget;
import com.nomagic.esi.api.messages.locking.LockType;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public class LockState
extends AnnotationTarget {
    private static final long serialVersionUID = 1L;
    private final String username;
    private final String lockType;
    private final Map<String, String> properties;

    public LockState(String string, String string2, UUID uUID, UUID uUID2, UUID uUID3) throws IllegalArgumentException {
        this(string, string2, uUID, uUID2, uUID3, null);
    }

    public LockState(String string, String string2, UUID uUID, UUID uUID2, UUID uUID3, Map<String, String> map) throws IllegalArgumentException {
        super(uUID2, uUID, uUID3);
        this.properties = map;
        LockState.checkNull("username cannot be null", string);
        LockState.checkNullOrEmpty("lockType cannot be null or empty", string2);
        this.username = string;
        this.lockType = string2;
    }

    public Map<String, String> getPropertyMap() {
        return this.properties;
    }

    public static LockState fromAnnotationTarget(AnnotationTarget annotationTarget) {
        return new LockState("", LockType.getDefault().toString(), annotationTarget.getResourceId(), annotationTarget.getEsiObjectId(), annotationTarget.getBranchId());
    }

    public String getUsername() {
        return this.username;
    }

    public String getLockType() {
        return this.lockType;
    }

    public boolean isNotLocked() {
        return "".equals(this.username);
    }

    public boolean isLocked() {
        boolean bl = !this.isNotLocked();
        return bl;
    }

    @Override
    public int hashCode() {
        int n = super.hashCode();
        int n2 = 31 * n;
        int n3 = this.lockType == null ? 0 : this.lockType.hashCode();
        n = n2 + n3;
        int n4 = 31 * n;
        int n5 = this.username == null ? 0 : this.username.hashCode();
        n = n4 + n5;
        return n;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        LockState lockState = (LockState)object;
        if (this.lockType == null ? lockState.lockType != null : !this.lockType.equals(lockState.lockType)) {
            return false;
        }
        return !(this.username == null ? lockState.username != null : !this.username.equals(lockState.username));
    }

    public LockState withUsername(String string) {
        return new LockState(string, this.lockType, this.getResourceId(), this.getEsiObjectId(), this.getBranchId(), new HashMap<String, String>(this.getPropertyMap()));
    }

    public String toString() {
        return "LockStateDTO [username=" + this.username + ", lockType=" + this.lockType + ", esiObjectId=" + this.esiObjectId + ", resourceId=" + this.resourceId + " properties=" + this.getPropertyMap() + "]";
    }
}

