/*
 * Decompiled with CFR 0.152.
 */
package com.nomagic.esi.api.messages.locking;

import com.nomagic.esi.api.messages.info.ElementAndBranchID;
import java.util.UUID;

public class AnnotationTarget {
    private static final long serialVersionUID = 8706363415258685116L;
    protected final UUID esiObjectId;
    protected final UUID resourceId;
    protected final UUID branchId;

    public AnnotationTarget(UUID uUID, UUID uUID2, UUID uUID3) {
        AnnotationTarget.checkNull("context project cannot be empty", uUID2);
        AnnotationTarget.checkNull("branchId cannot be empty", uUID3);
        AnnotationTarget.checkNull("elementId cannot be empty", uUID);
        this.branchId = uUID3;
        this.esiObjectId = uUID;
        this.resourceId = uUID2;
    }

    public ElementAndBranchID getElementAndBranchId() {
        return new ElementAndBranchID(this.esiObjectId, this.branchId);
    }

    public int hashCode() {
        int n = 1;
        int n2 = 31 * n;
        int n3 = this.esiObjectId == null ? 0 : this.esiObjectId.hashCode();
        n = n2 + n3;
        int n4 = 31 * n;
        int n5 = this.resourceId == null ? 0 : this.resourceId.hashCode();
        n = n4 + n5;
        return n;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        AnnotationTarget annotationTarget = (AnnotationTarget)object;
        if (this.esiObjectId == null ? annotationTarget.esiObjectId != null : !this.esiObjectId.equals(annotationTarget.esiObjectId)) {
            return false;
        }
        return !(this.resourceId == null ? annotationTarget.resourceId != null : !this.resourceId.equals(annotationTarget.resourceId));
    }

    public UUID getEsiObjectId() {
        return this.esiObjectId;
    }

    public UUID getBranchId() {
        return this.branchId;
    }

    public UUID getResourceId() {
        return this.resourceId;
    }

    public static final void checkNullOrEmpty(String string, String string2) throws IllegalArgumentException {
        AnnotationTarget.checkNull(string, string2);
        if ("".equals(string2)) {
            throw new IllegalArgumentException(string);
        }
    }

    public static final void checkNull(String string, String string2) throws IllegalArgumentException {
        if (string2 == null) {
            throw new IllegalArgumentException(string);
        }
    }

    public static final void checkNull(String string, UUID uUID) throws IllegalArgumentException {
        if (uUID == null) {
            throw new IllegalArgumentException(string);
        }
    }
}

