/*
 * Decompiled with CFR 0.152.
 */
package com.nomagic.esi.api.messages.info;

import com.nomagic.esi.api.messages.CommonAncestorFindingAlgorithm;
import com.nomagic.esi.api.messages.info.IdAndRev;
import java.util.UUID;

public class MergeInfo {
    private final UUID fromBranch;
    private final long fromRevision;
    private final boolean jumpCommitAsLatest;
    private final IdAndRev selectedCommonAncestor;
    private final long toRevision;
    private final int algorithmNumber;
    private transient int hashCode;

    public MergeInfo(UUID uUID, long l, long l2, int n, boolean bl, IdAndRev idAndRev) {
        this.fromBranch = uUID;
        this.fromRevision = l;
        this.toRevision = l2;
        this.algorithmNumber = n;
        this.jumpCommitAsLatest = bl;
        this.selectedCommonAncestor = idAndRev;
    }

    public UUID fromBranch() {
        return this.fromBranch;
    }

    public long fromRevision() {
        return this.fromRevision;
    }

    public CommonAncestorFindingAlgorithm getAlgorithm() {
        return CommonAncestorFindingAlgorithm.values()[this.algorithmNumber];
    }

    public IdAndRev getSelectedCommonAncestor() {
        return this.selectedCommonAncestor;
    }

    public boolean isJumpCommitAsLatest() {
        return this.jumpCommitAsLatest;
    }

    public long toRevision() {
        return this.toRevision;
    }

    public boolean equals(Object object) {
        if (!(object instanceof MergeInfo)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        MergeInfo mergeInfo = (MergeInfo)object;
        if (this.fromBranch == null ? mergeInfo.fromBranch != null : !this.fromBranch.equals(mergeInfo.fromBranch)) {
            return false;
        }
        if (this.fromRevision != mergeInfo.fromRevision || this.toRevision != mergeInfo.toRevision || this.algorithmNumber != mergeInfo.algorithmNumber || this.jumpCommitAsLatest != mergeInfo.jumpCommitAsLatest) {
            return false;
        }
        return !(this.selectedCommonAncestor == null ? mergeInfo.selectedCommonAncestor != null : !this.selectedCommonAncestor.equals(mergeInfo.selectedCommonAncestor));
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            int n = 1;
            n = 31 * n + (this.fromBranch == null ? 0 : this.fromBranch.hashCode());
            n = 31 * n + (int)(this.fromRevision ^ this.fromRevision >>> 32);
            n = 31 * n + (int)(this.toRevision ^ this.toRevision >>> 32);
            n = 31 * n + this.algorithmNumber;
            n = 31 * n + Boolean.hashCode(this.jumpCommitAsLatest);
            this.hashCode = n = 31 * n + (this.selectedCommonAncestor == null ? 0 : this.selectedCommonAncestor.hashCode());
        }
        return this.hashCode;
    }

    public String toString() {
        return String.format("merge-information {fromBranch=%s, fromRevision=%s, toRevision=%s, algorithm=%s, jumpCommitAsLatest=%s, selectedCommonAncestor=%s}", new Object[]{this.fromBranch, String.valueOf(this.fromRevision), String.valueOf(this.toRevision), this.getAlgorithm(), String.valueOf(this.jumpCommitAsLatest), this.selectedCommonAncestor});
    }
}

