/*
 * Decompiled with CFR 0.152.
 */
package com.nomagic.esi.api.messages.exceptions;

import com.nomagic.esi.api.messages.exceptions.ApiException;
import com.nomagic.esi.helper.annotation.serializer.Message;
import com.nomagic.esi.helper.annotation.serializer.Preferred;
import java.util.Collection;
import java.util.UUID;

public class ResourceNotFoundException
extends ApiException {
    private static final long serialVersionUID = 8203984924251294057L;

    public ResourceNotFoundException(UUID uUID) {
        this(String.format("Resource %s not found.", uUID));
    }

    public ResourceNotFoundException(Collection<UUID> collection) {
        this(ResourceNotFoundException.createMessage(collection));
    }

    @Preferred
    private ResourceNotFoundException(@Message String string) {
        super(string);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String createMessage(Collection<UUID> collection) {
        if (collection.size() == 1) {
            return String.format("Resource %s not found.", collection.iterator().next());
        }
        StringBuilder stringBuilder = new StringBuilder("Resources not found: ");
        for (UUID uUID : collection) {
            stringBuilder.append(String.format("%s, ", uUID));
        }
        stringBuilder.delete(stringBuilder.length() - 2, stringBuilder.length());
        return stringBuilder.toString();
    }
}

