/*
 * Decompiled with CFR 0.152.
 */
package com.nomagic.esi.api.messages.exceptions;

import com.nomagic.esi.api.messages.exceptions.ApiException;
import com.nomagic.esi.helper.annotation.serializer.Argument;
import com.nomagic.esi.helper.annotation.serializer.Preferred;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;

public class EObjectNotFoundException
extends ApiException {
    private static final long serialVersionUID = -3070249178850071850L;
    @Argument
    private final List<UUID> ids;

    public EObjectNotFoundException(UUID uUID) {
        super(String.format("EObject %s not found.", uUID));
        this.ids = new ArrayList<UUID>();
        this.ids.add(uUID);
    }

    @Preferred
    public EObjectNotFoundException(Collection<UUID> collection) {
        super(EObjectNotFoundException.createMessage(collection));
        this.ids = new ArrayList<UUID>(collection);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String createMessage(Collection<UUID> collection) {
        if (collection.size() == 1) {
            return String.format("EObject %s not found.", collection.iterator().next());
        }
        StringBuilder stringBuilder = new StringBuilder("EObjects not found: ");
        for (UUID uUID : collection) {
            stringBuilder.append(String.format("%s, ", uUID));
        }
        stringBuilder.delete(stringBuilder.length() - 2, stringBuilder.length());
        return stringBuilder.toString();
    }

    public List<UUID> getIds() {
        return new ArrayList<UUID>(this.ids);
    }
}

