/*
 * Decompiled with CFR 0.152.
 */
package com.nomagic.esi.api.messages.exceptions;

import com.nomagic.esi.api.messages.exceptions.ApiException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public class BlobsException
extends ApiException {
    private static final long serialVersionUID = 1916307480633404511L;
    private final Map<UUID, Throwable> causes;

    public BlobsException(Map<UUID, Throwable> map) {
        super(BlobsException.createMessage(map));
        this.causes = map != null ? new HashMap<UUID, Throwable>(map) : new HashMap();
    }

    public boolean contains(UUID uUID) {
        return this.causes.containsKey(uUID);
    }

    public Map<UUID, Throwable> getCauses() {
        return Collections.unmodifiableMap(this.causes);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String createMessage(Map<UUID, Throwable> map) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Blobs Exception");
        stringBuilder.append(System.lineSeparator());
        int n = map != null ? map.size() : 0;
        stringBuilder.append("The number of exceptions: ");
        stringBuilder.append(n);
        stringBuilder.append(System.lineSeparator());
        if (map != null) {
            for (Map.Entry<UUID, Throwable> entry : map.entrySet()) {
                UUID uUID = entry.getKey();
                Throwable throwable = entry.getValue();
                stringBuilder.append("Blob ID: ");
                stringBuilder.append(uUID);
                stringBuilder.append(", cause : ");
                stringBuilder.append(throwable.getMessage());
                stringBuilder.append(System.lineSeparator());
            }
        }
        return stringBuilder.toString();
    }
}

