/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.kryo.serializers;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.KryoException;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.esotericsoftware.kryo.serializers.FieldSerializer;
import com.esotericsoftware.minlog.Log;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;

public class TaggedFieldSerializer<T>
extends FieldSerializer<T> {
    private int[] tags;
    private int writeFieldCount;
    private boolean[] deprecated;

    public TaggedFieldSerializer(Kryo kryo, Class type) {
        super(kryo, type);
    }

    @Override
    protected void initializeCachedFields() {
        Field field;
        FieldSerializer.CachedField[] fields = this.getFields();
        int i = 0;
        int n = fields.length;
        while (i < n) {
            field = fields[i].getField();
            if (field.getAnnotation(Tag.class) == null) {
                if (Log.TRACE) {
                    Log.trace("kryo", "Ignoring field without tag: " + fields[i]);
                }
                super.removeField(field.getName());
            }
            ++i;
        }
        fields = this.getFields();
        this.tags = new int[fields.length];
        this.deprecated = new boolean[fields.length];
        this.writeFieldCount = fields.length;
        i = 0;
        n = fields.length;
        while (i < n) {
            field = fields[i].getField();
            this.tags[i] = field.getAnnotation(Tag.class).value();
            if (field.getAnnotation(Deprecated.class) != null) {
                this.deprecated[i] = true;
                --this.writeFieldCount;
            }
            ++i;
        }
    }

    @Override
    public void removeField(String fieldName) {
        super.removeField(fieldName);
        this.initializeCachedFields();
    }

    @Override
    public void write(Kryo kryo, Output output, T object) {
        FieldSerializer.CachedField[] fields = this.getFields();
        output.writeVarInt(this.writeFieldCount, true);
        int i = 0;
        int n = fields.length;
        while (i < n) {
            if (!this.deprecated[i]) {
                output.writeVarInt(this.tags[i], true);
                fields[i].write(output, object);
            }
            ++i;
        }
    }

    @Override
    public T read(Kryo kryo, Input input, Class<T> type) {
        T object = this.create(kryo, input, type);
        kryo.reference(object);
        int fieldCount = input.readVarInt(true);
        int[] tags = this.tags;
        FieldSerializer.CachedField[] fields = this.getFields();
        int i = 0;
        int n = fieldCount;
        while (i < n) {
            int tag = input.readVarInt(true);
            FieldSerializer.CachedField cachedField = null;
            int ii = 0;
            int nn = tags.length;
            while (ii < nn) {
                if (tags[ii] == tag) {
                    cachedField = fields[ii];
                    break;
                }
                ++ii;
            }
            if (cachedField == null) {
                throw new KryoException("Unknown field tag: " + tag + " (" + this.getType().getName() + ")");
            }
            cachedField.read(input, object);
            ++i;
        }
        return object;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Tag {
        public int value();
    }
}

