/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.kryo.serializers;

import com.esotericsoftware.kryo.Generics;
import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.NotNull;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.esotericsoftware.kryo.serializers.AsmCachedFieldFactory;
import com.esotericsoftware.kryo.serializers.FieldSerializerGenericsUtil;
import com.esotericsoftware.kryo.serializers.FieldSerializerUnsafeUtil;
import com.esotericsoftware.kryo.serializers.ObjectCachedFieldFactory;
import com.esotericsoftware.kryo.serializers.ObjectField;
import com.esotericsoftware.kryo.util.IntArray;
import com.esotericsoftware.kryo.util.ObjectMap;
import com.esotericsoftware.kryo.util.Util;
import com.esotericsoftware.minlog.Log;
import com.esotericsoftware.reflectasm.FieldAccess;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class FieldSerializer<T>
extends Serializer<T>
implements Comparator<CachedField> {
    final Kryo kryo;
    final Class type;
    private final TypeVariable[] typeParameters;
    private CachedField[] fields = new CachedField[0];
    private CachedField[] transientFields = new CachedField[0];
    Object access;
    private boolean fieldsCanBeNull = true;
    private boolean setFieldsAsAccessible = true;
    private boolean ignoreSyntheticFields = true;
    private boolean fixedFieldTypes;
    private boolean useAsmEnabled = !unsafeAvailable;
    private FieldSerializerUnsafeUtil unsafeUtil;
    private FieldSerializerGenericsUtil genericsUtil;
    private Class[] generics;
    private Generics genericsScope;
    private boolean varIntsEnabled = true;
    private boolean useMemRegions = false;
    private final boolean copyTransient = true;
    private final boolean serializeTransient = false;
    private boolean hasObjectFields = false;
    static CachedFieldFactory asmFieldFactory;
    static CachedFieldFactory objectFieldFactory;
    static CachedFieldFactory unsafeFieldFactory;
    static boolean unsafeAvailable;
    static Class<?> unsafeUtilClass;
    static Method sortFieldsByOffsetMethod;

    static {
        try {
            unsafeUtilClass = FieldSerializer.class.getClassLoader().loadClass("com.esotericsoftware.kryo.util.UnsafeUtil");
            Method unsafeMethod = unsafeUtilClass.getMethod("unsafe", new Class[0]);
            sortFieldsByOffsetMethod = unsafeUtilClass.getMethod("sortFieldsByOffset", List.class);
            Object unsafe = unsafeMethod.invoke(null, new Object[0]);
            if (unsafe != null) {
                unsafeAvailable = true;
            }
        }
        catch (Throwable throwable) {}
    }

    public FieldSerializer(Kryo kryo, Class type) {
        if (Log.TRACE) {
            Log.trace("kryo", "optimize ints is " + this.varIntsEnabled);
        }
        this.kryo = kryo;
        this.type = type;
        this.typeParameters = type.getTypeParameters();
        this.useAsmEnabled = kryo.getAsmEnabled();
        this.genericsUtil = new FieldSerializerGenericsUtil(this);
        this.unsafeUtil = new FieldSerializerUnsafeUtil(this);
        if (Log.TRACE) {
            Log.trace("kryo", "FieldSerializer(Kryo, Class)");
        }
        this.rebuildCachedFields();
    }

    public FieldSerializer(Kryo kryo, Class type, Class[] generics) {
        if (Log.TRACE) {
            Log.trace("kryo", "optimize ints is " + this.varIntsEnabled);
        }
        this.kryo = kryo;
        this.type = type;
        this.generics = generics;
        this.typeParameters = type.getTypeParameters();
        this.useAsmEnabled = kryo.getAsmEnabled();
        this.genericsUtil = new FieldSerializerGenericsUtil(this);
        this.unsafeUtil = new FieldSerializerUnsafeUtil(this);
        if (Log.TRACE) {
            Log.trace("kryo", "FieldSerializer(Kryo, Class, Generics)");
        }
        this.rebuildCachedFields();
    }

    protected void rebuildCachedFields() {
        Generics genScope;
        if (Log.TRACE && this.generics != null) {
            Log.trace("kryo", "generic type parameters are: " + Arrays.toString(this.generics));
        }
        if (this.type.isInterface()) {
            this.fields = new CachedField[0];
            return;
        }
        this.hasObjectFields = false;
        this.genericsScope = genScope = this.genericsUtil.buildGenericsScope(this.type, this.generics);
        if (this.genericsScope != null) {
            this.kryo.pushGenericsScope(this.type, this.genericsScope);
        }
        List<Field> allFields = new ArrayList<Field>();
        Class nextClass = this.type;
        while (nextClass != Object.class) {
            Field[] declaredFields = nextClass.getDeclaredFields();
            if (declaredFields != null) {
                Field[] fieldArray = declaredFields;
                int n = declaredFields.length;
                int n2 = 0;
                while (n2 < n) {
                    Field f = fieldArray[n2];
                    if (!Modifier.isStatic(f.getModifiers())) {
                        allFields.add(f);
                    }
                    ++n2;
                }
            }
            nextClass = nextClass.getSuperclass();
        }
        ObjectMap context = this.kryo.getContext();
        IntArray useAsm = new IntArray();
        if (this.useMemRegions && !this.useAsmEnabled && unsafeAvailable) {
            try {
                Field[] allFieldsArray = (Field[])sortFieldsByOffsetMethod.invoke(null, allFields);
                allFields = Arrays.asList(allFieldsArray);
            }
            catch (Exception e) {
                throw new RuntimeException("Cannot invoke UnsafeUtil.sortFieldsByOffset()", e);
            }
        }
        List<Field> validFields = this.buildValidFields(false, allFields, context, useAsm);
        List<Field> validTransientFields = this.buildValidFields(true, allFields, context, useAsm);
        if (this.useAsmEnabled && !Util.isAndroid && Modifier.isPublic(this.type.getModifiers()) && useAsm.indexOf(1) != -1) {
            try {
                this.access = FieldAccess.get(this.type);
            }
            catch (RuntimeException runtimeException) {}
        }
        ArrayList<CachedField> cachedFields = new ArrayList<CachedField>(validFields.size());
        ArrayList<CachedField> cachedTransientFields = new ArrayList<CachedField>(validTransientFields.size());
        this.createCachedFields(useAsm, validFields, cachedFields, 0);
        this.createCachedFields(useAsm, validTransientFields, cachedTransientFields, validFields.size());
        Collections.sort(cachedFields, this);
        this.fields = cachedFields.toArray(new CachedField[cachedFields.size()]);
        Collections.sort(cachedTransientFields, this);
        this.transientFields = cachedTransientFields.toArray(new CachedField[cachedTransientFields.size()]);
        this.initializeCachedFields();
        if (this.genericsScope != null) {
            this.kryo.popGenericsScope();
        }
    }

    private List<Field> buildValidFields(boolean transientFields, List<Field> allFields, ObjectMap context, IntArray useAsm) {
        ArrayList<Field> result = new ArrayList<Field>(allFields.size());
        int i = 0;
        int n = allFields.size();
        while (i < n) {
            Field field = allFields.get(i);
            int modifiers = field.getModifiers();
            if (!(Modifier.isTransient(modifiers) && !transientFields || Modifier.isStatic(modifiers) || field.isSynthetic() && this.ignoreSyntheticFields)) {
                Optional optional;
                if (!field.isAccessible()) {
                    if (this.setFieldsAsAccessible) {
                        try {
                            field.setAccessible(true);
                        }
                        catch (AccessControlException accessControlException) {
                        }
                    }
                } else if ((optional = field.getAnnotation(Optional.class)) == null || context.containsKey(optional.value())) {
                    result.add(field);
                    useAsm.add(!Modifier.isFinal(modifiers) && Modifier.isPublic(modifiers) && Modifier.isPublic(field.getType().getModifiers()) ? 1 : 0);
                }
            }
            ++i;
        }
        return result;
    }

    private void createCachedFields(IntArray useAsm, List<Field> validFields, List<CachedField> cachedFields, int baseIndex) {
        if (this.useAsmEnabled || !this.useMemRegions) {
            int i = 0;
            int n = validFields.size();
            while (i < n) {
                Field field = validFields.get(i);
                int accessIndex = -1;
                if (this.access != null && useAsm.get(baseIndex + i) == 1) {
                    accessIndex = ((FieldAccess)this.access).getIndex(field.getName());
                }
                cachedFields.add(this.newCachedField(field, cachedFields.size(), accessIndex));
                ++i;
            }
        } else {
            this.unsafeUtil.createUnsafeCacheFieldsAndRegions(validFields, cachedFields, baseIndex, useAsm);
        }
    }

    @Override
    public void setGenerics(Kryo kryo, Class[] generics) {
        this.generics = generics;
        if (Log.TRACE) {
            Log.trace("kryo", "setGenerics");
        }
        if (this.typeParameters != null && this.typeParameters.length > 0) {
            this.rebuildCachedFields();
        }
    }

    protected void initializeCachedFields() {
    }

    CachedField newCachedField(Field field, int fieldIndex, int accessIndex) {
        CachedField cachedField;
        Class[] fieldClass = new Class[]{field.getType()};
        Type fieldGenericType = field.getGenericType();
        if (fieldGenericType == fieldClass[0]) {
            if (Log.TRACE) {
                Log.trace("kryo", "Field '" + field.getName() + "' of type " + fieldClass[0]);
            }
            cachedField = this.newMatchingCachedField(field, accessIndex, fieldClass[0], fieldGenericType, null);
        } else {
            cachedField = this.genericsUtil.newCachedFieldOfGenericType(field, accessIndex, fieldClass, fieldGenericType);
        }
        if (cachedField instanceof ObjectField) {
            this.hasObjectFields = true;
        }
        cachedField.field = field;
        cachedField.varIntsEnabled = this.varIntsEnabled;
        if (!this.useAsmEnabled) {
            cachedField.offset = this.unsafeUtil.getObjectFieldOffset(field);
        }
        cachedField.access = (FieldAccess)this.access;
        cachedField.accessIndex = accessIndex;
        boolean bl = cachedField.canBeNull = this.fieldsCanBeNull && !fieldClass[0].isPrimitive() && !field.isAnnotationPresent(NotNull.class);
        if (this.kryo.isFinal(fieldClass[0]) || this.fixedFieldTypes) {
            cachedField.valueClass = fieldClass[0];
        }
        return cachedField;
    }

    CachedField newMatchingCachedField(Field field, int accessIndex, Class fieldClass, Type fieldGenericType, Class[] fieldGenerics) {
        CachedField cachedField;
        if (accessIndex != -1) {
            cachedField = this.getAsmFieldFactory().createCachedField(fieldClass, field, this);
        } else if (!this.useAsmEnabled) {
            cachedField = this.getUnsafeFieldFactory().createCachedField(fieldClass, field, this);
        } else {
            cachedField = this.getObjectFieldFactory().createCachedField(fieldClass, field, this);
            if (fieldGenerics != null) {
                ((ObjectField)cachedField).generics = fieldGenerics;
            } else {
                Object[] cachedFieldGenerics = FieldSerializerGenericsUtil.getGenerics(fieldGenericType, this.kryo);
                ((ObjectField)cachedField).generics = cachedFieldGenerics;
                if (Log.TRACE) {
                    Log.trace("kryo", "Field generics: " + Arrays.toString(cachedFieldGenerics));
                }
            }
        }
        return cachedField;
    }

    private CachedFieldFactory getAsmFieldFactory() {
        if (asmFieldFactory == null) {
            asmFieldFactory = new AsmCachedFieldFactory();
        }
        return asmFieldFactory;
    }

    private CachedFieldFactory getObjectFieldFactory() {
        if (objectFieldFactory == null) {
            objectFieldFactory = new ObjectCachedFieldFactory();
        }
        return objectFieldFactory;
    }

    private CachedFieldFactory getUnsafeFieldFactory() {
        if (unsafeFieldFactory == null) {
            try {
                unsafeFieldFactory = (CachedFieldFactory)this.getClass().getClassLoader().loadClass("com.esotericsoftware.kryo.serializers.UnsafeCachedFieldFactory").newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException("Cannot create UnsafeFieldFactory", e);
            }
        }
        return unsafeFieldFactory;
    }

    @Override
    public int compare(CachedField o1, CachedField o2) {
        return o1.field.getName().compareTo(o2.field.getName());
    }

    public void setFieldsCanBeNull(boolean fieldsCanBeNull) {
        this.fieldsCanBeNull = fieldsCanBeNull;
        if (Log.TRACE) {
            Log.trace("kryo", "setFieldsCanBeNull: " + fieldsCanBeNull);
        }
        this.rebuildCachedFields();
    }

    public void setFieldsAsAccessible(boolean setFieldsAsAccessible) {
        this.setFieldsAsAccessible = setFieldsAsAccessible;
        if (Log.TRACE) {
            Log.trace("kryo", "setFieldsAsAccessible: " + setFieldsAsAccessible);
        }
        this.rebuildCachedFields();
    }

    public void setIgnoreSyntheticFields(boolean ignoreSyntheticFields) {
        this.ignoreSyntheticFields = ignoreSyntheticFields;
        if (Log.TRACE) {
            Log.trace("kryo", "setIgnoreSyntheticFields: " + ignoreSyntheticFields);
        }
        this.rebuildCachedFields();
    }

    public void setFixedFieldTypes(boolean fixedFieldTypes) {
        this.fixedFieldTypes = fixedFieldTypes;
        if (Log.TRACE) {
            Log.trace("kryo", "setFixedFieldTypes: " + fixedFieldTypes);
        }
        this.rebuildCachedFields();
    }

    public void setUseAsm(boolean setUseAsm) {
        this.useAsmEnabled = setUseAsm;
        if (Log.TRACE) {
            Log.trace("kryo", "setUseAsm: " + setUseAsm);
        }
        this.rebuildCachedFields();
    }

    @Override
    public void write(Kryo kryo, Output output, T object) {
        if (Log.TRACE) {
            Log.trace("kryo", "FieldSerializer.write fields of class " + object.getClass().getName());
        }
        if (this.typeParameters != null && this.generics != null) {
            this.rebuildCachedFields();
        }
        if (this.genericsScope != null) {
            kryo.pushGenericsScope(this.type, this.genericsScope);
        }
        CachedField[] fields = this.fields;
        int i = 0;
        int n = fields.length;
        while (i < n) {
            fields[i].write(output, object);
            ++i;
        }
        if (this.genericsScope != null) {
            kryo.popGenericsScope();
        }
    }

    @Override
    public T read(Kryo kryo, Input input, Class<T> type) {
        try {
            if (this.typeParameters != null && this.generics != null) {
                this.rebuildCachedFields();
            }
            if (this.genericsScope != null) {
                kryo.pushGenericsScope(type, this.genericsScope);
            }
            T object = this.create(kryo, input, type);
            kryo.reference(object);
            CachedField[] fields = this.fields;
            int i = 0;
            int n = fields.length;
            while (i < n) {
                fields[i].read(input, object);
                ++i;
            }
            T t = object;
            return t;
        }
        finally {
            if (this.genericsScope != null && kryo.getGenericsScope() != null) {
                kryo.popGenericsScope();
            }
        }
    }

    protected T create(Kryo kryo, Input input, Class<T> type) {
        return kryo.newInstance(type);
    }

    public CachedField getField(String fieldName) {
        CachedField[] cachedFieldArray = this.fields;
        int n = this.fields.length;
        int n2 = 0;
        while (n2 < n) {
            CachedField cachedField = cachedFieldArray[n2];
            if (cachedField.field.getName().equals(fieldName)) {
                return cachedField;
            }
            ++n2;
        }
        throw new IllegalArgumentException("Field \"" + fieldName + "\" not found on class: " + this.type.getName());
    }

    public void removeField(String fieldName) {
        int i = 0;
        while (i < this.fields.length) {
            CachedField cachedField = this.fields[i];
            if (cachedField.field.getName().equals(fieldName)) {
                CachedField[] newFields = new CachedField[this.fields.length - 1];
                System.arraycopy(this.fields, 0, newFields, 0, i);
                System.arraycopy(this.fields, i + 1, newFields, i, newFields.length - i);
                this.fields = newFields;
                return;
            }
            ++i;
        }
        throw new IllegalArgumentException("Field \"" + fieldName + "\" not found on class: " + this.type.getName());
    }

    public CachedField[] getFields() {
        return this.fields;
    }

    public Class getType() {
        return this.type;
    }

    public Kryo getKryo() {
        return this.kryo;
    }

    public boolean getUseAsmEnabled() {
        return this.useAsmEnabled;
    }

    public boolean getUseMemRegions() {
        return this.useMemRegions;
    }

    protected T createCopy(Kryo kryo, T original) {
        return (T)kryo.newInstance(original.getClass());
    }

    @Override
    public T copy(Kryo kryo, T original) {
        T copy = this.createCopy(kryo, original);
        kryo.reference(copy);
        int i = 0;
        int n = this.transientFields.length;
        while (i < n) {
            this.transientFields[i].copy(original, copy);
            ++i;
        }
        i = 0;
        n = this.fields.length;
        while (i < n) {
            this.fields[i].copy(original, copy);
            ++i;
        }
        return copy;
    }

    public final Generics getGenericsScope() {
        return this.genericsScope;
    }

    public static abstract class CachedField<X> {
        Field field;
        FieldAccess access;
        Class valueClass;
        Serializer serializer;
        boolean canBeNull;
        int accessIndex = -1;
        long offset = -1L;
        boolean varIntsEnabled = true;

        public void setClass(Class valueClass) {
            this.valueClass = valueClass;
            this.serializer = null;
        }

        public void setClass(Class valueClass, Serializer serializer) {
            this.valueClass = valueClass;
            this.serializer = serializer;
        }

        public void setSerializer(Serializer serializer) {
            this.serializer = serializer;
        }

        public void setCanBeNull(boolean canBeNull) {
            this.canBeNull = canBeNull;
        }

        public Field getField() {
            return this.field;
        }

        public String toString() {
            return this.field.getName();
        }

        public abstract void write(Output var1, Object var2);

        public abstract void read(Input var1, Object var2);

        public abstract void copy(Object var1, Object var2);
    }

    public static interface CachedFieldFactory {
        public CachedField createCachedField(Class var1, Field var2, FieldSerializer var3);
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Optional {
        public String value();
    }
}

