/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.kryo.serializers;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.InputChunked;
import com.esotericsoftware.kryo.io.Output;
import com.esotericsoftware.kryo.io.OutputChunked;
import com.esotericsoftware.kryo.serializers.FieldSerializer;
import com.esotericsoftware.kryo.util.ObjectMap;
import com.esotericsoftware.minlog.Log;

public class CompatibleFieldSerializer<T>
extends FieldSerializer<T> {
    public CompatibleFieldSerializer(Kryo kryo, Class type) {
        super(kryo, type);
    }

    @Override
    public void write(Kryo kryo, Output output, T object) {
        FieldSerializer.CachedField[] fields = this.getFields();
        ObjectMap context = kryo.getGraphContext();
        if (!context.containsKey(this)) {
            context.put(this, null);
            if (Log.TRACE) {
                Log.trace("kryo", "Write " + fields.length + " field names.");
            }
            output.writeVarInt(fields.length, true);
            int i = 0;
            int n = fields.length;
            while (i < n) {
                output.writeString(fields[i].field.getName());
                ++i;
            }
        }
        OutputChunked outputChunked = new OutputChunked(output, 1024);
        int i = 0;
        int n = fields.length;
        while (i < n) {
            fields[i].write(outputChunked, object);
            outputChunked.endChunks();
            ++i;
        }
    }

    @Override
    public T read(Kryo kryo, Input input, Class<T> type) {
        T object = this.create(kryo, input, type);
        kryo.reference(object);
        ObjectMap context = kryo.getGraphContext();
        FieldSerializer.CachedField[] fields = (FieldSerializer.CachedField[])context.get(this);
        if (fields == null) {
            int length = input.readVarInt(true);
            if (Log.TRACE) {
                Log.trace("kryo", "Read " + length + " field names.");
            }
            String[] names = new String[length];
            int i = 0;
            while (i < length) {
                names[i] = input.readString();
                ++i;
            }
            fields = new FieldSerializer.CachedField[length];
            FieldSerializer.CachedField[] allFields = this.getFields();
            int i2 = 0;
            int n = names.length;
            while (i2 < n) {
                block11: {
                    String schemaName = names[i2];
                    int ii = 0;
                    int nn = allFields.length;
                    while (ii < nn) {
                        if (allFields[ii].field.getName().equals(schemaName)) {
                            fields[i2] = allFields[ii];
                            break block11;
                        }
                        ++ii;
                    }
                    if (Log.TRACE) {
                        Log.trace("kryo", "Ignore obsolete field: " + schemaName);
                    }
                }
                ++i2;
            }
            context.put(this, fields);
        }
        InputChunked inputChunked = new InputChunked(input, 1024);
        int i = 0;
        int n = fields.length;
        while (i < n) {
            FieldSerializer.CachedField cachedField = fields[i];
            if (cachedField == null) {
                if (Log.TRACE) {
                    Log.trace("kryo", "Skip obsolete field.");
                }
                inputChunked.nextChunks();
            } else {
                cachedField.read(inputChunked, object);
                inputChunked.nextChunks();
            }
            ++i;
        }
        return object;
    }
}

