/*
 * Decompiled with CFR 0.152.
 */
package akka.cluster.protobuf;

import akka.actor.ActorSystem;
import akka.actor.Address;
import akka.actor.Address$;
import akka.actor.ExtendedActorSystem;
import akka.annotation.InternalApi;
import akka.cluster.Cluster;
import akka.cluster.Cluster$;
import akka.cluster.ClusterHeartbeatSender;
import akka.cluster.ClusterSettings$;
import akka.cluster.ClusterUserAction;
import akka.cluster.Gossip;
import akka.cluster.GossipEnvelope;
import akka.cluster.GossipEnvelope$;
import akka.cluster.GossipOverview;
import akka.cluster.GossipStatus;
import akka.cluster.InternalClusterAction;
import akka.cluster.InternalClusterAction$IncompatibleConfig$;
import akka.cluster.InternalClusterAction$UncheckedConfig$;
import akka.cluster.Member;
import akka.cluster.Member$;
import akka.cluster.MemberStatus;
import akka.cluster.MemberStatus$Down$;
import akka.cluster.MemberStatus$Exiting$;
import akka.cluster.MemberStatus$Joining$;
import akka.cluster.MemberStatus$Leaving$;
import akka.cluster.MemberStatus$Removed$;
import akka.cluster.MemberStatus$Up$;
import akka.cluster.MemberStatus$WeaklyUp$;
import akka.cluster.Reachability;
import akka.cluster.Reachability$;
import akka.cluster.Reachability$Reachable$;
import akka.cluster.Reachability$Terminated$;
import akka.cluster.Reachability$Unreachable$;
import akka.cluster.UniqueAddress;
import akka.cluster.VectorClock;
import akka.cluster.VectorClock$Node$;
import akka.cluster.protobuf.msg.ClusterMessages;
import akka.cluster.routing.ClusterRouterPool;
import akka.cluster.routing.ClusterRouterPoolSettings;
import akka.protobuf.ByteString;
import akka.protobuf.MessageLite;
import akka.routing.Pool;
import akka.serialization.BaseSerializer;
import akka.serialization.Serialization;
import akka.serialization.SerializationExtension$;
import akka.serialization.Serializer;
import akka.serialization.SerializerWithStringManifest;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigRenderOptions;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.NotSerializableException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenMap;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.HashMap;
import scala.collection.immutable.HashMap$;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Set$;
import scala.collection.immutable.SortedSet;
import scala.collection.immutable.SortedSet$;
import scala.collection.immutable.TreeMap;
import scala.collection.immutable.TreeMap$;
import scala.collection.immutable.Vector;
import scala.collection.immutable.Vector$;
import scala.collection.immutable.VectorBuilder;
import scala.collection.mutable.MapBuilder;
import scala.collection.package$;
import scala.concurrent.duration.Deadline$;
import scala.concurrent.duration.FiniteDuration;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

@ScalaSignature(bytes="\u0006\u0001\r\u001dh\u0001B\u0001\u0003\u0001%\u0011\u0001d\u00117vgR,'/T3tg\u0006<WmU3sS\u0006d\u0017N_3s\u0015\t\u0019A!\u0001\u0005qe>$xNY;g\u0015\t)a!A\u0004dYV\u001cH/\u001a:\u000b\u0003\u001d\tA!Y6lC\u000e\u00011c\u0001\u0001\u000b!A\u00111BD\u0007\u0002\u0019)\tQ\"A\u0003tG\u0006d\u0017-\u0003\u0002\u0010\u0019\t1\u0011I\\=SK\u001a\u0004\"!\u0005\u000b\u000e\u0003IQ!a\u0005\u0004\u0002\u001bM,'/[1mSj\fG/[8o\u0013\t)\"C\u0001\bCCN,7+\u001a:jC2L'0\u001a:\t\u0011]\u0001!Q1A\u0005\u0002a\taa]=ti\u0016lW#A\r\u0011\u0005iiR\"A\u000e\u000b\u0005q1\u0011!B1di>\u0014\u0018B\u0001\u0010\u001c\u0005M)\u0005\u0010^3oI\u0016$\u0017i\u0019;peNK8\u000f^3n\u0011!\u0001\u0003A!A!\u0002\u0013I\u0012aB:zgR,W\u000e\t\u0005\u0006E\u0001!\taI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005\u00112\u0003CA\u0013\u0001\u001b\u0005\u0011\u0001\"B\f\"\u0001\u0004I\u0002\u0002C\n\u0001\u0011\u000b\u0007I\u0011\u0002\u0015\u0016\u0003%\u0002\"!\u0005\u0016\n\u0005-\u0012\"!D*fe&\fG.\u001b>bi&|g\u000eC\u0004.\u0001\t\u0007IQ\u0002\u0018\u0002\u0015\t+hMZ3s'&TX-F\u00010\u001f\u0005\u0001TD\u0001\t\u0001\u0011\u0019\u0011\u0004\u0001)A\u0007_\u0005Y!)\u001e4gKJ\u001c\u0016N_3!\u0011!!\u0004\u0001#b\u0001\n\u0013)\u0014\u0001E$pgNL\u0007\u000fV5nKR{G*\u001b<f+\u00051\u0004CA\u001c=\u001b\u0005A$BA\u001d;\u0003!!WO]1uS>t'BA\u001e\r\u0003)\u0019wN\\2veJ,g\u000e^\u0005\u0003{a\u0012aBR5oSR,G)\u001e:bi&|g\u000eC\u0004@\u0001\t\u0007I\u0011\u0002!\u0002\u001b\u0019\u0014x.\u001c\"j]\u0006\u0014\u00180T1q+\u0005\t\u0005\u0003\u0002\"H\u0013~k\u0011a\u0011\u0006\u0003\t\u0016\u000b\u0011\"[7nkR\f'\r\\3\u000b\u0005\u0019c\u0011AC2pY2,7\r^5p]&\u0011\u0001j\u0011\u0002\b\u0011\u0006\u001c\b.T1qa\tQE\u000bE\u0002L!Jk\u0011\u0001\u0014\u0006\u0003\u001b:\u000bA\u0001\\1oO*\tq*\u0001\u0003kCZ\f\u0017BA)M\u0005\u0015\u0019E.Y:t!\t\u0019F\u000b\u0004\u0001\u0005\u0013U3\u0016\u0011!A\u0001\u0006\u0003A&aA0%c!1q\u000b\u0001Q\u0001\n\u0005\u000baB\u001a:p[\nKg.\u0019:z\u001b\u0006\u0004\b%\u0005\u0002Z9B\u00111BW\u0005\u000372\u0011qAT8uQ&tw\r\u0005\u0002\f;&\u0011a\f\u0004\u0002\u0004\u0003:L\b\u0003B\u0006aE\"L!!\u0019\u0007\u0003\u0013\u0019+hn\u0019;j_:\f\u0004cA\u0006dK&\u0011A\r\u0004\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0003\u0017\u0019L!a\u001a\u0007\u0003\t\tKH/\u001a\t\u0003\u0017&L!A\u001b'\u0003\r=\u0013'.Z2u\u0011\u0015a\u0007\u0001\"\u0001n\u0003=Ign\u00197vI\u0016l\u0015M\\5gKN$X#\u00018\u0011\u0005-y\u0017B\u00019\r\u0005\u001d\u0011un\u001c7fC:DQA\u001d\u0001\u0005\u0002M\f\u0001\u0002^8CS:\f'/\u001f\u000b\u0003ERDQ!^9A\u0002)\t1a\u001c2k\u0011\u00159\b\u0001\"\u0001y\u0003!\u0019w.\u001c9sKN\u001cHC\u00012z\u0011\u0015Qh\u000f1\u0001|\u0003\ri7o\u001a\t\u0003yzl\u0011! \u0006\u0003\u0007\u0019I!a`?\u0003\u00175+7o]1hK2KG/\u001a\u0005\b\u0003\u0007\u0001A\u0011AA\u0003\u0003)!WmY8naJ,7o\u001d\u000b\u0004E\u0006\u001d\u0001bBA\u0005\u0003\u0003\u0001\rAY\u0001\u0006Ef$Xm\u001d\u0005\b\u0003\u001b\u0001A\u0011AA\b\u0003)1'o\\7CS:\f'/\u001f\u000b\u0006\u0015\u0005E\u00111\u0003\u0005\b\u0003\u0013\tY\u00011\u0001c\u0011!\t)\"a\u0003A\u0002\u0005]\u0011!B2mCjT\b#B\u0006\u0002\u001a\u0005u\u0011bAA\u000e\u0019\t1q\n\u001d;j_:\u0004D!a\b\u00026A1\u0011\u0011EA\u0018\u0003gqA!a\t\u0002,A\u0019\u0011Q\u0005\u0007\u000e\u0005\u0005\u001d\"bAA\u0015\u0011\u00051AH]8pizJ1!!\f\r\u0003\u0019\u0001&/\u001a3fM&\u0019\u0011+!\r\u000b\u0007\u00055B\u0002E\u0002T\u0003k!1\"a\u000e\u0002\u0014\u0005\u0005\t\u0011!B\u00011\n\u0019q\f\n\u001a\t\u000f\u0005m\u0002\u0001\"\u0003\u0002>\u0005\t\u0012\r\u001a3sKN\u001chI]8n\u0005&t\u0017M]=\u0015\t\u0005}\u0012Q\t\t\u00045\u0005\u0005\u0013bAA\"7\t9\u0011\t\u001a3sKN\u001c\bbBA\u0005\u0003s\u0001\rA\u0019\u0005\b\u0003\u0013\u0002A\u0011BA&\u0003])h.[9vK\u0006#GM]3tg\u001a\u0013x.\u001c\"j]\u0006\u0014\u0018\u0010\u0006\u0003\u0002N\u0005U\u0003\u0003BA(\u0003#j\u0011\u0001B\u0005\u0004\u0003'\"!!D+oSF,X-\u00113ee\u0016\u001c8\u000fC\u0004\u0002\n\u0005\u001d\u0003\u0019\u00012\t\u000f\u0005e\u0003\u0001\"\u0003\u0002\\\u0005q\u0011\r\u001a3sKN\u001cHk\u001c)s_R|G\u0003BA/\u0003o\u0002B!a\u0018\u0002r9!\u0011\u0011MA6\u001d\u0011\t\u0019'a\u001a\u000e\u0005\u0005\u0015$B\u0001>\u0003\u0013\u0011\tI'!\u001a\u0002\u001f\rcWo\u001d;fe6+7o]1hKNLA!!\u001c\u0002p\u00059\u0011\t\u001a3sKN\u001c(\u0002BA5\u0003KJA!a\u001d\u0002v\t9!)^5mI\u0016\u0014(\u0002BA7\u0003_B\u0001\"!\u001f\u0002X\u0001\u0007\u0011qH\u0001\bC\u0012$'/Z:t\u0011\u001d\ti\b\u0001C\u0005\u0003\u007f\nq#\u00193ee\u0016\u001c8\u000fV8Qe>$xNQ=uK\u0006\u0013(/Y=\u0015\u0007\t\f\t\t\u0003\u0005\u0002z\u0005m\u0004\u0019AA \u0011\u001d\t)\t\u0001C\u0005\u0003\u000f\u000bA#\u001e8jcV,\u0017\t\u001a3sKN\u001cHk\u001c)s_R|G\u0003BAE\u0003+\u0003B!a#\u0002\u0012:!\u0011\u0011MAG\u0013\u0011\ty)a\u001c\u0002\u001bUs\u0017.];f\u0003\u0012$'/Z:t\u0013\u0011\t\u0019(a%\u000b\t\u0005=\u0015q\u000e\u0005\t\u0003/\u000b\u0019\t1\u0001\u0002N\u0005iQO\\5rk\u0016\fE\r\u001a:fgNDq!a'\u0001\t\u0013\ti*A\u000fv]&\fX/Z!eIJ,7o\u001d+p!J|Go\u001c\"zi\u0016\f%O]1z)\r\u0011\u0017q\u0014\u0005\t\u0003/\u000bI\n1\u0001\u0002N!9\u00111\u0015\u0001\u0005\n\u0005\u0015\u0016!I2mkN$XM\u001d*pkR,'\u000fU8pYR{\u0007K]8u_\nKH/Z!se\u0006LHc\u00012\u0002(\"A\u0011\u0011VAQ\u0001\u0004\tY+\u0001\u0002saB!\u0011QVAZ\u001b\t\tyKC\u0002\u00022\u0012\tqA]8vi&tw-\u0003\u0003\u00026\u0006=&!E\"mkN$XM\u001d*pkR,'\u000fU8pY\"9\u0011\u0011\u0018\u0001\u0005\n\u0005m\u0016a\u00039p_2$v\u000e\u0015:pi>$B!!0\u0002DB!\u0011\u0011MA`\u0013\u0011\t\t-a\u001c\u0003\tA{w\u000e\u001c\u0005\t\u0003\u000b\f9\f1\u0001\u0002H\u0006!\u0001o\\8m!\u0011\tI-!4\u000e\u0005\u0005-'bAAY\r%!\u0011\u0011YAf\u0011\u001d\t\t\u000e\u0001C\u0005\u0003'\f\u0001e\u00197vgR,'OU8vi\u0016\u0014\bk\\8m'\u0016$H/\u001b8hgR{\u0007K]8u_R!\u0011Q[An!\u0011\t\t'a6\n\t\u0005e\u0017q\u000e\u0002\u001a\u00072,8\u000f^3s%>,H/\u001a:Q_>d7+\u001a;uS:<7\u000f\u0003\u0005\u0002^\u0006=\u0007\u0019AAp\u0003!\u0019X\r\u001e;j]\u001e\u001c\b\u0003BAW\u0003CLA!!7\u00020\"Y\u0011Q\u001d\u0001A\u0002\u0003\u0007I\u0011BAt\u00035\u0001(o\u001c;pG>d7)Y2iKV\u0011\u0011\u0011\u001e\t\u0005\u0003C\tY/\u0003\u0003\u0002n\u0006E\"AB*ue&tw\rC\u0006\u0002r\u0002\u0001\r\u00111A\u0005\n\u0005M\u0018!\u00059s_R|7m\u001c7DC\u000eDWm\u0018\u0013fcR!\u0011Q_A~!\rY\u0011q_\u0005\u0004\u0003sd!\u0001B+oSRD!\"!@\u0002p\u0006\u0005\t\u0019AAu\u0003\rAH%\r\u0005\f\u0005\u0003\u0001\u0001\u0019!A!B\u0013\tI/\u0001\bqe>$xnY8m\u0007\u0006\u001c\u0007.\u001a\u0011)\t\u0005}(Q\u0001\t\u0004\u0017\t\u001d\u0011b\u0001B\u0005\u0019\tAao\u001c7bi&dW\rC\u0006\u0003\u000e\u0001\u0001\r\u00111A\u0005\n\u0005\u001d\u0018aC:zgR,WnQ1dQ\u0016D1B!\u0005\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0003\u0014\u0005y1/_:uK6\u001c\u0015m\u00195f?\u0012*\u0017\u000f\u0006\u0003\u0002v\nU\u0001BCA\u007f\u0005\u001f\t\t\u00111\u0001\u0002j\"Y!\u0011\u0004\u0001A\u0002\u0003\u0005\u000b\u0015BAu\u00031\u0019\u0018p\u001d;f[\u000e\u000b7\r[3!Q\u0011\u00119B!\u0002\t\u000f\t}\u0001\u0001\"\u0003\u0003\"\u0005Yq-\u001a;Qe>$xnY8m)\u0011\tIOa\t\t\u0011\u0005e$Q\u0004a\u0001\u0005K\u0001B!!\u0019\u0003(%!\u00111IA8\u0011\u001d\u0011Y\u0003\u0001C\u0005\u0005[\t\u0011bZ3u'f\u001cH/Z7\u0015\t\u0005%(q\u0006\u0005\t\u0003s\u0012I\u00031\u0001\u0003&!9!1\u0007\u0001\u0005\n\tU\u0012\u0001E1eIJ,7o\u001d$s_6\u0004&o\u001c;p)\u0011\tyDa\u000e\t\u0011\u0005e$\u0011\u0007a\u0001\u0005KAqAa\u000f\u0001\t\u0013\u0011i$\u0001\fv]&\fX/Z!eIJ,7o\u001d$s_6\u0004&o\u001c;p)\u0011\tiEa\u0010\t\u0011\u0005]%\u0011\ba\u0001\u0005\u0003\u0002B!!\u0019\u0003D%!\u00111KA8\u0011%\u00119\u0005\u0001b\u0001\n\u0013\u0011I%A\tnK6\u0014WM]*uCR,8\u000fV8J]R,\"Aa\u0013\u0011\r\t;%Q\nB*!\u0011\tyEa\u0014\n\u0007\tECA\u0001\u0007NK6\u0014WM]*uCR,8\u000fE\u0002\f\u0005+J1Aa\u0016\r\u0005\rIe\u000e\u001e\u0005\t\u00057\u0002\u0001\u0015!\u0003\u0003L\u0005\u0011R.Z7cKJ\u001cF/\u0019;vgR{\u0017J\u001c;!\u0011%\u0011y\u0006\u0001b\u0001\n\u0013\u0011\t'A\nnK6\u0014WM]*uCR,8O\u0012:p[&sG/\u0006\u0002\u0003dA1!i\u0012B*\u0005\u001bB\u0001Ba\u001a\u0001A\u0003%!1M\u0001\u0015[\u0016l'-\u001a:Ti\u0006$Xo\u001d$s_6Le\u000e\u001e\u0011\t\u0013\t-\u0004A1A\u0005\n\t5\u0014a\u0006:fC\u000eD\u0017MY5mSRL8\u000b^1ukN$v.\u00138u+\t\u0011y\u0007\u0005\u0004C\u000f\nE$1\u000b\t\u0005\u0005g\u0012IH\u0004\u0003\u0002P\tU\u0014b\u0001B<\t\u0005a!+Z1dQ\u0006\u0014\u0017\u000e\\5us&!!1\u0010B?\u0005I\u0011V-Y2iC\nLG.\u001b;z'R\fG/^:\u000b\u0007\t]D\u0001\u0003\u0005\u0003\u0002\u0002\u0001\u000b\u0011\u0002B8\u0003a\u0011X-Y2iC\nLG.\u001b;z'R\fG/^:U_&sG\u000f\t\u0005\n\u0005\u000b\u0003!\u0019!C\u0005\u0005\u000f\u000b\u0011D]3bG\"\f'-\u001b7jif\u001cF/\u0019;vg\u001a\u0013x.\\%oiV\u0011!\u0011\u0012\t\u0007\u0005\u001e\u0013\u0019F!\u001d\t\u0011\t5\u0005\u0001)A\u0005\u0005\u0013\u000b!D]3bG\"\f'-\u001b7jif\u001cF/\u0019;vg\u001a\u0013x.\\%oi\u0002BqA!%\u0001\t\u0013\u0011\u0019*A\nnCB<\u0016\u000e\u001e5FeJ|'/T3tg\u0006<W-\u0006\u0003\u0003\u0016\n\rF\u0003\u0003B*\u0005/\u00139Ka+\t\u0011\te%q\u0012a\u0001\u00057\u000b1!\\1q!!\t\tC!(\u0003\"\nM\u0013\u0002\u0002BP\u0003c\u00111!T1q!\r\u0019&1\u0015\u0003\b\u0005K\u0013yI1\u0001Y\u0005\u0005!\u0006\u0002\u0003BU\u0005\u001f\u0003\rA!)\u0002\u000bY\fG.^3\t\u0011\t5&q\u0012a\u0001\u0003S\fq!\u001e8l]><h\u000eC\u0004\u00032\u0002!IAa-\u0002\u0017)|\u0017N\u001c+p!J|Go\u001c\u000b\u0007\u0005k\u0013YLa0\u0011\t\u0005\u0005$qW\u0005\u0005\u0005s\u000byG\u0001\u0003K_&t\u0007\u0002\u0003B_\u0005_\u0003\r!!\u0014\u0002\t9|G-\u001a\u0005\t\u0005\u0003\u0014y\u000b1\u0001\u0003D\u0006)!o\u001c7fgB1\u0011\u0011\u0005Bc\u0003SLAAa2\u00022\t\u00191+\u001a;\t\u000f\t-\u0007\u0001\"\u0003\u0003N\u0006y\u0011N\\5u\u0015>Lg\u000eV8Qe>$x\u000e\u0006\u0003\u0003P\nU\u0007\u0003BA1\u0005#LAAa5\u0002p\tA\u0011J\\5u\u0015>Lg\u000e\u0003\u0005\u0003X\n%\u0007\u0019\u0001Bm\u00035\u0019WO\u001d:f]R\u001cuN\u001c4jOB!!1\u001cBu\u001b\t\u0011iN\u0003\u0003\u0003`\n\u0005\u0018AB2p]\u001aLwM\u0003\u0003\u0003d\n\u0015\u0018\u0001\u0003;za\u0016\u001c\u0018MZ3\u000b\u0005\t\u001d\u0018aA2p[&!!1\u001eBo\u0005\u0019\u0019uN\u001c4jO\"9!q\u001e\u0001\u0005\n\tE\u0018AE5oSRTu.\u001b8BG.$v\u000e\u0015:pi>$bAa=\u0003z\nm\b\u0003BA1\u0005kLAAa>\u0002p\tY\u0011J\\5u\u0015>Lg.Q2l\u0011!\tIH!<A\u0002\u0005}\u0002\u0002\u0003B\u007f\u0005[\u0004\rAa@\u0002\u0017\r|gNZ5h\u0007\",7m\u001b\t\u0005\u0007\u0003\u0019yA\u0004\u0003\u0004\u0004\r-a\u0002BB\u0003\u0007\u0013qA!!\n\u0004\b%\tq!\u0003\u0002\u0006\r%\u00191Q\u0002\u0003\u0002+%sG/\u001a:oC2\u001cE.^:uKJ\f5\r^5p]&!1\u0011CB\n\u0005-\u0019uN\u001c4jO\u000eCWmY6\u000b\u0007\r5A\u0001C\u0004\u0004\u0018\u0001!Ia!\u0007\u0002\u001d],GnY8nKR{\u0007K]8u_R111DB\u0011\u0007K\u0001B!!\u0019\u0004\u001e%!1qDA8\u0005\u001d9V\r\\2p[\u0016D\u0001ba\t\u0004\u0016\u0001\u0007\u0011QJ\u0001\u0005MJ|W\u000e\u0003\u0005\u0004(\rU\u0001\u0019AB\u0015\u0003\u00199wn]:jaB!\u0011qJB\u0016\u0013\r\u0019i\u0003\u0002\u0002\u0007\u000f>\u001c8/\u001b9\t\u000f\rE\u0002\u0001\"\u0003\u00044\u0005iqm\\:tSB$v\u000e\u0015:pi>$Ba!\u000e\u0004BA!1qGB\u001f\u001d\u0011\t\tg!\u000f\n\t\rm\u0012qN\u0001\u0007\u000f>\u001c8/\u001b9\n\t\u0005M4q\b\u0006\u0005\u0007w\ty\u0007\u0003\u0005\u0004(\r=\u0002\u0019AB\u0015\u0011\u001d\u0019)\u0005\u0001C\u0005\u0007\u000f\n!C^3di>\u00148\t\\8dWR{\u0007K]8u_R11\u0011JB+\u0007?\u0002Baa\u0013\u0004R9!\u0011\u0011MB'\u0013\u0011\u0019y%a\u001c\u0002\u0017Y+7\r^8s\u00072|7m[\u0005\u0005\u0003g\u001a\u0019F\u0003\u0003\u0004P\u0005=\u0004\u0002CB,\u0007\u0007\u0002\ra!\u0017\u0002\u000fY,'o]5p]B!\u0011qJB.\u0013\r\u0019i\u0006\u0002\u0002\f-\u0016\u001cGo\u001c:DY>\u001c7\u000e\u0003\u0005\u0004b\r\r\u0003\u0019AB2\u0003-A\u0017m\u001d5NCB\u0004\u0018N\\4\u0011\u0011\u0005\u0005\"QTAu\u0005'Bqaa\u001a\u0001\t\u0013\u0019I'A\u000bh_N\u001c\u0018\u000e]#om\u0016dw\u000e]3U_B\u0013x\u000e^8\u0015\t\r-4\u0011\u000f\t\u0005\u0003C\u001ai'\u0003\u0003\u0004p\u0005=$AD$pgNL\u0007/\u00128wK2|\u0007/\u001a\u0005\t\u0007g\u001a)\u00071\u0001\u0004v\u0005AQM\u001c<fY>\u0004X\r\u0005\u0003\u0002P\r]\u0014bAB8\t!911\u0010\u0001\u0005\n\ru\u0014aE4pgNL\u0007o\u0015;biV\u001cHk\u001c)s_R|G\u0003BB@\u0007\u000b\u0003B!!\u0019\u0004\u0002&!11QA8\u000519un]:jaN#\u0018\r^;t\u0011!\u00199i!\u001fA\u0002\r%\u0015AB:uCR,8\u000f\u0005\u0003\u0002P\r-\u0015bABB\t!91q\u0012\u0001\u0005\n\rE\u0015\u0001G4pgNL\u0007/\u00128wK2|\u0007/\u001a$s_6\u0014\u0015N\\1ssR!1QOBJ\u0011\u001d\tIa!$A\u0002\tDqaa&\u0001\t\u0013\u0019I*\u0001\fh_N\u001c\u0018\u000e]*uCR,8O\u0012:p[\nKg.\u0019:z)\u0011\u0019Iia'\t\u000f\u0005%1Q\u0013a\u0001E\"91q\u0014\u0001\u0005\n\r\u0005\u0016aD4pgNL\u0007O\u0012:p[B\u0013x\u000e^8\u0015\t\r%21\u0015\u0005\t\u0007O\u0019i\n1\u0001\u0004&B!\u0011\u0011MBT\u0013\u0011\u0019i#a\u001c\t\u000f\r-\u0006\u0001\"\u0003\u0004.\u0006!b/Z2u_J\u001cEn\\2l\rJ|W\u000e\u0015:pi>$ba!\u0017\u00040\u000eU\u0006\u0002CB,\u0007S\u0003\ra!-\u0011\t\u0005\u000541W\u0005\u0005\u0007;\ny\u0007\u0003\u0005\u0004b\r%\u0006\u0019AB\\!\u0015\u00115\u0011XAu\u0013\r\u0019Yl\u0011\u0002\u0004'\u0016\f\bbBB`\u0001\u0011%1\u0011Y\u0001\u0018O>\u001c8/\u001b9F]Z,Gn\u001c9f\rJ|W\u000e\u0015:pi>$Ba!\u001e\u0004D\"A11OB_\u0001\u0004\u0019Y\u0007C\u0004\u0004H\u0002!Ia!3\u0002+\u001d|7o]5q'R\fG/^:Ge>l\u0007K]8u_R!1\u0011RBf\u0011!\u00199i!2A\u0002\r}\u0004bBBh\u0001\u0011\u00051\u0011[\u0001\u001cG2,8\u000f^3s%>,H/\u001a:Q_>dgI]8n\u0005&t\u0017M]=\u0015\t\u0005-61\u001b\u0005\b\u0003\u0013\u0019i\r1\u0001c\u0011\u001d\u00199\u000e\u0001C\u0005\u00073\fQ\u0002]8pY\u001a\u0013x.\u001c)s_R|G\u0003BAd\u00077D\u0001\"!2\u0004V\u0002\u0007\u0011Q\u0018\u0005\b\u0007?\u0004A\u0011BBq\u0003\t\u001aG.^:uKJ\u0014v.\u001e;feB{w\u000e\\*fiRLgnZ:Ge>l\u0007K]8u_R!\u0011q\\Br\u0011!\u0019)o!8A\u0002\u0005U\u0017\u0001B2saN\u0004")
public class ClusterMessageSerializer
implements BaseSerializer {
    private Serialization serialization;
    private FiniteDuration GossipTimeToLive;
    private final ExtendedActorSystem system;
    private final HashMap<Class<?>, Function1<byte[], Object>> fromBinaryMap;
    private volatile String protocolCache;
    private volatile String systemCache;
    private final HashMap<MemberStatus, Object> memberStatusToInt;
    private final HashMap<Object, MemberStatus> memberStatusFromInt;
    private final HashMap<Reachability.ReachabilityStatus, Object> reachabilityStatusToInt;
    private final HashMap<Object, Reachability.ReachabilityStatus> reachabilityStatusFromInt;
    private final int identifier;
    private volatile byte bitmap$0;

    @InternalApi
    public int identifierFromConfig() {
        return BaseSerializer.identifierFromConfig$((BaseSerializer)this);
    }

    public final Object fromBinary(byte[] bytes) {
        return Serializer.fromBinary$((Serializer)this, (byte[])bytes);
    }

    public final Object fromBinary(byte[] bytes, Class<?> clazz) throws NotSerializableException {
        return Serializer.fromBinary$((Serializer)this, (byte[])bytes, clazz);
    }

    public int identifier() {
        return this.identifier;
    }

    public void akka$serialization$BaseSerializer$_setter_$identifier_$eq(int x$1) {
        this.identifier = x$1;
    }

    public ExtendedActorSystem system() {
        return this.system;
    }

    private Serialization serialization$lzycompute() {
        ClusterMessageSerializer clusterMessageSerializer = this;
        synchronized (clusterMessageSerializer) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.serialization = (Serialization)SerializationExtension$.MODULE$.apply((ActorSystem)this.system());
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.serialization;
    }

    private Serialization serialization() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.serialization$lzycompute() : this.serialization;
    }

    private final int BufferSize() {
        return 4096;
    }

    private FiniteDuration GossipTimeToLive$lzycompute() {
        ClusterMessageSerializer clusterMessageSerializer = this;
        synchronized (clusterMessageSerializer) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.GossipTimeToLive = ((Cluster)Cluster$.MODULE$.apply((ActorSystem)this.system())).settings().GossipTimeToLive();
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.GossipTimeToLive;
    }

    private FiniteDuration GossipTimeToLive() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.GossipTimeToLive$lzycompute() : this.GossipTimeToLive;
    }

    private HashMap<Class<?>, Function1<byte[], Object>> fromBinaryMap() {
        return this.fromBinaryMap;
    }

    public boolean includeManifest() {
        return true;
    }

    public byte[] toBinary(Object obj) {
        byte[] byArray;
        Object object = obj;
        if (object instanceof ClusterHeartbeatSender.Heartbeat) {
            ClusterHeartbeatSender.Heartbeat heartbeat = (ClusterHeartbeatSender.Heartbeat)object;
            Address from = heartbeat.from();
            byArray = this.addressToProtoByteArray(from);
        } else if (object instanceof ClusterHeartbeatSender.HeartbeatRsp) {
            ClusterHeartbeatSender.HeartbeatRsp heartbeatRsp = (ClusterHeartbeatSender.HeartbeatRsp)object;
            UniqueAddress from = heartbeatRsp.from();
            byArray = this.uniqueAddressToProtoByteArray(from);
        } else if (object instanceof GossipEnvelope) {
            GossipEnvelope gossipEnvelope = (GossipEnvelope)object;
            byArray = this.gossipEnvelopeToProto(gossipEnvelope).toByteArray();
        } else if (object instanceof GossipStatus) {
            GossipStatus gossipStatus = (GossipStatus)object;
            byArray = this.gossipStatusToProto(gossipStatus).toByteArray();
        } else if (object instanceof InternalClusterAction.Join) {
            InternalClusterAction.Join join = (InternalClusterAction.Join)object;
            UniqueAddress node = join.node();
            scala.collection.immutable.Set<String> roles = join.roles();
            byArray = this.joinToProto(node, roles).toByteArray();
        } else if (object instanceof InternalClusterAction.Welcome) {
            InternalClusterAction.Welcome welcome = (InternalClusterAction.Welcome)object;
            UniqueAddress from = welcome.from();
            Gossip gossip = welcome.gossip();
            byArray = this.compress((MessageLite)this.welcomeToProto(from, gossip));
        } else if (object instanceof ClusterUserAction.Leave) {
            ClusterUserAction.Leave leave = (ClusterUserAction.Leave)object;
            Address address = leave.address();
            byArray = this.addressToProtoByteArray(address);
        } else if (object instanceof ClusterUserAction.Down) {
            ClusterUserAction.Down down = (ClusterUserAction.Down)object;
            Address address = down.address();
            byArray = this.addressToProtoByteArray(address);
        } else if (object instanceof InternalClusterAction.InitJoin) {
            InternalClusterAction.InitJoin initJoin = (InternalClusterAction.InitJoin)object;
            Config config = initJoin.configOfJoiningNode();
            byArray = this.initJoinToProto(config).toByteArray();
        } else if (object instanceof InternalClusterAction.InitJoinAck) {
            InternalClusterAction.InitJoinAck initJoinAck = (InternalClusterAction.InitJoinAck)object;
            Address address = initJoinAck.address();
            InternalClusterAction.ConfigCheck configCheck = initJoinAck.configCheck();
            byArray = this.initJoinAckToProto(address, configCheck).toByteArray();
        } else if (object instanceof InternalClusterAction.InitJoinNack) {
            InternalClusterAction.InitJoinNack initJoinNack = (InternalClusterAction.InitJoinNack)object;
            Address address = initJoinNack.address();
            byArray = this.addressToProtoByteArray(address);
        } else if (object instanceof InternalClusterAction.ExitingConfirmed) {
            InternalClusterAction.ExitingConfirmed exitingConfirmed = (InternalClusterAction.ExitingConfirmed)object;
            UniqueAddress node = exitingConfirmed.node();
            byArray = this.uniqueAddressToProtoByteArray(node);
        } else if (object instanceof ClusterRouterPool) {
            ClusterRouterPool clusterRouterPool = (ClusterRouterPool)object;
            byArray = this.clusterRouterPoolToProtoByteArray(clusterRouterPool);
        } else {
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Can't serialize object of type ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{obj.getClass()})));
        }
        return byArray;
    }

    public byte[] compress(MessageLite msg) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream(4096);
        try (GZIPOutputStream zip = new GZIPOutputStream(bos);){
            msg.writeTo((OutputStream)zip);
        }
        return bos.toByteArray();
    }

    public byte[] decompress(byte[] bytes) {
        GZIPInputStream in = new GZIPInputStream(new ByteArrayInputStream(bytes));
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] buffer = new byte[4096];
        try {
            this.readChunk$1(in, out, buffer);
        }
        finally {
            in.close();
        }
        return out.toByteArray();
    }

    public Object fromBinary(byte[] bytes, Option<Class<?>> clazz) {
        Object object;
        Option<Class<?>> option = clazz;
        if (option instanceof Some) {
            Some some = (Some)option;
            Class c = (Class)some.value();
            Option option2 = this.fromBinaryMap().get((Object)c);
            if (!(option2 instanceof Some)) {
                if (None$.MODULE$.equals(option2)) {
                    throw new NotSerializableException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unimplemented deserialization of message class ", " in ClusterSerializer"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{c})));
                }
                throw new MatchError((Object)option2);
            }
            Some some2 = (Some)option2;
            Function1 f = (Function1)some2.value();
            object = f.apply((Object)bytes);
        } else {
            throw new IllegalArgumentException("Need a cluster message class to be able to deserialize bytes in ClusterSerializer");
        }
        Object object2 = object;
        return object2;
    }

    private Address addressFromBinary(byte[] bytes) {
        return this.addressFromProto(ClusterMessages.Address.parseFrom(bytes));
    }

    private UniqueAddress uniqueAddressFromBinary(byte[] bytes) {
        return this.uniqueAddressFromProto(ClusterMessages.UniqueAddress.parseFrom(bytes));
    }

    private ClusterMessages.Address.Builder addressToProto(Address address) {
        String host;
        Option option;
        String actorSystem;
        String protocol;
        block3: {
            block2: {
                Address address2 = address;
                if (address2 == null) break block2;
                protocol = address2.protocol();
                actorSystem = address2.system();
                Option option2 = address2.host();
                option = address2.port();
                if (!(option2 instanceof Some)) break block2;
                Some some = (Some)option2;
                host = (String)some.value();
                if (option instanceof Some) break block3;
            }
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Address [", "] could not be serialized: host or port missing."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{address})));
        }
        Some some = (Some)option;
        int port = BoxesRunTime.unboxToInt((Object)some.value());
        ClusterMessages.Address.Builder builder = ClusterMessages.Address.newBuilder().setSystem(actorSystem).setHostname(host).setPort(port).setProtocol(protocol);
        return builder;
    }

    private byte[] addressToProtoByteArray(Address address) {
        return this.addressToProto(address).build().toByteArray();
    }

    private ClusterMessages.UniqueAddress.Builder uniqueAddressToProto(UniqueAddress uniqueAddress) {
        return ClusterMessages.UniqueAddress.newBuilder().setAddress(this.addressToProto(uniqueAddress.address())).setUid((int)uniqueAddress.longUid()).setUid2((int)(uniqueAddress.longUid() >> 32));
    }

    private byte[] uniqueAddressToProtoByteArray(UniqueAddress uniqueAddress) {
        return this.uniqueAddressToProto(uniqueAddress).build().toByteArray();
    }

    private byte[] clusterRouterPoolToProtoByteArray(ClusterRouterPool rp) {
        ClusterMessages.ClusterRouterPool.Builder builder = ClusterMessages.ClusterRouterPool.newBuilder();
        builder.setPool(this.poolToProto(rp.local()));
        builder.setSettings(this.clusterRouterPoolSettingsToProto(rp.settings()));
        return builder.build().toByteArray();
    }

    private ClusterMessages.Pool poolToProto(Pool pool) {
        ClusterMessages.Pool.Builder builder;
        ClusterMessages.Pool.Builder builder2 = ClusterMessages.Pool.newBuilder();
        Serializer serializer = this.serialization().findSerializerFor((Object)pool);
        builder2.setSerializerId(serializer.identifier()).setData(ByteString.copyFrom((byte[])serializer.toBinary((Object)pool)));
        Serializer serializer2 = serializer;
        if (serializer2 instanceof SerializerWithStringManifest) {
            SerializerWithStringManifest serializerWithStringManifest = (SerializerWithStringManifest)serializer2;
            builder = builder2.setManifest(serializerWithStringManifest.manifest((Object)pool));
        } else {
            builder = builder2.setManifest(serializer.includeManifest() ? pool.getClass().getName() : "");
        }
        return builder2.build();
    }

    private ClusterMessages.ClusterRouterPoolSettings clusterRouterPoolSettingsToProto(ClusterRouterPoolSettings settings) {
        ClusterMessages.ClusterRouterPoolSettings.Builder builder = ClusterMessages.ClusterRouterPoolSettings.newBuilder();
        builder.setAllowLocalRoutees(settings.allowLocalRoutees()).setMaxInstancesPerNode(settings.maxInstancesPerNode()).setTotalInstances(settings.totalInstances()).addAllUseRoles((java.lang.Iterable)JavaConverters$.MODULE$.setAsJavaSetConverter(settings.useRoles()).asJava());
        settings.useRole().foreach((Function1 & Serializable & scala.Serializable)value -> builder.setUseRole((String)value));
        return builder.build();
    }

    private String protocolCache() {
        return this.protocolCache;
    }

    private void protocolCache_$eq(String x$1) {
        this.protocolCache = x$1;
    }

    private String systemCache() {
        return this.systemCache;
    }

    private void systemCache_$eq(String x$1) {
        this.systemCache = x$1;
    }

    /*
     * WARNING - void declaration
     */
    private String getProtocol(ClusterMessages.Address address) {
        String string;
        String pc;
        String p = address.getProtocol();
        String string2 = pc = this.protocolCache();
        String string3 = p;
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            string = pc;
        } else {
            void var2_2;
            this.protocolCache_$eq(p);
            string = var2_2;
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private String getSystem(ClusterMessages.Address address) {
        String string;
        String sc;
        String s = address.getSystem();
        String string2 = sc = this.systemCache();
        String string3 = s;
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            string = sc;
        } else {
            void var2_2;
            this.systemCache_$eq(s);
            string = var2_2;
        }
        return string;
    }

    private Address addressFromProto(ClusterMessages.Address address) {
        return Address$.MODULE$.apply(this.getProtocol(address), this.getSystem(address), address.getHostname(), address.getPort());
    }

    private UniqueAddress uniqueAddressFromProto(ClusterMessages.UniqueAddress uniqueAddress) {
        return new UniqueAddress(this.addressFromProto(uniqueAddress.getAddress()), uniqueAddress.hasUid2() ? (long)uniqueAddress.getUid2() << 32 | (long)uniqueAddress.getUid() & 0xFFFFFFFFL : (long)uniqueAddress.getUid());
    }

    private HashMap<MemberStatus, Object> memberStatusToInt() {
        return this.memberStatusToInt;
    }

    private HashMap<Object, MemberStatus> memberStatusFromInt() {
        return this.memberStatusFromInt;
    }

    private HashMap<Reachability.ReachabilityStatus, Object> reachabilityStatusToInt() {
        return this.reachabilityStatusToInt;
    }

    private HashMap<Object, Reachability.ReachabilityStatus> reachabilityStatusFromInt() {
        return this.reachabilityStatusFromInt;
    }

    private <T> int mapWithErrorMessage(Map<T, Object> map, T value, String unknown) {
        int x;
        Option option = map.get(value);
        if (!(option instanceof Some)) {
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unknown ", " [", "] in cluster message"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{unknown, value})));
        }
        Some some = (Some)option;
        int n = x = BoxesRunTime.unboxToInt((Object)some.value());
        return n;
    }

    private ClusterMessages.Join joinToProto(UniqueAddress node, scala.collection.immutable.Set<String> roles) {
        return ClusterMessages.Join.newBuilder().setNode(this.uniqueAddressToProto(node)).addAllRoles((java.lang.Iterable)JavaConverters$.MODULE$.setAsJavaSetConverter(roles).asJava()).build();
    }

    private ClusterMessages.InitJoin initJoinToProto(Config currentConfig) {
        return ClusterMessages.InitJoin.newBuilder().setCurrentConfig(currentConfig.root().render(ConfigRenderOptions.concise())).build();
    }

    private ClusterMessages.InitJoinAck initJoinAckToProto(Address address, InternalClusterAction.ConfigCheck configCheck) {
        ClusterMessages.ConfigCheck.Builder builder;
        ClusterMessages.ConfigCheck.Builder configCheckBuilder = ClusterMessages.ConfigCheck.newBuilder();
        InternalClusterAction.ConfigCheck configCheck2 = configCheck;
        if (InternalClusterAction$UncheckedConfig$.MODULE$.equals(configCheck2)) {
            builder = configCheckBuilder.setType(ClusterMessages.ConfigCheck.Type.UncheckedConfig);
        } else if (InternalClusterAction$IncompatibleConfig$.MODULE$.equals(configCheck2)) {
            builder = configCheckBuilder.setType(ClusterMessages.ConfigCheck.Type.IncompatibleConfig);
        } else if (configCheck2 instanceof InternalClusterAction.CompatibleConfig) {
            InternalClusterAction.CompatibleConfig compatibleConfig = (InternalClusterAction.CompatibleConfig)configCheck2;
            Config conf = compatibleConfig.clusterConfig();
            builder = configCheckBuilder.setType(ClusterMessages.ConfigCheck.Type.CompatibleConfig).setClusterConfig(conf.root().render(ConfigRenderOptions.concise()));
        } else {
            throw new MatchError((Object)configCheck2);
        }
        return ClusterMessages.InitJoinAck.newBuilder().setAddress(this.addressToProto(address)).setConfigCheck(configCheckBuilder.build()).build();
    }

    private ClusterMessages.Welcome welcomeToProto(UniqueAddress from, Gossip gossip) {
        return ClusterMessages.Welcome.newBuilder().setFrom(this.uniqueAddressToProto(from)).setGossip(this.gossipToProto(gossip)).build();
    }

    private ClusterMessages.Gossip.Builder gossipToProto(Gossip gossip) {
        Vector allMembers = gossip.members().toVector();
        Vector allAddresses = (Vector)((Vector)allMembers.map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.uniqueAddress(), Vector$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)gossip.tombstones().keys(), Vector$.MODULE$.canBuildFrom());
        Map addressMapping = ((TraversableOnce)allAddresses.zipWithIndex(Vector$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        Vector allRoles = (Vector)((TraversableLike)allMembers.foldLeft((Object)Predef$.MODULE$.Set().empty(), (Function2 & Serializable & scala.Serializable)(acc, m) -> (scala.collection.immutable.Set)acc.union(m.roles()))).to(Vector$.MODULE$.canBuildFrom());
        Map roleMapping = ((TraversableOnce)allRoles.zipWithIndex(Vector$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        Vector allHashes = (Vector)gossip.version().versions().keys().to(Vector$.MODULE$.canBuildFrom());
        Map hashMapping = ((TraversableOnce)allHashes.zipWithIndex(Vector$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        Iterable reachability = this.reachabilityToProto$1(gossip.overview().reachability(), addressMapping);
        scala.collection.immutable.Set members = (scala.collection.immutable.Set)gossip.members().map((Function1 & Serializable & scala.Serializable)member -> this.memberToProto$1((Member)member, addressMapping, roleMapping), Set$.MODULE$.canBuildFrom());
        scala.collection.immutable.Set seen = (scala.collection.immutable.Set)gossip.overview().seen().map((Function1 & Serializable & scala.Serializable)uniqueAddress -> this.mapUniqueAddress$1((UniqueAddress)uniqueAddress, addressMapping), Set$.MODULE$.canBuildFrom());
        ClusterMessages.GossipOverview.Builder overview = ClusterMessages.GossipOverview.newBuilder().addAllSeen((java.lang.Iterable)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)seen).asJava()).addAllObserverReachability((java.lang.Iterable)JavaConverters$.MODULE$.asJavaIterableConverter((Iterable)reachability.map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.build(), scala.collection.Iterable$.MODULE$.canBuildFrom())).asJava());
        return ClusterMessages.Gossip.newBuilder().addAllAllAddresses((java.lang.Iterable)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)allAddresses.map((Function1 & Serializable & scala.Serializable)x$5 -> this.uniqueAddressToProto((UniqueAddress)x$5).build(), Vector$.MODULE$.canBuildFrom())).asJava()).addAllAllRoles((java.lang.Iterable)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)allRoles).asJava()).addAllAllHashes((java.lang.Iterable)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)allHashes).asJava()).addAllMembers((java.lang.Iterable)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)members.map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.build(), Set$.MODULE$.canBuildFrom())).asJava()).setOverview(overview).setVersion(this.vectorClockToProto(gossip.version(), (Map<String, Object>)hashMapping)).addAllTombstones((java.lang.Iterable)JavaConverters$.MODULE$.asJavaIterableConverter((Iterable)gossip.tombstones().map((Function1 & Serializable & scala.Serializable)t -> this.tombstoneToProto$1((Tuple2)t, addressMapping), Iterable$.MODULE$.canBuildFrom())).asJava());
    }

    private ClusterMessages.VectorClock.Builder vectorClockToProto(VectorClock version, Map<String, Object> hashMapping) {
        Iterable versions = (Iterable)version.versions().map((Function1 & Serializable & scala.Serializable)x0$8 -> {
            Tuple2 tuple2 = x0$8;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String n = (String)tuple2._1();
            long t = tuple2._2$mcJ$sp();
            ClusterMessages.VectorClock.Version.Builder builder = ClusterMessages.VectorClock.Version.newBuilder().setHashIndex(this.mapWithErrorMessage(hashMapping, n, "hash")).setTimestamp(t);
            return builder;
        }, Iterable$.MODULE$.canBuildFrom());
        return ClusterMessages.VectorClock.newBuilder().setTimestamp(0L).addAllVersions((java.lang.Iterable)JavaConverters$.MODULE$.asJavaIterableConverter((Iterable)versions.map((Function1 & Serializable & scala.Serializable)x$7 -> x$7.build(), scala.collection.Iterable$.MODULE$.canBuildFrom())).asJava());
    }

    private ClusterMessages.GossipEnvelope gossipEnvelopeToProto(GossipEnvelope envelope) {
        return ClusterMessages.GossipEnvelope.newBuilder().setFrom(this.uniqueAddressToProto(envelope.from())).setTo(this.uniqueAddressToProto(envelope.to())).setSerializedGossip(ByteString.copyFrom((byte[])this.compress((MessageLite)this.gossipToProto(envelope.gossip()).build()))).build();
    }

    private ClusterMessages.GossipStatus gossipStatusToProto(GossipStatus status) {
        Vector allHashes = status.version().versions().keys().toVector();
        Map hashMapping = ((TraversableOnce)allHashes.zipWithIndex(Vector$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        return ClusterMessages.GossipStatus.newBuilder().setFrom(this.uniqueAddressToProto(status.from())).addAllAllHashes((java.lang.Iterable)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)allHashes).asJava()).setVersion(this.vectorClockToProto(status.version(), (Map<String, Object>)hashMapping)).build();
    }

    private GossipEnvelope gossipEnvelopeFromBinary(byte[] bytes) {
        return this.gossipEnvelopeFromProto(ClusterMessages.GossipEnvelope.parseFrom(bytes));
    }

    private GossipStatus gossipStatusFromBinary(byte[] bytes) {
        return this.gossipStatusFromProto(ClusterMessages.GossipStatus.parseFrom(bytes));
    }

    private Gossip gossipFromProto(ClusterMessages.Gossip gossip) {
        Vector addressMapping = (Vector)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(gossip.getAllAddressesList()).asScala()).map((Function1 & Serializable & scala.Serializable)uniqueAddress -> this.uniqueAddressFromProto((ClusterMessages.UniqueAddress)uniqueAddress), package$.MODULE$.breakOut(Vector$.MODULE$.canBuildFrom()));
        Vector roleMapping = (Vector)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(gossip.getAllRolesList()).asScala()).map((Function1 & Serializable & scala.Serializable)x -> (String)Predef$.MODULE$.identity(x), package$.MODULE$.breakOut(Vector$.MODULE$.canBuildFrom()));
        Vector hashMapping = (Vector)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(gossip.getAllHashesList()).asScala()).map((Function1 & Serializable & scala.Serializable)x -> (String)Predef$.MODULE$.identity(x), package$.MODULE$.breakOut(Vector$.MODULE$.canBuildFrom()));
        SortedSet members = (SortedSet)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(gossip.getMembersList()).asScala()).map((Function1 & Serializable & scala.Serializable)member -> this.memberFromProto$1((ClusterMessages.Member)member, addressMapping, roleMapping), package$.MODULE$.breakOut(SortedSet$.MODULE$.newCanBuildFrom(Member$.MODULE$.ordering())));
        Reachability reachability = this.reachabilityFromProto$1((Iterable)JavaConverters$.MODULE$.asScalaBufferConverter(gossip.getOverview().getObserverReachabilityList()).asScala(), addressMapping);
        scala.collection.immutable.Set seen = (scala.collection.immutable.Set)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(gossip.getOverview().getSeenList()).asScala()).map((Function1 & Serializable & scala.Serializable)x$9 -> (UniqueAddress)addressMapping.apply(Predef$.MODULE$.Integer2int(x$9)), package$.MODULE$.breakOut(Set$.MODULE$.canBuildFrom()));
        GossipOverview overview = new GossipOverview((scala.collection.immutable.Set<UniqueAddress>)seen, reachability);
        Map tombstones = (Map)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(gossip.getTombstonesList()).asScala()).map((Function1 & Serializable & scala.Serializable)tombstone -> ClusterMessageSerializer.tombstoneFromProto$1(tombstone, addressMapping), package$.MODULE$.breakOut(Map$.MODULE$.canBuildFrom()));
        return new Gossip((SortedSet<Member>)members, overview, this.vectorClockFromProto(gossip.getVersion(), (scala.collection.immutable.Seq<String>)hashMapping), (Map<UniqueAddress, Object>)tombstones);
    }

    private VectorClock vectorClockFromProto(ClusterMessages.VectorClock version, scala.collection.immutable.Seq<String> hashMapping) {
        return new VectorClock((TreeMap<String, Object>)((TreeMap)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(version.getVersionsList()).asScala()).map((Function1 & Serializable & scala.Serializable)v -> new Tuple2((Object)VectorClock$Node$.MODULE$.fromHash((String)hashMapping.apply(v.getHashIndex())), (Object)BoxesRunTime.boxToLong((long)v.getTimestamp())), package$.MODULE$.breakOut(TreeMap$.MODULE$.canBuildFrom((Ordering)Ordering.String$.MODULE$)))));
    }

    private GossipEnvelope gossipEnvelopeFromProto(ClusterMessages.GossipEnvelope envelope) {
        ByteString serializedGossip = envelope.getSerializedGossip();
        return GossipEnvelope$.MODULE$.apply(this.uniqueAddressFromProto(envelope.getFrom()), this.uniqueAddressFromProto(envelope.getTo()), Deadline$.MODULE$.now().$plus(this.GossipTimeToLive()), (Function0<Gossip>)(Function0 & Serializable & scala.Serializable)() -> this.gossipFromProto(ClusterMessages.Gossip.parseFrom(this.decompress(serializedGossip.toByteArray()))));
    }

    private GossipStatus gossipStatusFromProto(ClusterMessages.GossipStatus status) {
        return new GossipStatus(this.uniqueAddressFromProto(status.getFrom()), this.vectorClockFromProto(status.getVersion(), (scala.collection.immutable.Seq<String>)((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(status.getAllHashesList()).asScala()).toVector()));
    }

    public ClusterRouterPool clusterRouterPoolFromBinary(byte[] bytes) {
        ClusterMessages.ClusterRouterPool crp = ClusterMessages.ClusterRouterPool.parseFrom(bytes);
        return new ClusterRouterPool(this.poolFromProto(crp.getPool()), this.clusterRouterPoolSettingsFromProto(crp.getSettings()));
    }

    private Pool poolFromProto(ClusterMessages.Pool pool) {
        return (Pool)this.serialization().deserialize(pool.getData().toByteArray(), pool.getSerializerId(), pool.getManifest()).get();
    }

    private ClusterRouterPoolSettings clusterRouterPoolSettingsFromProto(ClusterMessages.ClusterRouterPoolSettings crps) {
        return new ClusterRouterPoolSettings(crps.getTotalInstances(), crps.getMaxInstancesPerNode(), crps.getAllowLocalRoutees(), (scala.collection.immutable.Set<String>)(crps.hasUseRole() ? (scala.collection.immutable.Set)((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(crps.getUseRolesList()).asScala()).toSet().$plus((Object)crps.getUseRole()) : ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(crps.getUseRolesList()).asScala()).toSet()));
    }

    private final void readChunk$1(GZIPInputStream in$1, ByteArrayOutputStream out$1, byte[] buffer$1) {
        block3: while (true) {
            int n = in$1.read(buffer$1);
            switch (n) {
                case -1: {
                    break block3;
                }
                default: {
                    out$1.write(buffer$1, 0, n);
                    break;
                }
            }
        }
    }

    private final Integer mapUniqueAddress$1(UniqueAddress uniqueAddress, Map addressMapping$1) {
        return Predef$.MODULE$.int2Integer(this.mapWithErrorMessage(addressMapping$1, uniqueAddress, "address"));
    }

    private final Integer mapRole$1(String role, Map roleMapping$1) {
        return Predef$.MODULE$.int2Integer(this.mapWithErrorMessage(roleMapping$1, role, "role"));
    }

    private final ClusterMessages.Member.Builder memberToProto$1(Member member, Map addressMapping$1, Map roleMapping$1) {
        return ClusterMessages.Member.newBuilder().setAddressIndex(Predef$.MODULE$.Integer2int(this.mapUniqueAddress$1(member.uniqueAddress(), addressMapping$1))).setUpNumber(member.upNumber()).setStatus(ClusterMessages.MemberStatus.valueOf(BoxesRunTime.unboxToInt((Object)this.memberStatusToInt().apply((Object)member.status())))).addAllRolesIndexes((java.lang.Iterable)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)member.roles().map((Function1 & Serializable & scala.Serializable)role -> this.mapRole$1((String)role, roleMapping$1), Set$.MODULE$.canBuildFrom())).asJava());
    }

    private final Iterable reachabilityToProto$1(Reachability reachability, Map addressMapping$1) {
        return (Iterable)reachability.versions().map((Function1 & Serializable & scala.Serializable)x0$7 -> {
            Tuple2 tuple2 = x0$7;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            UniqueAddress observer = (UniqueAddress)tuple2._1();
            long version = tuple2._2$mcJ$sp();
            IndexedSeq subjectReachability = (IndexedSeq)reachability.recordsFrom(observer).map((Function1 & Serializable & scala.Serializable)r -> ClusterMessages.SubjectReachability.newBuilder().setAddressIndex(Predef$.MODULE$.Integer2int(this.mapUniqueAddress$1(r.subject(), addressMapping$1))).setStatus(ClusterMessages.ReachabilityStatus.valueOf(BoxesRunTime.unboxToInt((Object)this.reachabilityStatusToInt().apply((Object)r.status())))).setVersion(r.version()), IndexedSeq$.MODULE$.canBuildFrom());
            ClusterMessages.ObserverReachability.Builder builder = ClusterMessages.ObserverReachability.newBuilder().setAddressIndex(Predef$.MODULE$.Integer2int(this.mapUniqueAddress$1(observer, addressMapping$1))).setVersion(version).addAllSubjectReachability((java.lang.Iterable)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)subjectReachability.map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.build(), IndexedSeq$.MODULE$.canBuildFrom())).asJava());
            return builder;
        }, Iterable$.MODULE$.canBuildFrom());
    }

    private final ClusterMessages.Tombstone tombstoneToProto$1(Tuple2 t, Map addressMapping$1) {
        return ClusterMessages.Tombstone.newBuilder().setAddressIndex(Predef$.MODULE$.Integer2int(this.mapUniqueAddress$1((UniqueAddress)t._1(), addressMapping$1))).setTimestamp(t._2$mcJ$sp()).build();
    }

    public static final /* synthetic */ void $anonfun$gossipFromProto$4(ClusterMessageSerializer $this, Vector addressMapping$2, VectorBuilder recordBuilder$1, MapBuilder versionsBuilder$1, ClusterMessages.ObserverReachability o) {
        UniqueAddress observer = (UniqueAddress)addressMapping$2.apply(o.getAddressIndex());
        versionsBuilder$1.$plus$eq(new Tuple2((Object)observer, (Object)BoxesRunTime.boxToLong((long)o.getVersion())));
        ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(o.getSubjectReachabilityList()).asScala()).foreach((Function1 & Serializable & scala.Serializable)s -> {
            UniqueAddress subject = (UniqueAddress)addressMapping$2.apply(s.getAddressIndex());
            Reachability.Record record = new Reachability.Record(observer, subject, (Reachability.ReachabilityStatus)$this.reachabilityStatusFromInt().apply((Object)BoxesRunTime.boxToInteger((int)s.getStatus().getNumber())), s.getVersion());
            return recordBuilder$1.$plus$eq((Object)record);
        });
    }

    private final Reachability reachabilityFromProto$1(Iterable observerReachability, Vector addressMapping$2) {
        VectorBuilder recordBuilder = new VectorBuilder();
        MapBuilder versionsBuilder = new MapBuilder((GenMap)Predef$.MODULE$.Map().empty());
        observerReachability.foreach((Function1 & Serializable & scala.Serializable)o -> {
            ClusterMessageSerializer.$anonfun$gossipFromProto$4(this, addressMapping$2, recordBuilder, versionsBuilder, o);
            return BoxedUnit.UNIT;
        });
        return Reachability$.MODULE$.create((scala.collection.immutable.Seq<Reachability.Record>)recordBuilder.result(), (Map<UniqueAddress, Object>)((Map)versionsBuilder.result()));
    }

    private final Member memberFromProto$1(ClusterMessages.Member member, Vector addressMapping$2, Vector roleMapping$2) {
        return new Member((UniqueAddress)addressMapping$2.apply(member.getAddressIndex()), member.getUpNumber(), (MemberStatus)this.memberStatusFromInt().apply((Object)BoxesRunTime.boxToInteger((int)member.getStatus().getNumber())), (scala.collection.immutable.Set<String>)ClusterMessageSerializer.rolesFromProto$1((Seq)JavaConverters$.MODULE$.asScalaBufferConverter(member.getRolesIndexesList()).asScala(), roleMapping$2));
    }

    public static final /* synthetic */ void $anonfun$gossipFromProto$7(BooleanRef containsDc$1, ObjectRef roles$1, Tuple2 x$8) {
        String role;
        Tuple2 tuple2 = x$8;
        if (tuple2 != null) {
            role = (String)tuple2._2();
            if (role.startsWith(ClusterSettings$.MODULE$.DcRolePrefix())) {
                containsDc$1.elem = true;
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        roles$1.elem = (scala.collection.immutable.Set)((scala.collection.immutable.Set)roles$1.elem).$plus((Object)role);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private static final scala.collection.immutable.Set rolesFromProto$1(Seq roleIndexes, Vector roleMapping$2) {
        BooleanRef containsDc = BooleanRef.create((boolean)false);
        ObjectRef roles = ObjectRef.create((Object)Predef$.MODULE$.Set().empty());
        ((IterableLike)roleIndexes.map((Function1 & Serializable & scala.Serializable)roleIndex -> {
            String role = (String)roleMapping$2.apply(Predef$.MODULE$.Integer2int(roleIndex));
            return new Tuple2(roleIndex, (Object)role);
        }, Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x$8 -> {
            ClusterMessageSerializer.$anonfun$gossipFromProto$7(containsDc, roles, x$8);
            return BoxedUnit.UNIT;
        });
        return !containsDc.elem ? (scala.collection.immutable.Set)((scala.collection.immutable.Set)roles.elem).$plus((Object)(ClusterSettings$.MODULE$.DcRolePrefix() + ClusterSettings$.MODULE$.DefaultDataCenter())) : (scala.collection.immutable.Set)roles.elem;
    }

    private static final Tuple2 tombstoneFromProto$1(ClusterMessages.Tombstone tombstone, Vector addressMapping$2) {
        return new Tuple2(addressMapping$2.apply(tombstone.getAddressIndex()), (Object)BoxesRunTime.boxToLong((long)tombstone.getTimestamp()));
    }

    public ClusterMessageSerializer(ExtendedActorSystem system) {
        this.system = system;
        Serializer.$init$((Serializer)this);
        BaseSerializer.$init$((BaseSerializer)this);
        this.fromBinaryMap = (HashMap)HashMap$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$u2192$extension(Predef$.MODULE$.ArrowAssoc(InternalClusterAction.Join.class), (Function1 & Serializable & scala.Serializable)x0$1 -> {
            byte[] byArray = x0$1;
            ClusterMessages.Join m = ClusterMessages.Join.parseFrom(byArray);
            scala.collection.immutable.Set roles = (scala.collection.immutable.Set)Predef$.MODULE$.Set().empty().$plus$plus((GenTraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(m.getRolesList()).asScala());
            InternalClusterAction.Join join = new InternalClusterAction.Join(this.uniqueAddressFromProto(m.getNode()), (scala.collection.immutable.Set<String>)(roles.exists((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.startsWith(ClusterSettings$.MODULE$.DcRolePrefix()))) ? roles : (scala.collection.immutable.Set)roles.$plus((Object)(ClusterSettings$.MODULE$.DcRolePrefix() + ClusterSettings$.MODULE$.DefaultDataCenter()))));
            return join;
        }), Predef.ArrowAssoc$.MODULE$.$u2192$extension(Predef$.MODULE$.ArrowAssoc(InternalClusterAction.Welcome.class), (Function1 & Serializable & scala.Serializable)x0$2 -> {
            byte[] byArray = x0$2;
            ClusterMessages.Welcome m = ClusterMessages.Welcome.parseFrom(this.decompress(byArray));
            InternalClusterAction.Welcome welcome = new InternalClusterAction.Welcome(this.uniqueAddressFromProto(m.getFrom()), this.gossipFromProto(m.getGossip()));
            return welcome;
        }), Predef.ArrowAssoc$.MODULE$.$u2192$extension(Predef$.MODULE$.ArrowAssoc(ClusterUserAction.Leave.class), (Function1 & Serializable & scala.Serializable)bytes -> new ClusterUserAction.Leave(this.addressFromBinary((byte[])bytes))), Predef.ArrowAssoc$.MODULE$.$u2192$extension(Predef$.MODULE$.ArrowAssoc(ClusterUserAction.Down.class), (Function1 & Serializable & scala.Serializable)bytes -> new ClusterUserAction.Down(this.addressFromBinary((byte[])bytes))), Predef.ArrowAssoc$.MODULE$.$u2192$extension(Predef$.MODULE$.ArrowAssoc(InternalClusterAction.InitJoin.class), (Function1 & Serializable & scala.Serializable)x0$3 -> {
            byte[] byArray = x0$3;
            ClusterMessages.InitJoin m = ClusterMessages.InitJoin.parseFrom(byArray);
            InternalClusterAction.InitJoin initJoin = m.hasCurrentConfig() ? new InternalClusterAction.InitJoin(ConfigFactory.parseString((String)m.getCurrentConfig())) : new InternalClusterAction.InitJoin(ConfigFactory.empty());
            return initJoin;
        }), Predef.ArrowAssoc$.MODULE$.$u2192$extension(Predef$.MODULE$.ArrowAssoc(InternalClusterAction.InitJoinAck.class), (Function1 & Serializable & scala.Serializable)x0$4 -> {
            InternalClusterAction.ConfigCheck configCheck;
            byte[] byArray = x0$4;
            ClusterMessages.InitJoinAck i = ClusterMessages.InitJoinAck.parseFrom(byArray);
            if (i.hasConfigCheck()) {
                InternalClusterAction.ConfigCheck configCheck2;
                ClusterMessages.ConfigCheck.Type type = i.getConfigCheck().getType();
                if (((Object)((Object)ClusterMessages.ConfigCheck.Type.CompatibleConfig)).equals((Object)type)) {
                    configCheck2 = new InternalClusterAction.CompatibleConfig(ConfigFactory.parseString((String)i.getConfigCheck().getClusterConfig()));
                } else if (((Object)((Object)ClusterMessages.ConfigCheck.Type.IncompatibleConfig)).equals((Object)type)) {
                    configCheck2 = InternalClusterAction$IncompatibleConfig$.MODULE$;
                } else if (((Object)((Object)ClusterMessages.ConfigCheck.Type.UncheckedConfig)).equals((Object)type)) {
                    configCheck2 = InternalClusterAction$UncheckedConfig$.MODULE$;
                } else {
                    throw new MatchError((Object)type);
                }
                configCheck = configCheck2;
            } else {
                configCheck = InternalClusterAction$UncheckedConfig$.MODULE$;
            }
            InternalClusterAction$UncheckedConfig$ configCheck3 = configCheck;
            InternalClusterAction.InitJoinAck initJoinAck = new InternalClusterAction.InitJoinAck(this.addressFromProto(i.getAddress()), configCheck3);
            return initJoinAck;
        }), Predef.ArrowAssoc$.MODULE$.$u2192$extension(Predef$.MODULE$.ArrowAssoc(InternalClusterAction.InitJoinNack.class), (Function1 & Serializable & scala.Serializable)bytes -> new InternalClusterAction.InitJoinNack(this.addressFromBinary((byte[])bytes))), Predef.ArrowAssoc$.MODULE$.$u2192$extension(Predef$.MODULE$.ArrowAssoc(ClusterHeartbeatSender.Heartbeat.class), (Function1 & Serializable & scala.Serializable)bytes -> new ClusterHeartbeatSender.Heartbeat(this.addressFromBinary((byte[])bytes))), Predef.ArrowAssoc$.MODULE$.$u2192$extension(Predef$.MODULE$.ArrowAssoc(ClusterHeartbeatSender.HeartbeatRsp.class), (Function1 & Serializable & scala.Serializable)bytes -> new ClusterHeartbeatSender.HeartbeatRsp(this.uniqueAddressFromBinary((byte[])bytes))), Predef.ArrowAssoc$.MODULE$.$u2192$extension(Predef$.MODULE$.ArrowAssoc(InternalClusterAction.ExitingConfirmed.class), (Function1 & Serializable & scala.Serializable)bytes -> new InternalClusterAction.ExitingConfirmed(this.uniqueAddressFromBinary((byte[])bytes))), Predef.ArrowAssoc$.MODULE$.$u2192$extension(Predef$.MODULE$.ArrowAssoc(GossipStatus.class), (Function1 & Serializable & scala.Serializable)bytes -> this.gossipStatusFromBinary((byte[])bytes)), Predef.ArrowAssoc$.MODULE$.$u2192$extension(Predef$.MODULE$.ArrowAssoc(GossipEnvelope.class), (Function1 & Serializable & scala.Serializable)bytes -> this.gossipEnvelopeFromBinary((byte[])bytes)), Predef.ArrowAssoc$.MODULE$.$u2192$extension(Predef$.MODULE$.ArrowAssoc(ClusterRouterPool.class), (Function1 & Serializable & scala.Serializable)bytes -> this.clusterRouterPoolFromBinary((byte[])bytes))}));
        this.memberStatusToInt = (HashMap)HashMap$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$u2192$extension(Predef$.MODULE$.ArrowAssoc((Object)MemberStatus$Joining$.MODULE$), (Object)BoxesRunTime.boxToInteger((int)0)), Predef.ArrowAssoc$.MODULE$.$u2192$extension(Predef$.MODULE$.ArrowAssoc((Object)MemberStatus$Up$.MODULE$), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$u2192$extension(Predef$.MODULE$.ArrowAssoc((Object)MemberStatus$Leaving$.MODULE$), (Object)BoxesRunTime.boxToInteger((int)2)), Predef.ArrowAssoc$.MODULE$.$u2192$extension(Predef$.MODULE$.ArrowAssoc((Object)MemberStatus$Exiting$.MODULE$), (Object)BoxesRunTime.boxToInteger((int)3)), Predef.ArrowAssoc$.MODULE$.$u2192$extension(Predef$.MODULE$.ArrowAssoc((Object)MemberStatus$Down$.MODULE$), (Object)BoxesRunTime.boxToInteger((int)4)), Predef.ArrowAssoc$.MODULE$.$u2192$extension(Predef$.MODULE$.ArrowAssoc((Object)MemberStatus$Removed$.MODULE$), (Object)BoxesRunTime.boxToInteger((int)5)), Predef.ArrowAssoc$.MODULE$.$u2192$extension(Predef$.MODULE$.ArrowAssoc((Object)MemberStatus$WeaklyUp$.MODULE$), (Object)BoxesRunTime.boxToInteger((int)6))}));
        this.memberStatusFromInt = (HashMap)this.memberStatusToInt().map((Function1 & Serializable & scala.Serializable)x0$5 -> {
            Tuple2 tuple2 = x0$5;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            MemberStatus a = (MemberStatus)tuple2._1();
            int b = tuple2._2$mcI$sp();
            Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)b), (Object)a);
            return tuple22;
        }, HashMap$.MODULE$.canBuildFrom());
        this.reachabilityStatusToInt = (HashMap)HashMap$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$u2192$extension(Predef$.MODULE$.ArrowAssoc((Object)Reachability$Reachable$.MODULE$), (Object)BoxesRunTime.boxToInteger((int)0)), Predef.ArrowAssoc$.MODULE$.$u2192$extension(Predef$.MODULE$.ArrowAssoc((Object)Reachability$Unreachable$.MODULE$), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$u2192$extension(Predef$.MODULE$.ArrowAssoc((Object)Reachability$Terminated$.MODULE$), (Object)BoxesRunTime.boxToInteger((int)2))}));
        this.reachabilityStatusFromInt = (HashMap)this.reachabilityStatusToInt().map((Function1 & Serializable & scala.Serializable)x0$6 -> {
            Tuple2 tuple2 = x0$6;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Reachability.ReachabilityStatus a = (Reachability.ReachabilityStatus)tuple2._1();
            int b = tuple2._2$mcI$sp();
            Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)b), (Object)a);
            return tuple22;
        }, HashMap$.MODULE$.canBuildFrom());
    }
}

