/*
 * Decompiled with CFR 0.152.
 */
package akka.cluster;

import akka.ConfigurationException;
import akka.actor.ActorPath;
import akka.actor.ActorRef;
import akka.actor.ActorRefProvider;
import akka.actor.ActorSystem;
import akka.actor.Address;
import akka.actor.Cancellable;
import akka.actor.Deploy$;
import akka.actor.ExtendedActorSystem;
import akka.actor.Extension;
import akka.actor.Props$;
import akka.actor.RootActorPath;
import akka.actor.ScalaActorRef;
import akka.actor.Scheduler;
import akka.actor.package$;
import akka.annotation.InternalApi;
import akka.cluster.Cluster$;
import akka.cluster.Cluster$InfoLogger$;
import akka.cluster.ClusterActorRefProvider;
import akka.cluster.ClusterDaemon;
import akka.cluster.ClusterEvent;
import akka.cluster.ClusterEvent$InitialStateAsSnapshot$;
import akka.cluster.ClusterJmx;
import akka.cluster.ClusterReadView;
import akka.cluster.ClusterSettings;
import akka.cluster.ClusterUserAction;
import akka.cluster.DowningProvider;
import akka.cluster.DowningProvider$;
import akka.cluster.InternalClusterAction;
import akka.cluster.InternalClusterAction$GetClusterCoreRef$;
import akka.cluster.JoinConfigCompatChecker;
import akka.cluster.JoinConfigCompatChecker$;
import akka.cluster.Member;
import akka.cluster.UniqueAddress;
import akka.dispatch.MonitorableThreadFactory;
import akka.event.LogSource$;
import akka.event.Logging$;
import akka.event.LoggingAdapter;
import akka.japi.Util$;
import akka.pattern.AskableActorRef$;
import akka.remote.AddressUidExtension;
import akka.remote.AddressUidExtension$;
import akka.remote.DefaultFailureDetectorRegistry;
import akka.remote.FailureDetectorLoader$;
import akka.remote.FailureDetectorRegistry;
import akka.util.Timeout;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import java.io.Closeable;
import java.io.Serializable;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicBoolean;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Seq$;
import scala.collection.immutable.Vector$;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.control.NonFatal$;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\r5t!B\u0001\u0003\u0011\u00039\u0011aB\"mkN$XM\u001d\u0006\u0003\u0007\u0011\tqa\u00197vgR,'OC\u0001\u0006\u0003\u0011\t7n[1\u0004\u0001A\u0011\u0001\"C\u0007\u0002\u0005\u0019)!B\u0001E\u0001\u0017\t91\t\\;ti\u0016\u00148#B\u0005\r%\ru\u0002CA\u0007\u0011\u001b\u0005q!\"A\b\u0002\u000bM\u001c\u0017\r\\1\n\u0005Eq!AB!osJ+g\rE\u0002\u0014-ai\u0011\u0001\u0006\u0006\u0003+\u0011\tQ!Y2u_JL!a\u0006\u000b\u0003\u0017\u0015CH/\u001a8tS>t\u0017\n\u001a\t\u0003\u0011e1AA\u0003\u0002\u00015M\u0019\u0011\u0004D\u000e\u0011\u0005Ma\u0012BA\u000f\u0015\u0005%)\u0005\u0010^3og&|g\u000e\u0003\u0005 3\t\u0015\r\u0011\"\u0001!\u0003\u0019\u0019\u0018p\u001d;f[V\t\u0011\u0005\u0005\u0002\u0014E%\u00111\u0005\u0006\u0002\u0014\u000bb$XM\u001c3fI\u0006\u001bGo\u001c:TsN$X-\u001c\u0005\tKe\u0011\t\u0011)A\u0005C\u000591/_:uK6\u0004\u0003\"B\u0014\u001a\t\u0003A\u0013A\u0002\u001fj]&$h\b\u0006\u0002\u0019S!)qD\na\u0001C!91&\u0007b\u0001\n\u0003a\u0013\u0001C:fiRLgnZ:\u0016\u00035\u0002\"\u0001\u0003\u0018\n\u0005=\u0012!aD\"mkN$XM]*fiRLgnZ:\t\rEJ\u0002\u0015!\u0003.\u0003%\u0019X\r\u001e;j]\u001e\u001c\b\u0005C\u000443\t\u0007I\u0011\u0002\u001b\u0002/)|\u0017N\\\"p]\u001aLwmQ8na\u0006$8\t[3dW\u0016\u0014X#A\u001b\u0011\u0005!1\u0014BA\u001c\u0003\u0005]Qu.\u001b8D_:4\u0017nZ\"p[B\fGo\u00115fG.,'\u000f\u0003\u0004:3\u0001\u0006I!N\u0001\u0019U>LgnQ8oM&<7i\\7qCR\u001c\u0005.Z2lKJ\u0004\u0003bB\u001e\u001a\u0005\u0004%\t\u0001P\u0001\u0012g\u0016dg-\u00168jcV,\u0017\t\u001a3sKN\u001cX#A\u001f\u0011\u0005!q\u0014BA \u0003\u00055)f.[9vK\u0006#GM]3tg\"1\u0011)\u0007Q\u0001\nu\n!c]3mMVs\u0017.];f\u0003\u0012$'/Z:tA!)1)\u0007C\u0001\t\u0006Y1/\u001a7g\u0003\u0012$'/Z:t+\u0005)\u0005CA\nG\u0013\t9ECA\u0004BI\u0012\u0014Xm]:\t\u000b%KB\u0011\u0001&\u0002\u001dM,GN\u001a#bi\u0006\u001cUM\u001c;feV\t1\n\u0005\u0002M-:\u0011Q\n\u0016\b\u0003\u001dNs!a\u0014*\u000e\u0003AS!!\u0015\u0004\u0002\rq\u0012xn\u001c;?\u0013\u0005)\u0011BA\u0002\u0005\u0013\t)&!A\bDYV\u001cH/\u001a:TKR$\u0018N\\4t\u0013\t9\u0006L\u0001\u0006ECR\f7)\u001a8uKJT!!\u0016\u0002\t\u000biKB\u0011A.\u0002\u0013M,GN\u001a*pY\u0016\u001cX#\u0001/\u0011\u0007u\u000bGM\u0004\u0002_?B\u0011qJD\u0005\u0003A:\ta\u0001\u0015:fI\u00164\u0017B\u00012d\u0005\r\u0019V\r\u001e\u0006\u0003A:\u0001\"!X3\n\u0005\u0019\u001c'AB*ue&tw\rC\u0003i3\u0011\u0005\u0011.\u0001\u0007hKR\u001cV\r\u001c4S_2,7/F\u0001k!\rY\u0007\u000fZ\u0007\u0002Y*\u0011QN\\\u0001\u0005kRLGNC\u0001p\u0003\u0011Q\u0017M^1\n\u0005\td\u0007b\u0002:\u001a\u0005\u0004%Ia]\u0001\u000e?&\u001cH+\u001a:nS:\fG/\u001a3\u0016\u0003Q\u0004\"!\u001e>\u000e\u0003YT!a\u001e=\u0002\r\u0005$x.\\5d\u0015\tIH.\u0001\u0006d_:\u001cWO\u001d:f]RL!a\u001f<\u0003\u001b\u0005#x.\\5d\u0005>|G.Z1o\u0011\u0019i\u0018\u0004)A\u0005i\u0006qq,[:UKJl\u0017N\\1uK\u0012\u0004\u0003\u0002C@\u001a\u0005\u0004%I!!\u0001\u0002\u00071|w-\u0006\u0002\u0002\u0004A!\u0011QAA\u0006\u001b\t\t9AC\u0002\u0002\n\u0011\tQ!\u001a<f]RLA!!\u0004\u0002\b\tqAj\\4hS:<\u0017\tZ1qi\u0016\u0014\b\u0002CA\t3\u0001\u0006I!a\u0001\u0002\t1|w\r\t\u0005\n\u0003+I\u0002\u0019!C\u0005\u0003/\t!b\u00197vgR,'OS7y+\t\tI\u0002E\u0003\u000e\u00037\ty\"C\u0002\u0002\u001e9\u0011aa\u00149uS>t\u0007c\u0001\u0005\u0002\"%\u0019\u00111\u0005\u0002\u0003\u0015\rcWo\u001d;fe*k\u0007\u0010C\u0005\u0002(e\u0001\r\u0011\"\u0003\u0002*\u0005q1\r\\;ti\u0016\u0014(*\u001c=`I\u0015\fH\u0003BA\u0016\u0003c\u00012!DA\u0017\u0013\r\tyC\u0004\u0002\u0005+:LG\u000f\u0003\u0006\u00024\u0005\u0015\u0012\u0011!a\u0001\u00033\t1\u0001\u001f\u00132\u0011!\t9$\u0007Q!\n\u0005e\u0011aC2mkN$XM\u001d&nq\u0002B\u0011\"a\u000f\u001a\u0005\u0004%\t!!\u0010\u0002\u001f\u0019\f\u0017\u000e\\;sK\u0012+G/Z2u_J,\"!a\u0010\u0011\u000b\u0005\u0005\u0013qI#\u000e\u0005\u0005\r#bAA#\t\u00051!/Z7pi\u0016LA!!\u0013\u0002D\t9b)Y5mkJ,G)\u001a;fGR|'OU3hSN$(/\u001f\u0005\t\u0003\u001bJ\u0002\u0015!\u0003\u0002@\u0005\u0001b-Y5mkJ,G)\u001a;fGR|'\u000f\t\u0005\n\u0003#J\"\u0019!C\u0001\u0003{\tac\u0019:pgN$5MR1jYV\u0014X\rR3uK\u000e$xN\u001d\u0005\t\u0003+J\u0002\u0015!\u0003\u0002@\u000592M]8tg\u0012\u001bg)Y5mkJ,G)\u001a;fGR|'\u000f\t\u0005\u000b\u00033J\u0002R1A\u0005\u0002\u0005m\u0013a\u00043po:Lgn\u001a)s_ZLG-\u001a:\u0016\u0005\u0005u\u0003c\u0001\u0005\u0002`%\u0019\u0011\u0011\r\u0002\u0003\u001f\u0011{wO\\5oOB\u0013xN^5eKJD!\"!\u001a\u001a\u0005\u0004%\tAAA4\u0003%\u00198\r[3ek2,'/\u0006\u0002\u0002jA\u00191#a\u001b\n\u0007\u00055DCA\u0005TG\",G-\u001e7fe\"A\u0011\u0011O\r!\u0002\u0013\tI'\u0001\u0006tG\",G-\u001e7fe\u0002B\u0011\"!\u001e\u001a\u0005\u0004%I!a\u001e\u0002\u001d\rdWo\u001d;fe\u0012\u000bW-\\8ogV\u0011\u0011\u0011\u0010\t\u0004'\u0005m\u0014bAA?)\tA\u0011i\u0019;peJ+g\r\u0003\u0005\u0002\u0002f\u0001\u000b\u0011BA=\u0003=\u0019G.^:uKJ$\u0015-Z7p]N\u0004\u0003BCAC3\t\u0007I\u0011\u0001\u0002\u0002x\u0005Y1\r\\;ti\u0016\u00148i\u001c:f\u0011!\tI)\u0007Q\u0001\n\u0005e\u0014\u0001D2mkN$XM]\"pe\u0016\u0004\u0003BCAG3\t\u0007I\u0011\u0001\u0002\u0002\u0010\u0006A!/Z1e-&,w/\u0006\u0002\u0002\u0012B\u0019\u0001\"a%\n\u0007\u0005U%AA\bDYV\u001cH/\u001a:SK\u0006$g+[3x\u0011!\tI*\u0007Q\u0001\n\u0005E\u0015!\u0003:fC\u00124\u0016.Z<!\u0011\u001d\ti*\u0007C\u0001\u0003?\u000bA\"[:UKJl\u0017N\\1uK\u0012,\"!!)\u0011\u00075\t\u0019+C\u0002\u0002&:\u0011qAQ8pY\u0016\fg\u000eC\u0004\u0002*f!\t!a+\u0002\u000bM$\u0018\r^3\u0016\u0005\u00055\u0006\u0003BAX\u0003ks1\u0001CAY\u0013\r\t\u0019LA\u0001\r\u00072,8\u000f^3s\u000bZ,g\u000e^\u0005\u0005\u0003o\u000bILA\nDkJ\u0014XM\u001c;DYV\u001cH/\u001a:Ti\u0006$XMC\u0002\u00024\nAq!!0\u001a\t\u0003\ty,\u0001\u0006tK24W*Z7cKJ,\"!!1\u0011\u0007!\t\u0019-C\u0002\u0002F\n\u0011a!T3nE\u0016\u0014\bbBAe3\u0011\u0005\u00111Z\u0001\ngV\u00147o\u0019:jE\u0016$b!a\u000b\u0002N\u0006E\u0007\u0002CAh\u0003\u000f\u0004\r!!\u001f\u0002\u0015M,(m]2sS\n,'\u000f\u0003\u0005\u0002T\u0006\u001d\u0007\u0019AAk\u0003\t!x\u000eE\u0003\u000e\u0003/\fY.C\u0002\u0002Z:\u0011!\u0002\u0010:fa\u0016\fG/\u001a3?a\u0011\ti.a:\u0011\u000bu\u000by.a9\n\u0007\u0005\u00058MA\u0003DY\u0006\u001c8\u000f\u0005\u0003\u0002f\u0006\u001dH\u0002\u0001\u0003\r\u0003S\f\t.!A\u0001\u0002\u000b\u0005\u00111\u001e\u0002\u0004?\u0012\n\u0014\u0003BAw\u0003g\u00042!DAx\u0013\r\t\tP\u0004\u0002\b\u001d>$\b.\u001b8h!\ri\u0011Q_\u0005\u0004\u0003ot!aA!os\"\"\u0011qYA~!\u0011\tiPa\u0001\u000e\u0005\u0005}(b\u0001B\u0001\u001d\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\t\u0015\u0011q \u0002\bm\u0006\u0014\u0018M]4t\u0011\u001d\tI-\u0007C\u0001\u0005\u0013!\u0002\"a\u000b\u0003\f\t5!q\u0003\u0005\t\u0003\u001f\u00149\u00011\u0001\u0002z!A!q\u0002B\u0004\u0001\u0004\u0011\t\"\u0001\tj]&$\u0018.\u00197Ti\u0006$X-T8eKB!\u0011q\u0016B\n\u0013\u0011\u0011)\"!/\u00039M+(m]2sSB$\u0018n\u001c8J]&$\u0018.\u00197Ti\u0006$X-T8eK\"A\u00111\u001bB\u0004\u0001\u0004\u0011I\u0002E\u0003\u000e\u0003/\u0014Y\u0002\r\u0003\u0003\u001e\t\u0005\u0002#B/\u0002`\n}\u0001\u0003BAs\u0005C!ABa\t\u0003\u0018\u0005\u0005\t\u0011!B\u0001\u0003W\u00141a\u0018\u00133Q\u0011\u00119!a?\t\u000f\t%\u0012\u0004\"\u0001\u0003,\u0005YQO\\:vEN\u001c'/\u001b2f)\u0011\tYC!\f\t\u0011\u0005='q\u0005a\u0001\u0003sBqA!\u000b\u001a\t\u0003\u0011\t\u0004\u0006\u0004\u0002,\tM\"Q\u0007\u0005\t\u0003\u001f\u0014y\u00031\u0001\u0002z!A\u00111\u001bB\u0018\u0001\u0004\u00119\u0004\r\u0003\u0003:\tu\u0002#B/\u0002`\nm\u0002\u0003BAs\u0005{!ABa\u0010\u00036\u0005\u0005\t\u0011!B\u0001\u0003W\u00141a\u0018\u00134\u0011\u001d\u0011\u0019%\u0007C\u0001\u0005\u000b\nqc]3oI\u000e+(O]3oi\u000ecWo\u001d;feN#\u0018\r^3\u0015\t\u0005-\"q\t\u0005\t\u0005\u0013\u0012\t\u00051\u0001\u0002z\u0005A!/Z2fSZ,'\u000fC\u0004\u0003Ne!\tAa\u0014\u0002\t)|\u0017N\u001c\u000b\u0005\u0003W\u0011\t\u0006C\u0004\u0003T\t-\u0003\u0019A#\u0002\u000f\u0005$GM]3tg\"9!qK\r\u0005\n\te\u0013!\u00034jY2dunY1m)\r)%1\f\u0005\b\u0005'\u0012)\u00061\u0001F\u0011\u001d\u0011y&\u0007C\u0001\u0005C\nQB[8j]N+W\r\u001a(pI\u0016\u001cH\u0003BA\u0016\u0005GB\u0001B!\u001a\u0003^\u0001\u0007!qM\u0001\ng\u0016,GMT8eKN\u0004RA!\u001b\u0003t\u0015k!Aa\u001b\u000b\t\t5$qN\u0001\nS6lW\u000f^1cY\u0016T1A!\u001d\u000f\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0005k\u0012YGA\u0002TKFDqAa\u0018\u001a\t\u0003\u0011I\b\u0006\u0003\u0002,\tm\u0004\u0002\u0003B3\u0005o\u0002\rA! \u0011\t-\u0014y(R\u0005\u0004\u0005\u0003c'\u0001\u0002'jgRDqA!\"\u001a\t\u0003\u00119)A\u0003mK\u00064X\r\u0006\u0003\u0002,\t%\u0005b\u0002B*\u0005\u0007\u0003\r!\u0012\u0005\b\u0005\u001bKB\u0011\u0001BH\u0003\u0011!wn\u001e8\u0015\t\u0005-\"\u0011\u0013\u0005\b\u0005'\u0012Y\t1\u0001F\u0011\u001d\u0011)*\u0007C\u0001\u0005/\u000b!C]3hSN$XM](o\u001b\u0016l'-\u001a:VaV!!\u0011\u0014BT)\u0011\tYCa'\t\u0013\tu%1\u0013CA\u0002\t}\u0015\u0001B2pI\u0016\u0004R!\u0004BQ\u0005KK1Aa)\u000f\u0005!a$-\u001f8b[\u0016t\u0004\u0003BAs\u0005O#\u0001B!+\u0003\u0014\n\u0007\u00111\u001e\u0002\u0002)\"9!QS\r\u0005\u0002\t5F\u0003BA\u0016\u0005_C\u0001B!-\u0003,\u0002\u0007!1W\u0001\tG\u0006dGNY1dWB!!Q\u0017B^\u001b\t\u00119LC\u0002\u0003::\fA\u0001\\1oO&!!Q\u0018B\\\u0005!\u0011VO\u001c8bE2,\u0007b\u0002Ba3\u0011\u0005!1Y\u0001\u0018e\u0016<\u0017n\u001d;fe>sW*Z7cKJ\u0014V-\\8wK\u0012,BA!2\u0003NR!\u00111\u0006Bd\u0011%\u0011iJa0\u0005\u0002\u0004\u0011I\rE\u0003\u000e\u0005C\u0013Y\r\u0005\u0003\u0002f\n5G\u0001\u0003BU\u0005\u007f\u0013\r!a;\t\u000f\t\u0005\u0017\u0004\"\u0001\u0003RR!\u00111\u0006Bj\u0011!\u0011\tLa4A\u0002\tM\u0006b\u0002Bl3\u0011\u0005!\u0011\\\u0001\re\u0016lw\u000e^3QCRDwJ\u001a\u000b\u0005\u00057\u0014\t\u000fE\u0002\u0014\u0005;L1Aa8\u0015\u0005%\t5\r^8s!\u0006$\b\u000e\u0003\u0005\u0003d\nU\u0007\u0019AA=\u0003!\t7\r^8s%\u00164\u0007\u0002\u0003Bt3\u0011\u0005!A!;\u0002\u0011MDW\u000f\u001e3po:$\"!a\u000b)\t\t\u0015(Q\u001e\t\u0005\u0005_\u0014\u00190\u0004\u0002\u0003r*\u0019!\u0011\u0001\u0003\n\t\tU(\u0011\u001f\u0002\f\u0013:$XM\u001d8bY\u0006\u0003\u0018\u000eC\u0004\u0003zf!IA!;\u0002\u001d\rdwn]3TG\",G-\u001e7fe\u001eA!Q`\r\t\u0002\t\u0011y0\u0001\u0006J]\u001a|Gj\\4hKJ\u0004Ba!\u0001\u0004\u00045\t\u0011D\u0002\u0005\u0004\u0006eA\tAAB\u0004\u0005)IeNZ8M_\u001e<WM]\n\u0004\u0007\u0007a\u0001bB\u0014\u0004\u0004\u0011\u000511\u0002\u000b\u0003\u0005\u007fD\u0001ba\u0004\u0004\u0004\u0011\u00051\u0011C\u0001\bY><\u0017J\u001c4p)\u0011\tYca\u0005\t\u000f\rU1Q\u0002a\u0001I\u00069Q.Z:tC\u001e,\u0007\u0002CB\b\u0007\u0007!\ta!\u0007\u0015\r\u0005-21DB\u0010\u0011\u001d\u0019iba\u0006A\u0002\u0011\f\u0001\u0002^3na2\fG/\u001a\u0005\t\u0007C\u00199\u00021\u0001\u0002t\u0006!\u0011M]42\u0011!\u0019yaa\u0001\u0005\u0002\r\u0015B\u0003CA\u0016\u0007O\u0019Ica\u000b\t\u000f\ru11\u0005a\u0001I\"A1\u0011EB\u0012\u0001\u0004\t\u0019\u0010\u0003\u0005\u0004.\r\r\u0002\u0019AAz\u0003\u0011\t'o\u001a\u001a\t\u0011\r=11\u0001C\u0001\u0007c!\"\"a\u000b\u00044\rU2qGB\u001d\u0011\u001d\u0019iba\fA\u0002\u0011D\u0001b!\t\u00040\u0001\u0007\u00111\u001f\u0005\t\u0007[\u0019y\u00031\u0001\u0002t\"A11HB\u0018\u0001\u0004\t\u00190\u0001\u0003be\u001e\u001c\u0004cA\n\u0004@%\u00191\u0011\t\u000b\u0003'\u0015CH/\u001a8tS>t\u0017\n\u001a)s_ZLG-\u001a:\t\r\u001dJA\u0011AB#)\u00059\u0001bBB%\u0013\u0011\u000531J\u0001\u0004O\u0016$Hc\u0001\r\u0004N!9qda\u0012A\u0002\r=\u0003cA\n\u0004R%\u001911\u000b\u000b\u0003\u0017\u0005\u001bGo\u001c:TsN$X-\u001c\u0005\b\u0007/JA\u0011IB-\u0003\u0019awn\\6vaR\u001111\f\b\u0003\u0011\u0001Aqaa\u0018\n\t\u0003\u001a\t'A\bde\u0016\fG/Z#yi\u0016t7/[8o)\rA21\r\u0005\u0007?\ru\u0003\u0019A\u0011\t\u0015\r\u001d\u0014B1A\u0005\u0006\t\ty*A\rjg\u0006\u001b8/\u001a:u\u0013:4\u0018M]5b]R\u001cXI\\1cY\u0016$\u0007\u0002CB6\u0013\u0001\u0006i!!)\u00025%\u001c\u0018i]:feRLeN^1sS\u0006tGo]#oC\ndW\r\u001a\u0011")
public class Cluster
implements Extension {
    private DowningProvider downingProvider;
    private volatile Cluster$InfoLogger$ InfoLogger$module;
    private final ExtendedActorSystem system;
    private final ClusterSettings settings;
    private final JoinConfigCompatChecker joinConfigCompatChecker;
    private final UniqueAddress selfUniqueAddress;
    private final AtomicBoolean _isTerminated;
    private final LoggingAdapter akka$cluster$Cluster$$log;
    private Option<ClusterJmx> clusterJmx;
    private final FailureDetectorRegistry<Address> failureDetector;
    private final FailureDetectorRegistry<Address> crossDcFailureDetector;
    private final Scheduler scheduler;
    private final ActorRef clusterDaemons;
    private final ActorRef clusterCore;
    private final ClusterReadView readView;
    private volatile boolean bitmap$0;

    public static Extension apply(ActorSystem actorSystem) {
        return Cluster$.MODULE$.apply(actorSystem);
    }

    public static Cluster createExtension(ExtendedActorSystem extendedActorSystem) {
        return Cluster$.MODULE$.createExtension(extendedActorSystem);
    }

    public static Cluster$ lookup() {
        return Cluster$.MODULE$.lookup();
    }

    public static Cluster get(ActorSystem actorSystem) {
        return Cluster$.MODULE$.get(actorSystem);
    }

    public static Extension get(ActorSystem actorSystem) {
        return Cluster$.MODULE$.get(actorSystem);
    }

    public Cluster$InfoLogger$ InfoLogger() {
        if (this.InfoLogger$module == null) {
            this.InfoLogger$lzycompute$1();
        }
        return this.InfoLogger$module;
    }

    public void subscribe(ActorRef subscriber, Class<?> ... to) {
        this.subscribe(subscriber, (Seq<Class<?>>)Predef$.MODULE$.wrapRefArray((Object[])to));
    }

    public void subscribe(ActorRef subscriber, ClusterEvent.SubscriptionInitialStateMode initialStateMode, Class<?> ... to) {
        this.subscribe(subscriber, initialStateMode, (Seq<Class<?>>)Predef$.MODULE$.wrapRefArray((Object[])to));
    }

    public ExtendedActorSystem system() {
        return this.system;
    }

    public ClusterSettings settings() {
        return this.settings;
    }

    private JoinConfigCompatChecker joinConfigCompatChecker() {
        return this.joinConfigCompatChecker;
    }

    public UniqueAddress selfUniqueAddress() {
        return this.selfUniqueAddress;
    }

    public Address selfAddress() {
        return this.selfUniqueAddress().address();
    }

    public String selfDataCenter() {
        return this.settings().SelfDataCenter();
    }

    public scala.collection.immutable.Set<String> selfRoles() {
        return this.settings().Roles();
    }

    public Set<String> getSelfRoles() {
        return (Set)JavaConverters$.MODULE$.setAsJavaSetConverter(this.selfRoles()).asJava();
    }

    private AtomicBoolean _isTerminated() {
        return this._isTerminated;
    }

    public LoggingAdapter akka$cluster$Cluster$$log() {
        return this.akka$cluster$Cluster$$log;
    }

    private Option<ClusterJmx> clusterJmx() {
        return this.clusterJmx;
    }

    private void clusterJmx_$eq(Option<ClusterJmx> x$1) {
        this.clusterJmx = x$1;
    }

    public FailureDetectorRegistry<Address> failureDetector() {
        return this.failureDetector;
    }

    public FailureDetectorRegistry<Address> crossDcFailureDetector() {
        return this.crossDcFailureDetector;
    }

    private DowningProvider downingProvider$lzycompute() {
        Cluster cluster = this;
        synchronized (cluster) {
            if (!this.bitmap$0) {
                this.downingProvider = DowningProvider$.MODULE$.load(this.settings().DowningProviderClassName(), (ActorSystem)this.system());
                this.bitmap$0 = true;
            }
        }
        return this.downingProvider;
    }

    public DowningProvider downingProvider() {
        return !this.bitmap$0 ? this.downingProvider$lzycompute() : this.downingProvider;
    }

    public Scheduler scheduler() {
        return this.scheduler;
    }

    private ActorRef clusterDaemons() {
        return this.clusterDaemons;
    }

    public ActorRef clusterCore() {
        return this.clusterCore;
    }

    public ClusterReadView readView() {
        return this.readView;
    }

    public boolean isTerminated() {
        return this._isTerminated().get();
    }

    public ClusterEvent.CurrentClusterState state() {
        return this.readView().state();
    }

    public Member selfMember() {
        return this.readView().self();
    }

    public void subscribe(ActorRef subscriber, Seq<Class<?>> to) {
        this.subscribe(subscriber, (ClusterEvent.SubscriptionInitialStateMode)ClusterEvent$InitialStateAsSnapshot$.MODULE$, to);
    }

    public void subscribe(ActorRef subscriber, ClusterEvent.SubscriptionInitialStateMode initialStateMode, Seq<Class<?>> to) {
        Predef$.MODULE$.require(to.length() > 0, (Function0 & Serializable & scala.Serializable)() -> "at least one `ClusterDomainEvent` class is required");
        Predef$.MODULE$.require(to.forall((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)Cluster.$anonfun$subscribe$3(x$1))), (Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"subscribe to `akka.cluster.ClusterEvent.ClusterDomainEvent` or subclasses, was [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((TraversableOnce)to.map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.getName(), scala.collection.Seq$.MODULE$.canBuildFrom())).mkString(", ")})));
        ScalaActorRef qual$2 = package$.MODULE$.actorRef2Scala(this.clusterCore());
        InternalClusterAction.Subscribe x$6 = new InternalClusterAction.Subscribe(subscriber, initialStateMode, to.toSet());
        ActorRef x$7 = qual$2.$bang$default$2((Object)x$6);
        qual$2.$bang((Object)x$6, x$7);
    }

    public void unsubscribe(ActorRef subscriber) {
        ScalaActorRef qual$3 = package$.MODULE$.actorRef2Scala(this.clusterCore());
        InternalClusterAction.Unsubscribe x$8 = new InternalClusterAction.Unsubscribe(subscriber, (Option<Class<?>>)None$.MODULE$);
        ActorRef x$9 = qual$3.$bang$default$2((Object)x$8);
        qual$3.$bang((Object)x$8, x$9);
    }

    public void unsubscribe(ActorRef subscriber, Class<?> to) {
        ScalaActorRef qual$4 = package$.MODULE$.actorRef2Scala(this.clusterCore());
        InternalClusterAction.Unsubscribe x$10 = new InternalClusterAction.Unsubscribe(subscriber, (Option<Class<?>>)new Some(to));
        ActorRef x$11 = qual$4.$bang$default$2((Object)x$10);
        qual$4.$bang((Object)x$10, x$11);
    }

    public void sendCurrentClusterState(ActorRef receiver) {
        ScalaActorRef qual$5 = package$.MODULE$.actorRef2Scala(this.clusterCore());
        InternalClusterAction.SendCurrentClusterState x$12 = new InternalClusterAction.SendCurrentClusterState(receiver);
        ActorRef x$13 = qual$5.$bang$default$2((Object)x$12);
        qual$5.$bang((Object)x$12, x$13);
    }

    public void join(Address address) {
        ScalaActorRef qual$6 = package$.MODULE$.actorRef2Scala(this.clusterCore());
        ClusterUserAction.JoinTo x$14 = new ClusterUserAction.JoinTo(this.fillLocal(address));
        ActorRef x$15 = qual$6.$bang$default$2((Object)x$14);
        qual$6.$bang((Object)x$14, x$15);
    }

    /*
     * Enabled aggressive block sorting
     */
    private Address fillLocal(Address address) {
        Address address2;
        if (address.hasLocalScope()) {
            String string = address.system();
            String string2 = this.selfAddress().system();
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                address2 = this.selfAddress();
                return address2;
            }
        }
        address2 = address;
        return address2;
    }

    public void joinSeedNodes(scala.collection.immutable.Seq<Address> seedNodes) {
        ScalaActorRef qual$7 = package$.MODULE$.actorRef2Scala(this.clusterCore());
        InternalClusterAction.JoinSeedNodes x$16 = new InternalClusterAction.JoinSeedNodes((IndexedSeq<Address>)((IndexedSeq)seedNodes.toVector().map((Function1 & Serializable & scala.Serializable)address -> this.fillLocal((Address)address), Vector$.MODULE$.canBuildFrom())));
        ActorRef x$17 = qual$7.$bang$default$2((Object)x$16);
        qual$7.$bang((Object)x$16, x$17);
    }

    public void joinSeedNodes(List<Address> seedNodes) {
        this.joinSeedNodes((scala.collection.immutable.Seq<Address>)Util$.MODULE$.immutableSeq(seedNodes));
    }

    public void leave(Address address) {
        ScalaActorRef qual$8 = package$.MODULE$.actorRef2Scala(this.clusterCore());
        ClusterUserAction.Leave x$18 = new ClusterUserAction.Leave(this.fillLocal(address));
        ActorRef x$19 = qual$8.$bang$default$2((Object)x$18);
        qual$8.$bang((Object)x$18, x$19);
    }

    public void down(Address address) {
        ScalaActorRef qual$9 = package$.MODULE$.actorRef2Scala(this.clusterCore());
        ClusterUserAction.Down x$20 = new ClusterUserAction.Down(this.fillLocal(address));
        ActorRef x$21 = qual$9.$bang$default$2((Object)x$20);
        qual$9.$bang((Object)x$20, x$21);
    }

    public <T> void registerOnMemberUp(Function0<T> code) {
        this.registerOnMemberUp(new Runnable(null, code){
            private final Function0 code$1;

            public void run() {
                this.code$1.apply();
            }
            {
                this.code$1 = code$1;
            }
        });
    }

    public void registerOnMemberUp(Runnable callback) {
        ScalaActorRef qual$10 = package$.MODULE$.actorRef2Scala(this.clusterDaemons());
        InternalClusterAction.AddOnMemberUpListener x$22 = new InternalClusterAction.AddOnMemberUpListener(callback);
        ActorRef x$23 = qual$10.$bang$default$2((Object)x$22);
        qual$10.$bang((Object)x$22, x$23);
    }

    public <T> void registerOnMemberRemoved(Function0<T> code) {
        this.registerOnMemberRemoved(new Runnable(null, code){
            private final Function0 code$2;

            public void run() {
                this.code$2.apply();
            }
            {
                this.code$2 = code$2;
            }
        });
    }

    public void registerOnMemberRemoved(Runnable callback) {
        if (this._isTerminated().get()) {
            callback.run();
        } else {
            ScalaActorRef qual$11 = package$.MODULE$.actorRef2Scala(this.clusterDaemons());
            InternalClusterAction.AddOnMemberRemovedListener x$24 = new InternalClusterAction.AddOnMemberRemovedListener(callback);
            ActorRef x$25 = qual$11.$bang$default$2((Object)x$24);
            qual$11.$bang((Object)x$24, x$25);
        }
    }

    public ActorPath remotePathOf(ActorRef actorRef) {
        ActorPath actorPath;
        ActorPath path = actorRef.path();
        if (path.address().host().isDefined()) {
            actorPath = path;
        } else {
            RootActorPath qual$12 = path.root();
            Address x$26 = this.selfAddress();
            String x$27 = qual$12.copy$default$2();
            actorPath = qual$12.copy(x$26, x$27).$div((Iterable)path.elements()).withUid(path.uid());
        }
        return actorPath;
    }

    @InternalApi
    public void shutdown() {
        block1: {
            if (!this._isTerminated().compareAndSet(false, true)) break block1;
            this.InfoLogger().logInfo("Shutting down...");
            this.system().stop(this.clusterDaemons());
            if (this.readView() != null) {
                this.readView().close();
            }
            this.closeScheduler();
            this.clusterJmx().foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
                x$2.unregisterMBean();
                return BoxedUnit.UNIT;
            });
            this.InfoLogger().logInfo("Successfully shut down");
        }
    }

    private void closeScheduler() {
        Scheduler scheduler = this.scheduler();
        if (scheduler instanceof Closeable) {
            Scheduler scheduler2 = scheduler;
            ((Closeable)scheduler2).close();
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    private final void InfoLogger$lzycompute$1() {
        Cluster cluster = this;
        synchronized (cluster) {
            if (this.InfoLogger$module == null) {
                this.InfoLogger$module = new Cluster$InfoLogger$(this);
            }
        }
    }

    private final ActorRef liftedTree1$1(Timeout timeout$1) {
        ActorRef actorRef;
        try {
            ActorRef qual$1 = akka.pattern.package$.MODULE$.ask(this.clusterDaemons());
            InternalClusterAction$GetClusterCoreRef$ x$3 = InternalClusterAction$GetClusterCoreRef$.MODULE$;
            Timeout x$4 = timeout$1;
            ActorRef x$5 = AskableActorRef$.MODULE$.$qmark$default$3$extension(qual$1, (Object)x$3);
            actorRef = (ActorRef)Await$.MODULE$.result((Awaitable)AskableActorRef$.MODULE$.$qmark$extension1(qual$1, (Object)x$3, x$4, x$5).mapTo(ClassTag$.MODULE$.apply(ActorRef.class)), (Duration)timeout$1.duration());
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            Throwable e = (Throwable)option.get();
            this.akka$cluster$Cluster$$log().error(e, "Failed to startup Cluster. You can try to increase 'akka.actor.creation-timeout'.");
            this.shutdown();
            ActorRef actorRef2 = this.system().deadLetters();
            actorRef = actorRef2;
        }
        return actorRef;
    }

    public static final /* synthetic */ boolean $anonfun$subscribe$3(Class x$1) {
        return ClusterEvent.ClusterDomainEvent.class.isAssignableFrom(x$1);
    }

    public Cluster(ExtendedActorSystem system) {
        Scheduler scheduler;
        this.system = system;
        this.settings = new ClusterSettings(system.settings().config(), system.name());
        this.joinConfigCompatChecker = JoinConfigCompatChecker$.MODULE$.load(system, this.settings());
        ActorRefProvider actorRefProvider = system.provider();
        if (!(actorRefProvider instanceof ClusterActorRefProvider)) {
            throw new ConfigurationException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"ActorSystem [", "] needs to have a 'ClusterActorRefProvider' enabled in the configuration, currently uses [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{system, actorRefProvider.getClass().getName()})));
        }
        ClusterActorRefProvider clusterActorRefProvider = (ClusterActorRefProvider)actorRefProvider;
        UniqueAddress uniqueAddress = new UniqueAddress(clusterActorRefProvider.transport().defaultAddress(), ((AddressUidExtension)AddressUidExtension$.MODULE$.apply((ActorSystem)system)).longAddressUid());
        this.selfUniqueAddress = uniqueAddress;
        this._isTerminated = new AtomicBoolean(false);
        this.akka$cluster$Cluster$$log = Logging$.MODULE$.apply((ActorSystem)system, (Object)this.getClass().getName(), LogSource$.MODULE$.fromString());
        this.clusterJmx = None$.MODULE$;
        this.InfoLogger().logInfo("Starting up...");
        Function0 & Serializable & scala.Serializable createFailureDetector = (Function0 & Serializable & scala.Serializable)() -> FailureDetectorLoader$.MODULE$.load(this.settings().FailureDetectorImplementationClass(), this.settings().FailureDetectorConfig(), (ActorSystem)this.system());
        this.failureDetector = new DefaultFailureDetectorRegistry((Function0)createFailureDetector);
        Function0 & Serializable & scala.Serializable createFailureDetector2 = (Function0 & Serializable & scala.Serializable)() -> FailureDetectorLoader$.MODULE$.load(this.settings().MultiDataCenter().CrossDcFailureDetectorSettings().ImplementationClass(), this.settings().MultiDataCenter().CrossDcFailureDetectorSettings().config(), (ActorSystem)this.system());
        this.crossDcFailureDetector = new DefaultFailureDetectorRegistry((Function0)createFailureDetector2);
        package.DurationInt durationInt = new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(1));
        if (system.scheduler().maxFrequency() < durationInt.second().$div((Duration)this.settings().SchedulerTickDuration())) {
            ThreadFactory threadFactory;
            this.InfoLogger().logInfo("Using a dedicated scheduler for cluster. Default scheduler can be used if configured with 'akka.scheduler.tick-duration' [{} ms] <=  'akka.cluster.scheduler.tick-duration' [{} ms].", BoxesRunTime.boxToInteger((int)((int)((double)1000 / system.scheduler().maxFrequency()))), BoxesRunTime.boxToLong((long)this.settings().SchedulerTickDuration().toMillis()));
            Config cfg = ConfigFactory.parseString((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"akka.scheduler.tick-duration=", "ms"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.settings().SchedulerTickDuration().toMillis())}))).withFallback((ConfigMergeable)system.settings().config());
            ThreadFactory threadFactory2 = system.threadFactory();
            if (threadFactory2 instanceof MonitorableThreadFactory) {
                MonitorableThreadFactory monitorableThreadFactory = (MonitorableThreadFactory)threadFactory2;
                threadFactory = monitorableThreadFactory.withName(monitorableThreadFactory.name() + "-cluster-scheduler");
            } else {
                threadFactory = threadFactory2;
            }
            ThreadFactory threadFactory3 = threadFactory;
            scheduler = (Scheduler)system.dynamicAccess().createInstanceFor(system.settings().SchedulerClass(), (scala.collection.immutable.Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$u2192$extension(Predef$.MODULE$.ArrowAssoc(Config.class), (Object)cfg), Predef.ArrowAssoc$.MODULE$.$u2192$extension(Predef$.MODULE$.ArrowAssoc(LoggingAdapter.class), (Object)this.akka$cluster$Cluster$$log()), Predef.ArrowAssoc$.MODULE$.$u2192$extension(Predef$.MODULE$.ArrowAssoc(ThreadFactory.class), (Object)threadFactory3)})), ClassTag$.MODULE$.apply(Scheduler.class)).get();
        } else {
            Scheduler systemScheduler = system.scheduler();
            scheduler = new Scheduler(null, systemScheduler){
                private final Scheduler systemScheduler$1;

                public final Cancellable schedule(FiniteDuration initialDelay, FiniteDuration interval, ActorRef receiver, Object message, ExecutionContext executor, ActorRef sender) {
                    return Scheduler.schedule$((Scheduler)this, (FiniteDuration)initialDelay, (FiniteDuration)interval, (ActorRef)receiver, (Object)message, (ExecutionContext)executor, (ActorRef)sender);
                }

                public final Cancellable schedule(FiniteDuration initialDelay, FiniteDuration interval, Function0<BoxedUnit> f, ExecutionContext executor) {
                    return Scheduler.schedule$((Scheduler)this, (FiniteDuration)initialDelay, (FiniteDuration)interval, f, (ExecutionContext)executor);
                }

                public final Cancellable scheduleOnce(FiniteDuration delay, ActorRef receiver, Object message, ExecutionContext executor, ActorRef sender) {
                    return Scheduler.scheduleOnce$((Scheduler)this, (FiniteDuration)delay, (ActorRef)receiver, (Object)message, (ExecutionContext)executor, (ActorRef)sender);
                }

                public final Cancellable scheduleOnce(FiniteDuration delay, Function0<BoxedUnit> f, ExecutionContext executor) {
                    return Scheduler.scheduleOnce$((Scheduler)this, (FiniteDuration)delay, f, (ExecutionContext)executor);
                }

                public final ActorRef schedule$default$6(FiniteDuration initialDelay, FiniteDuration interval, ActorRef receiver, Object message) {
                    return Scheduler.schedule$default$6$((Scheduler)this, (FiniteDuration)initialDelay, (FiniteDuration)interval, (ActorRef)receiver, (Object)message);
                }

                public final ActorRef scheduleOnce$default$5(FiniteDuration delay, ActorRef receiver, Object message) {
                    return Scheduler.scheduleOnce$default$5$((Scheduler)this, (FiniteDuration)delay, (ActorRef)receiver, (Object)message);
                }

                public void close() {
                }

                public double maxFrequency() {
                    return this.systemScheduler$1.maxFrequency();
                }

                public Cancellable schedule(FiniteDuration initialDelay, FiniteDuration interval, Runnable runnable, ExecutionContext executor) {
                    return this.systemScheduler$1.schedule(initialDelay, interval, runnable, executor);
                }

                public Cancellable scheduleOnce(FiniteDuration delay, Runnable runnable, ExecutionContext executor) {
                    return this.systemScheduler$1.scheduleOnce(delay, runnable, executor);
                }
                {
                    this.systemScheduler$1 = systemScheduler$1;
                    Scheduler.$init$((Scheduler)this);
                }
            };
        }
        this.scheduler = scheduler;
        this.clusterDaemons = system.systemActorOf(Props$.MODULE$.apply(ClusterDaemon.class, (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.settings(), this.joinConfigCompatChecker()})).withDispatcher(this.settings().UseDispatcher()).withDeploy(Deploy$.MODULE$.local()), "cluster");
        Timeout timeout = system.settings().CreationTimeout();
        this.clusterCore = this.liftedTree1$1(timeout);
        this.readView = new ClusterReadView(this);
        system.registerOnTermination((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.shutdown());
        if (this.settings().JmxEnabled()) {
            ClusterJmx jmx = new ClusterJmx(this, this.akka$cluster$Cluster$$log());
            jmx.createMBean();
            this.clusterJmx_$eq((Option<ClusterJmx>)new Some((Object)jmx));
        }
        this.InfoLogger().logInfo("Started up successfully");
    }
}

