/*
 * Decompiled with CFR 0.152.
 */
package com.nomagic.esi.serializer;

import com.esotericsoftware.kryo.ClassResolver;
import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.ReferenceResolver;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.util.MapReferenceResolver;
import com.nomagic.esi.config.EsiConfigService;
import com.nomagic.esi.serializer.ClassRegistrarSerializer;
import com.nomagic.esi.serializer.ClassRegistration;
import com.nomagic.esi.serializer.ClassRepository;
import com.nomagic.esi.serializer.ISerializer;
import com.nomagic.esi.serializer.a.a.a;
import com.nomagic.esi.serializer.a.a.b;
import com.nomagic.esi.serializer.a.a.d;
import com.nomagic.esi.serializer.a.b.n;
import com.nomagic.esi.serializer.a.c;
import com.nomagic.esi.serializer.a.e;
import com.nomagic.esi.serializer.a.f;
import com.nomagic.esi.serializer.a.g;
import com.nomagic.esi.serializer.a.h;
import com.nomagic.esi.serializer.a.i;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import org.objenesis.strategy.InstantiatorStrategy;
import org.objenesis.strategy.StdInstantiatorStrategy;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KryoSerializer
implements ClassRegistrarSerializer {
    private static AtomicReference<KryoSerializer> instance = new AtomicReference<Object>(null);
    private static final Logger LOG = LoggerFactory.getLogger(KryoSerializer.class);
    private EsiConfigService configService;
    private final Consumer<ISerializer> container;
    private Map<com.nomagic.esi.common.a.c.a, h<ISerializer>> serializerPools;
    private Function<com.nomagic.esi.common.a.c.a, h<ISerializer>> serializerPoolGenerator;

    public static KryoSerializer getInstance() {
        return instance.get();
    }

    static void notifyRegistrationChanged() {
        KryoSerializer kryoSerializer = KryoSerializer.getInstance();
        if (kryoSerializer != null) {
            kryoSerializer.clearSerializerPool();
        }
    }

    public KryoSerializer() {
        if (instance.getAndSet(this) != null) {
            LOG.error("More than one serializer is created.");
        }
        this.container = iSerializer -> this.releaseSerializer((ISerializer)iSerializer);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void activate(BundleContext bundleContext) {
        LOG.info("Activating " + this.getClass().getSimpleName());
        this.addRegistrations(this.getFixedRegistrations());
        if (LOG.isDebugEnabled()) {
            LOG.debug("KryoSerializer initialized");
        }
        try {
            i[] iArray;
            i[] iArray2 = iArray = new i[]{new com.nomagic.esi.serializer.a.a.c(), new a(), new b(), new d()};
            int n2 = iArray.length;
            int n3 = 0;
            block4: while (n3 < n2) {
                i i2 = iArray2[n3];
                ClassRegistration[] classRegistrationArray = i2.j();
                int n4 = classRegistrationArray.length;
                int n5 = 0;
                while (true) {
                    if (n5 >= n4) {
                        ++n3;
                        continue block4;
                    }
                    ClassRegistration classRegistration = classRegistrationArray[n5];
                    ClassRepository.INSTANCE.addClassRegistration(classRegistration);
                    ++n5;
                }
            }
        }
        catch (Throwable throwable) {
            LOG.error("Unable to create KryoSerializer: " + throwable.getMessage(), throwable);
            throw throwable;
        }
        this.serializerPools = new ConcurrentHashMap<com.nomagic.esi.common.a.c.a, h<ISerializer>>();
        this.serializerPoolGenerator = a2 -> this.createSerializerPool((com.nomagic.esi.common.a.c.a)a2);
    }

    @Override
    public void addClassRegistration(ClassRegistration classRegistration) {
        ClassRepository.INSTANCE.addClassRegistration(classRegistration);
    }

    @Override
    public void addRegistrations(Iterable<ClassRegistration> iterable) {
        ClassRepository.INSTANCE.addRegistrations(iterable);
    }

    private void clearSerializerPool() {
        if (this.serializerPools != null) {
            this.serializerPools.clear();
        }
    }

    private h<ISerializer> createSerializerPool(final com.nomagic.esi.common.a.c.a a2) {
        final int n2 = g.b;
        final int n3 = g.c;
        int n4 = g.f;
        long l2 = g.g;
        return new h<ISerializer>(n4, new h.b<ISerializer>(){

            @Override
            public ISerializer newInstance() {
                if ("lz4".equals(g.h) || "gzip".equals(g.h)) {
                    return new e(a2, new f(a2, KryoSerializer.this.newKryo(a2), n2, n3, null), KryoSerializer.this.container);
                }
                return new f(a2, KryoSerializer.this.newKryo(a2), n2, n3, KryoSerializer.this.container);
            }
        }, l2);
    }

    private Iterable<ClassRegistration> createSet(Class<?>[] classArray, int n2) {
        int n3 = n2;
        ArrayList<ClassRegistration> arrayList = new ArrayList<ClassRegistration>(classArray.length);
        Class<?>[] classArray2 = classArray;
        int n4 = classArray.length;
        int n5 = 0;
        while (n5 < n4) {
            Class<?> clazz = classArray2[n5];
            if (clazz != null) {
                arrayList.add(new ClassRegistration(clazz, n3++, null));
            }
            ++n5;
        }
        return arrayList;
    }

    private Iterable<ClassRegistration> getFixedRegistrations() {
        Class[] classArray = new Class[]{byte[].class, HashMap.class, ArrayList.class, LinkedList.class, Date.class};
        return this.createSet(classArray, 10);
    }

    @Override
    public ISerializer getSerializer(com.nomagic.esi.common.a.c.a a2) {
        return this.serializerPools.computeIfAbsent(a2, this.serializerPoolGenerator).j();
    }

    private Kryo newKryo(com.nomagic.esi.common.a.c.a a2) {
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("Create a Kryo serializer for %s", a2.toString()));
        }
        Kryo kryo2 = new Kryo((ClassResolver)new c(), (ReferenceResolver)new MapReferenceResolver());
        kryo2.setClassLoader(this.getClass().getClassLoader());
        kryo2.setInstantiatorStrategy((InstantiatorStrategy)new StdInstantiatorStrategy());
        kryo2.setDefaultSerializer((kryo, clazz) -> new n(a2.j(), kryo, clazz));
        kryo2.setRegistrationRequired(g.d);
        kryo2.setReferences(g.e);
        for (ClassRegistration classRegistration : ClassRepository.INSTANCE.getClassRegistrations().values()) {
            Serializer<?> serializer = classRegistration.getOptionalSerializer(a2.j());
            if (serializer != null) {
                kryo2.register(classRegistration.getClazz(), serializer, classRegistration.getId());
            } else if (classRegistration.getId() == -1) {
                kryo2.getClassResolver().registerImplicit(classRegistration.getClazz());
            } else {
                kryo2.register(classRegistration.getClazz(), classRegistration.getId());
            }
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug("Added registration " + classRegistration.getClazz() + " with serializer: " + serializer);
        }
        return kryo2;
    }

    private void releaseSerializer(ISerializer iSerializer) {
        this.serializerPools.computeIfAbsent(iSerializer.getCapability(), this.serializerPoolGenerator).a(iSerializer);
    }

    @Override
    public void removeClassRegistration(ClassRegistration classRegistration) {
        ClassRepository.INSTANCE.removeClassRegistration(classRegistration);
    }

    @Override
    public void removeRegistrations(Iterable<ClassRegistration> iterable) {
        ClassRepository.INSTANCE.addRegistrations(iterable);
    }

    public void setEsiConfigService(EsiConfigService esiConfigService) {
        this.configService = esiConfigService;
    }

    @Override
    public void registerClass(Class<?> clazz, int n2, Serializer<?> serializer) {
        ClassRepository.INSTANCE.registerClass(clazz, n2, serializer);
    }
}

