/*
 * Decompiled with CFR 0.152.
 */
package com.nomagic.esi.serializer;

import com.esotericsoftware.kryo.Serializer;
import com.nomagic.esi.serializer.ClassRegistration;
import com.nomagic.esi.serializer.KryoSerializer;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ClassRepository {
    public static final ClassRepository INSTANCE = new ClassRepository();
    private static final Logger LOG = LoggerFactory.getLogger(ClassRepository.class);
    private final Map<Integer, ClassRegistration> classRegistrations = new HashMap<Integer, ClassRegistration>();
    private final Set<Integer> kryoIDs = new TreeSet<Integer>();
    private final HashMap<String, Integer> registrationMap = new HashMap();

    private ClassRepository() {
    }

    public void addClassRegistration(ClassRegistration classRegistration) {
        if (!this.canRegister(classRegistration.getClazz(), classRegistration.getId())) {
            LOG.warn("Class " + classRegistration.getClazz().getName() + " is already registered");
            return;
        }
        this.registrationMap.put(classRegistration.getClazz().getName(), classRegistration.getId());
        this.kryoIDs.add(classRegistration.getId());
        this.register(classRegistration);
        KryoSerializer.notifyRegistrationChanged();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void addRegistrations(Iterable<ClassRegistration> iterable) {
        for (ClassRegistration classRegistration : iterable) {
            this.register(classRegistration);
        }
        KryoSerializer.notifyRegistrationChanged();
    }

    private boolean canRegister(Class<?> clazz, int n2) {
        if (this.registrationMap.containsKey(clazz.getName())) {
            int n3 = this.registrationMap.get(clazz.getName());
            if (n3 != n2) {
                throw new IllegalStateException(String.format("Attempted to register the class %s with id %s but it was already registered with %s", clazz.getName(), Integer.toString(n2), Integer.toString(n3)));
            }
            LOG.warn(String.format("Attempted to re-register the class %s with id %s, but it is already registered under that ID.", clazz.getName(), Integer.toString(n2)));
            return false;
        }
        if (this.kryoIDs.contains(n2)) {
            throw new IllegalStateException(String.format("Attempted to register the class %s with id %s but this id has already been assigned", clazz.getName(), Integer.toString(n2)));
        }
        return true;
    }

    private void deregister(ClassRegistration classRegistration) {
        this.classRegistrations.remove(classRegistration.getId());
        if (LOG.isDebugEnabled()) {
            LOG.debug("Unloaded registration for class {} with id {}.", (Object)classRegistration.getClazz().getName(), (Object)classRegistration.getId());
        }
    }

    Map<Integer, ClassRegistration> getClassRegistrations() {
        return this.classRegistrations;
    }

    private void register(ClassRegistration classRegistration) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Registered class: " + classRegistration.getClazz().getName() + " with id: " + classRegistration.getId());
        }
        Integer n2 = classRegistration.getId();
        ClassRegistration classRegistration2 = this.classRegistrations.get(n2);
        if (this.classRegistrations.containsKey(n2)) {
            LOG.error("Duplicate registration ID: {} class: {}", (Object)n2, classRegistration2.getClazz());
        }
        this.classRegistrations.put(classRegistration.getId(), classRegistration);
    }

    public void registerClass(Class<?> clazz, int n2, Serializer<?> serializer) {
        if (LOG.isDebugEnabled()) {
            LOG.debug(MessageFormat.format("Registering class {0} with id {1}", clazz.getName(), Integer.toString(n2)));
        }
        ClassRegistration classRegistration = new ClassRegistration(clazz, n2, serializer);
        this.addClassRegistration(classRegistration);
    }

    public void removeClassRegistration(ClassRegistration classRegistration) {
        this.deregister(classRegistration);
        KryoSerializer.notifyRegistrationChanged();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void removeRegistrations(Iterable<ClassRegistration> iterable) {
        for (ClassRegistration classRegistration : iterable) {
            this.deregister(classRegistration);
        }
        KryoSerializer.notifyRegistrationChanged();
    }
}

