/*
 * Decompiled with CFR 0.152.
 */
package org.openmbee.mpspi.svc;

import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.FeatureMapUtil;
import org.openmbee.mpspi.MPAdapter;
import org.openmbee.mpspi.exceptions.MPAccessException;
import org.openmbee.mpspi.exceptions.MPDataLoadException;
import org.openmbee.mpspi.exceptions.MPException;
import org.openmbee.mpspi.svc.MPBaseAdapter;

public class MPDefaultAdapter
extends MPBaseAdapter {
    private ResourceSet resourceSet;
    private Resource resource;
    private boolean isTrackingModification = true;

    @Override
    public Serializable getInformation(MPAdapter.InformationOption option) throws MPException {
        switch (option) {
            case NAME: {
                return "MPSPI Default MPAdapter";
            }
            case SPECIFICATIONS: {
                return MPDefaultAdapter.specifications("false,,,XMI Resource");
            }
        }
        return super.getInformation(option);
    }

    protected void setTrackingModification(boolean flag) {
        this.isTrackingModification = flag;
    }

    @Override
    public void load(URI uri, Map<MPAdapter.LoadOption, Object> option) throws MPException {
        this.resourceSet = new ResourceSetImpl();
        try {
            this.resource = this.resourceSet.getResource(uri, true);
            if (this.resource == null) {
                throw new MPDataLoadException("Failed to load Model (possibly the model is nonexistent): " + uri);
            }
            this.resource.setTrackingModification(this.isTrackingModification);
        }
        catch (WrappedException we) {
            Exception e = we.exception();
            if (e instanceof MPException) {
                throw (MPException)e;
            }
            throw we;
        }
    }

    @Override
    public MPAdapter.ReloadResult reload() throws MPException {
        Resource r = this.checkResource();
        if (r.isLoaded()) {
            r.unload();
        }
        try {
            r.load(Collections.EMPTY_MAP);
        }
        catch (IOException e) {
            throw new MPAccessException("Failed to reload", e);
        }
        super.clearUndoRedoStacks();
        return MPAdapter.ReloadResult.NEED_REACTIVATE;
    }

    @Override
    public MPAdapter.UndoResult undo() throws MPException {
        return super.undo();
    }

    @Override
    public Resource getResource() {
        return this.resource;
    }

    private static void saveInternal(Resource r) throws MPException {
        try {
            r.save(null);
        }
        catch (IOException e) {
            throw new MPAccessException("Failed to save the model to: " + r.getURI().toString(), e);
        }
    }

    @Override
    public void save(Map<MPAdapter.SaveOption, Object> option) throws MPException {
        Resource r = this.checkResource();
        URI origURI = r.getURI();
        URI uri = MPDefaultAdapter.checkSaveAs(option);
        if (uri == null || uri.equals(origURI)) {
            MPDefaultAdapter.saveInternal(r);
        } else {
            try {
                r.setURI(uri);
                MPDefaultAdapter.saveInternal(r);
            }
            finally {
                if (MPDefaultAdapter.checkSaveCopyAs(option)) {
                    r.setURI(origURI);
                }
            }
        }
    }

    @Override
    public void unload() throws MPException {
        Resource r = this.checkResource();
        r.unload();
        this.resource = null;
    }

    @Override
    public void delete(EObject eObj) throws MPException {
        this.deleteRecursively(eObj);
    }

    protected void deleteEObject(EObject eobj) throws MPException {
        Collection usages = EcoreUtil.UsageCrossReferencer.find((EObject)eobj, (ResourceSet)this.resourceSet);
        for (EStructuralFeature.Setting setting : usages) {
            EObject eoS = setting.getEObject();
            EStructuralFeature f = setting.getEStructuralFeature();
            if (!f.isChangeable()) continue;
            if (FeatureMapUtil.isMany((EObject)eoS, (EStructuralFeature)f)) {
                this.doRemove(eoS, f, eobj);
                continue;
            }
            this.doUnset(eoS, f, eobj);
        }
        if (eobj instanceof InternalEObject) {
            Resource.Internal dr;
            EReference feature;
            InternalEObject ieo = (InternalEObject)eobj;
            InternalEObject container = ieo.eInternalContainer();
            if (container != null && (feature = eobj.eContainmentFeature()).isChangeable()) {
                if (FeatureMapUtil.isMany((EObject)container, (EStructuralFeature)feature)) {
                    this.doRemove((EObject)container, (EStructuralFeature)feature, eobj);
                } else {
                    this.doUnset((EObject)container, (EStructuralFeature)feature, eobj);
                }
            }
            if ((dr = ieo.eDirectResource()) != null) {
                this.doDelete(eobj, (Resource)dr);
            }
        }
    }

    private void deleteRecursively(EObject eObj) throws MPException {
        EClass cls = eObj.eClass();
        this.deleteContents(eObj, cls);
        this.deleteEObject(eObj);
    }

    private void deleteContents(EObject eObj, EClass cls) throws MPException {
        for (EReference ref : cls.getEAllContainments()) {
            Object o = eObj.eGet((EStructuralFeature)ref);
            if (o == null) continue;
            if (ref.isMany()) {
                EObject[] childrenArray;
                EList children = (EList)o;
                if (children == null || children.isEmpty()) continue;
                EObject[] eObjectArray = childrenArray = (EObject[])children.toArray((Object[])new EObject[0]);
                int n = childrenArray.length;
                int n2 = 0;
                while (n2 < n) {
                    EObject child = eObjectArray[n2];
                    this.deleteRecursively(child);
                    ++n2;
                }
                continue;
            }
            this.deleteRecursively((EObject)o);
        }
    }
}

