/*
 * Decompiled with CFR 0.152.
 */
package org.openmbee.mpspi.svc;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.openmbee.mpspi.util.MPUtil;

public abstract class MPCommand {
    protected final EObject target;
    protected final EStructuralFeature feature;

    public void addLockTarget(Collection<EObject> c) {
        c.add(this.target);
    }

    public abstract void execute();

    public abstract void undo();

    private MPCommand(EObject target, EStructuralFeature feature) {
        this.target = target;
        this.feature = feature;
    }

    /* synthetic */ MPCommand(EObject eObject, EStructuralFeature eStructuralFeature, MPCommand mPCommand) {
        this(eObject, eStructuralFeature);
    }

    public static class Add
    extends MPCommand {
        private final Object value;
        private final int index;

        public static void go(EObject t, EStructuralFeature f, Object v, int i) {
            EList valueList = (EList)t.eGet(f);
            if (i >= 0) {
                MPUtil.setToList(valueList, i, v);
            } else {
                valueList.add(v);
            }
        }

        @Override
        public void execute() {
            Add.go(this.target, this.feature, this.value, this.index);
        }

        public Add(EObject target, EStructuralFeature feature, Object value, int index) {
            super(target, feature, null);
            assert (feature.isMany());
            this.value = value;
            this.index = index;
        }

        public Add(EObject target, EStructuralFeature feature, Object value) {
            this(target, feature, value, -1);
        }

        @Override
        public void undo() {
            Remove.go(this.target, this.feature, this.value);
        }
    }

    public static class Delete
    extends MPCommand {
        private final Resource resource;

        public static void go(EObject t, Resource r) {
            r.getContents().remove((Object)t);
        }

        @Override
        public void execute() {
            Delete.go(this.target, this.resource);
        }

        public Delete(EObject target, Resource resource) {
            super(target, null, null);
            this.resource = resource;
        }

        @Override
        public void undo() {
            this.resource.getContents().add((Object)this.target);
        }
    }

    public static class Remove
    extends MPCommand {
        private final Object value;

        @Override
        public void addLockTarget(Collection<EObject> c) {
            if (this.value instanceof EObject) {
                c.add((EObject)this.value);
            }
            super.addLockTarget(c);
        }

        public static void go(EObject t, EStructuralFeature f, Object v) {
            EList valueList = (EList)t.eGet(f);
            valueList.remove(v);
        }

        @Override
        public void execute() {
            Remove.go(this.target, this.feature, this.value);
        }

        public Remove(EObject target, EStructuralFeature feature, Object value) {
            super(target, feature, null);
            assert (feature.isMany());
            this.value = value;
        }

        @Override
        public void undo() {
            Add.go(this.target, this.feature, this.value, -1);
        }
    }

    public static class RemoveByIdx
    extends MPCommand {
        private final int index;

        @Override
        public void addLockTarget(Collection<EObject> c) {
            Object o;
            EList valueList;
            Object vl = this.target.eGet(this.feature);
            if (vl instanceof EList && (valueList = (EList)vl).size() > this.index && (o = valueList.get(this.index)) instanceof EObject) {
                EObject eObj = (EObject)o;
                c.add(eObj);
            }
            super.addLockTarget(c);
        }

        public static void go(EObject t, EStructuralFeature f, int index) {
            EList valueList = (EList)t.eGet(f);
            valueList.remove(index);
        }

        @Override
        public void execute() {
            RemoveByIdx.go(this.target, this.feature, this.index);
        }

        public RemoveByIdx(EObject target, EStructuralFeature feature, int index) {
            super(target, feature, null);
            assert (feature.isMany());
            this.index = index;
        }

        @Override
        public void undo() {
        }
    }

    public static class Set
    extends MPCommand {
        private final Object newValue;
        private final Object oldValue;
        private final boolean force;
        private boolean isFirstValue;

        public static void go(EObject t, EStructuralFeature f, Object v) {
            t.eSet(f, v);
        }

        public static void forcibly(EObject t, EStructuralFeature f, Object v) {
            if (f.isChangeable()) {
                t.eSet(f, v);
            } else {
                try {
                    f.setChangeable(true);
                    t.eSet(f, v);
                }
                finally {
                    f.setChangeable(false);
                }
            }
        }

        @Override
        public void execute() {
            this.isFirstValue = this.target.eIsSet(this.feature);
            if (this.force) {
                Set.forcibly(this.target, this.feature, this.newValue);
            } else {
                Set.go(this.target, this.feature, this.newValue);
            }
        }

        public Set(EObject target, EStructuralFeature feature, Object newValue, Object oldValue, boolean force) {
            super(target, feature, null);
            this.newValue = newValue;
            this.oldValue = oldValue;
            this.force = force;
        }

        @Override
        public void undo() {
            if (!this.isFirstValue) {
                this.target.eUnset(this.feature);
            } else {
                Set.go(this.target, this.feature, this.oldValue);
            }
        }
    }

    public static class Unset
    extends MPCommand {
        private final Object value;
        private List<MPCommand> removeCommand = new ArrayList<MPCommand>();

        public static void go(EObject t, EStructuralFeature f) {
            t.eUnset(f);
        }

        @Override
        public void execute() {
            EReference eRef;
            if (this.feature instanceof EReference && (eRef = (EReference)this.feature).getEOpposite() != null) {
                Remove remove;
                EReference oppositeRef = eRef.getEOpposite();
                if (oppositeRef.isMany()) {
                    if (this.value instanceof Collection) {
                        Collection eObjects = (Collection)this.value;
                        for (EObject eObject : eObjects) {
                            remove = new Remove(eObject, (EStructuralFeature)oppositeRef, this.target);
                            this.removeCommand.add(remove);
                        }
                    } else {
                        Remove remove2 = new Remove((EObject)this.value, (EStructuralFeature)oppositeRef, this.target);
                        this.removeCommand.add(remove2);
                    }
                } else if (this.value instanceof EList) {
                    EList eList = (EList)this.value;
                    for (EObject eObject : eList) {
                        remove = new Remove(this.target, this.feature, eObject);
                        this.removeCommand.add(remove);
                    }
                }
            }
            for (MPCommand mpCommand : this.removeCommand) {
                mpCommand.execute();
            }
            Unset.go(this.target, this.feature);
        }

        public Unset(EObject target, EStructuralFeature feature, Object value) {
            super(target, feature, null);
            this.value = value;
        }

        @Override
        public void undo() {
            if (this.value != null && !(this.value instanceof Collection)) {
                Set.go(this.target, this.feature, this.value);
            }
            if (this.removeCommand != null) {
                for (MPCommand mpCommand : this.removeCommand) {
                    mpCommand.undo();
                }
            }
        }
    }
}

