/*
 * Decompiled with CFR 0.152.
 */
package org.openmbee.mpspi.svc;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.openmbee.mpspi.MPAdapter;
import org.openmbee.mpspi.exceptions.MPException;
import org.openmbee.mpspi.exceptions.MPRedoException;
import org.openmbee.mpspi.exceptions.MPUndoException;
import org.openmbee.mpspi.exceptions.MPUnsupportedOperationException;
import org.openmbee.mpspi.modifier.MPModifier;
import org.openmbee.mpspi.svc.MPAbstractAdapter;
import org.openmbee.mpspi.svc.MPCommand;
import org.openmbee.mpspi.util.MPUtil;

public abstract class MPBaseAdapter
extends MPAbstractAdapter {
    private Map<EStructuralFeature, MPModifier> mpModifierMap = new HashMap<EStructuralFeature, MPModifier>();
    private Stack<Stack<List<MPCommand>>> undoLogs = new Stack();
    private Stack<List<MPCommand>> undoCommandLog;
    private Collection<MPCommand> mpCommandLog;
    private Stack<Stack<List<MPCommand>>> redoStack = new Stack();

    public void registerMPModifier(MPModifier modifier) throws MPException {
        EModelElement c = modifier.getModificationCriteria();
        if (!(c instanceof EStructuralFeature)) {
            throw new MPUnsupportedOperationException("Unsupported criteria: " + c + " in " + modifier);
        }
        EStructuralFeature f = (EStructuralFeature)c;
        this.mpModifierMap.put(f, modifier);
    }

    private boolean isTransactionEnabled() {
        return this.mpCommandLog != null;
    }

    protected void setTransaction(boolean flag) {
        if (flag) {
            this.mpCommandLog = new ArrayList<MPCommand>();
            this.undoCommandLog = new Stack();
        } else {
            this.mpCommandLog = null;
            this.undoCommandLog = null;
        }
    }

    protected Set<EObject> getLockTargets() {
        HashSet<EObject> ret = new HashSet<EObject>(this.mpCommandLog.size());
        for (MPCommand mc : this.mpCommandLog) {
            mc.addLockTarget(ret);
        }
        return ret;
    }

    protected void clearTransaction() {
        if (this.mpCommandLog != null) {
            this.mpCommandLog.clear();
        }
    }

    protected void addUndoLog() {
        if (this.undoCommandLog != null && !this.mpCommandLog.isEmpty()) {
            ArrayList<MPCommand> commands = new ArrayList<MPCommand>();
            commands.addAll(this.mpCommandLog);
            this.undoCommandLog.add(commands);
        }
    }

    @Override
    public void storeTransaction() {
        if (this.undoCommandLog != null && !this.undoCommandLog.isEmpty()) {
            this.undoLogs.push(this.undoCommandLog);
            this.undoCommandLog = new Stack();
        }
    }

    protected void clearUndoRedoStacks() {
        this.undoLogs.clear();
        this.redoStack.clear();
    }

    protected void commit() throws MPException {
        for (MPCommand mpc : this.mpCommandLog) {
            mpc.execute();
        }
        this.redoStack.clear();
    }

    @Override
    public MPAdapter.UndoResult undo() throws MPException {
        if (this.undoLogs.isEmpty()) {
            return MPAdapter.DoResult.EMPTY_STACK;
        }
        try {
            Stack<List<MPCommand>> undoLog = this.undoLogs.pop();
            Object redoObject = undoLog.clone();
            while (!undoLog.isEmpty()) {
                List<MPCommand> undo = undoLog.pop();
                for (MPCommand mpCommand : undo) {
                    mpCommand.undo();
                }
            }
            this.redoStack.add((Stack)redoObject);
            return MPAdapter.DoResult.DONE;
        }
        catch (Exception e) {
            this.clearUndoRedoStacks();
            throw new MPUndoException("Unable to revert, Please reload the model without saving.", e);
        }
    }

    @Override
    public MPAdapter.RedoResult redo() throws MPException {
        if (this.redoStack.isEmpty()) {
            return MPAdapter.DoResult.EMPTY_STACK;
        }
        try {
            Stack<List<MPCommand>> redoLog = this.redoStack.pop();
            Object tmp = redoLog.clone();
            Stack undoObject = null;
            if (tmp instanceof Stack) {
                Stack stack;
                undoObject = stack = (Stack)tmp;
            }
            if (undoObject == null) {
                throw new IllegalStateException();
            }
            for (List list : redoLog) {
                for (MPCommand mpCommand : list) {
                    mpCommand.execute();
                }
            }
            this.undoLogs.push(undoObject);
            return MPAdapter.DoResult.DONE;
        }
        catch (Exception e) {
            this.clearRedoStack();
            throw new MPRedoException("Unable to perform redo operation, Please reload the model without saving.", e);
        }
    }

    private void clearRedoStack() {
        this.redoStack.clear();
    }

    @Override
    public void doSet(EObject target, EStructuralFeature feature, Object value, Object oldValue) {
        if (this.isTransactionEnabled()) {
            this.mpCommandLog.add(new MPCommand.Set(target, feature, value, oldValue, false));
        } else {
            super.doSet(target, feature, value, oldValue);
        }
    }

    @Override
    protected void doSetForcibly(EObject target, EStructuralFeature feature, Object value, Object oldValue) {
        if (this.isTransactionEnabled()) {
            this.mpCommandLog.add(new MPCommand.Set(target, feature, value, oldValue, true));
        } else {
            super.doSetForcibly(target, feature, value, oldValue);
        }
    }

    @Override
    public void doUnset(EObject target, EStructuralFeature feature, Object value) {
        if (this.isTransactionEnabled()) {
            this.mpCommandLog.add(new MPCommand.Unset(target, feature, value));
        } else {
            super.doUnset(target, feature, value);
        }
    }

    @Override
    public void doAdd(EObject target, EStructuralFeature feature, Object value, int index) {
        if (this.isTransactionEnabled()) {
            this.mpCommandLog.add(new MPCommand.Add(target, feature, value, index));
        } else {
            super.doAdd(target, feature, value, index);
        }
    }

    @Override
    public void doAdd(EObject target, EStructuralFeature feature, Object value) {
        this.doAdd(target, feature, value, -1);
    }

    @Override
    public void doRemove(EObject target, EStructuralFeature feature, Object value) {
        if (this.isTransactionEnabled()) {
            this.mpCommandLog.add(new MPCommand.Remove(target, feature, value));
        } else {
            super.doRemove(target, feature, value);
        }
    }

    @Override
    public void doRemoveByIdx(EObject target, EStructuralFeature feature, int index) {
        if (this.isTransactionEnabled()) {
            this.mpCommandLog.add(new MPCommand.RemoveByIdx(target, feature, index));
        } else {
            super.doRemoveByIdx(target, feature, index);
        }
    }

    @Override
    public void doDelete(EObject target, Resource resource) {
        if (this.isTransactionEnabled()) {
            this.mpCommandLog.add(new MPCommand.Delete(target, resource));
        } else {
            super.doDelete(target, resource);
        }
    }

    @Override
    public Object get(EObject eObj, EStructuralFeature feature) throws MPException {
        MPModifier m = this.mpModifierMap.get(feature);
        if (m != null) {
            return m.get(eObj, feature);
        }
        if (!eObj.eIsSet(feature)) {
            return null;
        }
        Object obj = eObj.eGet(feature);
        if (obj instanceof Collection) {
            return new BasicEList((Collection)obj);
        }
        return obj;
    }

    @Override
    public Object getParameter(EStructuralFeature feature) throws MPException {
        MPModifier m = this.mpModifierMap.get(feature);
        if (m != null) {
            return m.getParameter();
        }
        return null;
    }

    @Override
    public void setParameter(EStructuralFeature feature, Object parameter) throws MPException {
        MPModifier m = this.mpModifierMap.get(feature);
        if (m != null) {
            m.setParameter(parameter);
        }
    }

    @Override
    public void add(EObject eObj, EStructuralFeature feature, Object value, int index) throws MPException {
        MPModifier m = this.mpModifierMap.get(feature);
        if (m != null) {
            m.add(eObj, feature, value, index);
        } else {
            if (MPUtil.isVirtual((EModelElement)feature)) {
                return;
            }
            this.doAdd(eObj, feature, value, index);
        }
    }

    @Override
    protected MPAbstractAdapter.TranslateInitializersResult translateInitializers(EObject value, Map<EStructuralFeature, Object> inits) throws MPException {
        ArrayList<EStructuralFeature> translated = null;
        for (EStructuralFeature f : inits.keySet()) {
            Object initValue;
            EObject v;
            MPModifier m = this.mpModifierMap.get(f);
            if (m == null || (v = m.init(value, f, initValue = inits.get(f))) == null) continue;
            if (translated == null) {
                translated = new ArrayList<EStructuralFeature>(1);
            }
            value = v;
            translated.add(f);
        }
        if (translated == null) {
            return null;
        }
        HashMap<EStructuralFeature, Object> newInits = new HashMap<EStructuralFeature, Object>(inits.size());
        for (Map.Entry<EStructuralFeature, Object> e : inits.entrySet()) {
            EStructuralFeature feature = e.getKey();
            if (translated.contains(feature)) continue;
            Object val = e.getValue();
            newInits.put(feature, val);
        }
        return new MPAbstractAdapter.TranslateInitializersResult(value, newInits);
    }

    @Override
    public void remove(EObject eObj, EStructuralFeature feature, Object value) throws MPException {
        MPModifier m = this.mpModifierMap.get(feature);
        if (m != null) {
            m.remove(eObj, feature, value);
        } else {
            if (MPUtil.isVirtual((EModelElement)feature)) {
                return;
            }
            this.doRemove(eObj, feature, value);
        }
    }

    @Override
    public void removeByIdx(EObject eObj, EStructuralFeature feature, int index) throws MPException {
        MPModifier m = this.mpModifierMap.get(feature);
        if (m != null) {
            m.removeByIdx(eObj, feature, index);
        } else {
            if (MPUtil.isVirtual((EModelElement)feature)) {
                return;
            }
            this.doRemoveByIdx(eObj, feature, index);
        }
    }

    @Override
    public void set(EObject eObj, EStructuralFeature feature, Object value) throws MPException {
        MPModifier m = this.mpModifierMap.get(feature);
        if (m != null) {
            Object oldValue = this.get(eObj, feature);
            m.set(eObj, feature, value, oldValue);
        } else {
            if (MPUtil.isVirtual((EModelElement)feature)) {
                return;
            }
            Object oldValue = this.get(eObj, feature);
            this.doSet(eObj, feature, value, oldValue);
        }
    }

    @Override
    public void unset(EObject eObj, EStructuralFeature feature, Object value) throws MPException {
        MPModifier m = this.mpModifierMap.get(feature);
        if (m != null) {
            m.unset(eObj, feature, value);
        } else {
            if (MPUtil.isVirtual((EModelElement)feature)) {
                return;
            }
            this.doUnset(eObj, feature, value);
        }
    }
}

