/*
 * Decompiled with CFR 0.152.
 */
package org.openmbee.mpspi.svc;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.ServiceConfigurationError;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.openmbee.mpspi.Activator;
import org.openmbee.mpspi.MPAdapter;
import org.openmbee.mpspi.exceptions.MPException;
import org.openmbee.mpspi.exceptions.MPIllegalStateException;
import org.openmbee.mpspi.exceptions.MPInstantiateException;
import org.openmbee.mpspi.exceptions.MPNoRootNameException;
import org.openmbee.mpspi.svc.MPCommand;
import org.openmbee.mpspi.util.MPUtil;

public abstract class MPAbstractAdapter
implements MPAdapter {
    protected Resource checkResource() throws MPIllegalStateException {
        Resource r = this.getResource();
        if (r == null) {
            throw new MPIllegalStateException("Resource has not been loaded");
        }
        return r;
    }

    private static String convertSpecificationString(String str) {
        if ((str = str.trim()).length() == 0) {
            return null;
        }
        return str;
    }

    public static MPAdapter.Specification specification(String spec) throws MPException {
        String[] strs = spec.split(",");
        if (strs.length < 4) {
            throw new ServiceConfigurationError("Spefication String is invalid:" + spec);
        }
        return new SpecificationImpl(Boolean.parseBoolean(strs[0]), MPAbstractAdapter.convertSpecificationString(strs[1]), MPAbstractAdapter.convertSpecificationString(strs[2]), MPAbstractAdapter.convertSpecificationString(strs[3]));
    }

    public static MPAdapter.Specification[] specifications(String ... specs) throws MPException {
        MPAdapter.Specification[] r = new MPAdapter.Specification[specs.length];
        int i = 0;
        while (i < specs.length) {
            r[i] = MPAbstractAdapter.specification(specs[i]);
            ++i;
        }
        return r;
    }

    @Override
    public Serializable getInformation(MPAdapter.InformationOption option) throws MPException {
        switch (option) {
            case NAME: {
                return "MPSPI adapter";
            }
            case VERSION: {
                return Activator.getVersionString();
            }
        }
        return null;
    }

    @Override
    public List<EObject> getRoots(String name) throws MPException {
        Resource r = this.checkResource();
        if ("Root".equals(name)) {
            ArrayList<EObject> ret = new ArrayList<EObject>(1);
            EList contents = r.getContents();
            if (!contents.isEmpty()) {
                ret.add((EObject)contents.get(0));
            }
            return ret;
        }
        if ("Roots".equals(name)) {
            return r.getContents();
        }
        throw new MPNoRootNameException(name);
    }

    @Override
    public List<EObject> getByEClass(EClass eCls) throws MPException {
        Resource r = this.checkResource();
        ArrayList<EObject> results = new ArrayList<EObject>();
        TreeIterator it = r.getAllContents();
        while (it.hasNext()) {
            EObject eObj = (EObject)it.next();
            if (!eCls.isInstance((Object)eObj)) continue;
            results.add(eObj);
        }
        return results;
    }

    @Override
    public EPackage.Registry getPackageRegistry() {
        ResourceSet rs;
        EPackage.Registry pr;
        Resource r = this.getResource();
        if (r != null && (pr = (rs = r.getResourceSet()).getPackageRegistry()) != null) {
            return pr;
        }
        return EPackage.Registry.INSTANCE;
    }

    public static URI checkSaveAs(Map<MPAdapter.SaveOption, Object> option) {
        if (option == null) {
            return null;
        }
        Object o = option.get((Object)MPAdapter.SaveOption.SAVE_URI);
        if (o == null) {
            return null;
        }
        if (o instanceof URI) {
            return (URI)o;
        }
        throw new IllegalArgumentException("The value of SaveOption.SAVE_URI must be URI: " + o);
    }

    public static boolean checkSaveCopyAs(Map<MPAdapter.SaveOption, Object> option) {
        if (option == null) {
            return false;
        }
        Object o = option.get((Object)MPAdapter.SaveOption.SAVE_COPY_AS);
        if (o == null) {
            return false;
        }
        if (o instanceof Boolean) {
            return (Boolean)o;
        }
        throw new IllegalArgumentException("The value of SaveOption.SAVE_COPY_AS must be Boolean: " + o);
    }

    protected void initializeFeatures(EObject eObj, Map<EStructuralFeature, Object> inits) throws MPException {
        for (Map.Entry<EStructuralFeature, Object> e : inits.entrySet()) {
            EStructuralFeature feature = e.getKey();
            if (MPUtil.isVirtual((EModelElement)feature)) continue;
            Object val = e.getValue();
            this.doSetForcibly(eObj, feature, val, null);
        }
    }

    protected TranslateInitializersResult translateInitializers(EObject eObj, Map<EStructuralFeature, Object> inits) throws MPException {
        return null;
    }

    @Override
    public EObject instantiate(EClass eClass, Map<EStructuralFeature, Object> inits) throws MPException {
        try {
            EPackage ePkg = eClass.getEPackage();
            EObject eObj = ePkg.getEFactoryInstance().create(eClass);
            TranslateInitializersResult tir = this.translateInitializers(eObj, inits);
            if (tir != null) {
                eObj = tir.eObject;
                inits = tir.inits;
            }
            this.initializeFeatures(eObj, inits);
            return eObj;
        }
        catch (IllegalArgumentException e) {
            throw new MPInstantiateException(eClass, (Throwable)e);
        }
    }

    public void doSet(EObject target, EStructuralFeature feature, Object value, Object oldValue) {
        MPCommand.Set.go(target, feature, value);
    }

    protected void doSetForcibly(EObject target, EStructuralFeature feature, Object value, Object oldValue) {
        MPCommand.Set.forcibly(target, feature, value);
    }

    public void doUnset(EObject target, EStructuralFeature feature, Object value) {
        MPCommand.Unset.go(target, feature);
    }

    public void doAdd(EObject target, EStructuralFeature feature, Object value, int index) {
        MPCommand.Add.go(target, feature, value, index);
    }

    public void doAdd(EObject target, EStructuralFeature feature, Object value) {
        this.doAdd(target, feature, value, -1);
    }

    public void doRemove(EObject target, EStructuralFeature feature, Object value) {
        MPCommand.Remove.go(target, feature, value);
    }

    public void doRemoveByIdx(EObject target, EStructuralFeature feature, int index) {
        MPCommand.RemoveByIdx.go(target, feature, index);
    }

    public void doDelete(EObject target, Resource resource) {
        MPCommand.Delete.go(target, resource);
    }

    protected static class SpecificationImpl
    implements MPAdapter.Specification {
        private static final long serialVersionUID = 1L;
        private final boolean askUsers;
        private final String scheme;
        private final String suffix;
        private final String description;

        protected SpecificationImpl(boolean askUsers, String scheme, String suffix, String description) {
            this.askUsers = askUsers;
            this.scheme = scheme;
            this.suffix = suffix;
            this.description = description;
        }

        @Override
        public boolean canAskUsers() {
            return this.askUsers;
        }

        @Override
        public String getScheme() {
            return this.scheme;
        }

        @Override
        public String getSuffix() {
            return this.suffix;
        }

        @Override
        public String getDescription() {
            return this.description;
        }
    }

    protected static class TranslateInitializersResult {
        public final EObject eObject;
        public final Map<EStructuralFeature, Object> inits;

        public TranslateInitializersResult(EObject eObj, Map<EStructuralFeature, Object> inits) {
            this.eObject = eObj;
            this.inits = inits;
        }
    }
}

