/*
 * Decompiled with CFR 0.152.
 */
package org.openmbee.mpspi.modifier;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.notify.impl.NotificationImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.openmbee.mpspi.MPNotificationReceiver;
import org.openmbee.mpspi.modifier.MPNotificationModifier;

public abstract class MPAbstractNotificationModifier
extends AdapterImpl
implements MPNotificationModifier {
    private final EStructuralFeature actualFeature;

    public EStructuralFeature getActualFeature() {
        return this.actualFeature;
    }

    protected MPAbstractNotificationModifier(EStructuralFeature actualFeature) {
        this.actualFeature = actualFeature;
    }

    public boolean equals(Object o) {
        if (!(o instanceof MPAbstractNotificationModifier)) {
            return false;
        }
        MPAbstractNotificationModifier nm = (MPAbstractNotificationModifier)o;
        return this.actualFeature.equals(nm.getActualFeature());
    }

    public int hashCode() {
        return this.actualFeature.hashCode();
    }

    private void notify(Notifier target, Notification msg) {
        if (!target.eDeliver()) {
            return;
        }
        EList tmp = target.eAdapters();
        if (tmp == null) {
            return;
        }
        ArrayList adapters = new ArrayList(tmp);
        if (adapters.isEmpty()) {
            return;
        }
        for (Adapter a : adapters) {
            if (!(a instanceof MPNotificationReceiver)) continue;
            a.notifyChanged(msg);
        }
    }

    protected void send(EObject target, EStructuralFeature virtualFeature, Object obj, boolean isAdded) {
        Object oldValue;
        Object newValue;
        int eventType;
        if (isAdded) {
            eventType = virtualFeature.isMany() ? 3 : 1;
            newValue = obj;
            oldValue = null;
        } else {
            eventType = virtualFeature.isMany() ? 4 : 2;
            oldValue = obj;
            newValue = null;
        }
        MPModifiedNotification msg = new MPModifiedNotification(target, eventType, virtualFeature, oldValue, newValue, -1);
        this.notify((Notifier)target, (Notification)msg);
    }

    protected abstract void changed(Object var1, Notification var2, boolean var3);

    protected void changed(List<Object> objs, Notification msg, boolean isAdded) {
        for (Object obj : objs) {
            this.changed(obj, msg, isAdded);
        }
    }

    public void notifyChanged(Notification msg) {
        if (!this.actualFeature.equals(msg.getFeature())) {
            return;
        }
        switch (msg.getEventType()) {
            case 3: {
                Object add = msg.getNewValue();
                this.changed(add, msg, true);
                return;
            }
            case 5: {
                List adds = (List)msg.getNewValue();
                if (adds.size() <= 0) {
                    return;
                }
                this.changed(adds, msg, true);
                return;
            }
            case 4: {
                Object remove = msg.getOldValue();
                this.changed(remove, msg, false);
                return;
            }
            case 6: {
                List removes = (List)msg.getOldValue();
                if (removes.size() <= 0) {
                    return;
                }
                this.changed(removes, msg, false);
                return;
            }
            case 1: {
                Object set = msg.getNewValue();
                if (set == null) {
                    set = msg.getOldValue();
                    this.changed(set, msg, false);
                } else {
                    this.changed(set, msg, true);
                }
                return;
            }
            case 2: {
                Object set = msg.getOldValue();
                this.changed(set, msg, false);
                return;
            }
        }
    }

    private static class MPModifiedNotification
    extends NotificationImpl {
        private final EObject target;
        private final EStructuralFeature virtualFeature;

        public Object getNotifier() {
            return this.target;
        }

        public Object getFeature() {
            return this.virtualFeature;
        }

        MPModifiedNotification(EObject target, int eventType, EStructuralFeature virtualFeature, Object oldValue, Object newValue, int position) {
            super(eventType, oldValue, newValue, position);
            this.target = target;
            this.virtualFeature = virtualFeature;
        }
    }
}

