/*
 * Decompiled with CFR 0.152.
 */
package org.openmbee.mpspi.log;

public class MPLog {
    private static Logger logger = new DefaultLogger();
    private final Class<?> targetClass;

    public static void setLogger(Logger l) {
        logger = l;
    }

    public static void setDefaultLevel(Level lv) {
        if (logger instanceof DefaultLogger) {
            DefaultLogger defaultLogger = (DefaultLogger)logger;
            defaultLogger.level = lv;
        }
    }

    public boolean check(Level lv) {
        Level llv = logger.getLevel(this);
        return lv.ordinal() >= llv.ordinal();
    }

    public Class<?> getTargetClass() {
        return this.targetClass;
    }

    public MPLog(Class<?> targetClass) {
        this.targetClass = targetClass;
    }

    public void error(String msg) {
        if (!this.check(Level.ERROR)) {
            return;
        }
        logger.error(this, msg);
    }

    public void warn(String msg) {
        if (!this.check(Level.WARN)) {
            return;
        }
        logger.warn(this, msg);
    }

    public void info(String msg) {
        if (!this.check(Level.INFO)) {
            return;
        }
        logger.info(this, msg);
    }

    public void debug(String msg) {
        if (!this.check(Level.DEBUG)) {
            return;
        }
        logger.debug(this, msg);
    }

    private static class DefaultLogger
    implements Logger {
        public Level level = Level.ALL;

        private DefaultLogger() {
        }

        @Override
        public Level getLevel(MPLog mpLog) {
            return this.level;
        }

        @Override
        public void error(MPLog mpLog, String msg) {
            System.err.println(mpLog.getTargetClass() + ":" + msg);
        }

        @Override
        public void warn(MPLog mpLog, String msg) {
            System.err.println(mpLog.getTargetClass() + ":" + msg);
        }

        @Override
        public void info(MPLog mpLog, String msg) {
            System.err.println(mpLog.getTargetClass() + ":" + msg);
        }

        @Override
        public void debug(MPLog mpLog, String msg) {
            System.err.println(mpLog.getTargetClass() + ":" + msg);
        }
    }

    public static enum Level {
        ALL,
        DEBUG,
        INFO,
        WARN,
        ERROR,
        NONE;

    }

    public static interface Logger {
        public Level getLevel(MPLog var1);

        public void error(MPLog var1, String var2);

        public void warn(MPLog var1, String var2);

        public void info(MPLog var1, String var2);

        public void debug(MPLog var1, String var2);
    }
}

