/*
 * Decompiled with CFR 0.152.
 */
package org.openmbee.mpspi.discovery;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.openmbee.mpspi.MPAdapter;
import org.openmbee.mpspi.MPFactory;
import org.openmbee.mpspi.exceptions.MPException;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;

public class MPAdapterRegistry
implements ServiceListener {
    private final BundleContext context;
    private List<MPFactory> mpFactories = new ArrayList<MPFactory>();
    private static final String SERVICE_LISTENER_FILTER = "(objectClass=" + MPFactory.class.getName() + ")";

    private void initialize() {
        try {
            Collection srs = this.context.getServiceReferences(MPFactory.class, null);
            for (ServiceReference sr : srs) {
                MPFactory mpf = (MPFactory)this.context.getService(sr);
                this.mpFactories.add(mpf);
            }
        }
        catch (InvalidSyntaxException e) {
            e.printStackTrace();
        }
        try {
            this.context.addServiceListener((ServiceListener)this, SERVICE_LISTENER_FILTER);
        }
        catch (InvalidSyntaxException e) {
            e.printStackTrace();
        }
    }

    public static MPAdapterRegistry newInstance(BundleContext context) {
        MPAdapterRegistry d = new MPAdapterRegistry(context);
        d.initialize();
        return d;
    }

    private MPAdapterRegistry(BundleContext context) {
        this.context = context;
    }

    public void serviceChanged(ServiceEvent event) {
        ServiceReference sr = event.getServiceReference();
        Object o = this.context.getService(sr);
        if (!(o instanceof MPFactory)) {
            return;
        }
        MPFactory mpf = (MPFactory)o;
        switch (event.getType()) {
            case 1: {
                this.mpFactories.add(mpf);
                break;
            }
            case 4: {
                this.mpFactories.remove(mpf);
            }
        }
    }

    private static String uriToStr(URI uri) {
        if (uri == null) {
            return null;
        }
        String r = uri.trimQuery().toString();
        if (r.isEmpty()) {
            return null;
        }
        return r;
    }

    private MPFactory search(String nsURIStr, URI modelURI) {
        int priority = -1;
        MPFactory factory = null;
        String modelURIStr = MPAdapterRegistry.uriToStr(modelURI);
        for (MPFactory f : this.mpFactories) {
            MPFactory.Target target = f.getTarget();
            int p = target.getPriority();
            if (factory != null && p <= priority) continue;
            String nsURIPattern = target.getNsURIPattern();
            if (nsURIStr != null && nsURIPattern != null && !nsURIStr.matches(nsURIPattern)) continue;
            String modelURIPattern = target.getModelURIPattern();
            if (modelURIStr != null && modelURIPattern != null && !modelURIStr.matches(modelURIPattern)) continue;
            factory = f;
            priority = p;
        }
        return factory;
    }

    public Discovery newDiscovery() {
        return new Discovery();
    }

    public class Discovery {
        private Map<EPackage, MPAdapter> adapterMap = new HashMap<EPackage, MPAdapter>();

        private EPackage toEPackage(EObject target) {
            if (target == null) {
                return null;
            }
            EClass eCls = target.eClass();
            if (eCls == null) {
                return null;
            }
            return eCls.getEPackage();
        }

        private MPAdapter createAdapter(String nsURI, URI modelURI, MPAdapter parent) throws MPException {
            MPFactory factory = MPAdapterRegistry.this.search(nsURI, modelURI);
            if (factory == null) {
                return null;
            }
            MPAdapter a = factory.create(nsURI, modelURI, parent);
            return a;
        }

        public MPAdapter newAdapter(EPackage ePkg, String nsURI, URI modelURI, MPAdapter parent) throws MPException {
            MPAdapter a = this.createAdapter(nsURI, modelURI, parent);
            if (a == null) {
                return null;
            }
            this.adapterMap.put(ePkg, a);
            return a;
        }

        public MPAdapter newAdapter(EObject target, String nsURI, URI modelURI) throws MPException {
            EPackage ePkg = this.toEPackage(target);
            MPAdapter a = this.lookup(ePkg);
            return this.newAdapter(ePkg, nsURI, modelURI, a);
        }

        public MPAdapter newAdapter(EPackage ePkg, URI modelURI) throws MPException {
            MPAdapter a = this.lookup(ePkg);
            return this.newAdapter(ePkg, ePkg.getNsURI(), modelURI, a);
        }

        private EPackage registerAdapter(MPAdapter a, String nsURI) {
            EPackage.Registry reg = a.getPackageRegistry();
            EPackage ePkg = reg.getEPackage(nsURI);
            if (ePkg != null) {
                this.adapterMap.put(ePkg, a);
            }
            return ePkg;
        }

        public EPackage getEPackage(String nsURI, URI modelURI, MPAdapter parent) {
            MPAdapter a;
            block3: {
                try {
                    a = this.createAdapter(nsURI, modelURI, parent);
                    if (a != null) break block3;
                    return null;
                }
                catch (MPException e) {
                    return null;
                }
            }
            return this.registerAdapter(a, nsURI);
        }

        public MPAdapter lookup(EObject target) {
            EPackage ePkg = this.toEPackage(target);
            return this.lookup(ePkg);
        }

        public MPAdapter lookup(EPackage ePkg) {
            MPAdapter a = null;
            while (ePkg != null) {
                a = this.adapterMap.get(ePkg);
                if (a != null) {
                    return a;
                }
                ePkg = ePkg.getESuperPackage();
            }
            return this.adapterMap.get(null);
        }
    }
}

