/*
 * Decompiled with CFR 0.152.
 */
package com.nomagic.magicdraw.foundation.util;

import com.nomagic.magicdraw.foundation.util.ModelLockProvider;
import com.nomagic.magicdraw.foundation.util.Operation;
import com.nomagic.magicdraw.foundation.util.OperationTimeoutException;
import java.util.concurrent.locks.Lock;
import org.eclipse.emf.ecore.EObject;

public class AccessGuard {
    private AccessGuard() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T execute(EObject owner, Operation<T> operation) {
        ModelLockProvider lockProvider = ModelLockProvider.getInstance();
        if (lockProvider == null) return operation.call();
        Lock lock = lockProvider.getLock(owner);
        if (lock == null) return operation.call();
        try {
            if (!lock.tryLock(lockProvider.getTryLockTime(owner), lockProvider.getTimeUnit(owner))) throw new OperationTimeoutException();
            try {
                T t = operation.call();
                return t;
            }
            finally {
                lock.unlock();
            }
        }
        catch (InterruptedException interruptedException) {
            throw new OperationTimeoutException();
        }
    }
}

