/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.trinity.spreadsheet.excel.util;

import com.ibm.trinity.spreadsheet.excel.Comment;
import com.ibm.trinity.spreadsheet.excel.Range;
import com.ibm.trinity.spreadsheet.excel.Worksheet;
import com.ibm.trinity.spreadsheet.excel.util.CellAddress;
import com.ibm.trinity.spreadsheet.excel.util.RangeAddress;

public class WorksheetUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setNamedRange(Worksheet sheet, RangeAddress ra, String rangeName) {
        StringBuffer sb = new StringBuffer();
        sb.append('\'');
        sb.append(sheet.getName());
        sb.append("'!");
        sb.append(rangeName);
        String sheetRangeName = sb.toString();
        Range range = sheet.getRange(ra.getTopLeft().toA1(), ra.getBottomRight().toA1());
        try {
            range.setName(sheetRangeName);
        }
        finally {
            range.dispose();
        }
    }

    public static String getNamedRangeName(String ... items) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < items.length; ++i) {
            if (i > 0) {
                sb.append('_');
            }
            String item = items[i];
            sb.append(item);
        }
        return sb.toString().replaceAll("[^a-zA-Z0-9_]", "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean hasComment(Worksheet sheet, CellAddress cell, String prefix) {
        Range range = sheet.getRange(cell.toA1());
        try {
            Comment comment = range.getComment();
            if (comment == null) {
                boolean bl = false;
                return bl;
            }
            try {
                String c = comment.getText(null);
                if (prefix == null || c != null && c.startsWith(prefix)) {
                    boolean bl = true;
                    return bl;
                }
            }
            finally {
                comment.dispose();
            }
        }
        finally {
            range.dispose();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearComment(Worksheet sheet, CellAddress cell, String prefix) {
        Range range = sheet.getRange(cell.toA1());
        try {
            Comment comment = range.getComment();
            if (comment == null) {
                return;
            }
            boolean delete = false;
            try {
                String c = comment.getText(null);
                if (prefix == null || c != null && c.startsWith(prefix)) {
                    delete = true;
                }
            }
            finally {
                comment.dispose();
            }
            if (delete) {
                range.clearComments();
            }
        }
        finally {
            range.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setComment(Worksheet sheet, CellAddress cell, String prefix, String message, boolean append) {
        Range range = sheet.getRange(cell.toA1());
        try {
            Comment comment = range.getComment();
            try {
                boolean isNew = false;
                if (comment == null) {
                    comment = range.addComment();
                    isNew = true;
                }
                comment.setVisible(false);
                if (append && !isNew) {
                    String old = comment.getText(null);
                    comment.getText(new Object[]{old + "\n" + prefix + ": \n" + message});
                } else {
                    comment.getText(new Object[]{prefix + ": \n" + message});
                }
            }
            finally {
                if (comment != null) {
                    comment.dispose();
                }
            }
        }
        finally {
            range.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setID(Worksheet sheet, CellAddress cell, String idValue) {
        Range range = sheet.getRange(cell.toA1());
        try {
            range.setID(idValue);
        }
        finally {
            range.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getID(Worksheet sheet, CellAddress cell) {
        Range range = sheet.getRange(cell.toA1());
        try {
            String string = range.getID();
            return string;
        }
        finally {
            range.dispose();
        }
    }

    public static void clearWorksheetRange(Worksheet sheet, RangeAddress ra) {
        Range range = sheet.getRange(ra.getTopLeft().toA1(), ra.getBottomRight().toA1());
        try {
            range.clear();
        }
        finally {
            range.dispose();
        }
    }
}

