/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.trinity.spreadsheet.excel.util;

import com.ibm.trinity.spreadsheet.excel.util.RangeAddress;

public class WorksheetRangeAddress {
    private String worksheet;
    private RangeAddress range;

    public WorksheetRangeAddress(String s) {
        int idx;
        if (s == null || s.length() == 0) {
            throw new IllegalArgumentException(s);
        }
        if (s.charAt(0) == '=') {
            s = s.substring(1);
        }
        if ((idx = s.indexOf(33)) < 0) {
            throw new IllegalArgumentException(s);
        }
        this.worksheet = s.substring(0, idx);
        String ss = s.substring(idx + 1);
        try {
            this.range = new RangeAddress(ss);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(s);
        }
    }

    public String getWorksheet() {
        return this.worksheet;
    }

    public RangeAddress getRange() {
        return this.range;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.worksheet != null) {
            sb.append(this.worksheet);
            sb.append("!");
        }
        sb.append(this.range.toString());
        return sb.toString();
    }
}

