/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.trinity.spreadsheet.excel.util;

import com.ibm.trinity.spreadsheet.excel.util.RangeAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class RangeLiteral {
    public static final RangeLiteral MAX_ROW_RANGE = new RangeLiteral(1, 0, Integer.MAX_VALUE, Integer.MAX_VALUE);
    public static final RangeLiteral MAX_COLUMN_RANGE = new RangeLiteral(0, 1, Integer.MAX_VALUE, Integer.MAX_VALUE);
    public static final RangeLiteral MAX_ROW_COLUMN_RANGE = new RangeLiteral(1, 1, Integer.MAX_VALUE, Integer.MAX_VALUE);
    private static final int MAX_COLUMN_COUNT = 256;
    private static final int MAX_ROW_COUNT = 65536;
    private static final int NUM_ALPHA = 26;
    private static final int NUM_DIGIT = 10;
    private final int rowIndex;
    private final int rowCount;
    private final int columnIndex;
    private final int columnCount;
    private ArrayList<RangeLiteral> areas;

    public RangeLiteral(int rowIndex, int rowCount, int columnIndex, int columnCount) {
        this.rowIndex = rowIndex;
        this.rowCount = rowCount;
        this.columnIndex = columnIndex;
        this.columnCount = columnCount;
        this.areas = null;
    }

    public RangeLiteral(List<RangeLiteral> areas) {
        if (areas == null || areas.isEmpty()) {
            throw new IllegalArgumentException("Null or empty");
        }
        this.areas = new ArrayList<RangeLiteral>(areas);
        this.rowIndex = 0;
        this.rowCount = 0;
        this.columnIndex = 0;
        this.columnCount = 0;
    }

    public List<RangeLiteral> getAreas() {
        if (this.areas != null) {
            return Collections.unmodifiableList(this.areas);
        }
        return Collections.singletonList(this);
    }

    public int getAreasCount() {
        if (this.areas != null) {
            return this.areas.size();
        }
        return 1;
    }

    public boolean isRowRange() {
        if (this.areas != null) {
            return this.areas.get(0).isRowRange();
        }
        return this.columnIndex == 0;
    }

    public int getRow() {
        if (this.areas != null) {
            return this.areas.get(0).getRow();
        }
        return this.rowIndex > 0 ? this.rowIndex : 1;
    }

    public RangeLiteral getRows() {
        if (this.areas != null) {
            return this.areas.get(0).getRows();
        }
        return new RangeLiteral(this.rowIndex, this.rowCount, 0, 256);
    }

    public int getRowsCount() {
        if (this.areas != null) {
            return this.areas.get(0).getRowsCount();
        }
        return this.rowCount;
    }

    public int getRowEnd() {
        if (this.areas != null) {
            return this.areas.get(0).getRowEnd();
        }
        return this.getRow() + this.getRowsCount() - 1;
    }

    public boolean isColumnRange() {
        if (this.areas != null) {
            return this.areas.get(0).isColumnRange();
        }
        return this.rowIndex == 0;
    }

    public int getColumn() {
        if (this.areas != null) {
            return this.areas.get(0).getColumn();
        }
        return this.columnIndex > 0 ? this.columnIndex : 1;
    }

    public RangeLiteral getColumns() {
        if (this.areas != null) {
            return this.areas.get(0).getColumns();
        }
        return new RangeLiteral(0, 65536, this.columnIndex, this.columnCount);
    }

    public int getColumnsCount() {
        if (this.areas != null) {
            return this.areas.get(0).getColumnsCount();
        }
        return this.columnCount;
    }

    public int getColumnEnd() {
        if (this.areas != null) {
            return this.areas.get(0).getColumnEnd();
        }
        return this.getColumn() + this.getColumnsCount() - 1;
    }

    public RangeLiteral expand(int row, int column) {
        RangeLiteral result = new RangeLiteral(this.rowIndex, this.rowIndex != 0 ? this.rowCount + row : this.rowCount, this.columnIndex, this.columnIndex != 0 ? this.columnCount + column : this.columnCount);
        if (this.areas != null) {
            result.areas = new ArrayList(this.areas.size());
            for (RangeLiteral r : this.areas) {
                result.areas.add(r.expand(row, column));
            }
        }
        return result;
    }

    public RangeLiteral expandTo(int rowEnd, int columnEnd) {
        int numRow = 0;
        int numColumn = 0;
        if (rowEnd > 0 && rowEnd != this.getRowEnd() && (numRow = rowEnd - this.getRow() + 1) <= 0) {
            throw new RuntimeException("You are setting rowEnd " + rowEnd + " smaller than row start " + this.getRow() + ".");
        }
        if (columnEnd > 0 && columnEnd != this.getColumnEnd() && (numColumn = columnEnd - this.getColumn() + 1) <= 0) {
            throw new RuntimeException("You are setting columnEnd " + columnEnd + " smaller than column start " + this.getColumn() + ".");
        }
        if (numRow == 0 && numColumn == 0) {
            return this;
        }
        return new RangeLiteral(this.getRow(), numRow == 0 ? this.getRowsCount() : numRow, this.getColumn(), numColumn == 0 ? this.getColumnsCount() : numColumn);
    }

    public RangeLiteral offset(int row, int column) {
        RangeLiteral result = new RangeLiteral(this.rowIndex != 0 ? this.rowIndex + row : this.rowIndex, this.rowCount, this.columnIndex != 0 ? this.columnIndex + column : this.columnIndex, this.columnCount);
        if (this.areas != null) {
            result.areas = new ArrayList(this.areas.size());
            for (RangeLiteral r : this.areas) {
                result.areas.add(r.offset(row, column));
            }
        }
        return result;
    }

    public RangeLiteral offset(RangeLiteral offset) {
        return this.offset(offset.isColumnRange() ? 0 : offset.getRow() - 1, offset.isRowRange() ? 0 : offset.getColumn() - 1);
    }

    public RangeLiteral intersection(RangeLiteral other) {
        RangeLiteral result = this.internalIntersection(other);
        if (result != this && this.areas != null) {
            result.areas = new ArrayList(this.areas.size());
            for (RangeLiteral r : this.areas) {
                result.areas.add(r.intersection(other));
            }
        }
        return result;
    }

    private RangeLiteral internalIntersection(RangeLiteral other) {
        if (other == null) {
            return null;
        }
        if (other == this) {
            return this;
        }
        int rowIndex = this.rowIndex;
        int rowCount = this.rowCount;
        int columnIndex = this.columnIndex;
        int columnCount = this.columnCount;
        if (!other.isColumnRange()) {
            int rowEnd;
            if (this.isColumnRange()) {
                rowIndex = other.getRow();
                rowEnd = other.getRowEnd();
            } else {
                rowIndex = Math.max(this.getRow(), other.getRow());
                rowEnd = Math.min(this.getRowEnd(), other.getRowEnd());
            }
            rowCount = rowEnd - rowIndex + 1;
            if (rowCount <= 0) {
                return null;
            }
        }
        if (!other.isRowRange()) {
            int columnEnd;
            if (this.isRowRange()) {
                columnIndex = other.getColumn();
                columnEnd = other.getColumnEnd();
            } else {
                columnIndex = Math.max(this.getColumn(), other.getColumn());
                columnEnd = Math.min(this.getColumnEnd(), other.getColumnEnd());
            }
            columnCount = columnEnd - columnIndex + 1;
            if (columnCount <= 0) {
                return null;
            }
        }
        return new RangeLiteral(rowIndex, rowCount, columnIndex, columnCount);
    }

    public RangeLiteral transpose() {
        RangeLiteral result = new RangeLiteral(this.columnIndex, this.columnCount, this.rowIndex, this.rowCount);
        if (this.areas != null) {
            result.areas = new ArrayList(this.areas.size());
            for (RangeLiteral r : this.areas) {
                result.areas.add(r.transpose());
            }
        }
        return result;
    }

    public boolean isRCRange(boolean row) {
        return row ? this.isRowRange() : this.isColumnRange();
    }

    public int getRC(boolean row) {
        return row ? this.getRow() : this.getColumn();
    }

    public RangeLiteral getRCs(boolean row) {
        return row ? this.getRows() : this.getColumns();
    }

    public int getRCCount(boolean row) {
        return row ? this.getRowsCount() : this.getColumnsCount();
    }

    public int getRCEnd(boolean row) {
        return row ? this.getRowEnd() : this.getColumnEnd();
    }

    public RangeLiteral expandRC(boolean row, int count) {
        return row ? this.expand(count, 0) : this.expand(0, count);
    }

    public RangeLiteral offsetRC(boolean row, int count) {
        return row ? this.offset(count, 0) : this.offset(0, count);
    }

    public int hashCode() {
        if (this.areas != null) {
            return this.areas.hashCode();
        }
        return this.rowIndex * (37 * (this.rowCount + 83)) << 16 + this.columnIndex * (37 * (this.columnCount + 83));
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof RangeLiteral)) {
            return false;
        }
        RangeLiteral other = (RangeLiteral)obj;
        if (this.areas != null) {
            return other.areas == null ? false : this.areas.equals(other.areas);
        }
        return this.rowIndex == other.rowIndex && this.rowCount == other.rowCount && this.columnIndex == other.columnIndex && this.columnCount == other.columnCount;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(15);
        this.appendRange(sb);
        return sb.toString();
    }

    private void appendRange(StringBuilder sb) {
        if (this.areas != null) {
            for (RangeLiteral area : this.areas) {
                if (sb.length() > 0) {
                    sb.append(',');
                }
                area.appendRange(sb);
            }
        } else if (this.isRowRange()) {
            this.appendNumber(sb, this.rowIndex);
            sb.append(':');
            this.appendNumber(sb, this.rowIndex + this.rowCount - 1);
        } else if (this.isColumnRange()) {
            this.appendAlpha(sb, this.columnIndex);
            sb.append(':');
            this.appendAlpha(sb, this.columnIndex + this.columnCount - 1);
        } else {
            this.appendAlpha(sb, this.columnIndex);
            this.appendNumber(sb, this.rowIndex);
            if (this.getRowsCount() > 1 || this.getColumnsCount() > 1) {
                sb.append(':');
                this.appendAlpha(sb, this.columnIndex + this.columnCount - 1);
                this.appendNumber(sb, this.rowIndex + this.rowCount - 1);
            }
        }
    }

    private void appendAlpha(StringBuilder sb, int i) {
        this.appendAlphaCore(sb, i - 1);
    }

    private void appendAlphaCore(StringBuilder sb, int i) {
        int j = i / 26;
        if (j >= 1) {
            this.appendAlpha(sb, j);
        }
        sb.append((char)(65 + i % 26));
    }

    private void appendNumber(StringBuilder sb, int i) {
        sb.append(Integer.toString(i));
    }

    public static RangeLiteral parse(String range) {
        range = (String)range + ",";
        RangeLiteral result = null;
        int start = 0;
        int index = ((String)range).indexOf(44);
        do {
            RangeLiteral r = RangeLiteral.parseCore((String)range, start, index);
            if (result == null) {
                result = r;
                continue;
            }
            if (result.areas == null) {
                RangeLiteral clone = result.offset(0, 0);
                result.areas = new ArrayList(2);
                result.areas.add(clone);
            }
            result.areas.add(r);
        } while ((index = ((String)range).indexOf(44, start = index + 1)) != -1);
        return result;
    }

    private static RangeLiteral parseCore(String range, int start, int end) {
        int c = 0;
        int index = start;
        int fromColumnIndex = 0;
        int fromRowIndex = 0;
        int columnIndex = 0;
        int rowIndex = 0;
        try {
            int tmp;
            for (int count = 0; count == 0 || count == 1 && c == 58; ++count) {
                columnIndex = 0;
                rowIndex = 0;
                if ((c = (int)range.charAt(index++)) == 36) {
                    c = range.charAt(index++);
                }
                while (65 <= c && c <= 90) {
                    columnIndex = columnIndex * 26 + (c - 65 + 1);
                    c = range.charAt(index++);
                }
                if (c == 36) {
                    c = range.charAt(index++);
                }
                while (48 <= c && c <= 57) {
                    rowIndex = rowIndex * 10 + (c - 48);
                    c = range.charAt(index++);
                }
                if (c != 58 && c != 44 || rowIndex == 0 && columnIndex == 0) {
                    throw new RuntimeException("Bad range literal \"" + range.substring(start, end) + "\" in " + range);
                }
                if (count != 0) continue;
                fromColumnIndex = columnIndex;
                fromRowIndex = rowIndex;
            }
            if (fromColumnIndex > columnIndex) {
                tmp = columnIndex;
                columnIndex = fromColumnIndex;
                fromColumnIndex = tmp;
            }
            if (fromRowIndex > rowIndex) {
                tmp = rowIndex;
                rowIndex = fromRowIndex;
                fromRowIndex = tmp;
            }
            if (columnIndex == 0 && fromColumnIndex == 0) {
                return new RangeLiteral(fromRowIndex, rowIndex - fromRowIndex + 1, 0, 256);
            }
            if (rowIndex == 0 && fromRowIndex == 0) {
                return new RangeLiteral(0, 65536, fromColumnIndex, columnIndex - fromColumnIndex + 1);
            }
            return new RangeLiteral(fromRowIndex, rowIndex - fromRowIndex + 1, fromColumnIndex, columnIndex - fromColumnIndex + 1);
        }
        catch (IndexOutOfBoundsException e) {
            throw new RuntimeException("Bad range literal \"" + range.substring(start, end) + "\" in " + range);
        }
    }

    public static RangeLiteral create(RangeAddress ra) {
        return new RangeLiteral(ra.getTopLeft().getRow(), ra.getHeight(), ra.getTopLeft().getCol(), ra.getWidth());
    }

    public static RangeLiteral create(List<RangeAddress> areas) {
        if (areas == null || areas.isEmpty()) {
            throw new IllegalArgumentException("Null or empty");
        }
        if (areas.size() == 1) {
            return RangeLiteral.create(areas.get(0));
        }
        ArrayList<RangeLiteral> literals = new ArrayList<RangeLiteral>(areas.size());
        for (RangeAddress rangeAddress : areas) {
            literals.add(RangeLiteral.create(rangeAddress));
        }
        return new RangeLiteral(literals);
    }

    public static RangeLiteral create(List<RangeLiteral> areas, boolean dummy) {
        if (areas == null || areas.isEmpty()) {
            throw new IllegalArgumentException("Null or empty");
        }
        if (areas.size() == 1) {
            return areas.get(0);
        }
        return new RangeLiteral(areas);
    }

    public RangeAddress toRangeAddress() {
        return new RangeAddress(this.getRow(), this.getColumn(), this.getRowsCount(), this.getColumnsCount());
    }
}

