/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.trinity.spreadsheet.excel.util;

import com.ibm.accessibility.com.win32.DispatchException;
import com.ibm.trinity.spreadsheet.excel.Range;
import com.ibm.trinity.spreadsheet.excel.util.Address;
import com.ibm.trinity.spreadsheet.excel.util.CellAddress;

public final class RangeAddress
implements Address {
    private final CellAddress topLeft;
    private final int height;
    private final int width;
    public static final RangeAddress NULL_RANGE = new RangeAddress(0, 0, 0, 0, false);

    public RangeAddress(int top, int left, int height, int width) {
        this(top, left, height, width, true);
    }

    public RangeAddress(CellAddress topLeft, int height, int width) {
        this(topLeft, height, width, true);
    }

    public RangeAddress(CellAddress topLeft) {
        this(topLeft, 1, 1, true);
    }

    public RangeAddress(CellAddress topLeft, CellAddress bottomRight) {
        this(topLeft, bottomRight.getRow() - topLeft.getRow() + 1, bottomRight.getCol() - topLeft.getCol() + 1);
    }

    RangeAddress(int top, int left, int height, int width, boolean validate) {
        this(new CellAddress(top, left, validate), height, width, validate);
    }

    RangeAddress(CellAddress topLeft, int height, int width, boolean validate) {
        if (validate && (height <= 0 || width <= 0)) {
            throw new IllegalArgumentException();
        }
        this.topLeft = topLeft;
        this.height = height;
        this.width = width;
    }

    public RangeAddress(String s) {
        int idx;
        if (s == null || s.length() == 0) {
            throw new IllegalArgumentException(s);
        }
        if (s.charAt(0) == '!') {
            s = s.substring(1);
        }
        if ((idx = s.indexOf(58)) > 0) {
            String s1 = s.substring(0, idx);
            String s2 = s.substring(idx + 1);
            try {
                this.topLeft = CellAddress.newCellAddress(s1);
                CellAddress bottomRight = CellAddress.newCellAddress(s2);
                this.height = bottomRight.getRow() - this.topLeft.getRow() + 1;
                this.width = bottomRight.getCol() - this.topLeft.getCol() + 1;
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException(s);
            }
        } else {
            this.topLeft = CellAddress.newCellAddress(s);
            this.height = 1;
            this.width = 1;
        }
    }

    public static RangeAddress newRangeAddress(Range range) {
        int height;
        int row = range.getRow();
        int col = range.getColumn();
        Range cols = range.getColumns();
        int width = cols.getCount();
        cols.dispose();
        try {
            height = range.getCount() / width;
        }
        catch (DispatchException e) {
            Range rows = range.getRows();
            height = rows.getCount();
        }
        return new RangeAddress(row, col, height, width);
    }

    public CellAddress getTopLeft() {
        return this.topLeft;
    }

    public CellAddress getBottomRight() {
        return this.topLeft.getRelativeCell(this.height - 1, this.width - 1);
    }

    public CellAddress getTopRight() {
        return this.topLeft.getRelativeCell(0, this.width - 1);
    }

    public CellAddress getBottomLeft() {
        return this.topLeft.getRelativeCell(this.height - 1, 0);
    }

    public RangeAddress getRow(int rowOffset) {
        if (rowOffset > this.height) {
            throw new IllegalArgumentException("" + rowOffset);
        }
        int r = this.topLeft.getRow() + rowOffset;
        return new RangeAddress(r, this.topLeft.getCol(), 1, this.width);
    }

    public int getRow() {
        return this.getTopLeft().getRow();
    }

    public int getRowEnd() {
        return this.getRow() + this.getHeight() - 1;
    }

    public RangeAddress getCol(int colOffset) {
        if (colOffset > this.width) {
            throw new IllegalArgumentException("" + colOffset);
        }
        int c = this.topLeft.getCol() + colOffset;
        return new RangeAddress(this.topLeft.getRow(), c, this.height, 1);
    }

    public int getCol() {
        return this.getTopLeft().getCol();
    }

    public int getColEnd() {
        return this.getCol() + this.getWidth() - 1;
    }

    public int getRCEnd(boolean row) {
        return row ? this.getRowEnd() : this.getColEnd();
    }

    public RangeAddress move(int top, int left) {
        return new RangeAddress(top, left, this.width, this.height);
    }

    public RangeAddress offset(int rowOffset, int columnOffset, RangeAddress within) {
        int newRow = this.getRow() + rowOffset;
        int newCol = this.getCol() + columnOffset;
        RangeAddress result = new RangeAddress(newRow, newCol, this.getHeight(), this.getWidth(), false);
        if (within != null) {
            result = result.intersection(within);
        }
        return result;
    }

    public RangeAddress offsetRC(boolean row, int offset, RangeAddress within) {
        if (row) {
            return this.offset(offset, 0, within);
        }
        return this.offset(0, offset, within);
    }

    public RangeAddress expand(int rowDelta, int columnDelta, RangeAddress within) {
        int newRowCount = this.getHeight() + rowDelta;
        int newColumnCount = this.getWidth() + columnDelta;
        if (newRowCount <= 0 || newColumnCount <= 0) {
            return NULL_RANGE;
        }
        RangeAddress result = new RangeAddress(this.getTopLeft(), newRowCount, newColumnCount, false);
        if (within != null) {
            result = result.intersection(within);
        }
        return result;
    }

    public RangeAddress expandRC(boolean row, int delta, RangeAddress within) {
        if (row) {
            return this.expand(delta, 0, within);
        }
        return this.expand(0, delta, within);
    }

    public int getWidth() {
        return this.width;
    }

    public int getColCount() {
        return this.getWidth();
    }

    public int getHeight() {
        return this.height;
    }

    public int getRowCount() {
        return this.getHeight();
    }

    public int getRCCount(boolean row) {
        return row ? this.getHeight() : this.getWidth();
    }

    public int hashCode() {
        if (this.isNullRange()) {
            return 0;
        }
        int code = this.topLeft == null ? 0 : this.topLeft.hashCode();
        code = code * 17 + (this.height + 37);
        code = code * 17 + (this.width + 37);
        return code;
    }

    public boolean equals(Object o) {
        if (!(o instanceof RangeAddress)) {
            return false;
        }
        RangeAddress r = (RangeAddress)o;
        return this.isNullRange() && r.isNullRange() || this.topLeft.equals(r.topLeft) && this.width == r.width && this.height == r.height;
    }

    public boolean contains(CellAddress cell) {
        int row = cell.getRow();
        int col = cell.getCol();
        return this.contains(row, col);
    }

    public boolean contains(int row, int col) {
        int myRow = this.topLeft.getRow();
        int myCol = this.topLeft.getCol();
        return row >= myRow && row < myRow + this.height && col >= myCol && col < myCol + this.width;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append('[');
        sb.append(this.getTopLeft().toString());
        sb.append("..");
        sb.append(this.getBottomRight().toString());
        sb.append(']');
        return sb.toString();
    }

    public RangeAddress transpose() {
        return new RangeAddress(this.getTopLeft().transpose(), this.width, this.height);
    }

    public RangeAddress intersection(RangeAddress r) {
        if (r == null || r.isNullRange() || this.isNullRange()) {
            return NULL_RANGE;
        }
        int row = Math.max(this.getRow(), r.getRow());
        int col = Math.max(this.getCol(), r.getCol());
        int rowEnd = Math.min(this.getRowEnd(), r.getRowEnd());
        int colEnd = Math.min(this.getColEnd(), r.getColEnd());
        int height = rowEnd - row + 1;
        int width = colEnd - col + 1;
        if (height <= 0 || width <= 0) {
            return NULL_RANGE;
        }
        return new RangeAddress(row, col, height, width);
    }

    public boolean hasIntersection(RangeAddress r) {
        if (r == null || r.isNullRange() || this.isNullRange()) {
            return false;
        }
        int row = Math.max(this.topLeft.getRow(), r.getTopLeft().getRow());
        int col = Math.max(this.topLeft.getCol(), r.getTopLeft().getCol());
        int rowEnd = Math.min(this.getRowEnd(), r.getRowEnd());
        int colEnd = Math.min(this.getColEnd(), r.getColEnd());
        int height = rowEnd - row + 1;
        int width = colEnd - col + 1;
        return height > 0 && width > 0;
    }

    public RangeAddress union(RangeAddress r) {
        if (r == null || r.isNullRange()) {
            return this;
        }
        if (this.isNullRange()) {
            return r;
        }
        int row = Math.min(this.topLeft.getRow(), r.getTopLeft().getRow());
        int col = Math.min(this.topLeft.getCol(), r.getTopLeft().getCol());
        int rowEnd = Math.max(this.getRowEnd(), r.getRowEnd());
        int colEnd = Math.max(this.getColEnd(), r.getColEnd());
        int height = rowEnd - row + 1;
        int width = colEnd - col + 1;
        if (height <= 0 || width <= 0) {
            return NULL_RANGE;
        }
        return new RangeAddress(row, col, height, width);
    }

    public RangeAddress union(CellAddress r) {
        if (r == null) {
            return this;
        }
        if (this.isNullRange()) {
            return new RangeAddress(r, 1, 1);
        }
        int row = Math.min(this.topLeft.getRow(), r.getRow());
        int col = Math.min(this.topLeft.getCol(), r.getCol());
        int rowEnd = Math.max(this.getRowEnd(), r.getRow());
        int colEnd = Math.max(this.getColEnd(), r.getCol());
        int height = rowEnd - row + 1;
        int width = colEnd - col + 1;
        if (height <= 0 || width <= 0) {
            return NULL_RANGE;
        }
        return new RangeAddress(row, col, height, width);
    }

    public boolean isNullRange() {
        return this.width <= 0 || this.height <= 0;
    }
}

