/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.trinity.spreadsheet.excel.util;

import com.ibm.trinity.spreadsheet.excel.util.Address;
import com.ibm.trinity.spreadsheet.excel.util.RangeAddress;

public class CellAddress
implements Address {
    private final int row;
    private final int col;
    private static final int NUM_ALPHABETS = 26;

    public static CellAddress newCellAddress(String s) {
        if (s == null || s.length() < 1) {
            throw new IllegalArgumentException(s);
        }
        char c0 = s.charAt(0);
        switch (c0) {
            case 'R': {
                return CellAddress.initR1C1(s);
            }
            case '$': {
                return CellAddress.initAbsoluteA1(s);
            }
        }
        return CellAddress.initRelativeA1(s);
    }

    private static CellAddress initR1C1(String s) {
        int idx = s.indexOf(67);
        if (idx < 0) {
            throw new IllegalArgumentException(s);
        }
        String r = s.substring(1, idx);
        String c = s.substring(idx + 1);
        try {
            int row = Integer.parseInt(r);
            int col = Integer.parseInt(c);
            return new CellAddress(row, col);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(s);
        }
    }

    private static int parseAFormat(String c) {
        int col;
        block3: {
            char ch;
            int len = c.length();
            if (len <= 0) {
                throw new IllegalArgumentException(c);
            }
            col = 0;
            int i = 0;
            while ((ch = c.charAt(i)) >= 'A' || ch <= 'Z') {
                col += ch - 65;
                if (++i < len) {
                    col *= 26;
                    continue;
                }
                break block3;
            }
            throw new IllegalArgumentException(c);
        }
        return col;
    }

    private static CellAddress initAbsoluteA1(String s) {
        int idx = s.indexOf(36, 1);
        if (idx < 0) {
            throw new IllegalArgumentException("Relative A1 format is not supported yet: " + s);
        }
        String c = s.substring(1, idx);
        String r = s.substring(idx + 1);
        try {
            int row = Integer.parseInt(r);
            int col = CellAddress.parseAFormat(c);
            return new CellAddress(row, col);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(s);
        }
    }

    private static CellAddress initRelativeA1(String s) {
        throw new IllegalArgumentException("Relative A1 format is not supported yet: " + s);
    }

    public CellAddress(int row, int col) {
        this(row, col, true);
    }

    protected CellAddress(CellAddress orig) {
        this.row = orig.row;
        this.col = orig.col;
    }

    CellAddress(int row, int col, boolean validate) {
        if (validate && (row <= 0 || col <= 0)) {
            throw new IllegalArgumentException("row=" + row + ", col=" + col);
        }
        this.row = row;
        this.col = col;
    }

    public int getRow() {
        return this.row;
    }

    public int getCol() {
        return this.col;
    }

    public CellAddress getRelativeCell(int rowDiff, int colDiff) {
        return new CellAddress(this.row + rowDiff, this.col + colDiff);
    }

    public int hashCode() {
        int code = 37;
        code = code * 17 + this.row + 37;
        code = code * 17 + this.col + 37;
        return code;
    }

    public boolean equals(Object o) {
        if (!(o instanceof CellAddress)) {
            return false;
        }
        CellAddress addr = (CellAddress)o;
        return this.row == addr.row && this.col == addr.col;
    }

    public String toString() {
        return this.toA1();
    }

    public String toR1C1() {
        StringBuffer sb = new StringBuffer();
        sb.append('R');
        sb.append(Integer.toString(this.row));
        sb.append('C');
        sb.append(Integer.toString(this.col));
        return sb.toString();
    }

    public String toA1() {
        StringBuffer sb = new StringBuffer();
        this.appendColumnLabel(sb, this.col);
        sb.append(this.row);
        return sb.toString();
    }

    public RangeAddress toRange() {
        return new RangeAddress(this);
    }

    private void appendColumnLabel(StringBuffer sb, int col) {
        int r = --col % 26;
        if ((col /= 26) > 0) {
            this.appendColumnLabel(sb, col);
        }
        sb.append((char)(65 + r));
    }

    public CellAddress transpose() {
        return new CellAddress(this.col, this.row, false);
    }

    public CellAddress transposeIf(boolean cond) {
        return cond ? this.transpose() : this;
    }

    public CellAddress up() {
        return new CellAddress(this.row - 1, this.col);
    }

    public CellAddress down() {
        return new CellAddress(this.row + 1, this.col);
    }

    public CellAddress right() {
        return new CellAddress(this.row, this.col + 1);
    }

    public CellAddress left() {
        return new CellAddress(this.row, this.col - 1);
    }
}

