/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.trinity.spreadsheet.excel.impl;

import com.ibm.trinity.spreadsheet.excel.Range;
import com.ibm.trinity.spreadsheet.excel.Worksheet;
import com.ibm.trinity.spreadsheet.excel.XLEventManager;
import com.ibm.trinity.spreadsheet.excel.event.XLEventListener;
import com.ibm.trinity.spreadsheet.excel.impl.XLControllerImpl;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.swt.ole.win32.OleAutomation;
import org.eclipse.swt.ole.win32.OleControlSite;
import org.eclipse.swt.ole.win32.OleEvent;
import org.eclipse.swt.ole.win32.OleListener;
import org.eclipse.swt.ole.win32.Variant;

public class XLEventManagerImpl
implements XLEventManager {
    private final OleControlSite controlSite;
    private final OleAutomation automation;
    private final ListenerList _listeners = new ListenerList();
    private final OleListener oleListener = new OleListenerImpl();

    XLEventManagerImpl(OleControlSite controlSite, OleAutomation automation) {
        this.controlSite = controlSite;
        this.automation = automation;
        controlSite.addEventListener(automation, "{00024413-0000-0000-C000-000000000046}", 1563, this.oleListener);
        controlSite.addEventListener(automation, "{00024413-0000-0000-C000-000000000046}", 1564, this.oleListener);
        controlSite.addEventListener(automation, "{00024413-0000-0000-C000-000000000046}", 1558, this.oleListener);
    }

    @Override
    public void dispose() {
        if (!this.controlSite.isDisposed()) {
            this.controlSite.removeEventListener(this.automation, 1563, this.oleListener);
            this.controlSite.removeEventListener(this.automation, 1564, this.oleListener);
            this.controlSite.removeEventListener(this.automation, 1558, this.oleListener);
        }
    }

    @Override
    public void addXlEventListener(XLEventListener listener) {
        this._listeners.add((Object)listener);
    }

    @Override
    public void removeXlEventListener(XLEventListener listener) {
        this._listeners.remove((Object)listener);
    }

    class OleListenerImpl
    implements OleListener {
        OleListenerImpl() {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void handleEvent(OleEvent e) {
            try {
                Object[] listeners = XLEventManagerImpl.this._listeners.getListeners();
                switch (e.type) {
                    case 1563: {
                        if (listeners == null) return;
                        assert (e.arguments.length == 1);
                        Worksheet worksheet = XLControllerImpl.getWorksheet(e.arguments[0].getDispatch().getAddress());
                        worksheet.unmanage();
                        int i = 0;
                        while (i < listeners.length) {
                            ((XLEventListener)listeners[i]).worksheetCalculate(worksheet);
                            ++i;
                        }
                        return;
                    }
                    case 1564: {
                        if (listeners == null) return;
                        assert (e.arguments.length == 2);
                        Range range = XLControllerImpl.getRange(e.arguments[0].getDispatch().getAddress());
                        range.unmanage();
                        Worksheet worksheet = XLControllerImpl.getWorksheet(e.arguments[1].getDispatch().getAddress());
                        worksheet.unmanage();
                        int i = 0;
                        while (i < listeners.length) {
                            ((XLEventListener)listeners[i]).worksheetChange(worksheet, range);
                            ++i;
                        }
                        return;
                    }
                    case 1558: {
                        if (listeners == null) return;
                        assert (e.arguments.length == 2);
                        Range range = XLControllerImpl.getRange(e.arguments[0].getDispatch().getAddress());
                        range.unmanage();
                        Worksheet worksheet = XLControllerImpl.getWorksheet(e.arguments[1].getDispatch().getAddress());
                        worksheet.unmanage();
                        int i = 0;
                        while (i < listeners.length) {
                            ((XLEventListener)listeners[i]).worksheetSelectionChange(worksheet, range);
                            ++i;
                        }
                        return;
                    }
                }
                return;
            }
            catch (RuntimeException re) {
                re.printStackTrace();
                throw re;
            }
            finally {
                if (e != null && e.arguments != null) {
                    for (Variant v : e.arguments) {
                        try {
                            v.dispose();
                        }
                        catch (Exception exception) {}
                    }
                }
            }
        }
    }
}

