/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.trinity.spreadsheet.excel.impl;

import com.ibm.accessibility.com.win32.DispatchException;
import com.ibm.accessibility.com.win32.IDispatch;
import com.ibm.accessibility.com.win32.Missing;
import com.ibm.trinity.spreadsheet.excel.Application;
import com.ibm.trinity.spreadsheet.excel.AutoFilter;
import com.ibm.trinity.spreadsheet.excel.Name;
import com.ibm.trinity.spreadsheet.excel.OLEObject;
import com.ibm.trinity.spreadsheet.excel.Range;
import com.ibm.trinity.spreadsheet.excel.Worksheet;
import com.ibm.trinity.spreadsheet.excel.impl.ApplicationImpl;
import com.ibm.trinity.spreadsheet.excel.impl.AutoFilterImpl;
import com.ibm.trinity.spreadsheet.excel.impl.CommentImpl;
import com.ibm.trinity.spreadsheet.excel.impl.CommentsImpl;
import com.ibm.trinity.spreadsheet.excel.impl.IDispatchWrapperImpl;
import com.ibm.trinity.spreadsheet.excel.impl.NameImpl;
import com.ibm.trinity.spreadsheet.excel.impl.NamesImpl;
import com.ibm.trinity.spreadsheet.excel.impl.OLEObjectImpl;
import com.ibm.trinity.spreadsheet.excel.impl.RangeImpl;
import com.ibm.trinity.spreadsheet.excel.impl.WorkbookImpl;
import com.ibm.trinity.spreadsheet.excel.util.CellAddress;
import com.ibm.trinity.spreadsheet.excel.util.RangeAddress;
import com.ibm.trinity.spreadsheet.excel.util.RangeLiteral;
import com.ibm.trinity.spreadsheet.excel.util.WorksheetRangeAddress;
import java.util.Arrays;
import java.util.List;

public class WorksheetImpl
extends IDispatchWrapperImpl
implements Worksheet {
    private static final String FORMULA = "Formula";
    private static final String MACRO_GET_REFERS_TO_R1C1 = "Trinity.GetRefersToR1C1";
    private static final String MACRO_SET_RANGE_NAME = "Trinity.SetRangeName";
    private static final String MACRO_GET_CELL_IDS = "Trinity.GetCellIDs";
    private static final String MACRO_SET_CELL_IDS = "Trinity.SetCellIDs";
    private static final String MACRO_CLEAR_CELLS = "Trinity.ClearCells";
    private static final String MACRO_SET_CELL_VALUES = "Trinity.SetCellValues";
    private static final String MACRO_GET_MATRIX_CELL_IDS = "Trinity.GetMatrixCellIDs";
    private static final String MACRO_SET_RANGE_CELL_FORMAT = "Trinity.SetRangeCellFormat";
    private static final int MAX_CELL_CHUNK_SIZE = Short.MAX_VALUE;

    WorksheetImpl(IDispatch iWorksheet) {
        super(iWorksheet);
    }

    @Override
    public RangeImpl getRange(String cell1) {
        if (cell1 == null) {
            throw new IllegalArgumentException("Null");
        }
        Object[] obj = new Object[]{cell1};
        IDispatch o = (IDispatch)this.idispatch.get("Range", obj);
        return o == null ? null : new RangeImpl(o);
    }

    @Override
    public RangeImpl getRange(String cell1, String cell2) {
        if (cell1 == null) {
            throw new IllegalArgumentException("Null");
        }
        Object[] obj = new Object[]{cell1, cell2 == null ? Missing.VALUE : cell2};
        IDispatch o = (IDispatch)this.idispatch.get("Range", obj);
        return o == null ? null : new RangeImpl(o);
    }

    @Override
    public RangeImpl getRange(Name name) {
        if (name == null) {
            throw new IllegalArgumentException("Null");
        }
        return new RangeImpl((IDispatch)this.idispatch.get("Range", new Object[]{((NameImpl)name).getIDispatch()}));
    }

    @Override
    public RangeImpl getRange(RangeAddress address) {
        return this.getRange(address.getTopLeft().toA1(), address.getBottomRight().toA1());
    }

    @Override
    public RangeImpl getRows() {
        IDispatch o = (IDispatch)this.idispatch.get("Rows");
        return o == null ? null : new RangeImpl(o);
    }

    @Override
    public RangeImpl getColumns() {
        IDispatch o = (IDispatch)this.idispatch.get("Columns");
        return o == null ? null : new RangeImpl(o);
    }

    @Override
    public RangeImpl getCells() {
        IDispatch o = (IDispatch)this.idispatch.get("Cells");
        return o == null ? null : new RangeImpl(o);
    }

    @Override
    public RangeImpl getCells(int row, int col) {
        Object[] obj = new Object[]{row, col};
        IDispatch o = (IDispatch)this.idispatch.get("Cells", obj);
        return o == null ? null : new RangeImpl(o);
    }

    @Override
    public Range getCells(CellAddress cellAddress) {
        return this.getCells(cellAddress.getRow(), cellAddress.getCol());
    }

    @Override
    public String getName() {
        return (String)this.idispatch.get("Name");
    }

    @Override
    public void setName(String name) {
        WorksheetImpl.makeDirty();
        if (name == null) {
            throw new IllegalArgumentException("Null");
        }
        this.idispatch.put("Name", (Object)name);
    }

    @Override
    public NamesImpl getNames() {
        IDispatch o = (IDispatch)this.idispatch.get("Names");
        return o == null ? null : new NamesImpl(o);
    }

    @Override
    public void setNames(String name) {
        WorksheetImpl.makeDirty();
        if (name == null) {
            throw new IllegalArgumentException("Null");
        }
        this.idispatch.put("Names", (Object)name);
    }

    @Override
    public CommentsImpl getComments() {
        IDispatch o = (IDispatch)this.idispatch.get("Comments");
        return o == null ? null : new CommentsImpl(o);
    }

    @Override
    public CommentImpl getComment(RangeAddress address) {
        if (address == null) {
            throw new IllegalArgumentException("Null");
        }
        return this.getComment(address.getTopLeft().getRow(), address.getTopLeft().getCol());
    }

    @Override
    public CommentImpl getComment(int row, int col) {
        RangeImpl range = this.getCells(row, col);
        return range.getComment();
    }

    @Override
    public boolean isVisible() {
        Boolean b = (Boolean)this.idispatch.get("Visible");
        return b;
    }

    @Override
    public void setVisible(boolean visible) {
        this.idispatch.put("Visible", (Object)new Boolean(visible));
    }

    @Override
    public Object getCellValue(CellAddress address) {
        return this.getCellProp(address, "Value");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getCellProp(CellAddress address, String prop) {
        if (address == null) {
            throw new IllegalArgumentException("Null");
        }
        RangeImpl c = this.getCells(address.getRow(), address.getCol());
        try {
            Object object = c.getProp(prop);
            return object;
        }
        finally {
            c.dispose();
        }
    }

    @Override
    public void setCellValue(CellAddress address, Object value) {
        this.setCellProp(address, "Value", value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setCellProp(CellAddress address, String prop, Object value) {
        if (address == null) {
            throw new IllegalArgumentException("Null");
        }
        RangeImpl c = this.getCells(address.getRow(), address.getCol());
        try {
            c.setProp(prop, value);
        }
        finally {
            c.dispose();
        }
    }

    @Override
    public Object[][] getRangeValue(RangeAddress address) {
        return this.getRangeProp(address, "Value");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object[][] getRangeProp(RangeAddress address, String prop) {
        if (address == null) {
            throw new IllegalArgumentException("Null");
        }
        if (!address.isNullRange()) {
            if (address.getColCount() == 1 && address.getRowCount() == 1) {
                Object value = this.getCellProp(address.getTopLeft(), prop);
                Object[] r2 = new Object[]{value};
                Object[][] result = new Object[][]{r2};
                return result;
            }
            RangeImpl r = this.getRange(address.getTopLeft().toA1(), address.getBottomRight().toA1());
            try {
                Object[][] r2 = r.getPropAsArray(prop);
                return r2;
            }
            finally {
                r.dispose();
            }
        }
        Object[] r = new Object[]{null};
        Object[][] result = new Object[][]{r};
        return result;
    }

    @Override
    public void setRangeValue(RangeAddress address, Object[][] data) {
        this.setRangeProp(address, "Value", data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setRangeProp(RangeAddress address, String prop, Object[][] data) {
        if (address == null) {
            throw new IllegalArgumentException("Null");
        }
        if (!address.isNullRange()) {
            if (address.getColCount() == 1 && address.getRowCount() == 1) {
                this.setCellProp(address.getTopLeft(), prop, data == null ? null : data[0][0]);
            } else {
                RangeImpl r = this.getRange(address.getTopLeft().toA1(), address.getBottomRight().toA1());
                try {
                    r.setProp(prop, data);
                }
                finally {
                    r.dispose();
                }
            }
        }
    }

    @Override
    public void setRangeValue(RangeLiteral literal, Object data) {
        this.setRangeProp(literal, "Value", data);
    }

    protected void setRangeProp(RangeLiteral literal, final String prop, final Object data) {
        this.runWithRange(literal, new Worksheet.RunnableWithRange(){

            @Override
            public void run(Range range) {
                ((RangeImpl)range).setProp(prop, data);
            }
        });
    }

    @Override
    public void activate() {
        this.idispatch.invoke0("Activate");
    }

    @Override
    public ApplicationImpl getApplication() {
        IDispatch o = (IDispatch)this.idispatch.get("Application");
        return o == null ? null : new ApplicationImpl(o);
    }

    @Override
    public WorkbookImpl getParentAsWorkbook() {
        IDispatch o = (IDispatch)this.idispatch.get("Parent");
        return o == null ? null : new WorkbookImpl(o);
    }

    @Override
    public Object getCellFormula(CellAddress address) {
        return this.getCellProp(address, FORMULA);
    }

    @Override
    public Object[][] getRangeFormula(RangeAddress address) {
        return this.getRangeProp(address, FORMULA);
    }

    @Override
    public void setCellFormula(CellAddress address, Object formula) {
        this.setCellProp(address, FORMULA, formula);
    }

    @Override
    public void setRangeFormula(RangeAddress address, Object[][] data) {
        this.setRangeProp(address, FORMULA, data);
    }

    @Override
    public void setRangeFormula(RangeLiteral literal, Object data) {
        this.setRangeProp(literal, FORMULA, data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void runWithRange(RangeLiteral literal, Worksheet.RunnableWithRange runnable) {
        if (literal == null || runnable == null) {
            throw new IllegalArgumentException("Null");
        }
        if (literal.getRowsCount() > 0 && literal.getColumnsCount() > 0) {
            List<RangeLiteral> list = literal.getAreas();
            int unit = list.size();
            for (int currentIndex = 0; currentIndex < list.size(); currentIndex += unit) {
                RangeImpl currentRange;
                while (true) {
                    int end = Math.min(currentIndex + unit, list.size());
                    List<RangeLiteral> subList = list.subList(currentIndex, end);
                    RangeLiteral subLiteral = RangeLiteral.create(subList, true);
                    try {
                        currentRange = this.getRange(subLiteral.toString());
                    }
                    catch (DispatchException e) {
                        if (unit == 1) {
                            throw e;
                        }
                        int oldUnit = unit;
                        if (oldUnit != (unit = (int)(0.7 * (double)unit))) continue;
                        --unit;
                        continue;
                    }
                    break;
                }
                try {
                    runnable.run(currentRange);
                    continue;
                }
                finally {
                    currentRange.dispose();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RangeAddress getNamedRangeAddress(String rangeName) {
        WorkbookImpl workbook = this.getParentAsWorkbook();
        try {
            Application app;
            block8: {
                RangeAddress rangeAddress;
                app = workbook.getApplication();
                try {
                    Object o = app.run(MACRO_GET_REFERS_TO_R1C1, new Object[]{this.getIDispatch(), rangeName});
                    String refersToR1C1 = (String)o;
                    if (refersToR1C1 == null || refersToR1C1.length() <= 0) break block8;
                    rangeAddress = new WorksheetRangeAddress(refersToR1C1).getRange();
                }
                catch (Throwable throwable) {
                    app.dispose();
                    throw throwable;
                }
                app.dispose();
                return rangeAddress;
            }
            RangeAddress rangeAddress = null;
            app.dispose();
            return rangeAddress;
        }
        finally {
            workbook.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setRangeName(RangeAddress range, String rangeName) {
        String topLeft = range.getTopLeft().toA1();
        String bottomRight = range.getBottomRight().toA1();
        WorkbookImpl workbook = this.getParentAsWorkbook();
        try {
            Application app = workbook.getApplication();
            try {
                app.run(MACRO_SET_RANGE_NAME, new Object[]{this.getIDispatch(), topLeft, bottomRight, rangeName});
            }
            finally {
                app.dispose();
            }
        }
        finally {
            workbook.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long[] getMatrixCellIDs(int[] rowIndices, int[] colIndices) {
        int numRows = rowIndices.length;
        int numCols = colIndices.length;
        int numCells = numRows * numCols;
        long[] result = new long[numCells];
        short[] cols = new short[numCols];
        for (int i = 0; i < numCols; ++i) {
            cols[i] = (short)colIndices[i];
        }
        int rowChunkSize = Short.MAX_VALUE / numCols;
        int resultIndex = 0;
        WorkbookImpl workbook = this.getParentAsWorkbook();
        try {
            long[] lArray;
            Application app = workbook.getApplication();
            try {
                for (int rowOffset = 0; rowOffset < numRows; rowOffset += rowChunkSize) {
                    int chunk = Math.min(rowChunkSize, numRows - rowOffset);
                    short[] rows = new short[chunk];
                    for (int i = 0; i < chunk; ++i) {
                        rows[i] = (short)rowIndices[rowOffset + i];
                    }
                    Object o = app.run(MACRO_GET_MATRIX_CELL_IDS, new Object[]{this.getIDispatch(), rows, cols});
                    String[] ids = (String[])o;
                    for (int i = 0; i < ids.length; ++i) {
                        String s;
                        long id = (s = ids[i++]) != null && s.length() > 0 ? Long.parseLong(s) : 0L;
                        result[resultIndex++] = id;
                    }
                }
                lArray = result;
            }
            catch (Throwable throwable) {
                app.dispose();
                throw throwable;
            }
            app.dispose();
            return lArray;
        }
        finally {
            workbook.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getCellIDs(CellAddress[] cells, int idIndex) {
        int numCells = cells.length;
        String[] result = new String[numCells];
        if (numCells == 0) {
            return result;
        }
        WorkbookImpl workbook = this.getParentAsWorkbook();
        try {
            String[] stringArray;
            Application app = workbook.getApplication();
            try {
                for (int offset = 0; offset < numCells; offset += Short.MAX_VALUE) {
                    int chunk = Math.min(Short.MAX_VALUE, numCells - offset);
                    short[] rowAddresses = new short[chunk];
                    short[] colAddresses = new short[chunk];
                    for (int i = 0; i < chunk; ++i) {
                        rowAddresses[i] = (short)cells[offset + i].getRow();
                        colAddresses[i] = (short)cells[offset + i].getCol();
                    }
                    Object o = app.run(MACRO_GET_CELL_IDS, new Object[]{this.getIDispatch(), rowAddresses, colAddresses, idIndex});
                    String[] ids = (String[])o;
                    System.arraycopy(ids, 0, result, offset, chunk);
                }
                stringArray = result;
            }
            catch (Throwable throwable) {
                app.dispose();
                throw throwable;
            }
            app.dispose();
            return stringArray;
        }
        finally {
            workbook.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCellIDs(CellAddress[] cells, String[] ids, int idIndex) {
        if (cells.length != ids.length) {
            throw new IllegalArgumentException("Different number of elements between cells and IDs: cells=" + cells.length + ", IDs=" + ids.length);
        }
        if (cells.length == 0) {
            return;
        }
        int numCells = cells.length;
        WorkbookImpl workbook = this.getParentAsWorkbook();
        try {
            Application app = workbook.getApplication();
            try {
                for (int offset = 0; offset < numCells; offset += Short.MAX_VALUE) {
                    int chunk = Math.min(Short.MAX_VALUE, numCells - offset);
                    short[] rowIndices = new short[chunk];
                    short[] colIndices = new short[chunk];
                    Object[] ids2 = new Object[chunk];
                    for (int i = 0; i < chunk; ++i) {
                        rowIndices[i] = (short)cells[offset + i].getRow();
                        colIndices[i] = (short)cells[offset + i].getCol();
                        ids2[i] = ids[offset + i];
                    }
                    app.run(MACRO_SET_CELL_IDS, new Object[]{this.getIDispatch(), rowIndices, colIndices, ids2, idIndex});
                }
            }
            finally {
                app.dispose();
            }
        }
        finally {
            workbook.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearCells(CellAddress[] cells, boolean[] clearMetas) {
        int numCells = cells.length;
        WorkbookImpl workbook = this.getParentAsWorkbook();
        try {
            Application app = workbook.getApplication();
            try {
                for (int offset = 0; offset < numCells; offset += Short.MAX_VALUE) {
                    int chunk = Math.min(Short.MAX_VALUE, numCells - offset);
                    short[] rowIndices = new short[chunk];
                    short[] colIndices = new short[chunk];
                    for (int i = 0; i < chunk; ++i) {
                        rowIndices[i] = (short)cells[offset + i].getRow();
                        colIndices[i] = (short)cells[offset + i].getCol();
                    }
                    boolean[] clearMetasChunk = Arrays.copyOfRange(clearMetas, offset, offset + chunk);
                    app.run(MACRO_CLEAR_CELLS, new Object[]{this.getIDispatch(), rowIndices, colIndices, clearMetasChunk});
                }
            }
            finally {
                app.dispose();
            }
        }
        finally {
            workbook.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean[] setCellValues(CellAddress[] cells, Object[] values) {
        if (cells.length != values.length) {
            throw new IllegalArgumentException("Different number of elements between cells and values: cells=" + cells.length + ", values=" + values.length);
        }
        WorkbookImpl workbook = this.getParentAsWorkbook();
        try {
            boolean[] blArray;
            Application app = workbook.getApplication();
            try {
                int numCells = cells.length;
                boolean[] result = new boolean[numCells];
                for (int offset = 0; offset < numCells; offset += Short.MAX_VALUE) {
                    Object[] values2;
                    int chunk = Math.min(Short.MAX_VALUE, numCells - offset);
                    short[] rowIndices = new short[chunk];
                    short[] colIndices = new short[chunk];
                    for (int i = 0; i < chunk; ++i) {
                        rowIndices[i] = (short)cells[offset + i].getRow();
                        colIndices[i] = (short)cells[offset + i].getCol();
                    }
                    if (offset == 0 && chunk == values.length) {
                        values2 = values;
                    } else {
                        values2 = new Object[chunk];
                        for (int i = 0; i < chunk; ++i) {
                            values2[i] = values[offset + i];
                        }
                    }
                    Object o = app.run(MACRO_SET_CELL_VALUES, new Object[]{this.getIDispatch(), rowIndices, colIndices, values2});
                    Object[] tempResult = (Object[])o;
                    for (int i = 0; i < chunk; ++i) {
                        result[offset + i] = (Boolean)tempResult[i];
                    }
                }
                blArray = result;
            }
            catch (Throwable throwable) {
                app.dispose();
                throw throwable;
            }
            app.dispose();
            return blArray;
        }
        finally {
            workbook.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setRangeCellFormat(CellAddress[] cells, String numberFormat, boolean isFontSpecified, boolean isBold, boolean isItalic, double fontSize, Long fontColor, String fontName, double cellWidth, double cellHeight, short horizontalAlignment, short verticalAlignment, short orientation, boolean isShrinkToFit, boolean isWrapText, Long[] interiorColors, short[] interiorPatterns, Long[] interiorPatternColors) {
        Object[] interiorPatternColorsObj;
        Object[] interiorColorsObj;
        if (interiorColors == null) {
            interiorColorsObj = new Object[]{};
        } else {
            interiorColorsObj = new Object[interiorColors.length];
            for (int i = 0; i < interiorColors.length; ++i) {
                interiorColorsObj[i] = interiorColors[i];
            }
        }
        if (interiorPatternColors == null) {
            interiorPatternColorsObj = new Object[]{};
        } else {
            interiorPatternColorsObj = new Object[interiorPatternColors.length];
            for (int i = 0; i < interiorPatternColors.length; ++i) {
                interiorPatternColorsObj[i] = interiorPatternColors[i];
            }
        }
        if (interiorPatterns == null) {
            interiorPatterns = new short[]{};
        }
        int numCells = cells.length;
        WorkbookImpl workbook = this.getParentAsWorkbook();
        try {
            Application app = workbook.getApplication();
            try {
                for (int offset = 0; offset < numCells; offset += Short.MAX_VALUE) {
                    int chunk = Math.min(Short.MAX_VALUE, numCells - offset);
                    short[] rowIndices = new short[chunk];
                    short[] colIndices = new short[chunk];
                    for (int i = 0; i < chunk; ++i) {
                        rowIndices[i] = (short)cells[offset + i].getRow();
                        colIndices[i] = (short)cells[offset + i].getCol();
                    }
                    app.run(MACRO_SET_RANGE_CELL_FORMAT, new Object[]{this.getIDispatch(), rowIndices, colIndices, numberFormat, isFontSpecified, isBold, isItalic, fontSize, fontColor, fontName, cellWidth, cellHeight, horizontalAlignment, verticalAlignment, orientation, isShrinkToFit, isWrapText, interiorColorsObj, interiorPatterns, interiorPatternColorsObj});
                }
            }
            finally {
                app.dispose();
            }
        }
        finally {
            workbook.dispose();
        }
    }

    @Override
    public String getCellID(CellAddress address) {
        return (String)this.getCellProp(address, "ID");
    }

    @Override
    public void setCellID(CellAddress address, String id) {
        this.setCellProp(address, "ID", id);
    }

    @Override
    public boolean isDisplayPageBreaks() {
        Boolean b = (Boolean)this.idispatch.get("DisplayPageBreaks");
        return b;
    }

    @Override
    public void setDisplayPageBreaks(boolean b) {
        this.idispatch.put("DisplayPageBreaks", (Object)new Boolean(b));
    }

    @Override
    public OLEObject getOLEObject(String name) {
        Object o = this.idispatch.invoke1("OLEObjects", (Object)name);
        if (o instanceof IDispatch) {
            return new OLEObjectImpl((IDispatch)o);
        }
        return null;
    }

    @Override
    public RangeImpl getUsedRange() {
        IDispatch o = (IDispatch)this.idispatch.invoke0("UsedRange");
        return o == null ? null : new RangeImpl(o);
    }

    @Override
    public AutoFilter getAutoFilter() {
        IDispatch o = (IDispatch)this.idispatch.get("AutoFilter");
        if (o == null) {
            return null;
        }
        return new AutoFilterImpl(o);
    }

    @Override
    public Range getCircularReference() {
        IDispatch dispatch = (IDispatch)this.idispatch.get("CircularReference");
        if (dispatch == null) {
            return null;
        }
        return new RangeImpl(dispatch);
    }
}

