/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.trinity.spreadsheet.excel.impl;

import com.ibm.accessibility.com.win32.DispatchException;
import com.ibm.accessibility.com.win32.IDispatch;
import com.ibm.accessibility.com.win32.Missing;
import com.ibm.trinity.spreadsheet.excel.Border;
import com.ibm.trinity.spreadsheet.excel.Interior;
import com.ibm.trinity.spreadsheet.excel.Range;
import com.ibm.trinity.spreadsheet.excel.Validation;
import com.ibm.trinity.spreadsheet.excel.Worksheet;
import com.ibm.trinity.spreadsheet.excel.XlDirection;
import com.ibm.trinity.spreadsheet.excel.impl.BorderImpl;
import com.ibm.trinity.spreadsheet.excel.impl.BordersImpl;
import com.ibm.trinity.spreadsheet.excel.impl.CommentImpl;
import com.ibm.trinity.spreadsheet.excel.impl.FontImpl;
import com.ibm.trinity.spreadsheet.excel.impl.IDispatchWrapperImpl;
import com.ibm.trinity.spreadsheet.excel.impl.InteriorImpl;
import com.ibm.trinity.spreadsheet.excel.impl.NameImpl;
import com.ibm.trinity.spreadsheet.excel.impl.StyleImpl;
import com.ibm.trinity.spreadsheet.excel.impl.ValidationImpl;
import com.ibm.trinity.spreadsheet.excel.impl.WorksheetImpl;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class RangeImpl
extends IDispatchWrapperImpl
implements Range {
    public static Object testSortArgs = null;

    RangeImpl(IDispatch iRange) {
        super(iRange);
    }

    @Override
    public Object getValueRaw() {
        return this.getPropRow("Value");
    }

    protected Object getPropRow(String prop) {
        return this.idispatch.get(prop);
    }

    @Override
    public Object getValue() {
        return this.getProp("Value");
    }

    protected Object getProp(String prop) {
        Object value = this.idispatch.get(prop);
        if (value instanceof Object[][]) {
            Object[][] v = (Object[][])value;
            if (v.length != 1 || v[0].length != 1) {
                throw new IllegalStateException("Range#getProp doesn't work for a range containing multiple cells.");
            }
            return v[0][0];
        }
        return value;
    }

    @Override
    public Object getTopLeftValue() {
        return this.getTopLeftProp("Value");
    }

    protected Object getTopLeftProp(String prop) {
        Object value = this.idispatch.get(prop);
        if (value instanceof Object[][]) {
            Object[][] v = (Object[][])value;
            if (v.length < 1 || v[0].length < 1) {
                throw new IllegalStateException("No area contained in this range.");
            }
            return v[0][0];
        }
        return value;
    }

    @Override
    public Object[][] getValueAsArray() {
        return this.getPropAsArray("Value");
    }

    protected Object[][] getPropAsArray(String prop) {
        Object value = this.idispatch.get(prop);
        if (value instanceof Object[][]) {
            return (Object[][])value;
        }
        Object[] r = new Object[]{value};
        Object[][] result = new Object[][]{r};
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setValue(Object value) {
        if (!(value instanceof String)) {
            this.setProp("Value", value);
            return;
        }
        String strValue = (String)value;
        Validation validation = this.getValidation();
        if (validation == null || !validation.isMatch(strValue)) {
            this.setProp("Value", strValue);
            if (validation != null) {
                validation.dispose();
            }
            return;
        }
        String[] strs = validation.processEnumaration(strValue);
        this.setProp("Value", strs[0]);
        for (Range cell : this.getCells()) {
            int type;
            Validation v = null;
            String formula1 = null;
            try {
                v = cell.getValidation();
                type = v.getType();
                formula1 = v.getFormula1();
            }
            catch (Throwable e) {
                v.dispose();
                continue;
            }
            finally {
                cell.dispose();
                continue;
            }
            boolean isMapleMbseEnumFormat = v != null;
            isMapleMbseEnumFormat = isMapleMbseEnumFormat && Objects.equals(Validation.XlDVType.xlValidateList.getValue(), type);
            boolean bl = isMapleMbseEnumFormat = isMapleMbseEnumFormat && formula1 instanceof String && formula1.endsWith(",\t");
            if (isMapleMbseEnumFormat) {
                v.delete();
            }
            v.dispose();
        }
        validation.add(strs[1]);
        validation.dispose();
    }

    protected void setProp(String prop, Object value) {
        RangeImpl.makeDirty();
        this.idispatch.put(prop, value);
    }

    @Override
    public NameImpl getName() {
        IDispatch o = (IDispatch)this.idispatch.get("Name");
        return o == null ? null : new NameImpl(o);
    }

    @Override
    public void setName(String name) {
        RangeImpl.makeDirty();
        if (name == null) {
            throw new IllegalArgumentException("Null");
        }
        try {
            this.idispatch.put("Name", (Object)name);
        }
        catch (DispatchException e) {
            System.err.println("Bad name: " + name);
            throw e;
        }
    }

    @Override
    public List<Range> getCells() {
        ArrayList<Range> cells = new ArrayList<Range>(this.getCount());
        String[] addresses = this.getAddress().split(",");
        Worksheet ws = this.getWorksheet();
        for (String address : addresses) {
            Range range = ws.getRange(address);
            Range columns = range.getColumns();
            int width = columns.getCount();
            Range rows = range.getRows();
            int height = rows.getCount();
            for (int i = 1; i <= height; ++i) {
                for (int j = 1; j <= width; ++j) {
                    cells.add(range.getItem(i, j));
                }
            }
            range.dispose();
            rows.dispose();
            columns.dispose();
        }
        return cells;
    }

    @Override
    public RangeImpl duplicate() {
        this.idispatch.addRef();
        return new RangeImpl(this.idispatch);
    }

    @Override
    public int getColumn() {
        return (Integer)this.idispatch.get("Column");
    }

    @Override
    public int getRow() {
        return (Integer)this.idispatch.get("Row");
    }

    @Override
    public RangeImpl getColumns() {
        IDispatch o = (IDispatch)this.idispatch.get("Columns");
        return o == null ? null : new RangeImpl(o);
    }

    @Override
    public Range getColumns(int i) {
        IDispatch o = (IDispatch)this.idispatch.get("Columns", (Object[])new Integer[]{i});
        return o == null ? null : new RangeImpl(o);
    }

    @Override
    public RangeImpl getRows() {
        IDispatch o = (IDispatch)this.idispatch.get("Rows");
        return o == null ? null : new RangeImpl(o);
    }

    @Override
    public Range getRows(int i) {
        IDispatch o = (IDispatch)this.idispatch.get("Rows", (Object[])new Integer[]{i});
        return o == null ? null : new RangeImpl(o);
    }

    @Override
    public InteriorImpl getInterior() {
        IDispatch o = (IDispatch)this.idispatch.get("Interior");
        return o == null ? null : new InteriorImpl(o);
    }

    @Override
    public CommentImpl getComment() {
        IDispatch o = (IDispatch)this.idispatch.get("Comment");
        return o == null ? null : new CommentImpl(o);
    }

    @Override
    public FontImpl getFont() {
        IDispatch o = (IDispatch)this.idispatch.get("Font");
        return o == null ? null : new FontImpl(o);
    }

    @Override
    public StyleImpl getStyle() {
        IDispatch o = (IDispatch)this.idispatch.get("Style");
        return o == null ? null : new StyleImpl(o);
    }

    @Override
    public String getNumberFormat() {
        return (String)this.idispatch.get("NumberFormat");
    }

    @Override
    public void setNumberFormat(String s) {
        RangeImpl.makeDirty();
        this.idispatch.put("NumberFormat", (Object)s);
    }

    @Override
    public RangeImpl getDependents() {
        try {
            IDispatch o = (IDispatch)this.idispatch.get("Dependents");
            return o == null ? null : new RangeImpl(o);
        }
        catch (DispatchException e) {
            return null;
        }
    }

    @Override
    public RangeImpl getAreas(int i) {
        IDispatch o = (IDispatch)this.idispatch.get("Areas", (Object[])new Integer[]{i});
        return o == null ? null : new RangeImpl(o);
    }

    @Override
    public String getAddress() {
        return (String)this.idispatch.get("Address");
    }

    @Override
    public int getCount() {
        return (Integer)this.idispatch.get("Count");
    }

    @Override
    public int getCountAreas() {
        IDispatch o = (IDispatch)this.idispatch.get("Areas");
        try {
            int n = (Integer)o.get("Count");
            return n;
        }
        finally {
            o.release();
        }
    }

    @Override
    public RangeImpl getItem(int i) {
        IDispatch o = (IDispatch)this.idispatch.get("Item", (Object[])new Integer[]{i});
        return o == null ? null : new RangeImpl(o);
    }

    @Override
    public RangeImpl getItem(int i, int j) {
        IDispatch o = (IDispatch)this.idispatch.get("Item", (Object[])new Integer[]{i, j});
        return o == null ? null : new RangeImpl(o);
    }

    @Override
    public String getID() {
        return (String)this.idispatch.get("ID");
    }

    @Override
    public void setID(String id) {
        RangeImpl.makeDirty();
        this.idispatch.put("ID", (Object)id);
    }

    @Override
    public void select() {
        this.idispatch.invoke0("Select");
    }

    @Override
    public BordersImpl getBorders() {
        IDispatch o = (IDispatch)this.idispatch.get("Borders");
        return o == null ? null : new BordersImpl(o);
    }

    @Override
    public BorderImpl getBorders(Border.XlBordersIndex index) {
        IDispatch o = (IDispatch)this.idispatch.get("Borders", new Object[]{index.getValue()});
        return o == null ? null : new BorderImpl(o);
    }

    @Override
    public void borderAround(Border.XlLineStyle style, Border.XlBorderWeight weight, Interior.XlColorIndex colorIndex) {
        RangeImpl.makeDirty();
        Object[] args = new Object[]{style.getValue(), weight.getValue(), colorIndex.getValue(), Missing.VALUE};
        this.idispatch.invoke("borderAround", args);
    }

    @Override
    public void borderAround(Border.XlLineStyle style, Border.XlBorderWeight weight, Long color) {
        RangeImpl.makeDirty();
        if (color == null) {
            throw new IllegalArgumentException("Null");
        }
        Object[] args = new Object[]{style.getValue(), weight.getValue(), Missing.VALUE, color};
        this.idispatch.invoke("borderAround", args);
    }

    @Override
    public void borderAround(Border.XlLineStyle style, Border.XlBorderWeight weight) {
        this.borderAround(style, weight, Interior.XlColorIndex.xlColorIndexAutomatic);
    }

    @Override
    public void clearComments() {
        RangeImpl.makeDirty();
        this.idispatch.invoke0("ClearComments");
    }

    @Override
    public CommentImpl addComment() {
        RangeImpl.makeDirty();
        IDispatch o = (IDispatch)this.idispatch.invoke0("AddComment");
        return o == null ? null : new CommentImpl(o);
    }

    @Override
    public void copy(Range destination) {
        if (destination == null) {
            this.idispatch.invoke0("Copy");
        } else {
            this.idispatch.invoke1("Copy", (Object)destination.getIDispatch());
        }
    }

    @Override
    public void cut(Range destination) {
        if (destination == null) {
            this.idispatch.invoke0("Cut");
        } else {
            this.idispatch.invoke1("Cut", (Object)destination.getIDispatch());
        }
    }

    @Override
    public void clear() {
        RangeImpl.makeDirty();
        this.idispatch.invoke0("Clear");
    }

    @Override
    public void setColumnWidth(int width) {
        RangeImpl.makeDirty();
        this.idispatch.put("ColumnWidth", (Object)width);
    }

    @Override
    public void setRowHeight(int height) {
        RangeImpl.makeDirty();
        this.idispatch.put("RowHeight", (Object)height);
    }

    @Override
    public Worksheet getWorksheet() {
        IDispatch o = (IDispatch)this.idispatch.get("Worksheet");
        return o == null ? null : new WorksheetImpl(o);
    }

    @Override
    public void setHorizontalAlignment(int value) {
        RangeImpl.makeDirty();
        this.idispatch.put("HorizontalAlignment", (Object)value);
    }

    @Override
    public void setVerticalAlignment(int value) {
        RangeImpl.makeDirty();
        this.idispatch.put("VerticalAlignment", (Object)value);
    }

    @Override
    public void setOrientation(int orientation) {
        RangeImpl.makeDirty();
        this.idispatch.put("Orientation", (Object)orientation);
    }

    @Override
    public void setShrinkToFit(boolean shrinkToFit) {
        RangeImpl.makeDirty();
        this.idispatch.put("ShrinkToFit", (Object)shrinkToFit);
    }

    @Override
    public void setWrapText(boolean wrapText) {
        RangeImpl.makeDirty();
        this.idispatch.put("WrapText", (Object)wrapText);
    }

    @Override
    public int getHorizontalAlignment() {
        Number r = (Number)this.idispatch.get("HorizontalAlignment");
        return r == null ? 0 : r.intValue();
    }

    @Override
    public int getOrientation() {
        Number r = (Number)this.idispatch.get("Orientation");
        return r == null ? 0 : r.intValue();
    }

    @Override
    public Boolean getShrinkToFit() {
        Boolean r = (Boolean)this.idispatch.get("ShrinkToFit");
        return r;
    }

    public Range getEnd() {
        Range r = (Range)this.idispatch.get("End");
        return r;
    }

    @Override
    public RangeImpl getEnd(XlDirection d) {
        IDispatch o = (IDispatch)this.idispatch.invoke("End", new Object[]{d.getValue()});
        return o == null ? null : new RangeImpl(o);
    }

    @Override
    public int getVerticalAlignment() {
        Number r = (Number)this.idispatch.get("VerticalAlignment");
        return r == null ? 0 : r.intValue();
    }

    @Override
    public Boolean getWrapText() {
        Boolean r = (Boolean)this.idispatch.get("WrapText");
        return r;
    }

    @Override
    public int getColumnWidth() {
        Number r = (Number)this.idispatch.get("ColumnWidth");
        return r == null ? 0 : r.intValue();
    }

    @Override
    public int getRowHeight() {
        Number r = (Number)this.idispatch.get("RowHeight");
        return r == null ? 0 : r.intValue();
    }

    @Override
    public void autoFill(Range destination, Range.XlAutoFillType type) {
        RangeImpl.makeDirty();
        if (type == null) {
            type = Range.XlAutoFillType.xlFillDefault;
        }
        this.idispatch.invoke("AutoFill", new Object[]{destination, type.getValue()});
    }

    @Override
    public void merge() {
        RangeImpl.makeDirty();
        this.idispatch.invoke0("Merge");
    }

    @Override
    public boolean isAllFormula() {
        Boolean result = (Boolean)this.idispatch.get("HasFormula");
        return result != null && result != false;
    }

    @Override
    public boolean isExistFormula() {
        Boolean result = (Boolean)this.idispatch.get("HasFormula");
        return result == null || result != false;
    }

    @Override
    public void sort(Range key1, Range.XlSortOrder order1, Range.XlYesNoGuess header, Integer orderCustom, Boolean matchCase, Range.XlSortOrientation orientation, Range.XlSortMethod sortMethod, Range.XlSortDataOption dataOption1) {
        this.sort(key1, order1, null, null, null, null, null, header, orderCustom, matchCase, orientation, sortMethod, dataOption1, null, null);
    }

    @Override
    public void sort(Range key1, Range.XlSortOrder order1, Range key2, Range.XlSortType type, Range.XlSortOrder order2, Range.XlYesNoGuess header, Integer orderCustom, Boolean matchCase, Range.XlSortOrientation orientation, Range.XlSortMethod sortMethod, Range.XlSortDataOption dataOption1, Range.XlSortDataOption dataOption2) {
        this.sort(key1, order1, key2, type, order2, null, null, header, orderCustom, matchCase, orientation, sortMethod, dataOption1, dataOption2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sort(Range key1, Range.XlSortOrder order1, Range key2, Range.XlSortType type, Range.XlSortOrder order2, Range key3, Range.XlSortOrder order3, Range.XlYesNoGuess header, Integer orderCustom, Boolean matchCase, Range.XlSortOrientation orientation, Range.XlSortMethod sortMethod, Range.XlSortDataOption dataOption1, Range.XlSortDataOption dataOption2, Range.XlSortDataOption dataOption3) {
        int size;
        RangeImpl.makeDirty();
        Object[] args = new Object[]{key1 == null ? Missing.VALUE : ((RangeImpl)key1).getIDispatch(), order1 == null ? Missing.VALUE : Integer.valueOf(order1.getValue()), key2 == null ? Missing.VALUE : ((RangeImpl)key2).getIDispatch(), type == null ? Missing.VALUE : Integer.valueOf(type.getValue()), order2 == null ? Missing.VALUE : Integer.valueOf(order2.getValue()), key3 == null ? Missing.VALUE : ((RangeImpl)key3).getIDispatch(), order3 == null ? Missing.VALUE : Integer.valueOf(order3.getValue()), header == null ? Missing.VALUE : Integer.valueOf(header.getValue()), orderCustom == null ? Missing.VALUE : orderCustom, matchCase, orientation == null ? Missing.VALUE : Integer.valueOf(orientation.getValue()), sortMethod == null ? Missing.VALUE : Integer.valueOf(sortMethod.getValue()), dataOption1 == null ? Missing.VALUE : Integer.valueOf(dataOption1.getValue()), dataOption2 == null ? Missing.VALUE : Integer.valueOf(dataOption2.getValue()), dataOption3 == null ? Missing.VALUE : Integer.valueOf(dataOption3.getValue())};
        RangeImpl range = orientation == null || Range.XlSortOrientation.xlTopToBottom.equals((Object)orientation) ? this.getRows() : this.getColumns();
        try {
            size = range.getCount();
        }
        finally {
            range.dispose();
        }
        if (size > 1) {
            if (testSortArgs != null) {
                testSortArgs = args;
            }
            this.idispatch.invoke("Sort", args);
        }
    }

    @Override
    public void delete(Range.XlDeleteShiftDirection direction) {
        RangeImpl.makeDirty();
        this.idispatch.invoke1("Delete", (Object)direction.getValue());
    }

    @Override
    public void insert(Range.XlInsertShiftDirection direction) {
        RangeImpl.makeDirty();
        this.idispatch.invoke1("Insert", (Object)direction.getValue());
    }

    public String toString() {
        return this.getAddress();
    }

    @Override
    public Range getEntireRow() {
        IDispatch o = (IDispatch)this.idispatch.get("EntireRow");
        return o == null ? null : new RangeImpl(o);
    }

    @Override
    public Range getEntireColumn() {
        IDispatch o = (IDispatch)this.idispatch.get("EntireColumn");
        return o == null ? null : new RangeImpl(o);
    }

    @Override
    public void delete() {
        this.idispatch.get("Delete");
    }

    @Override
    public Validation getValidation() {
        IDispatch validation = (IDispatch)this.idispatch.get("Validation");
        if (validation == null) {
            return null;
        }
        return new ValidationImpl(validation);
    }

    @Override
    public void setTestArgs(Object[] args) {
        testSortArgs = args;
    }
}

