/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.trinity.spreadsheet.excel.impl;

import com.ibm.accessibility.com.win32.IDispatch;
import com.ibm.accessibility.com.win32.IUnknown;
import com.ibm.trinity.spreadsheet.excel.IDispatchWrapper;
import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.UUID;

public class IDispatchWrapperImpl
implements IDispatchWrapper {
    private static final boolean _DEBUG_ = false;
    private static final UUID UUID_IUNKNOWN = UUID.fromString("00000000-0000-0000-C000-000000000046");
    protected IDispatch idispatch;
    private Throwable _pointCreated;
    private static final ArrayList<IDispatchWrapperImpl> _allInstances = null;
    private static boolean dirty = false;

    protected IDispatchWrapperImpl(IDispatch idispatch) {
        if (idispatch == null) {
            throw new IllegalArgumentException("IDispatch cannot be null");
        }
        this.idispatch = idispatch;
    }

    @Override
    public IDispatch getIDispatch() {
        return this.idispatch;
    }

    @Override
    public void unmanage() {
    }

    @Override
    public void manage() {
    }

    @Override
    public void dispose() {
        this.unmanage();
        this.idispatch.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean equalsCOMObject(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IDispatchWrapperImpl)) {
            return false;
        }
        IDispatch od = ((IDispatchWrapperImpl)o).idispatch;
        if (od == this.idispatch) {
            return true;
        }
        if (od == null) {
            return this.idispatch == null;
        }
        if (this.idispatch == null) {
            return od == null;
        }
        if (od.getPtr() == this.idispatch.getPtr()) {
            return true;
        }
        IUnknown thisIU = this.idispatch.queryInterface(UUID_IUNKNOWN);
        IUnknown otherIU = od.queryInterface(UUID_IUNKNOWN);
        try {
            if (thisIU == null) {
                boolean bl = otherIU == null;
                return bl;
            }
            if (otherIU == null) {
                boolean bl = thisIU == null;
                return bl;
            }
            boolean bl = thisIU.getPtr() == otherIU.getPtr();
            return bl;
        }
        finally {
            if (thisIU != null) {
                thisIU.release();
            }
            if (otherIU != null) {
                otherIU.release();
            }
        }
    }

    public boolean equals(Object o) {
        return this.equalsCOMObject(o);
    }

    public int hashCode() {
        IUnknown thisIU = this.idispatch.queryInterface(UUID_IUNKNOWN);
        if (thisIU == null) {
            return 0;
        }
        long ptr = thisIU.getPtr();
        thisIU.release();
        return (int)(ptr ^ ptr >> 32);
    }

    public static void dumpAllActiveWrappers(PrintStream out) {
        out.println("------------------------------------------- start");
        out.println("Dump all IDispatchWrapper only works when IDispatchWrapper#_DEBUG_ flag is set.");
        out.println("------------------------------------------- end");
    }

    private boolean isManaged() {
        int size = _allInstances.size();
        for (int i = 0; i < size; ++i) {
            if (_allInstances.get(i) != this) continue;
            return true;
        }
        return false;
    }

    protected static void makeDirty() {
        if (!dirty) {
            dirty = true;
        }
    }

    public static void clearDirty() {
        dirty = false;
    }

    @Override
    public <T> T internalInvoke(String string, Class<T> clazz, Object ... args) {
        Object[] clone = (Object[])args.clone();
        for (int i = 0; i < clone.length; ++i) {
            if (!(clone[i] instanceof IDispatchWrapper)) continue;
            clone[i] = ((IDispatchWrapperImpl)clone[i]).getIDispatch();
        }
        Object o = this.getIDispatch().invoke(string, clone);
        T wrapper = this.createWrapper(clazz, o);
        return wrapper;
    }

    @Override
    public void internalInvoke(String string, Object ... args) {
        this.internalInvoke(string, Object.class, args);
    }

    @Override
    public void internalSetProperty(String prop, Object value) {
        if (value instanceof IDispatchWrapper) {
            value = ((IDispatchWrapperImpl)value).getIDispatch();
        }
        this.getIDispatch().put(prop, value);
    }

    @Override
    public <T> T internalGetProperty(String prop, Class<T> clazz, Object ... args) {
        Object o = this.getIDispatch().get(prop, args);
        T wrapper = this.createWrapper(clazz, o);
        return wrapper;
    }

    private <T> T createWrapper(Class<T> clazz, Object o) {
        if (clazz != null) {
            if (IDispatchWrapper.class.isAssignableFrom(clazz)) {
                if (o == null) {
                    return null;
                }
                try {
                    String baseName = clazz.getCanonicalName();
                    int lastIndexOfDot = baseName.lastIndexOf(46);
                    String className = baseName.substring(0, lastIndexOfDot) + ".impl" + baseName.substring(lastIndexOfDot) + "Impl";
                    Class<?> implClazz = Class.forName(className);
                    Constructor<?> constructor = implClazz.getDeclaredConstructor(IDispatch.class);
                    constructor.setAccessible(true);
                    return (T)constructor.newInstance(o);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (o instanceof IDispatch) {
                ((IDispatch)o).release();
                return null;
            }
        }
        return (T)o;
    }
}

