/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.trinity.spreadsheet.excel.impl;

import com.ibm.accessibility.com.win32.DispatchException;
import com.ibm.accessibility.com.win32.IDispatch;
import com.ibm.accessibility.com.win32.Missing;
import com.ibm.trinity.spreadsheet.excel.Activator;
import com.ibm.trinity.spreadsheet.excel.Application;
import com.ibm.trinity.spreadsheet.excel.CommandBars;
import com.ibm.trinity.spreadsheet.excel.Range;
import com.ibm.trinity.spreadsheet.excel.impl.AddInImpl;
import com.ibm.trinity.spreadsheet.excel.impl.AddInsImpl;
import com.ibm.trinity.spreadsheet.excel.impl.CommandBarsImpl;
import com.ibm.trinity.spreadsheet.excel.impl.IDispatchWrapperImpl;
import com.ibm.trinity.spreadsheet.excel.impl.NamesImpl;
import com.ibm.trinity.spreadsheet.excel.impl.RangeImpl;
import com.ibm.trinity.spreadsheet.excel.impl.WorkbookImpl;
import com.ibm.trinity.spreadsheet.excel.impl.WorkbooksImpl;
import com.ibm.trinity.spreadsheet.excel.impl.WorksheetImpl;
import com.ibm.trinity.spreadsheet.excel.impl.WorksheetsImpl;
import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.osgi.framework.Bundle;

public class ApplicationImpl
extends IDispatchWrapperImpl
implements Application {
    private static boolean isAddInInstalled = false;
    private AddInImpl addIn = null;

    ApplicationImpl(IDispatch iApplication) {
        super(iApplication);
    }

    @Override
    public boolean isAddInInstalled() {
        return isAddInInstalled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void installTrinityAddIn() {
        if (isAddInInstalled) {
            return;
        }
        AddInsImpl addIns = this.getAddIns();
        try {
            this.addIn = addIns.getAddIn("Trinity");
        }
        catch (DispatchException dispatchException) {
            // empty catch block
        }
        try {
            if (this.addIn == null) {
                Bundle bundle = Activator.getDefault().getBundle();
                Path path = new Path("AddIns/Trinity001.xla");
                URL url = FileLocator.find((Bundle)bundle, (IPath)path, Collections.emptyMap());
                try {
                    URL fileUrl = FileLocator.toFileURL((URL)url);
                    String addInFilePath = fileUrl.getPath();
                    if (addInFilePath.charAt(0) == '/') {
                        addInFilePath = addInFilePath.substring(1);
                    }
                    this.addIn = addIns.add(addInFilePath);
                    if (!this.addIn.isInstalled()) {
                        this.addIn.setInstalled(true);
                    }
                    isAddInInstalled = true;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        finally {
            if (addIns != null) {
                addIns.dispose();
            }
        }
    }

    @Override
    public void uninstallTrinityAddIn() {
        if (!isAddInInstalled) {
            return;
        }
        try {
            if (this.addIn != null) {
                this.addIn.setInstalled(false);
            }
            isAddInInstalled = false;
        }
        finally {
            if (this.addIn != null) {
                this.addIn.dispose();
                this.addIn = null;
            }
        }
    }

    @Override
    public WorkbooksImpl getWorkbooks() {
        IDispatch o = (IDispatch)this.idispatch.get("Workbooks");
        return o == null ? null : new WorkbooksImpl(o);
    }

    @Override
    public WorkbookImpl getActiveWorkbook() {
        IDispatch o = (IDispatch)this.idispatch.get("ActiveWorkbook");
        return o == null ? null : new WorkbookImpl(o);
    }

    @Override
    public WorkbookImpl getWorkbook(Object[] book) {
        if (book == null) {
            throw new IllegalArgumentException("Null");
        }
        IDispatch o = (IDispatch)this.idispatch.get("Workbooks", book);
        return o == null ? null : new WorkbookImpl(o);
    }

    @Override
    public WorksheetsImpl getWorksheets() {
        IDispatch o = (IDispatch)this.idispatch.get("Worksheets");
        return o == null ? null : new WorksheetsImpl(o);
    }

    @Override
    public WorksheetImpl getActivesheet() {
        IDispatch o = (IDispatch)this.idispatch.get("Activesheet");
        return o == null ? null : new WorksheetImpl(o);
    }

    @Override
    public WorksheetImpl getWorksheet(String sheet) {
        if (sheet == null) {
            throw new IllegalArgumentException("Null");
        }
        Object[] obj = new Object[]{sheet};
        IDispatch o = (IDispatch)this.idispatch.get("Worksheets", obj);
        return o == null ? null : new WorksheetImpl(o);
    }

    @Override
    public RangeImpl getRange(String cell1) {
        if (cell1 == null) {
            throw new IllegalArgumentException("Null");
        }
        Object[] obj = new Object[]{cell1};
        IDispatch o = (IDispatch)this.idispatch.get("Range", obj);
        return o == null ? null : new RangeImpl(o);
    }

    @Override
    public RangeImpl getRange(String cell1, String cell2) {
        if (cell1 == null || cell2 == null) {
            throw new IllegalArgumentException("Null");
        }
        Object[] obj = new Object[]{cell1, cell2};
        IDispatch o = (IDispatch)this.idispatch.get("Range", obj);
        return o == null ? null : new RangeImpl(o);
    }

    @Override
    public RangeImpl getActiveCell() {
        IDispatch o = (IDispatch)this.idispatch.get("ActiveCell");
        return o == null ? null : new RangeImpl(o);
    }

    @Override
    public RangeImpl getCells(int row, int col) {
        Object[] obj = new Object[]{row, col};
        IDispatch o = (IDispatch)this.idispatch.get("Cells", obj);
        return o == null ? null : new RangeImpl(o);
    }

    @Override
    public RangeImpl getCells() {
        IDispatch o = (IDispatch)this.idispatch.get("Cells");
        return o == null ? null : new RangeImpl(o);
    }

    @Override
    public String getName() {
        return (String)this.idispatch.get("Name");
    }

    @Override
    public NamesImpl getNames() {
        IDispatch o = (IDispatch)this.idispatch.get("Names");
        return o == null ? null : new NamesImpl(o);
    }

    @Override
    public AddInsImpl getAddIns() {
        IDispatch o = (IDispatch)this.idispatch.get("AddIns");
        return o == null ? null : new AddInsImpl(o);
    }

    @Override
    public boolean isEnableEvents() {
        Boolean b = (Boolean)this.idispatch.get("EnableEvents");
        return b;
    }

    @Override
    public void setEnableEvents(boolean b) {
        this.idispatch.put("EnableEvents", (Object)new Boolean(b));
    }

    @Override
    public void GoTo() {
        this.idispatch.invoke0("Goto");
    }

    @Override
    public void GoTo(Range reference) {
        if (reference == null) {
            this.GoTo();
            return;
        }
        Object[] obj = new Object[]{reference};
        this.idispatch.invoke("Goto", obj);
    }

    @Override
    public void GoTo(Range reference, boolean scroll) {
        Object[] obj = new Object[2];
        if (reference != null) {
            obj[0] = ((RangeImpl)reference).getIDispatch();
        }
        obj[1] = scroll;
        this.idispatch.invoke("Goto", obj);
    }

    @Override
    public Application.XlCutCopyMode getCutCopyMode() {
        Object o = this.idispatch.get("CutCopyMode");
        return Application.XlCutCopyMode.valueOf(o);
    }

    @Override
    public void setCutCopyMode(Application.XlCutCopyMode mode) {
        this.idispatch.put("CutCopyMode", (Object)mode.getValue());
    }

    @Override
    public RangeImpl union(Range[] ranges, int len) {
        if (len < 2) {
            throw new IllegalArgumentException("The number of arguments must be larger than 2:" + len);
        }
        Object[] args = new Object[len];
        for (int i = 0; i < len; ++i) {
            args[i] = ((RangeImpl)ranges[i]).getIDispatch();
        }
        IDispatch o = (IDispatch)this.idispatch.invoke("Union", args);
        return o == null ? null : new RangeImpl(o);
    }

    @Override
    public RangeImpl union(Range r0, Range r1, Range ... ranges) {
        Object[] args = new Object[ranges.length + 2];
        args[0] = ((RangeImpl)r0).getIDispatch();
        args[1] = ((RangeImpl)r1).getIDispatch();
        for (int i = 0; i < ranges.length; ++i) {
            args[i + 2] = ((RangeImpl)ranges[i]).getIDispatch();
        }
        IDispatch o = (IDispatch)this.idispatch.invoke("Union", args);
        return o == null ? null : new RangeImpl(o);
    }

    @Override
    public void undo() {
        this.idispatch.invoke0("Undo");
    }

    @Override
    public void onUndo(String undoText, String procName) {
        Object[] args = new Object[]{undoText, procName};
        this.idispatch.invoke("OnUndo", args);
    }

    @Override
    public Object run(String method, Object[] args) {
        Object[] newArgs = new Object[args.length + 1];
        newArgs[0] = method;
        for (int i = 0; i < args.length; ++i) {
            newArgs[i + 1] = args[i] instanceof IDispatchWrapperImpl ? ((IDispatchWrapperImpl)args[i]).getIDispatch() : args[i];
        }
        Object o = this.idispatch.invoke("Run", newArgs);
        return o;
    }

    @Override
    public void setVisibility(boolean b) {
        this.idispatch.put("Visible", (Object)new Boolean(b));
    }

    @Override
    public boolean isScreenUpdating() {
        Boolean b = (Boolean)this.idispatch.get("ScreenUpdating");
        return b;
    }

    @Override
    public void setScreenUpdating(boolean b) {
        this.idispatch.put("ScreenUpdating", (Object)new Boolean(b));
    }

    @Override
    public boolean isDisplayStatusBar() {
        Boolean b = (Boolean)this.idispatch.get("DisplayStatusBar");
        return b;
    }

    @Override
    public void setDisplayStatusBar(boolean b) {
        this.idispatch.put("DisplayStatusBar", (Object)new Boolean(b));
    }

    @Override
    public Application.XlCalculation getCalculation() {
        Integer val = (Integer)this.idispatch.get("Calculation");
        int ival = val;
        if (ival == Application.XlCalculation.xlCalculationAutomatic.getValue()) {
            return Application.XlCalculation.xlCalculationAutomatic;
        }
        if (ival == Application.XlCalculation.xlCalculationManual.getValue()) {
            return Application.XlCalculation.xlCalculationManual;
        }
        if (ival == Application.XlCalculation.xlCalculationSemiautomatic.getValue()) {
            return Application.XlCalculation.xlCalculationSemiautomatic;
        }
        throw new IllegalStateException(val.toString());
    }

    @Override
    public void setCalculation(Application.XlCalculation val) {
        this.idispatch.put("Calculation", (Object)new Integer(val.getValue()));
    }

    @Override
    public void setStatusBar(String status) {
        this.idispatch.put("StatusBar", (Object)status);
    }

    @Override
    public void clearStatusBar() {
        this.idispatch.put("StatusBar", (Object)Boolean.FALSE);
    }

    @Override
    public void quit() {
        this.idispatch.invoke0("quit");
    }

    @Override
    public boolean isDisplayAlert() {
        Boolean b = (Boolean)this.idispatch.get("DisplayAlert");
        return b;
    }

    @Override
    public void setDisplayAlert(boolean b) {
        this.idispatch.put("DisplayAlert", (Object)b);
    }

    @Override
    public CommandBars getCommandBars() {
        IDispatch o = (IDispatch)this.idispatch.get("CommandBars");
        return o == null ? null : new CommandBarsImpl(o);
    }

    @Override
    public Object getOpenFilename(String fileFilter, int index, String title, boolean multiSelect) {
        Object[] args = new Object[]{fileFilter == null ? Missing.VALUE : fileFilter, index < 1 ? Missing.VALUE : new Integer(index), title == null ? Missing.VALUE : title, new Boolean(multiSelect)};
        return this.idispatch.invoke("GetOpenFilename", args);
    }

    @Override
    public String testRetrieveVersion() {
        return (String)this.idispatch.get("Version");
    }
}

