/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.driver.status;

import org.agrona.concurrent.UnsafeBuffer;
import org.agrona.concurrent.status.CountersManager;
import org.agrona.concurrent.status.UnsafeBufferPosition;

public class StreamPositionCounter {
    public static final int REGISTRATION_ID_OFFSET = 0;
    public static final int SESSION_ID_OFFSET = 8;
    public static final int STREAM_ID_OFFSET = 12;
    public static final int CHANNEL_OFFSET = 16;
    public static final int MAX_CHANNEL_LENGTH = 100;

    public static UnsafeBufferPosition allocate(String name, int typeId, CountersManager countersManager, long registrationId, int sessionId, int streamId, String channel) {
        return StreamPositionCounter.allocate(name, typeId, countersManager, registrationId, sessionId, streamId, channel, "");
    }

    public static UnsafeBufferPosition allocate(String name, int typeId, CountersManager countersManager, long registrationId, int sessionId, int streamId, String channel, String suffix) {
        String label = name + ": " + registrationId + ' ' + sessionId + ' ' + streamId + ' ' + channel + ' ' + suffix;
        int counterId = countersManager.allocate(label, typeId, buffer -> {
            buffer.putLong(0, registrationId);
            buffer.putInt(8, sessionId);
            buffer.putInt(12, streamId);
            buffer.putStringAscii(16, channel.length() > 100 ? channel.substring(0, 100) : channel);
        });
        return new UnsafeBufferPosition((UnsafeBuffer)countersManager.valuesBuffer(), counterId, countersManager);
    }

    public static String labelName(int typeId) {
        switch (typeId) {
            case 1: {
                return "pub-lmt";
            }
            case 2: {
                return "snd-pos";
            }
            case 9: {
                return "snd-lmt";
            }
            case 3: {
                return "rcv-hwm";
            }
            case 4: {
                return "sub-pos";
            }
            case 5: {
                return "rcv-pos";
            }
        }
        return "<unknown>";
    }
}

