/*
 * Decompiled with CFR 0.152.
 */
package akka.remote.artery.tcp;

import akka.actor.ActorSystem;
import akka.annotation.InternalApi;
import akka.event.LogMarker$;
import akka.event.LogSource$;
import akka.event.Logging$;
import akka.event.MarkerLoggingAdapter;
import akka.japi.Util$;
import akka.remote.artery.tcp.SSLEngineProvider;
import akka.remote.artery.tcp.SslTransportException;
import akka.remote.security.provider.AkkaProvider$;
import akka.stream.Client$;
import akka.stream.IgnoreComplete$;
import akka.stream.Server$;
import akka.stream.TLSClosing;
import akka.stream.TLSRole;
import com.typesafe.config.Config;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.SecureRandom;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.java8.JFunction0;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\u0005eg!B\u0001\u0003\u0005!Q!aF\"p]\u001aLwmU*M\u000b:<\u0017N\\3Qe>4\u0018\u000eZ3s\u0015\t\u0019A!A\u0002uGBT!!\u0002\u0004\u0002\r\u0005\u0014H/\u001a:z\u0015\t9\u0001\"\u0001\u0004sK6|G/\u001a\u0006\u0002\u0013\u0005!\u0011m[6b'\r\u00011\"\u0005\t\u0003\u0019=i\u0011!\u0004\u0006\u0002\u001d\u0005)1oY1mC&\u0011\u0001#\u0004\u0002\u0007\u0003:L(+\u001a4\u0011\u0005I\u0019R\"\u0001\u0002\n\u0005Q\u0011!!E*T\u0019\u0016sw-\u001b8f!J|g/\u001b3fe\"Aa\u0003\u0001B\u0001B\u0003%\u0001$\u0001\u0004d_:4\u0017nZ\u0002\u0001!\tIr$D\u0001\u001b\u0015\t12D\u0003\u0002\u001d;\u0005AA/\u001f9fg\u00064WMC\u0001\u001f\u0003\r\u0019w.\\\u0005\u0003Ai\u0011aaQ8oM&<\u0007\u0002\u0003\u0012\u0001\u0005\u0003\u0005\u000b\u0011B\u0012\u0002\u00071|w\r\u0005\u0002%O5\tQE\u0003\u0002'\u0011\u0005)QM^3oi&\u0011\u0001&\n\u0002\u0015\u001b\u0006\u00148.\u001a:M_\u001e<\u0017N\\4BI\u0006\u0004H/\u001a:\t\u000b)\u0002A\u0011A\u0016\u0002\rqJg.\u001b;?)\raSF\f\t\u0003%\u0001AQAF\u0015A\u0002aAQAI\u0015A\u0002\rBQA\u000b\u0001\u0005\u0002A\"\"\u0001L\u0019\t\u000bIz\u0003\u0019A\u001a\u0002\rML8\u000f^3n!\t!t'D\u00016\u0015\t1\u0004\"A\u0003bGR|'/\u0003\u00029k\tY\u0011i\u0019;peNK8\u000f^3n\u0011\u001dQ\u0004A1A\u0005\nm\n1bU*M\u0017\u0016L8\u000b^8sKV\tA\b\u0005\u0002>\u00056\taH\u0003\u0002@\u0001\u0006!A.\u00198h\u0015\u0005\t\u0015\u0001\u00026bm\u0006L!a\u0011 \u0003\rM#(/\u001b8h\u0011\u0019)\u0005\u0001)A\u0005y\u0005a1k\u0015'LKf\u001cFo\u001c:fA!9q\t\u0001b\u0001\n\u0013Y\u0014!D*T\u0019R\u0013Xo\u001d;Ti>\u0014X\r\u0003\u0004J\u0001\u0001\u0006I\u0001P\u0001\u000f'NcEK];tiN#xN]3!\u0011\u001dY\u0005A1A\u0005\nm\n1cU*M\u0017\u0016L8\u000b^8sKB\u000b7o]<pe\u0012Da!\u0014\u0001!\u0002\u0013a\u0014\u0001F*T\u0019.+\u0017p\u0015;pe\u0016\u0004\u0016m]:x_J$\u0007\u0005C\u0004P\u0001\t\u0007I\u0011B\u001e\u0002\u001dM\u001bFjS3z!\u0006\u001c8o^8sI\"1\u0011\u000b\u0001Q\u0001\nq\nqbU*M\u0017\u0016L\b+Y:to>\u0014H\r\t\u0005\b'\u0002\u0011\r\u0011\"\u0003<\u0003U\u00196\u000b\u0014+skN$8\u000b^8sKB\u000b7o]<pe\u0012Da!\u0016\u0001!\u0002\u0013a\u0014AF*T\u0019R\u0013Xo\u001d;Ti>\u0014X\rU1tg^|'\u000f\u001a\u0011\t\u000f]\u0003!\u0019!C\u00011\u0006!2k\u0015'F]\u0006\u0014G.\u001a3BY\u001e|'/\u001b;i[N,\u0012!\u0017\t\u00045\u0006ddBA.`!\taV\"D\u0001^\u0015\tqv#\u0001\u0004=e>|GOP\u0005\u0003A6\ta\u0001\u0015:fI\u00164\u0017B\u00012d\u0005\r\u0019V\r\u001e\u0006\u0003A6Aa!\u001a\u0001!\u0002\u0013I\u0016!F*T\u0019\u0016s\u0017M\u00197fI\u0006cwm\u001c:ji\"l7\u000f\t\u0005\bO\u0002\u0011\r\u0011\"\u0001<\u0003-\u00196\u000b\u0014)s_R|7m\u001c7\t\r%\u0004\u0001\u0015!\u0003=\u00031\u00196\u000b\u0014)s_R|7m\u001c7!\u0011\u001dY\u0007A1A\u0005\u0002m\n\u0001dU*M%\u0006tGm\\7Ok6\u0014WM]$f]\u0016\u0014\u0018\r^8s\u0011\u0019i\u0007\u0001)A\u0005y\u0005I2k\u0015'SC:$w.\u001c(v[\n,'oR3oKJ\fGo\u001c:!\u0011\u001dy\u0007A1A\u0005\u0002A\fadU*M%\u0016\fX/\u001b:f\u001bV$X/\u00197BkRDWM\u001c;jG\u0006$\u0018n\u001c8\u0016\u0003E\u0004\"\u0001\u0004:\n\u0005Ml!a\u0002\"p_2,\u0017M\u001c\u0005\u0007k\u0002\u0001\u000b\u0011B9\u0002?M\u001bFJU3rk&\u0014X-T;uk\u0006d\u0017)\u001e;iK:$\u0018nY1uS>t\u0007\u0005C\u0004x\u0001\t\u0007I\u0011\u00029\u0002)!{7\u000f\u001e8b[\u00164VM]5gS\u000e\fG/[8o\u0011\u0019I\b\u0001)A\u0005c\u0006)\u0002j\\:u]\u0006lWMV3sS\u001aL7-\u0019;j_:\u0004\u0003\u0002C>\u0001\u0011\u000b\u0007I\u0011\u0002?\u0002\u0015M\u001cHnQ8oi\u0016DH/F\u0001~!\rq\u00181B\u0007\u0002\u007f*!\u0011\u0011AA\u0002\u0003\r\u00198\u000f\u001c\u0006\u0005\u0003\u000b\t9!A\u0002oKRT!!!\u0003\u0002\u000b)\fg/\u0019=\n\u0007\u00055qP\u0001\u0006T'2\u001buN\u001c;fqRDq!!\u0005\u0001\t\u0013\t\u0019\"\u0001\td_:\u001cHO];di\u000e{g\u000e^3yiR\tQ\u0010C\u0004\u0002\u0018\u0001!\t!!\u0007\u0002%\r\u0014X-\u0019;f'\u0016\u001cWO]3SC:$w.\u001c\u000b\u0003\u00037\u0001B!!\b\u0002$5\u0011\u0011q\u0004\u0006\u0004\u0003C\u0001\u0015\u0001C:fGV\u0014\u0018\u000e^=\n\t\u0005\u0015\u0012q\u0004\u0002\r'\u0016\u001cWO]3SC:$w.\u001c\u0005\b\u0003S\u0001A\u0011IA\u0016\u0003U\u0019'/Z1uKN+'O^3s'NcUI\\4j]\u0016$b!!\f\u00024\u0005m\u0002c\u0001@\u00020%\u0019\u0011\u0011G@\u0003\u0013M\u001bF*\u00128hS:,\u0007\u0002CA\u001b\u0003O\u0001\r!a\u000e\u0002\u0011!|7\u000f\u001e8b[\u0016\u00042AWA\u001d\u0013\t\u00195\r\u0003\u0005\u0002>\u0005\u001d\u0002\u0019AA \u0003\u0011\u0001xN\u001d;\u0011\u00071\t\t%C\u0002\u0002D5\u00111!\u00138u\u0011\u001d\t9\u0005\u0001C!\u0003\u0013\nQc\u0019:fCR,7\t\\5f]R\u001c6\u000bT#oO&tW\r\u0006\u0004\u0002.\u0005-\u0013Q\n\u0005\t\u0003k\t)\u00051\u0001\u00028!A\u0011QHA#\u0001\u0004\ty\u0004C\u0004\u0002R\u0001!I!a\u0015\u0002\u001f\r\u0014X-\u0019;f'NcUI\\4j]\u0016$\u0002\"!\f\u0002V\u0005\u0015\u0014q\r\u0005\t\u0003/\ny\u00051\u0001\u0002Z\u0005!!o\u001c7f!\u0011\tY&!\u0019\u000e\u0005\u0005u#bAA0\u0011\u000511\u000f\u001e:fC6LA!a\u0019\u0002^\t9A\u000bT*S_2,\u0007\u0002CA\u001b\u0003\u001f\u0002\r!a\u000e\t\u0011\u0005u\u0012q\na\u0001\u0003\u007fAq!!\u0015\u0001\t\u0013\tY\u0007\u0006\u0007\u0002.\u00055\u0014qNA9\u0003g\n)\b\u0003\u0004|\u0003S\u0002\r! \u0005\t\u0003/\nI\u00071\u0001\u0002Z!A\u0011QGA5\u0001\u0004\t9\u0004\u0003\u0005\u0002>\u0005%\u0004\u0019AA \u0011)\t9(!\u001b\u0011\u0002\u0003\u0007\u0011\u0011P\u0001\bG2|7/\u001b8h!\u0011\tY&a\u001f\n\t\u0005u\u0014Q\f\u0002\u000b)2\u001b6\t\\8tS:<\u0007bBAA\u0001\u0011\u0005\u00131Q\u0001\u0014m\u0016\u0014\u0018NZ=DY&,g\u000e^*fgNLwN\u001c\u000b\u0007\u0003\u000b\u000bi*a(\u0011\u000b1\t9)a#\n\u0007\u0005%UB\u0001\u0004PaRLwN\u001c\t\u0005\u0003\u001b\u000b9J\u0004\u0003\u0002\u0010\u0006Meb\u0001/\u0002\u0012&\ta\"C\u0002\u0002\u00166\tq\u0001]1dW\u0006<W-\u0003\u0003\u0002\u001a\u0006m%!\u0003+ie><\u0018M\u00197f\u0015\r\t)*\u0004\u0005\t\u0003k\ty\b1\u0001\u00028!A\u0011\u0011UA@\u0001\u0004\t\u0019+A\u0004tKN\u001c\u0018n\u001c8\u0011\u0007y\f)+C\u0002\u0002(~\u0014!bU*M'\u0016\u001c8/[8o\u0011\u001d\tY\u000b\u0001C!\u0003[\u000b1C^3sS\u001aL8+\u001a:wKJ\u001cVm]:j_:$b!!\"\u00020\u0006E\u0006\u0002CA\u001b\u0003S\u0003\r!a\u000e\t\u0011\u0005\u0005\u0016\u0011\u0016a\u0001\u0003GC\u0011\"!.\u0001#\u0003%I!a.\u00023\r\u0014X-\u0019;f'NcUI\\4j]\u0016$C-\u001a4bk2$H%N\u000b\u0003\u0003sSC!!\u001f\u0002<.\u0012\u0011Q\u0018\t\u0005\u0003\u007f\u000bI-\u0004\u0002\u0002B*!\u00111YAc\u0003%)hn\u00195fG.,GMC\u0002\u0002H6\t!\"\u00198o_R\fG/[8o\u0013\u0011\tY-!1\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\rK\u0002\u0001\u0003\u001f\u0004B!!5\u0002V6\u0011\u00111\u001b\u0006\u0004\u0003\u000fD\u0011\u0002BAl\u0003'\u00141\"\u00138uKJt\u0017\r\\!qS\u0002")
@InternalApi
public final class ConfigSSLEngineProvider
implements SSLEngineProvider {
    private SSLContext sslContext;
    private final MarkerLoggingAdapter log;
    private final String SSLKeyStore;
    private final String SSLTrustStore;
    private final String SSLKeyStorePassword;
    private final String SSLKeyPassword;
    private final String SSLTrustStorePassword;
    private final Set<String> SSLEnabledAlgorithms;
    private final String SSLProtocol;
    private final String SSLRandomNumberGenerator;
    private final boolean SSLRequireMutualAuthentication;
    private final boolean HostnameVerification;
    private volatile boolean bitmap$0;

    private String SSLKeyStore() {
        return this.SSLKeyStore;
    }

    private String SSLTrustStore() {
        return this.SSLTrustStore;
    }

    private String SSLKeyStorePassword() {
        return this.SSLKeyStorePassword;
    }

    private String SSLKeyPassword() {
        return this.SSLKeyPassword;
    }

    private String SSLTrustStorePassword() {
        return this.SSLTrustStorePassword;
    }

    public Set<String> SSLEnabledAlgorithms() {
        return this.SSLEnabledAlgorithms;
    }

    public String SSLProtocol() {
        return this.SSLProtocol;
    }

    public String SSLRandomNumberGenerator() {
        return this.SSLRandomNumberGenerator;
    }

    public boolean SSLRequireMutualAuthentication() {
        return this.SSLRequireMutualAuthentication;
    }

    private boolean HostnameVerification() {
        return this.HostnameVerification;
    }

    private SSLContext sslContext$lzycompute() {
        ConfigSSLEngineProvider configSSLEngineProvider = this;
        synchronized (configSSLEngineProvider) {
            if (!this.bitmap$0) {
                if (this.HostnameVerification()) {
                    this.log.debug("TLS/SSL hostname verification is enabled.");
                } else {
                    this.log.warning(LogMarker$.MODULE$.Security(), "TLS/SSL hostname verification is disabled. Please configure akka.remote.artery.ssl.config-ssl-engine.hostname-verification=on and ensure the X.509 certificate on the host is correct to remove this warning. See Akka reference documentation for more information.");
                }
                this.sslContext = this.constructContext();
                this.bitmap$0 = true;
            }
        }
        return this.sslContext;
    }

    private SSLContext sslContext() {
        return !this.bitmap$0 ? this.sslContext$lzycompute() : this.sslContext;
    }

    private SSLContext constructContext() {
        SSLContext sSLContext;
        try {
            KeyManagerFactory factory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            factory.init(ConfigSSLEngineProvider.loadKeystore$1(this.SSLKeyStore(), this.SSLKeyStorePassword()), this.SSLKeyPassword().toCharArray());
            KeyManager[] keyManagers = factory.getKeyManagers();
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init(ConfigSSLEngineProvider.loadKeystore$1(this.SSLTrustStore(), this.SSLTrustStorePassword()));
            TrustManager[] trustManagers = trustManagerFactory.getTrustManagers();
            SecureRandom rng = this.createSecureRandom();
            SSLContext ctx = SSLContext.getInstance(this.SSLProtocol());
            ctx.init(keyManagers, trustManagers, rng);
            sSLContext = ctx;
        }
        catch (FileNotFoundException e) {
            throw new SslTransportException("Server SSL connection could not be established because key store could not be loaded", e);
        }
        catch (IOException e) {
            throw new SslTransportException("Server SSL connection could not be established because: " + e.getMessage(), e);
        }
        catch (GeneralSecurityException e) {
            throw new SslTransportException("Server SSL connection could not be established because SSL context could not be constructed", e);
        }
        return sSLContext;
    }

    public SecureRandom createSecureRandom() {
        SecureRandom secureRandom;
        String string = this.SSLRandomNumberGenerator();
        boolean bl = "AES128CounterSecureRNG".equals(string) ? true : "AES256CounterSecureRNG".equals(string);
        if (bl) {
            this.log.debug("SSL random number generator set to: {}", (Object)string);
            secureRandom = SecureRandom.getInstance(string, AkkaProvider$.MODULE$);
        } else {
            boolean bl2 = "SHA1PRNG".equals(string) ? true : "NativePRNG".equals(string);
            if (bl2) {
                this.log.debug("SSL random number generator set to: {}", (Object)string);
                secureRandom = SecureRandom.getInstance(string);
            } else if ("".equals(string)) {
                this.log.debug("SSLRandomNumberGenerator not specified, falling back to SecureRandom");
                secureRandom = new SecureRandom();
            } else {
                this.log.warning(LogMarker$.MODULE$.Security(), "Unknown SSLRandomNumberGenerator [{}] falling back to SecureRandom", (Object)string);
                secureRandom = new SecureRandom();
            }
        }
        SecureRandom rng = secureRandom;
        rng.nextInt();
        return rng;
    }

    @Override
    public SSLEngine createServerSSLEngine(String hostname, int port) {
        return this.createSSLEngine((TLSRole)Server$.MODULE$, hostname, port);
    }

    @Override
    public SSLEngine createClientSSLEngine(String hostname, int port) {
        return this.createSSLEngine((TLSRole)Client$.MODULE$, hostname, port);
    }

    private SSLEngine createSSLEngine(TLSRole role, String hostname, int port) {
        return this.createSSLEngine(this.sslContext(), role, hostname, port, this.createSSLEngine$default$5());
    }

    private SSLEngine createSSLEngine(SSLContext sslContext, TLSRole role, String hostname, int port, TLSClosing closing) {
        SSLEngine engine;
        block1: {
            engine = sslContext.createSSLEngine(hostname, port);
            if (this.HostnameVerification()) {
                SSLParameters sslParams = sslContext.getDefaultSSLParameters();
                sslParams.setEndpointIdentificationAlgorithm("HTTPS");
                engine.setSSLParameters(sslParams);
            }
            TLSRole tLSRole = role;
            Client$ client$ = Client$.MODULE$;
            engine.setUseClientMode(!(tLSRole != null ? !tLSRole.equals(client$) : client$ != null));
            engine.setEnabledCipherSuites((String[])this.SSLEnabledAlgorithms().toArray(ClassTag$.MODULE$.apply(String.class)));
            engine.setEnabledProtocols((String[])((Object[])new String[]{this.SSLProtocol()}));
            TLSRole tLSRole2 = role;
            Client$ client$2 = Client$.MODULE$;
            if (!(tLSRole2 == null ? client$2 != null : !tLSRole2.equals(client$2)) || !this.SSLRequireMutualAuthentication()) break block1;
            engine.setNeedClientAuth(true);
        }
        return engine;
    }

    private TLSClosing createSSLEngine$default$5() {
        return IgnoreComplete$.MODULE$;
    }

    @Override
    public Option<Throwable> verifyClientSession(String hostname, SSLSession session) {
        return None$.MODULE$;
    }

    @Override
    public Option<Throwable> verifyServerSession(String hostname, SSLSession session) {
        return None$.MODULE$;
    }

    /*
     * WARNING - void declaration
     */
    private static final KeyStore loadKeystore$1(String filename, String password) {
        void var2_2;
        KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        InputStream fin = Files.newInputStream(Paths.get(filename, new String[0]), new OpenOption[0]);
        try {
            keyStore.load(fin, password.toCharArray());
        }
        finally {
            Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> fin.close());
        }
        return var2_2;
    }

    public ConfigSSLEngineProvider(Config config, MarkerLoggingAdapter log) {
        this.log = log;
        this.SSLKeyStore = config.getString("key-store");
        this.SSLTrustStore = config.getString("trust-store");
        this.SSLKeyStorePassword = config.getString("key-store-password");
        this.SSLKeyPassword = config.getString("key-password");
        this.SSLTrustStorePassword = config.getString("trust-store-password");
        this.SSLEnabledAlgorithms = (Set)Util$.MODULE$.immutableSeq((Iterable)config.getStringList("enabled-algorithms")).to(Set$.MODULE$.canBuildFrom());
        this.SSLProtocol = config.getString("protocol");
        this.SSLRandomNumberGenerator = config.getString("random-number-generator");
        this.SSLRequireMutualAuthentication = config.getBoolean("require-mutual-authentication");
        this.HostnameVerification = config.getBoolean("hostname-verification");
    }

    public ConfigSSLEngineProvider(ActorSystem system) {
        this(system.settings().config().getConfig("akka.remote.artery.ssl.config-ssl-engine"), Logging$.MODULE$.withMarker(system, (Object)ConfigSSLEngineProvider.class.getName(), LogSource$.MODULE$.fromString()));
    }
}

