/*
 * Decompiled with CFR 0.152.
 */
package akka.remote.artery.compress;

import akka.actor.Address;
import akka.event.Logging$;
import akka.event.LoggingAdapter;
import akka.remote.artery.ArterySettings;
import akka.remote.artery.InboundContext;
import akka.remote.artery.OutboundContext;
import akka.remote.artery.compress.CompressionTable;
import akka.remote.artery.compress.CountMinSketch;
import akka.remote.artery.compress.DecompressionTable;
import akka.remote.artery.compress.DecompressionTable$;
import akka.remote.artery.compress.InboundCompression$;
import akka.remote.artery.compress.InboundCompression$Tables$;
import akka.remote.artery.compress.TopHeavyHitters;
import akka.remote.artery.compress.UnknownCompressedIdException;
import akka.util.OptionVal;
import akka.util.OptionVal$;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Builder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0001\r\rtAB\u0001\u0003\u0011\u00031!\"\u0001\nJ]\n|WO\u001c3D_6\u0004(/Z:tS>t'BA\u0002\u0005\u0003!\u0019w.\u001c9sKN\u001c(BA\u0003\u0007\u0003\u0019\t'\u000f^3ss*\u0011q\u0001C\u0001\u0007e\u0016lw\u000e^3\u000b\u0003%\tA!Y6lCB\u00111\u0002D\u0007\u0002\u0005\u00191QB\u0001E\u0001\r9\u0011!#\u00138c_VtGmQ8naJ,7o]5p]N\u0011Ab\u0004\t\u0003!Mi\u0011!\u0005\u0006\u0002%\u0005)1oY1mC&\u0011A#\u0005\u0002\u0007\u0003:L(+\u001a4\t\u000bYaA\u0011\u0001\r\u0002\rqJg.\u001b;?\u0007\u0001!\u0012A\u0003\u0005\b51\u0011\r\u0011\"\u0002\u001c\u0003MYU-\u001a9PY\u0012$\u0016M\u00197fg:+XNY3s+\u0005ar\"A\u000f\u001e\u0003\rAaa\b\u0007!\u0002\u001ba\u0012\u0001F&fKB|E\u000e\u001a+bE2,7OT;nE\u0016\u0014\beB\u0003\"\u0019!\u0005!%\u0001\u0004UC\ndWm\u001d\t\u0003G\u0011j\u0011\u0001\u0004\u0004\u0006K1A\tA\n\u0002\u0007)\u0006\u0014G.Z:\u0014\u0007\u0011zq\u0005\u0005\u0002\u0011Q%\u0011\u0011&\u0005\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0005\u0006-\u0011\"\ta\u000b\u000b\u0002E!)Q\u0006\nC\u0001]\u0005)Q-\u001c9usV\u0019q&!6\u0016\u0003A\u0002BaI\u0019\u0002T\u001a!Q\u0005\u0004\"3+\t\u00194j\u0005\u00032\u001fQ:\u0003C\u0001\t6\u0013\t1\u0014CA\u0004Qe>$Wo\u0019;\t\u0011a\n$Q3A\u0005\u0002e\n\u0011b\u001c7e)\u0006\u0014G.Z:\u0016\u0003i\u00022aO\"G\u001d\ta\u0014I\u0004\u0002>\u00016\taH\u0003\u0002@/\u00051AH]8pizJ\u0011AE\u0005\u0003\u0005F\tq\u0001]1dW\u0006<W-\u0003\u0002E\u000b\n!A*[:u\u0015\t\u0011\u0015\u0003E\u0002\f\u000f&K!\u0001\u0013\u0002\u0003%\u0011+7m\\7qe\u0016\u001c8/[8o)\u0006\u0014G.\u001a\t\u0003\u0015.c\u0001\u0001B\u0003Mc\t\u0007QJA\u0001U#\tq\u0015\u000b\u0005\u0002\u0011\u001f&\u0011\u0001+\u0005\u0002\b\u001d>$\b.\u001b8h!\t\u0001\"+\u0003\u0002T#\t\u0019\u0011I\\=\t\u0011U\u000b$\u0011#Q\u0001\ni\n!b\u001c7e)\u0006\u0014G.Z:!\u0011!9\u0016G!f\u0001\n\u0003A\u0016aC1di&4X\rV1cY\u0016,\u0012A\u0012\u0005\t5F\u0012\t\u0012)A\u0005\r\u0006a\u0011m\u0019;jm\u0016$\u0016M\u00197fA!AA,\rBK\u0002\u0013\u0005\u0001,A\u0005oKb$H+\u00192mK\"Aa,\rB\tB\u0003%a)\u0001\u0006oKb$H+\u00192mK\u0002B\u0001\u0002Y\u0019\u0003\u0016\u0004%\t!Y\u0001\u0018C\u00124XM\u001d;jg\u0016lWM\u001c;J]B\u0013xn\u001a:fgN,\u0012A\u0019\t\u0004!\r,\u0017B\u00013\u0012\u0005\u0019y\u0005\u000f^5p]B\u00191BZ%\n\u0005\u001d\u0014!\u0001E\"p[B\u0014Xm]:j_:$\u0016M\u00197f\u0011!I\u0017G!E!\u0002\u0013\u0011\u0017\u0001G1em\u0016\u0014H/[:f[\u0016tG/\u00138Qe><'/Z:tA!A1.\rBK\u0002\u0013\u0005A.A\u0007lK\u0016\u0004x\n\u001c3UC\ndWm]\u000b\u0002[B\u0011\u0001C\\\u0005\u0003_F\u00111!\u00138u\u0011!\t\u0018G!E!\u0002\u0013i\u0017AD6fKB|E\u000e\u001a+bE2,7\u000f\t\u0005\u0006-E\"\ta\u001d\u000b\u0007iV4x\u000f_=\u0011\u0007\r\n\u0014\nC\u00039e\u0002\u0007!\bC\u0003Xe\u0002\u0007a\tC\u0003]e\u0002\u0007a\tC\u0003ae\u0002\u0007!\rC\u0003le\u0002\u0007Q\u000eC\u0003|c\u0011\u0005A0A\u0006tK2,7\r\u001e+bE2,GcA?\u0002\bA!a0a\u0001G\u001b\u0005y(bAA\u0001\u0011\u0005!Q\u000f^5m\u0013\r\t)a \u0002\n\u001fB$\u0018n\u001c8WC2Da!!\u0003{\u0001\u0004i\u0017a\u0002<feNLwN\u001c\u0005\b\u0003\u001b\tD\u0011AA\b\u0003M\u0019H/\u0019:u+NLgn\u001a(fqR$\u0016M\u00197f)\u0005!\b\"CA\nc\u0005\u0005I\u0011AA\u000b\u0003\u0011\u0019w\u000e]=\u0016\t\u0005]\u0011Q\u0004\u000b\r\u00033\ty\"!\n\u0002(\u0005%\u0012q\u0006\t\u0005GE\nY\u0002E\u0002K\u0003;!a\u0001TA\t\u0005\u0004i\u0005\"\u0003\u001d\u0002\u0012A\u0005\t\u0019AA\u0011!\u0011Y4)a\t\u0011\t-9\u00151\u0004\u0005\n/\u0006E\u0001\u0013!a\u0001\u0003GA\u0011\u0002XA\t!\u0003\u0005\r!a\t\t\u0013\u0001\f\t\u0002%AA\u0002\u0005-\u0002\u0003\u0002\td\u0003[\u0001Ba\u00034\u0002\u001c!A1.!\u0005\u0011\u0002\u0003\u0007Q\u000eC\u0005\u00024E\n\n\u0011\"\u0001\u00026\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\nT\u0003BA\u001c\u0003\u001b*\"!!\u000f+\u0007i\nYd\u000b\u0002\u0002>A!\u0011qHA%\u001b\t\t\tE\u0003\u0003\u0002D\u0005\u0015\u0013!C;oG\",7m[3e\u0015\r\t9%E\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA&\u0003\u0003\u0012\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\t\u0019a\u0015\u0011\u0007b\u0001\u001b\"I\u0011\u0011K\u0019\u0012\u0002\u0013\u0005\u00111K\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133+\u0011\t)&!\u0017\u0016\u0005\u0005]#f\u0001$\u0002<\u00111A*a\u0014C\u00025C\u0011\"!\u00182#\u0003%\t!a\u0018\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%gU!\u0011QKA1\t\u0019a\u00151\fb\u0001\u001b\"I\u0011QM\u0019\u0012\u0002\u0013\u0005\u0011qM\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00135+\u0011\tI'!\u001c\u0016\u0005\u0005-$f\u00012\u0002<\u00111A*a\u0019C\u00025C\u0011\"!\u001d2#\u0003%\t!a\u001d\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%kU!\u0011QOA=+\t\t9HK\u0002n\u0003w!a\u0001TA8\u0005\u0004i\u0005\"CA?c\u0005\u0005I\u0011IA@\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011\u0011\u0011\u0011\t\u0005\u0003\u0007\u000bi)\u0004\u0002\u0002\u0006*!\u0011qQAE\u0003\u0011a\u0017M\\4\u000b\u0005\u0005-\u0015\u0001\u00026bm\u0006LA!a$\u0002\u0006\n11\u000b\u001e:j]\u001eD\u0001\"a%2\u0003\u0003%\t\u0001\\\u0001\raJ|G-^2u\u0003JLG/\u001f\u0005\n\u0003/\u000b\u0014\u0011!C\u0001\u00033\u000ba\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000fF\u0002R\u00037C\u0011\"!(\u0002\u0016\u0006\u0005\t\u0019A7\u0002\u0007a$\u0013\u0007C\u0005\u0002\"F\n\t\u0011\"\u0011\u0002$\u0006y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0002&B)\u0011qUAW#6\u0011\u0011\u0011\u0016\u0006\u0004\u0003W\u000b\u0012AC2pY2,7\r^5p]&!\u0011qVAU\u0005!IE/\u001a:bi>\u0014\b\"CAZc\u0005\u0005I\u0011AA[\u0003!\u0019\u0017M\\#rk\u0006dG\u0003BA\\\u0003{\u00032\u0001EA]\u0013\r\tY,\u0005\u0002\b\u0005>|G.Z1o\u0011%\ti*!-\u0002\u0002\u0003\u0007\u0011\u000bC\u0005\u0002BF\n\t\u0011\"\u0011\u0002D\u0006A\u0001.Y:i\u0007>$W\rF\u0001n\u0011%\t9-MA\u0001\n\u0003\nI-\u0001\u0005u_N#(/\u001b8h)\t\t\t\tC\u0005\u0002NF\n\t\u0011\"\u0011\u0002P\u00061Q-];bYN$B!a.\u0002R\"I\u0011QTAf\u0003\u0003\u0005\r!\u0015\t\u0004\u0015\u0006UG!\u0002'-\u0005\u0004i\u0005\"CAmI\u0005\u0005I\u0011QAn\u0003\u0015\t\u0007\u000f\u001d7z+\u0011\ti.a9\u0015\u0019\u0005}\u0017Q]Av\u0003[\fy/!>\u0011\t\r\n\u0014\u0011\u001d\t\u0004\u0015\u0006\rHA\u0002'\u0002X\n\u0007Q\nC\u00049\u0003/\u0004\r!a:\u0011\tm\u001a\u0015\u0011\u001e\t\u0005\u0017\u001d\u000b\t\u000fC\u0004X\u0003/\u0004\r!!;\t\u000fq\u000b9\u000e1\u0001\u0002j\"9\u0001-a6A\u0002\u0005E\b\u0003\u0002\td\u0003g\u0004Ba\u00034\u0002b\"11.a6A\u00025D\u0011\"!?%\u0003\u0003%\t)a?\u0002\u000fUt\u0017\r\u001d9msV!\u0011Q B\u0007)\u0011\tyPa\u0005\u0011\tA\u0019'\u0011\u0001\t\r!\t\r!q\u0001B\u0005\u0005\u0013\u0011y!\\\u0005\u0004\u0005\u000b\t\"A\u0002+va2,W\u0007\u0005\u0003<\u0007\n%\u0001\u0003B\u0006H\u0005\u0017\u00012A\u0013B\u0007\t\u0019a\u0015q\u001fb\u0001\u001bB!\u0001c\u0019B\t!\u0011YaMa\u0003\t\u0015\tU\u0011q_A\u0001\u0002\u0004\u00119\"A\u0002yIA\u0002BaI\u0019\u0003\f!I!1\u0004\u0013\u0002\u0002\u0013%!QD\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0003 A!\u00111\u0011B\u0011\u0013\u0011\u0011\u0019#!\"\u0003\r=\u0013'.Z2u\r\u001di!!!\u0001\u0007\u0005O)BA!\u000b\u0003\u0004N\u0019!QE\b\t\u0017\t5\"Q\u0005BC\u0002\u0013\u0005!qF\u0001\u0004Y><WC\u0001B\u0019!\u0011\u0011\u0019D!\u000f\u000e\u0005\tU\"b\u0001B\u001c\u0011\u0005)QM^3oi&!!1\bB\u001b\u00059aunZ4j]\u001e\fE-\u00199uKJD1Ba\u0010\u0003&\t\u0005\t\u0015!\u0003\u00032\u0005!An\\4!\u0011-\u0011\u0019E!\n\u0003\u0006\u0004%\tA!\u0012\u0002\u0011M,G\u000f^5oON,\"Aa\u0012\u0011\t\t%#\u0011\u000b\b\u0005\u0005\u0017\u0012i%D\u0001\u0005\u0013\r\u0011y\u0005B\u0001\u000f\u0003J$XM]=TKR$\u0018N\\4t\u0013\u0011\u0011\u0019F!\u0016\u0003\u0017\r{W\u000e\u001d:fgNLwN\u001c\u0006\u0004\u0005\u001f\"\u0001b\u0003B-\u0005K\u0011\t\u0011)A\u0005\u0005\u000f\n\u0011b]3ui&twm\u001d\u0011\t\u0017\tu#Q\u0005BC\u0002\u0013\u0005!qL\u0001\n_JLw-\u001b8VS\u0012,\"A!\u0019\u0011\u0007A\u0011\u0019'C\u0002\u0003fE\u0011A\u0001T8oO\"Y!\u0011\u000eB\u0013\u0005\u0003\u0005\u000b\u0011\u0002B1\u0003)y'/[4j]VKG\r\t\u0005\f\u0005[\u0012)C!A!\u0002\u0013\u0011y'\u0001\bj]\n|WO\u001c3D_:$X\r\u001f;\u0011\t\t-#\u0011O\u0005\u0004\u0005g\"!AD%oE>,h\u000eZ\"p]R,\u0007\u0010\u001e\u0005\f\u0005o\u0012)C!b\u0001\n\u0003\u0011I(\u0001\u0007iK\u00064\u0018\u0010S5ui\u0016\u00148/\u0006\u0002\u0003|A)1B! \u0003\u0002&\u0019!q\u0010\u0002\u0003\u001fQ{\u0007\u000fS3bmfD\u0015\u000e\u001e;feN\u00042A\u0013BB\t\u001da%Q\u0005b\u0001\u0005\u000b\u000b2Aa\"R!\r\u0001\"\u0011R\u0005\u0004\u0005\u0017\u000b\"\u0001\u0002(vY2D1Ba$\u0003&\t\u0005\t\u0015!\u0003\u0003|\u0005i\u0001.Z1ws\"KG\u000f^3sg\u0002BqA\u0006B\u0013\t\u0003\u0011\u0019\n\u0006\u0007\u0003\u0016\n]%\u0011\u0014BN\u0005;\u0013y\nE\u0003\f\u0005K\u0011\t\t\u0003\u0005\u0003.\tE\u0005\u0019\u0001B\u0019\u0011!\u0011\u0019E!%A\u0002\t\u001d\u0003\u0002\u0003B/\u0005#\u0003\rA!\u0019\t\u0011\t5$\u0011\u0013a\u0001\u0005_B\u0001Ba\u001e\u0003\u0012\u0002\u0007!1\u0010\u0005\n\u0005G\u0013)\u0003)Q\u0005\u0005K\u000ba\u0001^1cY\u0016\u001c\b#\u0002BTc\t\u0005eBA\u0006\u0001\u0011%\u0011YK!\n!B\u0013\t9,A\u0003bY&4X\r\u000b\u0003\u0003*\n=\u0006c\u0001\t\u00032&\u0019!1W\t\u0003\u0011Y|G.\u0019;jY\u0016D\u0001Ba.\u0003&\u0001\u0006K!\\\u0001\fe\u0016\u001cXM\u001c3D_VtG\u000fC\u0005\u0003<\n\u0015\u0002\u0015!\u0003\u0003>\u0006\u00191-\\:\u0011\u0007-\u0011y,C\u0002\u0003B\n\u0011abQ8v]Rl\u0015N\\*lKR\u001c\u0007\u000e\u0003\u0005\u0003F\n\u0015b\u0011\u0001Bd\u0003)!WmY8naJ,7o\u001d\u000b\u0007\u0005\u0013\u0014YM!6\u0011\u000by\f\u0019A!!\t\u0011\t5'1\u0019a\u0001\u0005\u001f\fA#\u001b8d_6Lgn\u001a+bE2,g+\u001a:tS>t\u0007c\u0001\t\u0003R&\u0019!1[\t\u0003\t\tKH/\u001a\u0005\b\u0005/\u0014\u0019\r1\u0001n\u0003\rIG\r\u001f\u0005\t\u00057\u0014)\u0003\"\u0002\u0003^\u0006\u0011B-Z2p[B\u0014Xm]:J]R,'O\\1m)!\u0011IMa8\u0003b\n\r\b\u0002\u0003Bg\u00053\u0004\rAa4\t\u000f\t]'\u0011\u001ca\u0001[\"9!Q\u001dBm\u0001\u0004i\u0017AD1ui\u0016l\u0007\u000f^\"pk:$XM\u001d\u0015\u0005\u00053\u0014I\u000f\u0005\u0003\u0003l\n5XBAA#\u0013\u0011\u0011y/!\u0012\u0003\u000fQ\f\u0017\u000e\u001c:fG\"A!1\u001fB\u0013\t\u000b\u0011)0\u0001\u000bd_:4\u0017N]7BIZ,'\u000f^5tK6,g\u000e\u001e\u000b\u0005\u0005o\u0014i\u0010E\u0002\u0011\u0005sL1Aa?\u0012\u0005\u0011)f.\u001b;\t\u0011\t}(\u0011\u001fa\u0001\u0005\u001f\fA\u0002^1cY\u00164VM]:j_:D\u0001ba\u0001\u0003&\u0011\u00051QA\u0001\nS:\u001c'/Z7f]R$\u0002Ba>\u0004\b\r]11\u0004\u0005\t\u0007\u0013\u0019\t\u00011\u0001\u0004\f\u0005i!/Z7pi\u0016\fE\r\u001a:fgN\u0004Ba!\u0004\u0004\u00145\u00111q\u0002\u0006\u0004\u0007#A\u0011!B1di>\u0014\u0018\u0002BB\u000b\u0007\u001f\u0011q!\u00113ee\u0016\u001c8\u000f\u0003\u0005\u0004\u001a\r\u0005\u0001\u0019\u0001BA\u0003\u00151\u0018\r\\;f\u0011!\u0019ib!\u0001A\u0002\t\u0005\u0014!\u00018\t\u0011\r\u0005\"Q\u0005C\u0005\u0007G\t\u0001%\u00193e\u0003:$7\t[3dW&3\u0007.Z1ws\"KG\u000f^3s\t\u0016$Xm\u0019;fIR1\u0011qWB\u0013\u0007OA\u0001b!\u0007\u0004 \u0001\u0007!\u0011\u0011\u0005\t\u0007S\u0019y\u00021\u0001\u0003b\u0005)1m\\;oi\"I1Q\u0006B\u0013\t\u000311qF\u0001\u001aeVtg*\u001a=u)\u0006\u0014G.Z!em\u0016\u0014H/[:f[\u0016tG\u000f\u0006\u0002\u0003x\"A11\u0007B\u0013\r#\u0019)$A\rbIZ,'\u000f^5tK\u000e{W\u000e\u001d:fgNLwN\u001c+bE2,GC\u0002B|\u0007o\u0019\t\u0005\u0003\u0005\u0004:\rE\u0002\u0019AB\u001e\u0003-\t7o]8dS\u0006$\u0018n\u001c8\u0011\t\t-3QH\u0005\u0004\u0007\u007f!!aD(vi\n|WO\u001c3D_:$X\r\u001f;\t\u0011\r\r3\u0011\u0007a\u0001\u0007\u000b\nQ\u0001^1cY\u0016\u0004Ba\u00034\u0003\u0002\"A1\u0011\nB\u0013\t\u0013\u0019Y%A\u0010qe\u0016\u0004\u0018M]3D_6\u0004(/Z:tS>t\u0017\t\u001a<feRL7/Z7f]R$Ba!\u0012\u0004N!A1qJB$\u0001\u0004\u0011y-\u0001\toKb$H+\u00192mKZ+'o]5p]\"A\u0011q\u0019B\u0013\t\u0003\u001a\u0019\u0006\u0006\u0002\u0004VA!1qKB0\u001d\u0011\u0019Ifa\u0017\u0011\u0005u\n\u0012bAB/#\u00051\u0001K]3eK\u001aLA!a$\u0004b)\u00191QL\t")
public abstract class InboundCompression<T> {
    private final LoggingAdapter log;
    private final ArterySettings.Compression settings;
    private final long originUid;
    private final InboundContext inboundContext;
    private final TopHeavyHitters<T> heavyHitters;
    private Tables<T> tables;
    private volatile boolean alive;
    private int resendCount;
    private final CountMinSketch cms;

    public static int KeepOldTablesNumber() {
        return InboundCompression$.MODULE$.KeepOldTablesNumber();
    }

    public LoggingAdapter log() {
        return this.log;
    }

    public ArterySettings.Compression settings() {
        return this.settings;
    }

    public long originUid() {
        return this.originUid;
    }

    public TopHeavyHitters<T> heavyHitters() {
        return this.heavyHitters;
    }

    public abstract T decompress(byte var1, int var2);

    public final T decompressInternal(byte incomingTableVersion, int idx, int attemptCounter) {
        Object object;
        block5: {
            Object object2;
            block6: {
                byte activeVersion;
                Tables<T> current;
                while (true) {
                    if (attemptCounter > 2) {
                        throw new IllegalStateException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unable to decompress ", " from table ", ". Internal tables: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)idx), BoxesRunTime.boxToByte((byte)incomingTableVersion), this.tables})));
                    }
                    current = this.tables;
                    activeVersion = current.activeTable().version();
                    if (incomingTableVersion == DecompressionTable$.MODULE$.DisabledVersion()) {
                        OptionVal$.MODULE$.None();
                        object = null;
                        break block5;
                    }
                    DecompressionTable<T> decompressionTable = current.selectTable(incomingTableVersion);
                    DecompressionTable decompressionTable2 = (DecompressionTable)OptionVal.Some$.MODULE$.unapply(decompressionTable);
                    if (!OptionVal$.MODULE$.isEmpty$extension((Object)decompressionTable2)) {
                        DecompressionTable selectedTable = (DecompressionTable)OptionVal$.MODULE$.get$extension((Object)decompressionTable2);
                        Object value = selectedTable.get(idx);
                        if (value == null) {
                            throw new UnknownCompressedIdException(idx);
                        }
                        object2 = OptionVal.Some$.MODULE$.apply(value);
                        break block6;
                    }
                    if (!InboundCompression.incomingVersionIsAdvertisementInProgress$1(incomingTableVersion, current)) break;
                    this.log().debug("Received first value from originUid [{}] compressed using the advertised compression table, flipping to it (version: {})", (Object)BoxesRunTime.boxToLong((long)this.originUid()), (Object)BoxesRunTime.boxToByte((byte)current.nextTable().version()));
                    this.confirmAdvertisement(incomingTableVersion);
                    ++attemptCounter;
                }
                this.log().warning("Inbound message from originUid [{}] is using unknown compression table version. It may have been sent with compression table built for previous incarnation of this system. Versions activeTable: {}, nextTable: {}, incomingTable: {}", (Object)BoxesRunTime.boxToLong((long)this.originUid()), (Object)BoxesRunTime.boxToByte((byte)activeVersion), (Object)BoxesRunTime.boxToByte((byte)current.nextTable().version()), (Object)BoxesRunTime.boxToByte((byte)incomingTableVersion));
                OptionVal$.MODULE$.None();
                object2 = null;
            }
            object = object2;
        }
        return (T)object;
    }

    /*
     * Enabled aggressive block sorting
     */
    public final void confirmAdvertisement(byte tableVersion) {
        CompressionTable inProgress;
        boolean bl = false;
        Some some = null;
        Option<CompressionTable<T>> option = this.tables.advertisementInProgress();
        if (option instanceof Some) {
            bl = true;
            some = (Some)option;
            CompressionTable inProgress2 = (CompressionTable)some.value();
            if (tableVersion == inProgress2.version()) {
                this.tables = this.tables.startUsingNextTable();
                this.log().debug("Confirmed compression table version [{}] for originUid [{}]", (Object)BoxesRunTime.boxToByte((byte)tableVersion), (Object)BoxesRunTime.boxToLong((long)this.originUid()));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            }
        }
        if (bl && tableVersion != (inProgress = (CompressionTable)some.value()).version()) {
            this.log().debug("Confirmed compression table version [{}] for originUid [{}] but other version in progress [{}]", (Object)BoxesRunTime.boxToByte((byte)tableVersion), (Object)BoxesRunTime.boxToLong((long)this.originUid()), (Object)BoxesRunTime.boxToByte((byte)inProgress.version()));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        if (!None$.MODULE$.equals(option)) throw new MatchError(option);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public void increment(Address remoteAddress, T value, long n) {
        long count = this.cms.addObjectAndEstimateCount(value, n);
        this.addAndCheckIfheavyHitterDetected(value, count);
        this.alive = true;
    }

    private boolean addAndCheckIfheavyHitterDetected(T value, long count) {
        return this.heavyHitters().update(value, count);
    }

    public void runNextTableAdvertisement() {
        Option<CompressionTable<T>> option = this.tables.advertisementInProgress();
        if (None$.MODULE$.equals(option)) {
            OutboundContext outboundContext = this.inboundContext.association(this.originUid());
            OutboundContext outboundContext2 = (OutboundContext)OptionVal.Some$.MODULE$.unapply((Object)outboundContext);
            if (!OptionVal$.MODULE$.isEmpty$extension((Object)outboundContext2)) {
                BoxedUnit boxedUnit;
                OutboundContext association = (OutboundContext)OptionVal$.MODULE$.get$extension((Object)outboundContext2);
                if (this.alive && association.isOrdinaryMessageStreamActive()) {
                    CompressionTable<T> table = this.prepareCompressionAdvertisement(this.tables.nextTable().version());
                    Tables<T> qual$3 = this.tables;
                    DecompressionTable<T> x$11 = table.invert();
                    Some x$12 = new Some(table);
                    List<DecompressionTable<T>> x$13 = qual$3.copy$default$1();
                    DecompressionTable<T> x$14 = qual$3.copy$default$2();
                    int x$15 = qual$3.copy$default$5();
                    Tables<T> nextState = qual$3.copy(x$13, x$14, x$11, (Option<CompressionTable<T>>)x$12, x$15);
                    this.tables = nextState;
                    this.alive = false;
                    this.resendCount = 0;
                    this.advertiseCompressionTable(association, table);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    this.log().debug("{} for originUid [{}] not changed, no need to advertise same.", (Object)Logging$.MODULE$.simpleName(this.tables.activeTable()), (Object)BoxesRunTime.boxToLong((long)this.originUid()));
                    boxedUnit = BoxedUnit.UNIT;
                }
                BoxedUnit boxedUnit2 = boxedUnit;
            } else {
                OptionVal$.MODULE$.None();
                OutboundContext outboundContext3 = outboundContext;
                if (!(null != null ? !((Object)null).equals(outboundContext3) : outboundContext3 != null)) {
                    this.log().debug("No Association for originUid [{}] yet, unable to advertise compression table.", (Object)BoxesRunTime.boxToLong((long)this.originUid()));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    throw new MatchError((Object)new OptionVal((Object)outboundContext));
                }
            }
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (option instanceof Some) {
            BoxedUnit boxedUnit;
            Some some = (Some)option;
            CompressionTable inProgress = (CompressionTable)some.value();
            ++this.resendCount;
            if (this.resendCount <= 5) {
                OutboundContext outboundContext = this.inboundContext.association(this.originUid());
                OutboundContext outboundContext4 = (OutboundContext)OptionVal.Some$.MODULE$.unapply((Object)outboundContext);
                if (!OptionVal$.MODULE$.isEmpty$extension((Object)outboundContext4)) {
                    OutboundContext association = (OutboundContext)OptionVal$.MODULE$.get$extension((Object)outboundContext4);
                    this.log().debug("Advertisement in progress for originUid [{}] version {}, resending", (Object)BoxesRunTime.boxToLong((long)this.originUid()), (Object)BoxesRunTime.boxToByte((byte)inProgress.version()));
                    this.advertiseCompressionTable(association, inProgress);
                    BoxedUnit boxedUnit3 = BoxedUnit.UNIT;
                } else {
                    OptionVal$.MODULE$.None();
                    OutboundContext outboundContext5 = outboundContext;
                    if (!(null != null ? !((Object)null).equals(outboundContext5) : outboundContext5 != null)) {
                        BoxedUnit boxedUnit4 = BoxedUnit.UNIT;
                    } else {
                        throw new MatchError((Object)new OptionVal((Object)outboundContext));
                    }
                }
                boxedUnit = BoxedUnit.UNIT;
            } else {
                this.log().debug("Advertisement in progress for originUid [{}] version {} but no confirmation after retries.", (Object)BoxesRunTime.boxToLong((long)this.originUid()), (Object)BoxesRunTime.boxToByte((byte)inProgress.version()));
                this.confirmAdvertisement(inProgress.version());
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit5 = boxedUnit;
        } else {
            throw new MatchError(option);
        }
    }

    public abstract void advertiseCompressionTable(OutboundContext var1, CompressionTable<T> var2);

    private CompressionTable<T> prepareCompressionAdvertisement(byte nextTableVersion) {
        Builder mb = Predef$.MODULE$.Map().newBuilder();
        mb.$plus$plus$eq((TraversableOnce)this.heavyHitters().iterator().zipWithIndex());
        Map mappings = (Map)mb.result();
        return new CompressionTable(this.originUid(), nextTableVersion, mappings);
    }

    public String toString() {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "(countMinSketch: ", ", heavyHitters: ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Logging$.MODULE$.simpleName(this.getClass()), this.cms, this.heavyHitters()}));
    }

    private static final boolean incomingVersionIsAdvertisementInProgress$1(byte incomingTableVersion, Tables current$1) {
        return current$1.advertisementInProgress().isDefined() && incomingTableVersion == ((CompressionTable)current$1.advertisementInProgress().get()).version();
    }

    public InboundCompression(LoggingAdapter log, ArterySettings.Compression settings, long originUid, InboundContext inboundContext, TopHeavyHitters<T> heavyHitters) {
        this.log = log;
        this.settings = settings;
        this.originUid = originUid;
        this.inboundContext = inboundContext;
        this.heavyHitters = heavyHitters;
        this.tables = InboundCompression$Tables$.MODULE$.empty();
        this.alive = true;
        this.resendCount = 0;
        this.cms = new CountMinSketch(16, 1024, (int)System.currentTimeMillis());
        log.debug("Initializing {} for originUid [{}]", (Object)Logging$.MODULE$.simpleName(this.getClass()), (Object)BoxesRunTime.boxToLong((long)originUid));
    }

    public static final class Tables<T>
    implements Product,
    Serializable {
        private final List<DecompressionTable<T>> oldTables;
        private final DecompressionTable<T> activeTable;
        private final DecompressionTable<T> nextTable;
        private final Option<CompressionTable<T>> advertisementInProgress;
        private final int keepOldTables;

        public List<DecompressionTable<T>> oldTables() {
            return this.oldTables;
        }

        public DecompressionTable<T> activeTable() {
            return this.activeTable;
        }

        public DecompressionTable<T> nextTable() {
            return this.nextTable;
        }

        public Option<CompressionTable<T>> advertisementInProgress() {
            return this.advertisementInProgress;
        }

        public int keepOldTables() {
            return this.keepOldTables;
        }

        /*
         * WARNING - void declaration
         */
        public DecompressionTable<T> selectTable(int version) {
            DecompressionTable decompressionTable;
            if (this.activeTable().version() == version) {
                decompressionTable = (DecompressionTable)OptionVal.Some$.MODULE$.apply(this.activeTable());
            } else {
                void var2_2;
                DecompressionTable found = this.find$1(this.oldTables(), version);
                decompressionTable = var2_2;
            }
            return decompressionTable;
        }

        public Tables<T> startUsingNextTable() {
            DecompressionTable<T> decompressionTable = this.activeTable();
            DecompressionTable qual$2 = DecompressionTable$.MODULE$.empty();
            byte x$8 = Tables.incrementTableVersion$1(this.nextTable().version());
            long x$9 = qual$2.copy$default$1();
            Object x$10 = qual$2.copy$default$3();
            return new Tables<T>(this.oldTables().$colon$colon(decompressionTable).take(this.keepOldTables()), this.nextTable(), qual$2.copy(x$9, x$8, x$10), None$.MODULE$, this.keepOldTables());
        }

        public <T> Tables<T> copy(List<DecompressionTable<T>> oldTables, DecompressionTable<T> activeTable, DecompressionTable<T> nextTable, Option<CompressionTable<T>> advertisementInProgress, int keepOldTables) {
            return new Tables<T>(oldTables, activeTable, nextTable, advertisementInProgress, keepOldTables);
        }

        public <T> List<DecompressionTable<T>> copy$default$1() {
            return this.oldTables();
        }

        public <T> DecompressionTable<T> copy$default$2() {
            return this.activeTable();
        }

        public <T> DecompressionTable<T> copy$default$3() {
            return this.nextTable();
        }

        public <T> Option<CompressionTable<T>> copy$default$4() {
            return this.advertisementInProgress();
        }

        public <T> int copy$default$5() {
            return this.keepOldTables();
        }

        public String productPrefix() {
            return "Tables";
        }

        public int productArity() {
            return 5;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                case 0: {
                    object = this.oldTables();
                    break;
                }
                case 1: {
                    object = this.activeTable();
                    break;
                }
                case 2: {
                    object = this.nextTable();
                    break;
                }
                case 3: {
                    object = this.advertisementInProgress();
                    break;
                }
                case 4: {
                    object = BoxesRunTime.boxToInteger((int)this.keepOldTables());
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof Tables;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)Statics.anyHash(this.oldTables()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.activeTable()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.nextTable()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.advertisementInProgress()));
            n = Statics.mix((int)n, (int)this.keepOldTables());
            return Statics.finalizeHash((int)n, (int)5);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof Tables)) return false;
            boolean bl = true;
            if (!bl) return false;
            Tables tables = (Tables)x$1;
            List<DecompressionTable<T>> list = this.oldTables();
            List<DecompressionTable<T>> list2 = tables.oldTables();
            if (list == null) {
                if (list2 != null) {
                    return false;
                }
            } else if (!list.equals(list2)) return false;
            DecompressionTable<T> decompressionTable = this.activeTable();
            DecompressionTable<T> decompressionTable2 = tables.activeTable();
            if (decompressionTable == null) {
                if (decompressionTable2 != null) {
                    return false;
                }
            } else if (!((Object)decompressionTable).equals(decompressionTable2)) return false;
            DecompressionTable<T> decompressionTable3 = this.nextTable();
            DecompressionTable<T> decompressionTable4 = tables.nextTable();
            if (decompressionTable3 == null) {
                if (decompressionTable4 != null) {
                    return false;
                }
            } else if (!((Object)decompressionTable3).equals(decompressionTable4)) return false;
            Option<CompressionTable<T>> option = this.advertisementInProgress();
            Option<CompressionTable<T>> option2 = tables.advertisementInProgress();
            if (option == null) {
                if (option2 != null) {
                    return false;
                }
            } else if (!option.equals(option2)) return false;
            if (this.keepOldTables() != tables.keepOldTables()) return false;
            return true;
        }

        private final DecompressionTable find$1(List tables, int version$1) {
            DecompressionTable decompressionTable;
            block2: {
                List list;
                block3: {
                    DecompressionTable t;
                    while (true) {
                        if (Nil$.MODULE$.equals(list = tables)) {
                            OptionVal$.MODULE$.None();
                            decompressionTable = null;
                            break block2;
                        }
                        if (!(list instanceof .colon.colon)) break block3;
                        .colon.colon colon2 = (.colon.colon)list;
                        t = (DecompressionTable)colon2.head();
                        List tail = colon2.tl$access$1();
                        if (t.version() == version$1) break;
                        tables = tail;
                    }
                    decompressionTable = (DecompressionTable)OptionVal.Some$.MODULE$.apply((Object)t);
                    break block2;
                }
                throw new MatchError((Object)list);
            }
            return decompressionTable;
        }

        private static final byte incrementTableVersion$1(byte version) {
            return version == 127 ? (byte)0 : (byte)(version + 1);
        }

        public Tables(List<DecompressionTable<T>> oldTables, DecompressionTable<T> activeTable, DecompressionTable<T> nextTable, Option<CompressionTable<T>> advertisementInProgress, int keepOldTables) {
            this.oldTables = oldTables;
            this.activeTable = activeTable;
            this.nextTable = nextTable;
            this.advertisementInProgress = advertisementInProgress;
            this.keepOldTables = keepOldTables;
            Product.$init$((Product)this);
        }
    }
}

