/*
 * Decompiled with CFR 0.152.
 */
package akka.remote.artery.aeron;

import akka.Done;
import akka.Done$;
import akka.actor.Address;
import akka.actor.Cancellable;
import akka.actor.ExtendedActorSystem;
import akka.event.Logging$;
import akka.remote.RemoteActorRefProvider;
import akka.remote.RemoteTransportException;
import akka.remote.artery.ArteryTransport;
import akka.remote.artery.ArteryTransport$;
import akka.remote.artery.ArteryTransport$ShuttingDown$;
import akka.remote.artery.Decoder;
import akka.remote.artery.DuplicateHandshakeReq;
import akka.remote.artery.EnvelopeBuffer;
import akka.remote.artery.EnvelopeBufferPool;
import akka.remote.artery.FixedSizePartitionHub;
import akka.remote.artery.FlightRecorderEvents$;
import akka.remote.artery.InboundControlJunction;
import akka.remote.artery.InboundEnvelope;
import akka.remote.artery.OutboundContext;
import akka.remote.artery.aeron.AeronErrorLog;
import akka.remote.artery.aeron.AeronSink;
import akka.remote.artery.aeron.AeronSource;
import akka.remote.artery.aeron.ArteryAeronUdpTransport$;
import akka.remote.artery.aeron.TaskRunner;
import akka.remote.artery.aeron.TaskRunner$;
import akka.remote.artery.compress.NoInboundCompressions$;
import akka.stream.Graph;
import akka.stream.KillSwitches$;
import akka.stream.SharedKillSwitch;
import akka.stream.scaladsl.Flow$;
import akka.stream.scaladsl.Keep$;
import akka.stream.scaladsl.Sink;
import akka.stream.scaladsl.Sink$;
import akka.stream.scaladsl.Source;
import akka.stream.scaladsl.Source$;
import io.aeron.Aeron;
import io.aeron.AvailableImageHandler;
import io.aeron.CommonContext;
import io.aeron.Image;
import io.aeron.UnavailableImageHandler;
import io.aeron.driver.MediaDriver;
import io.aeron.driver.ThreadingMode;
import io.aeron.exceptions.ConductorServiceTimeoutException;
import io.aeron.exceptions.DriverTimeoutException;
import java.io.File;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.agrona.DirectBuffer;
import org.agrona.ErrorHandler;
import org.agrona.IoUtil;
import org.agrona.collections.IntObjConsumer;
import org.agrona.concurrent.BackoffIdleStrategy;
import org.agrona.concurrent.IdleStrategy;
import org.agrona.concurrent.status.CountersReader;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.collection.immutable.Vector;
import scala.collection.immutable.Vector$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContextExecutor;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001dg!B\u0001\u0003\u0001\u0019Q!aF!si\u0016\u0014\u00180Q3s_:,F\r\u001d+sC:\u001c\bo\u001c:u\u0015\t\u0019A!A\u0003bKJ|gN\u0003\u0002\u0006\r\u00051\u0011M\u001d;fefT!a\u0002\u0005\u0002\rI,Wn\u001c;f\u0015\u0005I\u0011\u0001B1lW\u0006\u001c\"\u0001A\u0006\u0011\u00051iQ\"\u0001\u0003\n\u00059!!aD!si\u0016\u0014\u0018\u0010\u0016:b]N\u0004xN\u001d;\t\u0013A\u0001!\u0011!Q\u0001\nIA\u0012aB0tsN$X-\\\u0002\u0001!\t\u0019b#D\u0001\u0015\u0015\t)\u0002\"A\u0003bGR|'/\u0003\u0002\u0018)\t\u0019R\t\u001f;f]\u0012,G-Q2u_J\u001c\u0016p\u001d;f[&\u0011\u0011DG\u0001\u0007gf\u001cH/Z7\n\u0005m1!a\u0004*f[>$X\r\u0016:b]N\u0004xN\u001d;\t\u0013u\u0001!\u0011!Q\u0001\ny\u0011\u0013!C0qe>4\u0018\u000eZ3s!\ty\u0002%D\u0001\u0007\u0013\t\tcA\u0001\fSK6|G/Z!di>\u0014(+\u001a4Qe>4\u0018\u000eZ3s\u0013\t\u0019#$\u0001\u0005qe>4\u0018\u000eZ3s\u0011\u0015)\u0003\u0001\"\u0001'\u0003\u0019a\u0014N\\5u}Q\u0019q%\u000b\u0016\u0011\u0005!\u0002Q\"\u0001\u0002\t\u000bA!\u0003\u0019\u0001\n\t\u000bu!\u0003\u0019\u0001\u0010\t\r1\u0002\u0001\u0015!\u0003.\u0003-iW\rZ5b\tJLg/\u001a:\u0011\u00079:\u0014(D\u00010\u0015\t\u0001\u0014'\u0001\u0004bi>l\u0017n\u0019\u0006\u0003eM\n!bY8oGV\u0014(/\u001a8u\u0015\t!T'\u0001\u0003vi&d'\"\u0001\u001c\u0002\t)\fg/Y\u0005\u0003q=\u0012q\"\u0011;p[&\u001c'+\u001a4fe\u0016t7-\u001a\t\u0004uuzT\"A\u001e\u000b\u0003q\nQa]2bY\u0006L!AP\u001e\u0003\r=\u0003H/[8o!\t\u0001e)D\u0001B\u0015\t\u00115)\u0001\u0004ee&4XM\u001d\u0006\u0003\u0007\u0011S\u0011!R\u0001\u0003S>L!aR!\u0003\u00175+G-[1Ee&4XM\u001d\u0005\n\u0007\u0001\u0001\r\u0011!Q!\n%\u0003\"AS&\u000e\u0003\rK!\u0001T\"\u0003\u000b\u0005+'o\u001c8)\u0005!s\u0005C\u0001\u001eP\u0013\t\u00016H\u0001\u0005w_2\fG/\u001b7f\u0011%\u0011\u0006\u00011A\u0001B\u0003&1+\u0001\tbKJ|gnQ8v]R,'\u000fV1tWB\u00111\u0003V\u0005\u0003+R\u00111bQ1oG\u0016dG.\u00192mK\"\u0012\u0011K\u0014\u0005\n1\u0002\u0001\r\u0011!Q!\nM\u000b\u0011#Y3s_:,%O]8s\u0019><G+Y:lQ\t9f\nC\u0005\\\u0001\u0001\u0007\t\u0011)Q\u00059\u0006i\u0011-\u001a:p]\u0016\u0013(o\u001c:M_\u001e\u0004\"\u0001K/\n\u0005y\u0013!!D!fe>tWI\u001d:pe2{w\r\u000b\u0002[\u001d\"9\u0011\r\u0001b\u0001\n\u0013\u0011\u0017A\u0003;bg.\u0014VO\u001c8feV\t1\r\u0005\u0002)I&\u0011QM\u0001\u0002\u000b)\u0006\u001c8NU;o]\u0016\u0014\bBB4\u0001A\u0003%1-A\u0006uCN\\'+\u001e8oKJ\u0004\u0003\"B5\u0001\t\u0013Q\u0017AD5oE>,h\u000eZ\"iC:tW\r\\\u000b\u0002WB\u0011An\u001d\b\u0003[F\u0004\"A\\\u001e\u000e\u0003=T!\u0001]\t\u0002\rq\u0012xn\u001c;?\u0013\t\u00118(\u0001\u0004Qe\u0016$WMZ\u0005\u0003iV\u0014aa\u0015;sS:<'B\u0001:<\u0011\u00159\b\u0001\"\u0003y\u0003=yW\u000f\u001e2pk:$7\t[1o]\u0016dGCA6z\u0011\u0015Qh\u000f1\u0001|\u0003\u0005\t\u0007CA\n}\u0013\tiHCA\u0004BI\u0012\u0014Xm]:\t\r}\u0004A\u0011KA\u0001\u00039\u0019H/\u0019:u)J\fgn\u001d9peR$\"!a\u0001\u0011\u0007i\n)!C\u0002\u0002\bm\u0012A!\u00168ji\"9\u00111\u0002\u0001\u0005\n\u0005\u0005\u0011\u0001E:uCJ$X*\u001a3jC\u0012\u0013\u0018N^3s\u0011\u0019\ty\u0001\u0001C\u0005U\u0006A\u0011-\u001a:p]\u0012K'\u000fC\u0004\u0002\u0014\u0001!I!!\u0001\u0002\u001fM$x\u000e]'fI&\fGI]5wKJDq!a\u0006\u0001\t\u0013\t\t!\u0001\u0006ti\u0006\u0014H/Q3s_:Dq!a\u0007\u0001\t\u0013\t\t!A\fcY>\u001c7.\u00168uS2\u001c\u0005.\u00198oK2\f5\r^5wK\"9\u0011q\u0004\u0001\u0005\n\u0005\u0005\u0012!\u00044j]\u0012\u001cu.\u001e8uKJLE\r\u0006\u0003\u0002$\u0005%\u0002c\u0001\u001e\u0002&%\u0019\u0011qE\u001e\u0003\u0007%sG\u000fC\u0004\u0002,\u0005u\u0001\u0019A6\u0002\u000b1\f'-\u001a7\t\u000f\u0005=\u0002\u0001\"\u0003\u0002\u0002\u0005\u00112\u000f^1si\u0006+'o\u001c8FeJ|'\u000fT8h\u0011\u001d\t\u0019\u0004\u0001C\u0005\u0003\u0003\tAc\u001d;beR\fUM]8o\u0007>,h\u000e^3s\u0019><\u0007bBA\u001c\u0001\u0011E\u0013\u0011H\u0001\u0016_V$(m\\;oIR\u0013\u0018M\\:q_J$8+\u001b8l)!\tY$a\u0019\u0002n\u0005E\u0004\u0003CA\u001f\u0003\u000f\nY%!\u0015\u000e\u0005\u0005}\"\u0002BA!\u0003\u0007\n\u0001b]2bY\u0006$7\u000f\u001c\u0006\u0004\u0003\u000bB\u0011AB:ue\u0016\fW.\u0003\u0003\u0002J\u0005}\"\u0001B*j].\u00042\u0001DA'\u0013\r\ty\u0005\u0002\u0002\u000f\u000b:4X\r\\8qK\n+hMZ3s!\u0019\t\u0019&a\u0016\u0002\\5\u0011\u0011Q\u000b\u0006\u0003emJA!!\u0017\u0002V\t1a)\u001e;ve\u0016\u0004B!!\u0018\u0002`5\t\u0001\"C\u0002\u0002b!\u0011A\u0001R8oK\"A\u0011QMA\u001b\u0001\u0004\t9'A\bpkR\u0014w.\u001e8e\u0007>tG/\u001a=u!\ra\u0011\u0011N\u0005\u0004\u0003W\"!aD(vi\n|WO\u001c3D_:$X\r\u001f;\t\u0011\u0005=\u0014Q\u0007a\u0001\u0003G\t\u0001b\u001d;sK\u0006l\u0017\n\u001a\u0005\t\u0003g\n)\u00041\u0001\u0002v\u0005Q!-\u001e4gKJ\u0004vn\u001c7\u0011\u00071\t9(C\u0002\u0002z\u0011\u0011!#\u00128wK2|\u0007/\u001a\"vM\u001a,'\u000fU8pY\"9\u0011Q\u0010\u0001\u0005\n\u0005}\u0014aC1fe>t7k\\;sG\u0016$b!!!\u0002\u0016\u0006]\u0005\u0003CA\u001f\u0003\u0007\u000bY%a\"\n\t\u0005\u0015\u0015q\b\u0002\u0007'>,(oY3\u0011\t\u0005%\u0015q\u0012\b\u0004Q\u0005-\u0015bAAG\u0005\u0005Y\u0011)\u001a:p]N{WO]2f\u0013\u0011\t\t*a%\u0003#I+7o\\;sG\u0016d\u0015NZ3ds\u000edWMC\u0002\u0002\u000e\nA\u0001\"a\u001c\u0002|\u0001\u0007\u00111\u0005\u0005\t\u00033\u000bY\b1\u0001\u0002v\u0005!\u0001o\\8m\u0011\u001d\ti\n\u0001C\u0005\u0003?\u000b1$Y3s_:\u001cv.\u001e:dKN\u0003\u0018N\u001c8j]\u001e\u001cFO]1uK\u001eLXCAA\u0012\u0011\u001d\t\u0019\u000b\u0001C)\u0003\u0003\t\u0011C];o\u0013:\u0014w.\u001e8e'R\u0014X-Y7t\u0011\u001d\t9\u000b\u0001C\u0005\u0003\u0003\tqC];o\u0013:\u0014w.\u001e8e\u0007>tGO]8m'R\u0014X-Y7\t\u000f\u0005-\u0006\u0001\"\u0003\u0002\u0002\u0005\u0001#/\u001e8J]\n|WO\u001c3Pe\u0012Lg.\u0019:z\u001b\u0016\u001c8/Y4fgN#(/Z1n\u0011\u001d\ty\u000b\u0001C\u0005\u0003\u0003\tQD];o\u0013:\u0014w.\u001e8e\u0019\u0006\u0014x-Z'fgN\fw-Z:TiJ,\u0017-\u001c\u0005\b\u0003g\u0003A\u0011BA[\u0003U)\b\u000fZ1uKN#(/Z1n\u001b\u0006$h+\u00197vKN$\u0002\"a\u0001\u00028\u0006e\u0016Q\u0018\u0005\t\u0003_\n\t\f1\u0001\u0002$!A\u00111XAY\u0001\u0004\t9)\u0001\u000bbKJ|gnU8ve\u000e,G*\u001b4fGf\u001cG.\u001a\u0005\t\u0003\u007f\u000b\t\f1\u0001\u0002R\u0005I1m\\7qY\u0016$X\r\u001a\u0005\b\u0003\u0007\u0004A\u0011KAc\u0003E\u0019\b.\u001e;e_^tGK]1ogB|'\u000f\u001e\u000b\u0003\u0003#\u0002")
public class ArteryAeronUdpTransport
extends ArteryTransport {
    private final AtomicReference<Option<MediaDriver>> mediaDriver = new AtomicReference<None$>(None$.MODULE$);
    public volatile Aeron akka$remote$artery$aeron$ArteryAeronUdpTransport$$aeron;
    public volatile Cancellable akka$remote$artery$aeron$ArteryAeronUdpTransport$$aeronCounterTask;
    public volatile Cancellable akka$remote$artery$aeron$ArteryAeronUdpTransport$$aeronErrorLogTask;
    private volatile AeronErrorLog aeronErrorLog;
    private final TaskRunner akka$remote$artery$aeron$ArteryAeronUdpTransport$$taskRunner = new TaskRunner(this.system(), this.settings().Advanced().IdleCpuLevel());

    public TaskRunner akka$remote$artery$aeron$ArteryAeronUdpTransport$$taskRunner() {
        return this.akka$remote$artery$aeron$ArteryAeronUdpTransport$$taskRunner;
    }

    private String inboundChannel() {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"aeron:udp?endpoint=", ":", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.bindAddress().address().host().get(), this.bindAddress().address().port().get()}));
    }

    private String outboundChannel(Address a) {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"aeron:udp?endpoint=", ":", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{a.host().get(), a.port().get()}));
    }

    @Override
    public void startTransport() {
        this.startMediaDriver();
        this.startAeron();
        this.startAeronErrorLog();
        this.topLevelFlightRecorder().loFreq(FlightRecorderEvents$.MODULE$.Transport_AeronErrorLogStarted(), FlightRecorderEvents$.MODULE$.NoMetaData());
        if (this.settings().LogAeronCounters()) {
            this.startAeronCounterLog();
        }
        this.akka$remote$artery$aeron$ArteryAeronUdpTransport$$taskRunner().start();
        this.topLevelFlightRecorder().loFreq(FlightRecorderEvents$.MODULE$.Transport_TaskRunnerStarted(), FlightRecorderEvents$.MODULE$.NoMetaData());
    }

    private void startMediaDriver() {
        if (this.settings().Advanced().EmbeddedMediaDriver()) {
            MediaDriver.Context context;
            MediaDriver.Context driverContext = new MediaDriver.Context();
            if (new StringOps(Predef$.MODULE$.augmentString(this.settings().Advanced().AeronDirectoryName())).nonEmpty()) {
                context = driverContext.aeronDirectoryName(this.settings().Advanced().AeronDirectoryName());
            } else {
                String uniquePart = UUID.randomUUID().toString();
                String randomName = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "-", "-", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{CommonContext.AERON_DIR_PROP_DEFAULT, this.system().name(), uniquePart}));
                context = driverContext.aeronDirectoryName(randomName);
            }
            driverContext.clientLivenessTimeoutNs(this.settings().Advanced().ClientLivenessTimeout().toNanos());
            driverContext.imageLivenessTimeoutNs(this.settings().Advanced().ImageLivenessTimeout().toNanos());
            driverContext.driverTimeoutMs(this.settings().Advanced().DriverTimeout().toMillis());
            int idleCpuLevel = this.settings().Advanced().IdleCpuLevel();
            MediaDriver.Context context2 = idleCpuLevel == 10 ? driverContext.threadingMode(ThreadingMode.DEDICATED).conductorIdleStrategy((IdleStrategy)new BackoffIdleStrategy(1L, 1L, 1L, 1L)).receiverIdleStrategy(TaskRunner$.MODULE$.createIdleStrategy(idleCpuLevel)).senderIdleStrategy(TaskRunner$.MODULE$.createIdleStrategy(idleCpuLevel)) : (idleCpuLevel == 1 ? driverContext.threadingMode(ThreadingMode.SHARED).sharedIdleStrategy(TaskRunner$.MODULE$.createIdleStrategy(idleCpuLevel)) : (idleCpuLevel <= 7 ? driverContext.threadingMode(ThreadingMode.SHARED_NETWORK).sharedNetworkIdleStrategy(TaskRunner$.MODULE$.createIdleStrategy(idleCpuLevel)) : driverContext.threadingMode(ThreadingMode.DEDICATED).receiverIdleStrategy(TaskRunner$.MODULE$.createIdleStrategy(idleCpuLevel)).senderIdleStrategy(TaskRunner$.MODULE$.createIdleStrategy(idleCpuLevel))));
            MediaDriver driver = MediaDriver.launchEmbedded((MediaDriver.Context)driverContext);
            this.log().info("Started embedded media driver in directory [{}]", (Object)driver.aeronDirectoryName());
            this.topLevelFlightRecorder().loFreq(FlightRecorderEvents$.MODULE$.Transport_MediaDriverStarted(), driver.aeronDirectoryName());
            if (!this.mediaDriver.compareAndSet((Option<MediaDriver>)None$.MODULE$, (Option<MediaDriver>)new Some((Object)driver))) {
                throw new IllegalStateException("media driver started more than once");
            }
        }
    }

    private String aeronDir() {
        String string;
        Option<MediaDriver> option = this.mediaDriver.get();
        if (option instanceof Some) {
            Some some = (Some)option;
            MediaDriver driver = (MediaDriver)some.value();
            string = driver.aeronDirectoryName();
        } else if (None$.MODULE$.equals(option)) {
            string = this.settings().Advanced().AeronDirectoryName();
        } else {
            throw new MatchError(option);
        }
        return string;
    }

    private void stopMediaDriver() {
        Option<MediaDriver> maybeDriver = this.mediaDriver.getAndSet((Option<MediaDriver>)None$.MODULE$);
        maybeDriver.foreach((Function1 & Serializable & scala.Serializable)driver -> {
            ArteryAeronUdpTransport.$anonfun$stopMediaDriver$1(this, driver);
            return BoxedUnit.UNIT;
        });
    }

    private void startAeron() {
        Aeron.Context ctx = new Aeron.Context();
        ctx.driverTimeoutMs(this.settings().Advanced().DriverTimeout().toMillis());
        ctx.availableImageHandler(new AvailableImageHandler(this){
            private final /* synthetic */ ArteryAeronUdpTransport $outer;

            public void onAvailableImage(Image img) {
                block0: {
                    if (!this.$outer.log().isDebugEnabled()) break block0;
                    this.$outer.log().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"onAvailableImage from ", " session ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{img.sourceIdentity(), BoxesRunTime.boxToInteger((int)img.sessionId())})));
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        ctx.unavailableImageHandler(new UnavailableImageHandler(this){
            private final /* synthetic */ ArteryAeronUdpTransport $outer;

            public void onUnavailableImage(Image img) {
                if (this.$outer.log().isDebugEnabled()) {
                    this.$outer.log().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"onUnavailableImage from ", " session ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{img.sourceIdentity(), BoxesRunTime.boxToInteger((int)img.sessionId())})));
                }
                ((MapLike)this.$outer.streamMatValues().get()).valuesIterator().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    $anon$2.$anonfun$onUnavailableImage$1(img, x0$1);
                    return BoxedUnit.UNIT;
                });
            }

            public static final /* synthetic */ void $anonfun$onUnavailableImage$2(Image img$1, AeronSource.ResourceLifecycle x$1) {
                x$1.onUnavailableImage(img$1.sessionId());
            }

            public static final /* synthetic */ void $anonfun$onUnavailableImage$1(Image img$1, ArteryTransport.InboundStreamMatValues x0$1) {
                ArteryTransport.InboundStreamMatValues inboundStreamMatValues = x0$1;
                if (inboundStreamMatValues == null) {
                    throw new MatchError((Object)inboundStreamMatValues);
                }
                Option<AeronSource.ResourceLifecycle> resourceLife = inboundStreamMatValues.aeronSourceLifecycle();
                resourceLife.foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
                    $anon$2.$anonfun$onUnavailableImage$2(img$1, x$1);
                    return BoxedUnit.UNIT;
                });
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$onUnavailableImage$1$adapted(io.aeron.Image akka.remote.artery.ArteryTransport$InboundStreamMatValues ), $anonfun$onUnavailableImage$2$adapted(io.aeron.Image akka.remote.artery.aeron.AeronSource$ResourceLifecycle )}, serializedLambda);
            }
        });
        ctx.errorHandler(new ErrorHandler(this){
            private final AtomicBoolean fatalErrorOccured;
            private final /* synthetic */ ArteryAeronUdpTransport $outer;

            private AtomicBoolean fatalErrorOccured() {
                return this.fatalErrorOccured;
            }

            public void onError(Throwable cause) {
                Throwable throwable = cause;
                if (throwable instanceof ConductorServiceTimeoutException) {
                    ConductorServiceTimeoutException conductorServiceTimeoutException = (ConductorServiceTimeoutException)throwable;
                    this.handleFatalError((Throwable)conductorServiceTimeoutException);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else if (throwable instanceof DriverTimeoutException) {
                    DriverTimeoutException driverTimeoutException = (DriverTimeoutException)throwable;
                    this.handleFatalError(driverTimeoutException);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else if (throwable instanceof ArteryTransport.AeronTerminated) {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    this.$outer.log().error(cause, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Aeron error, ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{cause})));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
            }

            private void handleFatalError(Throwable cause) {
                if (this.fatalErrorOccured().compareAndSet(false, true)) {
                    if (!this.$outer.isShutdown()) {
                        this.$outer.log().error(cause, "Fatal Aeron error {}. Have to terminate ActorSystem because it lost contact with the {} Aeron media driver. Possible configuration properties to mitigate the problem are 'client-liveness-timeout' or 'driver-timeout'. {}", (Object)Logging$.MODULE$.simpleName((Object)cause), (Object)(this.$outer.settings().Advanced().EmbeddedMediaDriver() ? "embedded" : "external"), (Object)cause);
                        this.$outer.akka$remote$artery$aeron$ArteryAeronUdpTransport$$taskRunner().stop();
                        this.$outer.akka$remote$artery$aeron$ArteryAeronUdpTransport$$aeronErrorLogTask.cancel();
                        Object object = this.$outer.settings().LogAeronCounters() ? BoxesRunTime.boxToBoolean((boolean)this.$outer.akka$remote$artery$aeron$ArteryAeronUdpTransport$$aeronCounterTask.cancel()) : BoxedUnit.UNIT;
                        this.$outer.system().terminate();
                        throw new ArteryTransport.AeronTerminated(cause);
                    }
                } else {
                    throw new ArteryTransport.AeronTerminated(cause);
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.fatalErrorOccured = new AtomicBoolean();
            }
        });
        ctx.aeronDirectoryName(this.aeronDir());
        this.akka$remote$artery$aeron$ArteryAeronUdpTransport$$aeron = Aeron.connect((Aeron.Context)ctx);
    }

    private void blockUntilChannelActive() {
        int counterIdForInboundChannel = this.findCounterId(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"rcv-channel: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.inboundChannel()})));
        int waitInterval = 200;
        long retries = package$.MODULE$.max(1L, this.settings().Bind().BindTimeout().toMillis() / (long)waitInterval);
        this.retry$1(retries, counterIdForInboundChannel, waitInterval);
    }

    private int findCounterId(String label) {
        IntRef counterId = IntRef.create((int)-1);
        this.akka$remote$artery$aeron$ArteryAeronUdpTransport$$aeron.countersReader().forEach((IntObjConsumer)new IntObjConsumer<String>(null, label, counterId){
            private final String label$1;
            private final IntRef counterId$1;

            public void accept(int i, String l) {
                block0: {
                    String string = this.label$1;
                    String string2 = l;
                    if (string != null ? !string.equals(string2) : string2 != null) break block0;
                    this.counterId$1.elem = i;
                }
            }
            {
                this.label$1 = label$1;
                this.counterId$1 = counterId$1;
            }
        });
        if (counterId.elem == -1) {
            throw new RuntimeException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unable to found counterId for label: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{label})));
        }
        return counterId.elem;
    }

    private void startAeronErrorLog() {
        this.aeronErrorLog = new AeronErrorLog(new File(this.aeronDir(), "cnc.dat"), this.log());
        AtomicLong lastTimestamp = new AtomicLong(0L);
        this.akka$remote$artery$aeron$ArteryAeronUdpTransport$$aeronErrorLogTask = this.system().scheduler().schedule(new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(3)).seconds(), new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(5)).seconds(), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            block0: {
                if (this.isShutdown()) break block0;
                long newLastTimestamp = $this.aeronErrorLog.logErrors(this.log(), lastTimestamp.get());
                lastTimestamp.set(newLastTimestamp + 1L);
            }
        }, (ExecutionContext)this.system().dispatcher());
    }

    private void startAeronCounterLog() {
        this.akka$remote$artery$aeron$ArteryAeronUdpTransport$$aeronCounterTask = this.system().scheduler().schedule(new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(5)).seconds(), new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(5)).seconds(), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            block0: {
                if (this.isShutdown() || !this.log().isDebugEnabled()) break block0;
                $this.akka$remote$artery$aeron$ArteryAeronUdpTransport$$aeron.countersReader().forEach(new CountersReader.MetaData(this){
                    private final /* synthetic */ ArteryAeronUdpTransport $outer;

                    public void accept(int counterId, int typeId, DirectBuffer keyBuffer, String label) {
                        long value = this.$outer.akka$remote$artery$aeron$ArteryAeronUdpTransport$$aeron.countersReader().getCounterValue(counterId);
                        this.$outer.log().debug("Aeron Counter {}: {} {}]", (Object)BoxesRunTime.boxToInteger((int)counterId), (Object)BoxesRunTime.boxToLong((long)value), (Object)label);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }
        }, (ExecutionContext)this.system().dispatcher());
    }

    @Override
    public Sink<EnvelopeBuffer, Future<Done>> outboundTransportSink(OutboundContext outboundContext, int streamId, EnvelopeBufferPool bufferPool) {
        FiniteDuration giveUpAfter = streamId == ArteryTransport$.MODULE$.ControlStreamId() ? this.settings().Advanced().GiveUpSystemMessageAfter() : this.settings().Advanced().GiveUpMessageAfter();
        return Sink$.MODULE$.fromGraph((Graph)new AeronSink(this.outboundChannel(outboundContext.remoteAddress()), streamId, this.akka$remote$artery$aeron$ArteryAeronUdpTransport$$aeron, this.akka$remote$artery$aeron$ArteryAeronUdpTransport$$taskRunner(), bufferPool, (Duration)giveUpAfter, this.createFlightRecorderEventSink(this.createFlightRecorderEventSink$default$1())));
    }

    private Source<EnvelopeBuffer, AeronSource.ResourceLifecycle> aeronSource(int streamId, EnvelopeBufferPool pool) {
        return Source$.MODULE$.fromGraph((Graph)new AeronSource(this.inboundChannel(), streamId, this.akka$remote$artery$aeron$ArteryAeronUdpTransport$$aeron, this.akka$remote$artery$aeron$ArteryAeronUdpTransport$$taskRunner(), pool, this.createFlightRecorderEventSink(this.createFlightRecorderEventSink$default$1()), this.aeronSourceSpinningStrategy()));
    }

    private int aeronSourceSpinningStrategy() {
        return this.settings().Advanced().InboundLanes() > 1 || this.settings().Advanced().IdleCpuLevel() < 5 ? 0 : 50 * this.settings().Advanced().IdleCpuLevel() - 240;
    }

    @Override
    public void runInboundStreams() {
        this.runInboundControlStream();
        this.runInboundOrdinaryMessagesStream();
        if (this.largeMessageChannelEnabled()) {
            this.runInboundLargeMessagesStream();
        }
        this.blockUntilChannelActive();
    }

    private void runInboundControlStream() {
        if (this.isShutdown()) {
            throw ArteryTransport$ShuttingDown$.MODULE$;
        }
        Tuple3 tuple3 = (Tuple3)this.aeronSource(ArteryTransport$.MODULE$.ControlStreamId(), this.envelopeBufferPool()).via(this.inboundFlow(this.settings(), NoInboundCompressions$.MODULE$)).toMat(this.inboundControlSink(), (Function2 & Serializable & scala.Serializable)(x0$2, x1$1) -> {
            Tuple2 tuple2;
            AeronSource.ResourceLifecycle a;
            block3: {
                Tuple2 tuple22;
                block2: {
                    tuple22 = new Tuple2(x0$2, x1$1);
                    if (tuple22 == null) break block2;
                    a = (AeronSource.ResourceLifecycle)tuple22._1();
                    tuple2 = (Tuple2)tuple22._2();
                    if (tuple2 != null) break block3;
                }
                throw new MatchError((Object)tuple22);
            }
            InboundControlJunction.ControlMessageSubject c = (InboundControlJunction.ControlMessageSubject)tuple2._1();
            Future d = (Future)tuple2._2();
            Tuple3 tuple3 = new Tuple3((Object)a, (Object)c, (Object)d);
            return tuple3;
        }).run(this.controlMaterializer());
        if (tuple3 == null) {
            throw new MatchError((Object)tuple3);
        }
        AeronSource.ResourceLifecycle resourceLife = (AeronSource.ResourceLifecycle)tuple3._1();
        InboundControlJunction.ControlMessageSubject ctrl = (InboundControlJunction.ControlMessageSubject)tuple3._2();
        Future completed = (Future)tuple3._3();
        Tuple3 tuple32 = new Tuple3((Object)resourceLife, (Object)ctrl, (Object)completed);
        Tuple3 tuple33 = tuple32;
        AeronSource.ResourceLifecycle resourceLife2 = (AeronSource.ResourceLifecycle)tuple33._1();
        InboundControlJunction.ControlMessageSubject ctrl2 = (InboundControlJunction.ControlMessageSubject)tuple33._2();
        Future completed2 = (Future)tuple33._3();
        this.attachControlMessageObserver(ctrl2);
        this.updateStreamMatValues(ArteryTransport$.MODULE$.ControlStreamId(), resourceLife2, (Future<Done>)completed2);
        this.attachInboundStreamRestart("Inbound control stream", (Future<Done>)completed2, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.runInboundControlStream());
    }

    private void runInboundOrdinaryMessagesStream() {
        Tuple3 tuple3;
        Tuple3 tuple32;
        if (this.isShutdown()) {
            throw ArteryTransport$ShuttingDown$.MODULE$;
        }
        if (this.inboundLanes() == 1) {
            tuple32 = (Tuple3)this.aeronSource(ArteryTransport$.MODULE$.OrdinaryStreamId(), this.envelopeBufferPool()).viaMat(this.inboundFlow(this.settings(), this._inboundCompressions()), Keep$.MODULE$.both()).toMat(this.inboundSink(this.envelopeBufferPool()), (Function2 & Serializable & scala.Serializable)(x0$3, x1$2) -> {
                Future c;
                Tuple2 tuple2;
                block3: {
                    Tuple2 tuple22;
                    block2: {
                        tuple22 = new Tuple2(x0$3, x1$2);
                        if (tuple22 == null) break block2;
                        tuple2 = (Tuple2)tuple22._1();
                        c = (Future)tuple22._2();
                        if (tuple2 != null) break block3;
                    }
                    throw new MatchError((Object)tuple22);
                }
                AeronSource.ResourceLifecycle a = (AeronSource.ResourceLifecycle)tuple2._1();
                Decoder.InboundCompressionAccess b = (Decoder.InboundCompressionAccess)tuple2._2();
                Tuple3 tuple3 = new Tuple3((Object)a, (Object)b, (Object)c);
                return tuple3;
            }).run(this.materializer());
        } else {
            SharedKillSwitch laneKillSwitch = KillSwitches$.MODULE$.shared("laneKillSwitch");
            Source laneSource = this.aeronSource(ArteryTransport$.MODULE$.OrdinaryStreamId(), this.envelopeBufferPool()).via(laneKillSwitch.flow()).viaMat(this.inboundFlow(this.settings(), this._inboundCompressions()), Keep$.MODULE$.both()).via((Graph)Flow$.MODULE$.fromGraph((Graph)new DuplicateHandshakeReq(this.inboundLanes(), this, this.system(), this.envelopeBufferPool())));
            Tuple3 tuple33 = (Tuple3)laneSource.toMat((Graph)Sink$.MODULE$.fromGraph(new FixedSizePartitionHub<InboundEnvelope>(this.inboundLanePartitioner(), this.inboundLanes(), this.settings().Advanced().InboundHubBufferSize())), (Function2 & Serializable & scala.Serializable)(x0$4, x1$3) -> {
                Source c;
                Tuple2 tuple2;
                block3: {
                    Tuple2 tuple22;
                    block2: {
                        tuple22 = new Tuple2(x0$4, x1$3);
                        if (tuple22 == null) break block2;
                        tuple2 = (Tuple2)tuple22._1();
                        c = (Source)tuple22._2();
                        if (tuple2 != null) break block3;
                    }
                    throw new MatchError((Object)tuple22);
                }
                AeronSource.ResourceLifecycle a = (AeronSource.ResourceLifecycle)tuple2._1();
                Decoder.InboundCompressionAccess b = (Decoder.InboundCompressionAccess)tuple2._2();
                Tuple3 tuple3 = new Tuple3((Object)a, (Object)b, (Object)c);
                return tuple3;
            }).run(this.materializer());
            if (tuple33 == null) {
                throw new MatchError((Object)tuple33);
            }
            AeronSource.ResourceLifecycle resourceLife = (AeronSource.ResourceLifecycle)tuple33._1();
            Decoder.InboundCompressionAccess compressionAccess = (Decoder.InboundCompressionAccess)tuple33._2();
            Source laneHub = (Source)tuple33._3();
            Tuple3 tuple34 = new Tuple3((Object)resourceLife, (Object)compressionAccess, (Object)laneHub);
            Tuple3 tuple35 = tuple34;
            AeronSource.ResourceLifecycle resourceLife2 = (AeronSource.ResourceLifecycle)tuple35._1();
            Decoder.InboundCompressionAccess compressionAccess2 = (Decoder.InboundCompressionAccess)tuple35._2();
            Source laneHub2 = (Source)tuple35._3();
            Sink<InboundEnvelope, Future<Done>> lane = this.inboundSink(this.envelopeBufferPool());
            Vector completedValues = (Vector)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.inboundLanes()).map((Function1 & Serializable & scala.Serializable)x$4 -> ArteryAeronUdpTransport.$anonfun$runInboundOrdinaryMessagesStream$3(this, laneHub2, lane, BoxesRunTime.unboxToInt((Object)x$4)), scala.collection.package$.MODULE$.breakOut(Vector$.MODULE$.canBuildFrom()));
            Future$.MODULE$.firstCompletedOf((TraversableOnce)completedValues, (ExecutionContext)this.system().dispatcher()).failed().foreach((Function1 & Serializable & scala.Serializable)reason -> {
                laneKillSwitch.abort(reason);
                return BoxedUnit.UNIT;
            }, (ExecutionContext)this.system().dispatcher());
            Future allCompleted = Future$.MODULE$.sequence((TraversableOnce)completedValues, Vector$.MODULE$.canBuildFrom(), (ExecutionContext)this.system().dispatcher()).map((Function1 & Serializable & scala.Serializable)x$5 -> Done$.MODULE$, (ExecutionContext)this.system().dispatcher());
            tuple32 = tuple3 = new Tuple3((Object)resourceLife2, (Object)compressionAccess2, (Object)allCompleted);
        }
        if (tuple3 == null) {
            throw new MatchError((Object)tuple3);
        }
        AeronSource.ResourceLifecycle resourceLife = (AeronSource.ResourceLifecycle)tuple3._1();
        Decoder.InboundCompressionAccess inboundCompressionAccess = (Decoder.InboundCompressionAccess)tuple3._2();
        Future completed = (Future)tuple3._3();
        Tuple3 tuple36 = new Tuple3((Object)resourceLife, (Object)inboundCompressionAccess, (Object)completed);
        Tuple3 tuple37 = tuple36;
        AeronSource.ResourceLifecycle resourceLife3 = (AeronSource.ResourceLifecycle)tuple37._1();
        Decoder.InboundCompressionAccess inboundCompressionAccess2 = (Decoder.InboundCompressionAccess)tuple37._2();
        Future completed2 = (Future)tuple37._3();
        this.setInboundCompressionAccess(inboundCompressionAccess2);
        this.updateStreamMatValues(ArteryTransport$.MODULE$.OrdinaryStreamId(), resourceLife3, (Future<Done>)completed2);
        this.attachInboundStreamRestart("Inbound message stream", (Future<Done>)completed2, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.runInboundOrdinaryMessagesStream());
    }

    private void runInboundLargeMessagesStream() {
        if (this.isShutdown()) {
            throw ArteryTransport$ShuttingDown$.MODULE$;
        }
        Tuple2 tuple2 = (Tuple2)this.aeronSource(ArteryTransport$.MODULE$.LargeStreamId(), this.largeEnvelopeBufferPool()).via(this.inboundLargeFlow(this.settings())).toMat(this.inboundSink(this.largeEnvelopeBufferPool()), Keep$.MODULE$.both()).run(this.materializer());
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        AeronSource.ResourceLifecycle resourceLife = (AeronSource.ResourceLifecycle)tuple2._1();
        Future completed = (Future)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)resourceLife, (Object)completed);
        Tuple2 tuple23 = tuple22;
        AeronSource.ResourceLifecycle resourceLife2 = (AeronSource.ResourceLifecycle)tuple23._1();
        Future completed2 = (Future)tuple23._2();
        this.updateStreamMatValues(ArteryTransport$.MODULE$.LargeStreamId(), resourceLife2, (Future<Done>)completed2);
        this.attachInboundStreamRestart("Inbound large message stream", (Future<Done>)completed2, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.runInboundLargeMessagesStream());
    }

    private void updateStreamMatValues(int streamId, AeronSource.ResourceLifecycle aeronSourceLifecycle, Future<Done> completed) {
        ExecutionContextExecutor ec = this.materializer().executionContext();
        this.updateStreamMatValues(streamId, new ArteryTransport.InboundStreamMatValues((Option<AeronSource.ResourceLifecycle>)new Some((Object)aeronSourceLifecycle), (Future<Done>)completed.recover((PartialFunction)new scala.Serializable(null){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                Done$ done$ = Done$.MODULE$;
                return (B1)done$;
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                boolean bl = true;
                return bl;
            }
        }, (ExecutionContext)ec)));
    }

    @Override
    public Future<Done> shutdownTransport() {
        return this.akka$remote$artery$aeron$ArteryAeronUdpTransport$$taskRunner().stop().map((Function1 & Serializable & scala.Serializable)x$8 -> {
            block3: {
                this.topLevelFlightRecorder().loFreq(FlightRecorderEvents$.MODULE$.Transport_Stopped(), FlightRecorderEvents$.MODULE$.NoMetaData());
                if ($this.akka$remote$artery$aeron$ArteryAeronUdpTransport$$aeronErrorLogTask != null) {
                    $this.akka$remote$artery$aeron$ArteryAeronUdpTransport$$aeronErrorLogTask.cancel();
                    this.topLevelFlightRecorder().loFreq(FlightRecorderEvents$.MODULE$.Transport_AeronErrorLogTaskStopped(), FlightRecorderEvents$.MODULE$.NoMetaData());
                }
                if ($this.akka$remote$artery$aeron$ArteryAeronUdpTransport$$aeron != null) {
                    $this.akka$remote$artery$aeron$ArteryAeronUdpTransport$$aeron.close();
                }
                if ($this.aeronErrorLog != null) {
                    $this.aeronErrorLog.close();
                }
                if (!$this.mediaDriver.get().isDefined()) break block3;
                this.stopMediaDriver();
            }
            return Done$.MODULE$;
        }, (ExecutionContext)this.system().dispatcher());
    }

    public static final /* synthetic */ void $anonfun$stopMediaDriver$1(ArteryAeronUdpTransport $this, MediaDriver driver) {
        try {
            driver.close();
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable e = (Throwable)option.get();
                $this.log().warning("Couldn't close Aeron embedded media driver due to [{}]", (Object)e);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            throw throwable;
        }
        try {
            if ($this.settings().Advanced().DeleteAeronDirectory()) {
                IoUtil.delete((File)new File(driver.aeronDirectoryName()), (boolean)false);
                $this.topLevelFlightRecorder().loFreq(FlightRecorderEvents$.MODULE$.Transport_MediaFileDeleted(), FlightRecorderEvents$.MODULE$.NoMetaData());
            }
        }
        catch (Throwable throwable) {
            Throwable throwable3 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable3);
            if (!option.isEmpty()) {
                Throwable e = (Throwable)option.get();
                $this.log().warning("Couldn't delete Aeron embedded media driver files in [{}] due to [{}]", (Object)driver.aeronDirectoryName(), (Object)e);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            throw throwable;
        }
    }

    private final void retry$1(long retries, int counterIdForInboundChannel$1, int waitInterval$1) {
        block2: {
            while (true) {
                long status;
                if ((status = this.akka$remote$artery$aeron$ArteryAeronUdpTransport$$aeron.countersReader().getCounterValue(counterIdForInboundChannel$1)) == 1L) break block2;
                if (status == -1L) {
                    this.aeronErrorLog.logErrors(this.log(), 0L);
                    this.stopMediaDriver();
                    throw new RemoteTransportException("Inbound Aeron channel is in errored state. See Aeron logs for details.");
                }
                if (status != 0L || retries <= 0L) break;
                Thread.sleep(waitInterval$1);
                --retries;
            }
            this.aeronErrorLog.logErrors(this.log(), 0L);
            this.stopMediaDriver();
            throw new RemoteTransportException("Timed out waiting for Aeron transport to bind. See Aeoron logs.");
        }
        this.log().debug("Inbound channel is now active");
    }

    public static final /* synthetic */ Future $anonfun$runInboundOrdinaryMessagesStream$3(ArteryAeronUdpTransport $this, Source laneHub$1, Sink lane$1, int x$4) {
        return (Future)laneHub$1.toMat((Graph)lane$1, Keep$.MODULE$.right()).run($this.materializer());
    }

    public ArteryAeronUdpTransport(ExtendedActorSystem _system, RemoteActorRefProvider _provider) {
        super(_system, _provider);
    }
}

