/*
 * Decompiled with CFR 0.152.
 */
package akka.stream.impl.fusing;

import akka.annotation.InternalApi;
import akka.stream.Attributes;
import akka.stream.FlowShape;
import akka.stream.Inlet;
import akka.stream.Inlet$;
import akka.stream.Outlet;
import akka.stream.Outlet$;
import akka.stream.impl.Stages$DefaultAttributes$;
import akka.stream.impl.fusing.GroupedWeightedWithin$;
import akka.stream.stage.GraphStage;
import akka.stream.stage.GraphStageLogic;
import akka.stream.stage.InHandler;
import akka.stream.stage.OutHandler;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.VectorBuilder;
import scala.concurrent.duration.Duration$;
import scala.concurrent.duration.FiniteDuration;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015rAB\u0001\u0003\u0011\u0003A!\"A\u000bHe>,\b/\u001a3XK&<\u0007\u000e^3e/&$\b.\u001b8\u000b\u0005\r!\u0011A\u00024vg&twM\u0003\u0002\u0006\r\u0005!\u0011.\u001c9m\u0015\t9\u0001\"\u0001\u0004tiJ,\u0017-\u001c\u0006\u0002\u0013\u0005!\u0011m[6b!\tYA\"D\u0001\u0003\r\u0019i!\u0001#\u0001\t\u001d\t)rI]8va\u0016$w+Z5hQR,GmV5uQ&t7C\u0001\u0007\u0010!\t\u00012#D\u0001\u0012\u0015\u0005\u0011\u0012!B:dC2\f\u0017B\u0001\u000b\u0012\u0005\u0019\te.\u001f*fM\")a\u0003\u0004C\u00011\u00051A(\u001b8jiz\u001a\u0001\u0001F\u0001\u000b\u0011\u001dQBB1A\u0005\u0002m\t!d\u001a:pkB,GmV3jO\"$X\rZ,ji\"Lg\u000eV5nKJ,\u0012\u0001\b\t\u0003;\tj\u0011A\b\u0006\u0003?\u0001\nA\u0001\\1oO*\t\u0011%\u0001\u0003kCZ\f\u0017BA\u0012\u001f\u0005\u0019\u0019FO]5oO\"1Q\u0005\u0004Q\u0001\nq\t1d\u001a:pkB,GmV3jO\"$X\rZ,ji\"Lg\u000eV5nKJ\u0004\u0003F\u0001\u0007(!\tA3&D\u0001*\u0015\tQ\u0003\"\u0001\u0006b]:|G/\u0019;j_:L!\u0001L\u0015\u0003\u0017%sG/\u001a:oC2\f\u0005/\u001b\u0015\u0003\u0001\u001d2Q!\u0004\u0002\u0003\u0011=*\"\u0001M\u001f\u0014\u00059\n\u0004c\u0001\u001a6o5\t1G\u0003\u00025\r\u0005)1\u000f^1hK&\u0011ag\r\u0002\u000b\u000fJ\f\u0007\u000f[*uC\u001e,\u0007\u0003\u0002\u001d:w\u0019k\u0011AB\u0005\u0003u\u0019\u0011\u0011B\u00127poNC\u0017\r]3\u0011\u0005qjD\u0002\u0001\u0003\u0006}9\u0012\ra\u0010\u0002\u0002)F\u0011\u0001i\u0011\t\u0003!\u0005K!AQ\t\u0003\u000f9{G\u000f[5oOB\u0011\u0001\u0003R\u0005\u0003\u000bF\u00111!\u00118z!\r9EjO\u0007\u0002\u0011*\u0011\u0011JS\u0001\nS6lW\u000f^1cY\u0016T!aS\t\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002N\u0011\n\u00191+Z9\t\u0011=s#Q1A\u0005\u0002A\u000b\u0011\"\\1y/\u0016Lw\r\u001b;\u0016\u0003E\u0003\"\u0001\u0005*\n\u0005M\u000b\"\u0001\u0002'p]\u001eD\u0001\"\u0016\u0018\u0003\u0002\u0003\u0006I!U\u0001\u000b[\u0006Dx+Z5hQR\u0004\u0003\u0002C,/\u0005\u0003\u0005\u000b\u0011\u0002-\u0002\r\r|7\u000f\u001e$o!\u0011\u0001\u0012lO)\n\u0005i\u000b\"!\u0003$v]\u000e$\u0018n\u001c82\u0011!afF!b\u0001\n\u0003i\u0016\u0001C5oi\u0016\u0014h/\u00197\u0016\u0003y\u0003\"a\u00183\u000e\u0003\u0001T!!\u00192\u0002\u0011\u0011,(/\u0019;j_:T!aY\t\u0002\u0015\r|gnY;se\u0016tG/\u0003\u0002fA\nqa)\u001b8ji\u0016$UO]1uS>t\u0007\u0002C4/\u0005\u0003\u0005\u000b\u0011\u00020\u0002\u0013%tG/\u001a:wC2\u0004\u0003\"\u0002\f/\t\u0003IG\u0003\u00026lY6\u00042a\u0003\u0018<\u0011\u0015y\u0005\u000e1\u0001R\u0011\u00159\u0006\u000e1\u0001Y\u0011\u0015a\u0006\u000e1\u0001_\u0011\u001dygF1A\u0005\u0002A\f!!\u001b8\u0016\u0003E\u00042\u0001\u000f:<\u0013\t\u0019hAA\u0003J]2,G\u000f\u0003\u0004v]\u0001\u0006I!]\u0001\u0004S:\u0004\u0003bB</\u0005\u0004%\t\u0001_\u0001\u0004_V$X#A=\u0011\u0007aRh)\u0003\u0002|\r\t1q*\u001e;mKRDa! \u0018!\u0002\u0013I\u0018\u0001B8vi\u0002Baa \u0018\u0005B\u0005\u0005\u0011!E5oSRL\u0017\r\\!uiJL'-\u001e;fgV\u0011\u00111\u0001\t\u0004q\u0005\u0015\u0011bAA\u0004\r\tQ\u0011\t\u001e;sS\n,H/Z:\t\u0013\u0005-aF1A\u0005\u0002\u00055\u0011!B:iCB,W#A\u001c\t\u000f\u0005Ea\u0006)A\u0005o\u000511\u000f[1qK\u0002Bq!!\u0006/\t\u0003\n9\"A\u0006de\u0016\fG/\u001a'pO&\u001cG\u0003BA\r\u0003?\u00012AMA\u000e\u0013\r\tib\r\u0002\u0010\u000fJ\f\u0007\u000f[*uC\u001e,Gj\\4jG\"A\u0011\u0011EA\n\u0001\u0004\t\u0019!A\nj]\",'/\u001b;fI\u0006#HO]5ckR,7\u000f\u000b\u0002/O\u0001")
@InternalApi
public final class GroupedWeightedWithin<T>
extends GraphStage<FlowShape<T, scala.collection.immutable.Seq<T>>> {
    private final long maxWeight;
    public final Function1<T, Object> akka$stream$impl$fusing$GroupedWeightedWithin$$costFn;
    private final FiniteDuration interval;
    private final Inlet<T> in;
    private final Outlet<scala.collection.immutable.Seq<T>> out;
    private final FlowShape<T, scala.collection.immutable.Seq<T>> shape;

    public static String groupedWeightedWithinTimer() {
        return GroupedWeightedWithin$.MODULE$.groupedWeightedWithinTimer();
    }

    public long maxWeight() {
        return this.maxWeight;
    }

    public FiniteDuration interval() {
        return this.interval;
    }

    public Inlet<T> in() {
        return this.in;
    }

    public Outlet<scala.collection.immutable.Seq<T>> out() {
        return this.out;
    }

    @Override
    public Attributes initialAttributes() {
        return Stages$DefaultAttributes$.MODULE$.groupedWeightedWithin();
    }

    @Override
    public FlowShape<T, scala.collection.immutable.Seq<T>> shape() {
        return this.shape;
    }

    @Override
    public GraphStageLogic createLogic(Attributes inheritedAttributes) {
        return new InHandler(this){
            private final VectorBuilder<T> buf;
            private T pending;
            private long pendingWeight;
            private boolean pushEagerly;
            private boolean groupEmitted;
            private boolean finished;
            private long totalWeight;
            private boolean hasElements;
            private final /* synthetic */ GroupedWeightedWithin $outer;

            public void onDownstreamFinish() throws Exception {
                OutHandler.onDownstreamFinish$(this);
            }

            public void onUpstreamFailure(Throwable ex) throws Exception {
                InHandler.onUpstreamFailure$(this, ex);
            }

            private VectorBuilder<T> buf() {
                return this.buf;
            }

            private T pending() {
                return this.pending;
            }

            private void pending_$eq(T x$1) {
                this.pending = x$1;
            }

            private long pendingWeight() {
                return this.pendingWeight;
            }

            private void pendingWeight_$eq(long x$1) {
                this.pendingWeight = x$1;
            }

            private boolean pushEagerly() {
                return this.pushEagerly;
            }

            private void pushEagerly_$eq(boolean x$1) {
                this.pushEagerly = x$1;
            }

            private boolean groupEmitted() {
                return this.groupEmitted;
            }

            private void groupEmitted_$eq(boolean x$1) {
                this.groupEmitted = x$1;
            }

            private boolean finished() {
                return this.finished;
            }

            private void finished_$eq(boolean x$1) {
                this.finished = x$1;
            }

            private long totalWeight() {
                return this.totalWeight;
            }

            private void totalWeight_$eq(long x$1) {
                this.totalWeight = x$1;
            }

            private boolean hasElements() {
                return this.hasElements;
            }

            private void hasElements_$eq(boolean x$1) {
                this.hasElements = x$1;
            }

            public void preStart() {
                this.schedulePeriodically(GroupedWeightedWithin$.MODULE$.groupedWeightedWithinTimer(), this.$outer.interval());
                this.pull(this.$outer.in());
            }

            private void nextElement(T elem) {
                this.groupEmitted_$eq(false);
                long cost = BoxesRunTime.unboxToLong((Object)this.$outer.akka$stream$impl$fusing$GroupedWeightedWithin$$costFn.apply(elem));
                if (cost < 0L) {
                    this.failStage(new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Negative weight [", "] for element [", "] is not allowed"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)cost), elem}))));
                } else {
                    this.hasElements_$eq(true);
                    if (this.totalWeight() + cost <= this.$outer.maxWeight()) {
                        this.buf().$plus$eq(elem);
                        this.totalWeight_$eq(this.totalWeight() + cost);
                        if (this.totalWeight() < this.$outer.maxWeight()) {
                            this.pull(this.$outer.in());
                        } else if (!this.isAvailable(this.$outer.out())) {
                            this.pushEagerly_$eq(true);
                            this.pull(this.$outer.in());
                        } else {
                            this.schedulePeriodically(GroupedWeightedWithin$.MODULE$.groupedWeightedWithinTimer(), this.$outer.interval());
                            this.emitGroup();
                        }
                    } else {
                        if (this.totalWeight() == 0L) {
                            this.buf().$plus$eq(elem);
                            this.totalWeight_$eq(this.totalWeight() + cost);
                            this.pushEagerly_$eq(true);
                        } else {
                            this.pending_$eq(elem);
                            this.pendingWeight_$eq(cost);
                        }
                        this.schedulePeriodically(GroupedWeightedWithin$.MODULE$.groupedWeightedWithinTimer(), this.$outer.interval());
                        this.tryCloseGroup();
                    }
                }
            }

            private void tryCloseGroup() {
                block1: {
                    block0: {
                        if (!this.isAvailable(this.$outer.out())) break block0;
                        this.emitGroup();
                        break block1;
                    }
                    if (this.pending() == null && !this.finished()) break block1;
                    this.pushEagerly_$eq(true);
                }
            }

            private void emitGroup() {
                this.groupEmitted_$eq(true);
                this.push(this.$outer.out(), this.buf().result());
                this.buf().clear();
                if (!this.finished()) {
                    this.startNewGroup();
                } else if (this.pending() != null) {
                    this.emit(this.$outer.out(), package$.MODULE$.Vector().apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.pending()})), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.completeStage());
                } else {
                    this.completeStage();
                }
            }

            private void startNewGroup() {
                block3: {
                    block2: {
                        if (this.pending() != null) {
                            this.totalWeight_$eq(this.pendingWeight());
                            this.pendingWeight_$eq(0L);
                            this.buf().$plus$eq(this.pending());
                            this.pending_$eq(null);
                            this.groupEmitted_$eq(false);
                        } else {
                            this.totalWeight_$eq(0L);
                            this.hasElements_$eq(false);
                        }
                        this.pushEagerly_$eq(false);
                        if (!this.isAvailable(this.$outer.in())) break block2;
                        this.nextElement(this.grab(this.$outer.in()));
                        break block3;
                    }
                    if (this.hasBeenPulled(this.$outer.in())) break block3;
                    this.pull(this.$outer.in());
                }
            }

            public void onPush() {
                block0: {
                    if (this.pending() != null) break block0;
                    this.nextElement(this.grab(this.$outer.in()));
                }
            }

            public void onPull() {
                block0: {
                    if (!this.pushEagerly()) break block0;
                    this.emitGroup();
                }
            }

            public void onUpstreamFinish() {
                this.finished_$eq(true);
                if (this.groupEmitted()) {
                    this.completeStage();
                } else {
                    this.tryCloseGroup();
                }
            }

            public void onTimer(Object timerKey) {
                block2: {
                    if (!this.hasElements()) break block2;
                    if (this.isAvailable(this.$outer.out())) {
                        this.emitGroup();
                    } else {
                        this.pushEagerly_$eq(true);
                    }
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                super($outer.shape());
                InHandler.$init$(this);
                OutHandler.$init$(this);
                this.buf = new VectorBuilder();
                this.pending = null;
                this.pendingWeight = 0L;
                this.pushEagerly = false;
                this.groupEmitted = true;
                this.finished = false;
                this.totalWeight = 0L;
                this.hasElements = false;
                this.setHandlers($outer.in(), $outer.out(), this);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$emitGroup$1(akka.stream.impl.fusing.GroupedWeightedWithin$$anon$6 )}, serializedLambda);
            }
        };
    }

    public GroupedWeightedWithin(long maxWeight, Function1<T, Object> costFn, FiniteDuration interval) {
        this.maxWeight = maxWeight;
        this.akka$stream$impl$fusing$GroupedWeightedWithin$$costFn = costFn;
        this.interval = interval;
        Predef$.MODULE$.require(maxWeight > 0L, (Function0 & Serializable & scala.Serializable)() -> "maxWeight must be greater than 0");
        Predef$.MODULE$.require(interval.$greater((Object)Duration$.MODULE$.Zero()));
        this.in = Inlet$.MODULE$.apply("in");
        this.out = Outlet$.MODULE$.apply("out");
        this.shape = new FlowShape<T, scala.collection.immutable.Seq<T>>(this.in(), this.out());
    }
}

