/*
 * Decompiled with CFR 0.152.
 */
package akka.stream;

import akka.actor.ActorContext;
import akka.actor.ActorRef;
import akka.actor.ActorRefFactory;
import akka.actor.ActorSystem;
import akka.actor.ExtendedActorSystem;
import akka.stream.ActorMaterializer;
import akka.stream.ActorMaterializerSettings;
import akka.stream.ActorMaterializerSettings$;
import akka.stream.impl.FlowNames;
import akka.stream.impl.FlowNames$;
import akka.stream.impl.PhasedFusingActorMaterializer;
import akka.stream.impl.StreamSupervisor$;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicBoolean;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;

public final class ActorMaterializer$ {
    public static ActorMaterializer$ MODULE$;

    static {
        new ActorMaterializer$();
    }

    public ActorMaterializer apply(Option<ActorMaterializerSettings> materializerSettings, Option<String> namePrefix, ActorRefFactory context) {
        ActorSystem system = this.actorSystemOf(context);
        ActorMaterializerSettings settings = (ActorMaterializerSettings)materializerSettings.getOrElse((Function0 & Serializable & scala.Serializable)() -> ActorMaterializerSettings$.MODULE$.apply(system));
        return this.apply(settings, (String)namePrefix.getOrElse((Function0 & Serializable & scala.Serializable)() -> "flow"), context);
    }

    public ActorMaterializer apply(ActorMaterializerSettings materializerSettings, String namePrefix, ActorRefFactory context) {
        AtomicBoolean haveShutDown = new AtomicBoolean(false);
        ActorSystem system = this.actorSystemOf(context);
        return new PhasedFusingActorMaterializer(system, materializerSettings, system.dispatchers(), this.actorOfStreamSupervisor(materializerSettings, context, haveShutDown), haveShutDown, ((FlowNames)FlowNames$.MODULE$.apply(system)).name().copy(namePrefix));
    }

    private ActorRef actorOfStreamSupervisor(ActorMaterializerSettings materializerSettings, ActorRefFactory context, AtomicBoolean haveShutDown) {
        ActorRef actorRef2;
        ActorRefFactory actorRefFactory = context;
        if (actorRefFactory instanceof ExtendedActorSystem) {
            ExtendedActorSystem extendedActorSystem = (ExtendedActorSystem)actorRefFactory;
            actorRef2 = extendedActorSystem.systemActorOf(StreamSupervisor$.MODULE$.props(materializerSettings, haveShutDown).withDispatcher(materializerSettings.dispatcher()), StreamSupervisor$.MODULE$.nextName());
        } else if (actorRefFactory instanceof ActorContext) {
            ActorContext actorContext = (ActorContext)actorRefFactory;
            actorRef2 = actorContext.actorOf(StreamSupervisor$.MODULE$.props(materializerSettings, haveShutDown).withDispatcher(materializerSettings.dispatcher()), StreamSupervisor$.MODULE$.nextName());
        } else {
            throw new MatchError((Object)actorRefFactory);
        }
        return actorRef2;
    }

    public ActorMaterializer apply(ActorMaterializerSettings materializerSettings, ActorRefFactory context) {
        return this.apply((Option<ActorMaterializerSettings>)new Some((Object)materializerSettings), (Option<String>)None$.MODULE$, context);
    }

    public Option<ActorMaterializerSettings> apply$default$1() {
        return None$.MODULE$;
    }

    public Option<String> apply$default$2() {
        return None$.MODULE$;
    }

    public ActorMaterializer systemMaterializer(ActorMaterializerSettings materializerSettings, String namePrefix, ExtendedActorSystem system) {
        AtomicBoolean haveShutDown = new AtomicBoolean(false);
        return new PhasedFusingActorMaterializer((ActorSystem)system, materializerSettings, system.dispatchers(), system.systemActorOf(StreamSupervisor$.MODULE$.props(materializerSettings, haveShutDown).withDispatcher(materializerSettings.dispatcher()), StreamSupervisor$.MODULE$.nextName()), haveShutDown, ((FlowNames)FlowNames$.MODULE$.apply((ActorSystem)system)).name().copy(namePrefix));
    }

    public ActorMaterializer create(ActorRefFactory context) {
        return this.apply(this.apply$default$1(), this.apply$default$2(), context);
    }

    public ActorMaterializer create(ActorMaterializerSettings settings, ActorRefFactory context) {
        return this.apply((Option<ActorMaterializerSettings>)Option$.MODULE$.apply((Object)settings), (Option<String>)None$.MODULE$, context);
    }

    public ActorMaterializer create(ActorMaterializerSettings settings, ActorRefFactory context, String namePrefix) {
        return this.apply((Option<ActorMaterializerSettings>)Option$.MODULE$.apply((Object)settings), (Option<String>)Option$.MODULE$.apply((Object)namePrefix), context);
    }

    /*
     * WARNING - void declaration
     */
    private ActorSystem actorSystemOf(ActorRefFactory context) {
        void var3_6;
        ExtendedActorSystem extendedActorSystem;
        ActorRefFactory actorRefFactory = context;
        if (actorRefFactory instanceof ExtendedActorSystem) {
            ExtendedActorSystem extendedActorSystem2;
            extendedActorSystem = extendedActorSystem2 = (ExtendedActorSystem)actorRefFactory;
        } else if (actorRefFactory instanceof ActorContext) {
            ActorContext actorContext = (ActorContext)actorRefFactory;
            extendedActorSystem = actorContext.system();
        } else {
            if (actorRefFactory == null) {
                throw new IllegalArgumentException("ActorRefFactory context must be defined");
            }
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"ActorRefFactory context must be an ActorSystem or ActorContext, got [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{context.getClass().getName()})));
        }
        ExtendedActorSystem system = extendedActorSystem;
        return var3_6;
    }

    private ActorMaterializer$() {
        MODULE$ = this;
    }
}

