/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.maplembse.capella.adapter;

import com.maplesoft.maplembse.capella.adapter.CapellaDialogBox;
import com.maplesoft.maplembse.capella.adapter.CapellaPackageRegistry;
import com.maplesoft.maplembse.capella.adapter.mpm.MPMAbstractTraceTargetElement;
import com.maplesoft.maplembse.capella.adapter.mpm.MPMCapellaRelation;
import com.maplesoft.maplembse.capella.adapter.mpm.MPMElementOwner;
import com.maplesoft.maplembse.capella.adapter.mpm.MPMRecursiveElements;
import com.maplesoft.maplembse.capella.adapter.mpm.MPMReferencingElements;
import com.maplesoft.maplembse.license.CheckLicense;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.FeatureMapUtil;
import org.openmbee.mpspi.MPAdapter;
import org.openmbee.mpspi.exceptions.MPAccessException;
import org.openmbee.mpspi.exceptions.MPDataLoadException;
import org.openmbee.mpspi.exceptions.MPException;
import org.openmbee.mpspi.modifier.MPModifier;
import org.openmbee.mpspi.svc.MPBaseAdapter;
import org.polarsys.capella.core.data.capellamodeller.Project;

public class MPCapellaAdapter
extends MPBaseAdapter {
    private final CapellaDialogBox capellaDialogBox = new CapellaDialogBox();
    private CapellaPackageRegistry capellaPackageRegistry;
    private ResourceSet resourceSet;
    private Resource resource;
    private Project project = null;

    public MPCapellaAdapter() {
        try {
            this.setTransaction(true);
            this.registerMPModifier((MPModifier)new MPMAbstractTraceTargetElement(this));
            this.registerMPModifier((MPModifier)new MPMCapellaRelation.CapIncomingRelation(this));
            this.registerMPModifier((MPModifier)new MPMCapellaRelation.CapOutgoingRelation(this));
            this.registerMPModifier((MPModifier)new MPMElementOwner(this));
            this.registerMPModifier((MPModifier)new MPMRecursiveElements(this));
            this.registerMPModifier((MPModifier)new MPMReferencingElements(this));
        }
        catch (MPException e) {
            e.printStackTrace();
        }
    }

    public Serializable getInformation(MPAdapter.InformationOption option) throws MPException {
        switch (option) {
            case NAME: {
                return "Capella Adapter";
            }
            case SPECIFICATIONS: {
                return MPCapellaAdapter.specifications((String[])new String[]{"false,,capella,Capella Adapter"});
            }
        }
        return super.getInformation(option);
    }

    public EPackage.Registry getPackageRegistry() {
        if (this.capellaPackageRegistry == null) {
            this.capellaPackageRegistry = new CapellaPackageRegistry();
        }
        return this.capellaPackageRegistry;
    }

    public Resource getResource() {
        return this.resource;
    }

    public Project getProject() {
        if (this.project != null) {
            return this.project;
        }
        TreeIterator contents = this.resource.getAllContents();
        while (contents.hasNext()) {
            EObject element = (EObject)contents.next();
            if (!(element instanceof Project)) continue;
            this.project = (Project)element;
            break;
        }
        return this.project;
    }

    public void load(URI uri, Map<MPAdapter.LoadOption, Object> option) throws MPException {
        CheckLicense.check((String)"MapleMBSECapAdapter");
        this.resourceSet = new ResourceSetImpl();
        try {
            this.resource = this.resourceSet.getResource(uri, true);
            if (this.resource == null) {
                throw new MPDataLoadException("Failed to load Model (possibly the model is nonexistent): " + uri);
            }
            this.resource.setTrackingModification(true);
        }
        catch (WrappedException we) {
            Exception e = we.exception();
            if (e instanceof MPException) {
                throw (MPException)((Object)e);
            }
            throw we;
        }
    }

    public MPAdapter.ReloadResult reload() throws MPException {
        int result = this.capellaDialogBox.messageBox("Reload", "Reloading the model may discard your unsaved changes. Are you sure to continue?", 296);
        if (result == 256) {
            return MPAdapter.ReloadResult.DONE;
        }
        Resource r = this.checkResource();
        if (r.isLoaded()) {
            r.unload();
        }
        try {
            r.load(Collections.EMPTY_MAP);
        }
        catch (IOException e) {
            throw new MPAccessException("Failed to reload", (Throwable)e);
        }
        super.clearUndoRedoStacks();
        return MPAdapter.ReloadResult.NEED_REACTIVATE;
    }

    public Object get(EObject eObj, EStructuralFeature feature) throws MPException {
        return super.get(eObj, feature);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(EObject eObj, EStructuralFeature feature, Object value, int index) throws MPException {
        try {
            super.add(eObj, feature, value, index);
            super.commit();
        }
        finally {
            super.addUndoLog();
            super.clearTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set(EObject eObj, EStructuralFeature feature, Object value) throws MPException {
        try {
            if (value != null && value.equals("")) {
                return;
            }
            super.set(eObj, feature, value);
            super.commit();
        }
        finally {
            super.addUndoLog();
            super.clearTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unset(EObject eObj, EStructuralFeature feature, Object value) throws MPException {
        try {
            super.unset(eObj, feature, value);
            super.commit();
        }
        finally {
            super.addUndoLog();
            super.clearTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(EObject eObj, EStructuralFeature feature, Object value) throws MPException {
        try {
            super.remove(eObj, feature, value);
            super.commit();
        }
        finally {
            super.addUndoLog();
            super.clearTransaction();
        }
    }

    public void delete(EObject eObj) throws MPException {
        try {
            this.deleteRecursively(eObj);
            super.commit();
        }
        finally {
            super.addUndoLog();
            super.clearTransaction();
        }
    }

    private static void saveInternal(Resource r) throws MPException {
        try {
            r.save(null);
        }
        catch (IOException e) {
            throw new MPAccessException("Failed to save the model to: " + r.getURI().toString(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(Map<MPAdapter.SaveOption, Object> option) throws MPException {
        Resource r = this.checkResource();
        URI origURI = r.getURI();
        URI uri = MPCapellaAdapter.checkSaveAs(option);
        if (uri == null || uri.equals(origURI)) {
            MPCapellaAdapter.saveInternal(r);
        } else {
            try {
                r.setURI(uri);
                MPCapellaAdapter.saveInternal(r);
            }
            finally {
                if (MPCapellaAdapter.checkSaveCopyAs(option)) {
                    r.setURI(origURI);
                }
            }
        }
        super.clearUndoRedoStacks();
    }

    public void unload() throws MPException {
        Resource r = this.checkResource();
        r.unload();
        this.resource = null;
    }

    protected void deleteEObject(EObject eobj) throws MPException {
        Collection usages = EcoreUtil.UsageCrossReferencer.find((EObject)eobj, (ResourceSet)this.resourceSet);
        for (EStructuralFeature.Setting setting : usages) {
            EObject eoS = setting.getEObject();
            EStructuralFeature f = setting.getEStructuralFeature();
            if (!f.isChangeable()) continue;
            if (FeatureMapUtil.isMany((EObject)eoS, (EStructuralFeature)f)) {
                this.doRemove(eoS, f, eobj);
                continue;
            }
            this.doUnset(eoS, f, eobj);
        }
        if (eobj instanceof InternalEObject) {
            Resource.Internal dr;
            EReference feature;
            InternalEObject ieo = (InternalEObject)eobj;
            InternalEObject container = ieo.eInternalContainer();
            if (container != null && (feature = eobj.eContainmentFeature()).isChangeable()) {
                if (FeatureMapUtil.isMany((EObject)container, (EStructuralFeature)feature)) {
                    this.doRemove((EObject)container, (EStructuralFeature)feature, eobj);
                } else {
                    this.doUnset((EObject)container, (EStructuralFeature)feature, eobj);
                }
            }
            if ((dr = ieo.eDirectResource()) != null) {
                this.doDelete(eobj, (Resource)dr);
            }
        }
    }

    private void deleteRecursively(EObject eObj) throws MPException {
        EClass cls = eObj.eClass();
        this.deleteContents(eObj, cls);
        this.deleteEObject(eObj);
    }

    private void deleteContents(EObject eObj, EClass cls) throws MPException {
        for (EReference ref : cls.getEAllContainments()) {
            Object o = eObj.eGet((EStructuralFeature)ref);
            if (o == null) continue;
            if (ref.isMany()) {
                EObject[] childrenArray;
                EList children = (EList)o;
                if (children == null || children.isEmpty()) continue;
                for (EObject child : childrenArray = (EObject[])children.toArray((Object[])new EObject[0])) {
                    this.deleteRecursively(child);
                }
                continue;
            }
            this.deleteRecursively((EObject)o);
        }
    }
}

