/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.platform.sirius.clipboard.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.sirius.diagram.AbstractDNode;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DSemanticDiagram;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.cs.Part;
import org.polarsys.capella.core.data.la.LogicalArchitecture;
import org.polarsys.capella.core.platform.sirius.clipboard.util.SiriusUtil;

public class DiagramBusinessHelper {
    private static final DiagramBusinessHelper INSTANCE = new DiagramBusinessHelper();
    private static final Collection<String> DUMMY_MAPPING_NAMES = Collections.unmodifiableCollection(Arrays.asList("lab sub components"));
    private static final String PHYSICAL_COMPONENT_MAPPING_NAME = "pab_pc";
    private static final String DEPLOYMENT_MAPPING_NAME = "pab_deployment";
    private static final Collection<String> SUBCOMPONENT_MAPPING_NAMES = Collections.unmodifiableCollection(Arrays.asList("lab logical component", "pab_pc"));

    public static DiagramBusinessHelper getInstance() {
        return INSTANCE;
    }

    private DiagramBusinessHelper() {
    }

    public EObject getRepresentableElement(EObject element_p, DDiagram diagram_p) {
        Component component;
        EObject result = element_p;
        if ((this.isLab(diagram_p) || this.isPab(diagram_p)) && element_p instanceof Component && (component = (Component)element_p).getAbstractTypedElements().size() == 1) {
            result = (EObject)component.getAbstractTypedElements().get(0);
        }
        return result;
    }

    public EObject getRepresentedStorage(Object representation_p) {
        DSemanticDiagram diagram;
        DSemanticDecorator graphicalSource;
        EObject result = SiriusUtil.getSemanticElement(representation_p);
        if (result instanceof Part) {
            result = ((Part)result).getAbstractType();
        }
        if ((graphicalSource = this.toSiriusElement(representation_p)) instanceof DSemanticDiagram && this.diagramTargetIsExplicitlyRepresented(diagram = (DSemanticDiagram)graphicalSource)) {
            if (this.isLab((DDiagram)diagram)) {
                Component rootLc = this.getLogicalArchitecture(diagram.getTarget()).getSystem();
                if (rootLc != null) {
                    result = rootLc;
                }
            } else {
                result = result.eContainer();
            }
        }
        return result;
    }

    private LogicalArchitecture getLogicalArchitecture(EObject current_p) {
        if (current_p == null) {
            return null;
        }
        if (current_p instanceof LogicalArchitecture) {
            return (LogicalArchitecture)current_p;
        }
        return this.getLogicalArchitecture(current_p.eContainer());
    }

    private boolean isLab(DDiagram diagram_p) {
        boolean result = false;
        String descName = diagram_p.getDescription().getName();
        if (descName != null) {
            result = descName.toLowerCase().contains("logical architecture");
        }
        return result;
    }

    private boolean isPab(DDiagram diagram_p) {
        boolean result = false;
        String descName = diagram_p.getDescription().getName();
        if (descName != null) {
            result = descName.toLowerCase().contains("physical architecture");
        }
        return result;
    }

    private DSemanticDecorator toSiriusElement(Object source_p) {
        DSemanticDecorator result = null;
        Object current = source_p;
        if (current instanceof EditPart) {
            current = ((EditPart)source_p).getModel();
        }
        if (current instanceof View) {
            current = ((View)current).getElement();
        }
        if (current instanceof DSemanticDecorator) {
            result = (DSemanticDecorator)current;
        }
        return result;
    }

    private boolean diagramTargetIsExplicitlyRepresented(DSemanticDiagram diagram_p) {
        EObject diagramTarget = diagram_p.getTarget();
        if (diagramTarget == null) {
            return false;
        }
        ArrayList subNodes = new ArrayList();
        subNodes.addAll(diagram_p.getContainers());
        subNodes.addAll(diagram_p.getNodeListElements());
        subNodes.addAll(diagram_p.getNodes());
        for (AbstractDNode currentNode : subNodes) {
            if (diagramTarget != currentNode.getTarget()) continue;
            return true;
        }
        return false;
    }
}

