/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.maplembse.generic.uml.adapter.mpa;

import com.maplesoft.maplembse.common.models.twc.TwcPackage;
import com.maplesoft.maplembse.generic.uml.adapter.M2Element;
import com.maplesoft.maplembse.generic.uml.adapter.Util;
import java.util.Collections;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.openmbee.mpspi.exceptions.MPException;
import org.openmbee.mpspi.exceptions.MPInvalidException;
import org.openmbee.mpspi.modifier.MPAbstractModifier;
import org.openmbee.mpspi.modifier.MPAbstractNotificationModifier;
import org.openmbee.mpspi.modifier.MPNotificationModifier;
import org.openmbee.mpspi.svc.MPBaseAdapter;

public class MPMMultiplicity
extends MPAbstractModifier {
    public static final Logger LOGGER = Logger.getLogger(MPMMultiplicity.class);
    private static final String iRegex = "0|[1-9][0-9]*";
    private static final String pRegex = "(?<=\\.|\\s)";
    private static final String mRegex = String.format("((%s)\\s*\\.\\.\\s*)?(%s\\-1|\\*|(%1$s)(\\.0)?)", "0|[1-9][0-9]*", "(?<=\\.|\\s)");
    private static final Pattern mPattern = Pattern.compile(mRegex);

    public MPMMultiplicity(MPBaseAdapter adapter) throws MPException {
        super(adapter);
    }

    public Object get(EObject eobj, EStructuralFeature feature) throws MPException {
        if (!Util.isInstanceOf(eobj, M2Element.MultiplicityElement)) {
            throw new MPInvalidException("Invalid for " + feature + " " + eobj);
        }
        return MPMMultiplicity.getMultiplicityString(eobj);
    }

    private static String getMultiplicityString(EObject eobj) throws MPInvalidException {
        int lower = 0;
        EObject lowerValue = (EObject)eobj.eGet(M2Element.MultiplicityElement$lowerValue);
        if (lowerValue == null) {
            return null;
        }
        if (Util.isInstanceOf(lowerValue, M2Element.LiteralInteger)) {
            lower = (Integer)lowerValue.eGet(M2Element.LiteralInteger$value);
        } else if (Util.isInstanceOf(lowerValue, M2Element.LiteralUnlimitedNatural)) {
            lower = (Integer)lowerValue.eGet(M2Element.LiteralUnlimitedNatural$value);
        } else {
            throw new MPInvalidException("Wrong access to non-integer literal");
        }
        if (lower < 0) {
            return null;
        }
        int upper = -1;
        EObject upperValue = (EObject)eobj.eGet(M2Element.MultiplicityElement$upperValue);
        if (upperValue == null) {
            return null;
        }
        if (Util.isInstanceOf(upperValue, M2Element.LiteralInteger)) {
            upper = (Integer)upperValue.eGet(M2Element.LiteralInteger$value);
        } else if (Util.isInstanceOf(upperValue, M2Element.LiteralUnlimitedNatural)) {
            upper = (Integer)upperValue.eGet(M2Element.LiteralUnlimitedNatural$value);
        } else {
            throw new MPInvalidException("Wrong access to non-integer literal");
        }
        if (lower > upper && upper != -1) {
            return null;
        }
        String m = "" + lower;
        if (lower != upper) {
            m = m + (String)(upper == -1 ? "..*" : ".." + upper);
        }
        return m;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void set(EObject obj, EStructuralFeature feature, Object value, Object oldValue) throws MPException {
        if (!Util.isInstanceOf(obj, M2Element.MultiplicityElement)) {
            return;
        }
        if (value == null) {
            value = "1";
        }
        if (!(value instanceof String)) {
            throw new MPInvalidException("Invalid input, a string was expected");
        }
        int lower = 0;
        int upper = -1;
        String m = (String)value;
        if (m.length() == 0) {
            return;
        }
        Matcher matcher = mPattern.matcher(m);
        if (m.equals("*")) {
            lower = 0;
            upper = -1;
        } else {
            if (!matcher.matches()) throw new MPInvalidException("Make sure you are using a text input and the accepted pattern.");
            String[] splits = m.replaceAll("\\s", "").split("\\.\\.");
            assert (splits.length == 1 || splits.length == 2) : splits;
            try {
                lower = upper = Integer.parseInt(splits[0].split("\\.")[0]);
                int upperIndex = splits.length - 1;
                if (upperIndex != 0) {
                    upper = splits[upperIndex].equals("*") ? -1 : Integer.parseInt(splits[upperIndex]);
                }
            }
            catch (NumberFormatException exception) {
                throw new MPInvalidException("Invalid number, error while casting.");
            }
        }
        if (lower > upper && upper != -1) {
            throw new MPInvalidException("Invalid input");
        }
        EObject lowerValue = this.adapter.instantiate(M2Element.LiteralInteger, Collections.singletonMap(M2Element.LiteralInteger$value, lower));
        EObject upperValue = this.adapter.instantiate(M2Element.LiteralUnlimitedNatural, Collections.singletonMap(M2Element.LiteralUnlimitedNatural$value, upper));
        this.doSet(obj, M2Element.MultiplicityElement$lowerValue, lowerValue, obj.eGet(M2Element.MultiplicityElement$lowerValue));
        this.doSet(obj, M2Element.MultiplicityElement$upperValue, upperValue, obj.eGet(M2Element.MultiplicityElement$upperValue));
        MPMMultiplicity.addNotificationModifier((Notifier)obj, (MPNotificationModifier)UpperValueNM.INSTANCE);
    }

    public EModelElement getModificationCriteria() {
        return TwcPackage.eINSTANCE.getTwcClass_MultiplicityProperty();
    }

    private static class UpperValueNM
    extends MPAbstractNotificationModifier {
        private static UpperValueNM INSTANCE = new UpperValueNM();

        protected UpperValueNM() {
            super(M2Element.MultiplicityElement$upperValue);
        }

        protected void changed(Object obj, Notification msg, boolean isAdded) {
            try {
                EObject eobj = (EObject)msg.getNotifier();
                String str = MPMMultiplicity.getMultiplicityString(eobj);
                this.send(eobj, (EStructuralFeature)TwcPackage.eINSTANCE.getTwcClass_MultiplicityProperty(), str, isAdded);
            }
            catch (MPInvalidException e) {
                LOGGER.error((Object)e);
            }
        }
    }
}

