/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.maplembse.generic.uml.adapter.mpa;

import com.maplesoft.maplembse.common.models.twc.TwcPackage;
import com.maplesoft.maplembse.generic.uml.adapter.M2Element;
import com.maplesoft.maplembse.generic.uml.adapter.Util;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.openmbee.mpspi.exceptions.MPException;
import org.openmbee.mpspi.exceptions.MPInvalidException;
import org.openmbee.mpspi.modifier.MPAbstractModifier;
import org.openmbee.mpspi.svc.MPBaseAdapter;

public class MPMDurationConstraint
extends MPAbstractModifier {
    public static final Logger LOGGER = Logger.getLogger(MPMDurationConstraint.class);
    private Pattern pattern = Pattern.compile("(?<!\\\\)\\.\\.");

    public MPMDurationConstraint(MPBaseAdapter adapter) throws MPException {
        super(adapter);
    }

    public EModelElement getModificationCriteria() {
        return TwcPackage.eINSTANCE.getTwcClass_DurationConstraint();
    }

    public Object get(EObject eobj, EStructuralFeature feature) throws MPException {
        if (!Util.isInstanceOf(eobj, M2Element.Constraint)) {
            throw new MPInvalidException("Invalid for " + feature + " " + eobj);
        }
        EObject durationInterval = (EObject)eobj.eGet(M2Element.Constraint$specification);
        if (durationInterval != null) {
            EObject maxDuration = (EObject)durationInterval.eGet(M2Element.Interval$max);
            String str2 = "";
            if (maxDuration != null) {
                EObject maxVS = (EObject)maxDuration.eGet(M2Element.Duration$expr);
                str2 = maxVS.eGet(M2Element.LiteralString$value).toString();
            }
            String str1 = "";
            EObject minDuration = (EObject)durationInterval.eGet(M2Element.Interval$min);
            if (minDuration != null) {
                EObject minVS = (EObject)minDuration.eGet(M2Element.Duration$expr);
                str1 = minVS.eGet(M2Element.LiteralString$value).toString();
            }
            return String.format("%s .. %s", str1, str2);
        }
        return "";
    }

    public void set(EObject eObj, EStructuralFeature feature, Object value, Object oldValue) throws MPException {
        if (!Util.isInstanceOf(eObj, M2Element.Constraint)) {
            throw new MPInvalidException("Invalid for " + feature + " " + eObj);
        }
        if (!(value instanceof String)) {
            throw new MPInvalidException("Invalid for " + feature + " " + value);
        }
        Matcher matcher = this.pattern.matcher(value.toString());
        if (!matcher.find()) {
            throw new MPInvalidException("Invalid for " + feature + " " + value);
        }
        String[] values = this.pattern.split((String)value);
        if (values.length < 2) {
            throw new MPInvalidException("Invalid values for the DurationConstraint");
        }
        this.checkValues(values);
        try {
            EObject durationInterval = (EObject)eObj.eGet(M2Element.Constraint$specification);
            if (durationInterval == null) {
                this.createValues(eObj, values);
            } else {
                this.updateValue(durationInterval, values);
            }
        }
        catch (Throwable th) {
            if (th instanceof IllegalStateException) {
                return;
            }
            LOGGER.error((Object)"Something went wrong while finding the LiteralString values specifications. They might need to be created first.", th);
        }
    }

    private void checkValues(String[] values) throws MPException {
        try {
            for (int i = 1; i < values.length; ++i) {
                float max;
                float min = Float.valueOf(values[i - 1]).floatValue();
                if (!(min > (max = Float.valueOf(values[i]).floatValue()))) continue;
                throw new MPInvalidException("min value should not be greater then max value");
            }
        }
        catch (NumberFormatException e) {
            return;
        }
    }

    private void createValues(EObject eObj, String[] values) {
        EObject durationInterval = Util.instantiateEClass(M2Element.DurationInterval);
        EObject activity = eObj.eContainer();
        this.createDuration(activity, durationInterval, values[0].trim(), M2Element.Interval$min);
        this.createDuration(activity, durationInterval, values[1].trim(), M2Element.Interval$max);
        this.doSet(eObj, M2Element.Constraint$specification, durationInterval, null);
        this.doAdd(eObj, M2Element.Constraint$constrainedElement, activity);
    }

    private void createDuration(EObject owner, EObject durationInterval, String value, EStructuralFeature feature) {
        EObject maxTimeEvent = Util.instantiateEClass(M2Element.TimeEvent);
        this.doAdd(owner, M2Element.Behavior$event, maxTimeEvent, -1);
        EObject maxTimeExpression = Util.instantiateEClass(M2Element.TimeExpression);
        this.doSet(maxTimeEvent, M2Element.TimeEvent$when, maxTimeExpression, null);
        EObject maxDuration = Util.instantiateEClass(M2Element.Duration);
        this.doSet(maxTimeExpression, M2Element.TimeExpression$expr, maxDuration, null);
        EObject maxExpr = Util.instantiateEClass(M2Element.LiteralString);
        this.doSet(maxDuration, M2Element.Duration$expr, maxExpr, null);
        this.doSet(maxExpr, M2Element.LiteralString$value, value, null);
        EObject durationObservation = Util.instantiateEClass(M2Element.DurationObservation);
        this.doAdd(owner, M2Element.Behavior$observation, durationObservation, -1);
        this.doAdd(maxDuration, M2Element.Duration$observation, durationObservation, -1);
        this.doSet(durationInterval, feature, maxDuration, null);
    }

    private void updateValue(EObject durationInterval, String[] values) {
        EObject maxDuration = (EObject)durationInterval.eGet(M2Element.Interval$max);
        EObject minDuration = (EObject)durationInterval.eGet(M2Element.Interval$min);
        EObject maxVS = (EObject)maxDuration.eGet(M2Element.Duration$expr);
        EObject minVS = (EObject)minDuration.eGet(M2Element.Duration$expr);
        this.doSet(minVS, M2Element.LiteralString$value, values[0].trim(), minVS.eGet(M2Element.LiteralString$value));
        this.doSet(maxVS, M2Element.LiteralString$value, values[1].trim(), maxVS.eGet(M2Element.LiteralString$value));
    }
}

