/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.maplembse.generic.uml.adapter.mpa;

import com.maplesoft.maplembse.common.models.twc.TwcPackage;
import com.maplesoft.maplembse.generic.uml.adapter.M2Element;
import com.maplesoft.maplembse.generic.uml.adapter.Util;
import com.maplesoft.maplembse.generic.uml.adapter.mpa.MPANM_ActivityEdge;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.openmbee.mpspi.exceptions.MPException;
import org.openmbee.mpspi.exceptions.MPInvalidException;
import org.openmbee.mpspi.modifier.MPAbstractModifier;
import org.openmbee.mpspi.modifier.MPNotificationModifier;
import org.openmbee.mpspi.svc.MPBaseAdapter;

public class MPMActivityObjectFlow
extends MPAbstractModifier {
    private static final EEnum directionEnum = M2Element.ParameterDirectionKind;
    private static final Enumerator PARAMETER_IN = directionEnum.getEEnumLiteral("in").getInstance();
    private static final Enumerator PARAMETER_INOUT = directionEnum.getEEnumLiteral("inout").getInstance();
    private static final Enumerator PARAMETER_OUT = directionEnum.getEEnumLiteral("out").getInstance();
    private static final Enumerator PARAMETER_RETURN = directionEnum.getEEnumLiteral("return").getInstance();
    private static final Pattern inputPinNameRegex = Pattern.compile("^input([0-9]*)$");
    private static final Pattern outputPinNameRegex = Pattern.compile("^output([0-9]*)$");

    public MPMActivityObjectFlow(MPBaseAdapter adapter) throws MPException {
        super(adapter);
    }

    public Object get(EObject obj, EStructuralFeature feature) throws MPException {
        EObject node;
        if (!Util.isInstanceOf(obj, M2Element.ActivityNode)) {
            throw new MPInvalidException("Invalid feature: " + feature + " for:" + obj);
        }
        BasicEList edges = new BasicEList();
        if (Util.isInstanceOf(obj, M2Element.CallAction)) {
            node = obj;
            List<EObject> restultPins = Util.getEList(node, M2Element.CallAction$result);
            for (EObject pin : restultPins) {
                EObject sourceNode = pin.eContainer();
                this.monitorCallActionResultNM(sourceNode);
                List<EObject> outgoingEdges = Util.getEList(pin, M2Element.ActivityNode$outgoing);
                edges.addAll(outgoingEdges);
            }
        }
        node = obj;
        List<EObject> outgoingEdges = Util.getEList(node, M2Element.ActivityNode$outgoing);
        edges.addAll(outgoingEdges);
        BasicEList activityNodes = new BasicEList();
        for (EObject edge : edges) {
            if (!Util.isInstanceOf(edge, M2Element.ObjectFlow)) continue;
            this.monitorActivityEdge(edge);
            EObject tmp = (EObject)edge.eGet(M2Element.ActivityEdge$target);
            if (Util.isInstanceOf(tmp, M2Element.InputPin)) {
                EObject pin = tmp;
                EObject targetNode = pin.eContainer();
                this.monitorInvocationActionArgumentNM(targetNode);
                activityNodes.add(targetNode);
                continue;
            }
            if (!Util.isInstanceOf(tmp, M2Element.ActivityNode)) continue;
            activityNodes.add(tmp);
        }
        return activityNodes;
    }

    private void monitorActivity(EObject activity) {
        MPMActivityObjectFlow.addNotificationModifier((Notifier)activity, (MPNotificationModifier)MPANM_ActivityEdge.activityEdgeNM);
    }

    private void monitorActivityEdge(EObject edge) {
        MPMActivityObjectFlow.addNotificationModifier((Notifier)edge, (MPNotificationModifier)MPANM_ActivityEdge.activityEdgeSourceNM);
        MPMActivityObjectFlow.addNotificationModifier((Notifier)edge, (MPNotificationModifier)MPANM_ActivityEdge.activityEdgeTargetNM);
    }

    private void monitorCallActionResultNM(EObject node) {
        MPMActivityObjectFlow.addNotificationModifier((Notifier)node, (MPNotificationModifier)MPANM_ActivityEdge.callActionResultNM);
    }

    private void monitorInvocationActionArgumentNM(EObject node) {
        MPMActivityObjectFlow.addNotificationModifier((Notifier)node, (MPNotificationModifier)MPANM_ActivityEdge.invocationActionArgumentNM);
    }

    private boolean canAcceptIncomingFlow(EObject node) {
        if (Util.isInstanceOf(node, M2Element.InvocationAction) || Util.isInstanceOf(node, M2Element.InputPin)) {
            return true;
        }
        if (Util.isInstanceOf(node, M2Element.ActivityParameterNode)) {
            EObject param = (EObject)node.eGet(M2Element.ActivityParameterNode$parameter);
            Enumerator direction = (Enumerator)param.eGet(M2Element.Parameter$direction);
            if (PARAMETER_OUT.equals(direction) || PARAMETER_RETURN.equals(direction)) {
                return true;
            }
            if (PARAMETER_INOUT.equals(direction)) {
                return Util.getEList(node, M2Element.ActivityNode$outgoing).isEmpty();
            }
            return false;
        }
        return Util.isInstanceOf(node, M2Element.ControlNode) || Util.isInstanceOf(node, M2Element.ObjectNode) || Util.isInstanceOf(node, M2Element.AcceptEventAction);
    }

    public void add(EObject owner, EStructuralFeature feature, Object value, int index) throws MPException {
        EObject source;
        EObject tmp;
        Object name;
        List usedSuffixes;
        List matchers;
        List<EObject> pins;
        EObject target;
        if (Util.isInstanceOf(owner, M2Element.InitialNode) || Util.isInstanceOf(value, M2Element.InitialNode)) {
            throw new MPInvalidException("Invalid feature: " + feature);
        }
        if (!Util.isInstanceOf(owner, M2Element.ActivityNode) || Util.isInstanceOf(owner, M2Element.FinalNode)) {
            throw new MPInvalidException("Invalid feature: " + feature + " for:" + owner);
        }
        if (!Util.isInstanceOf(value, M2Element.ActivityNode)) {
            throw new MPInvalidException("Invalid feature: " + feature + " for:" + value);
        }
        if (!this.canAcceptIncomingFlow((EObject)value)) {
            throw new MPInvalidException(value + " cannot accept an incoming object flow");
        }
        EObject objectFlow = Util.instantiateEClass(M2Element.ObjectFlow);
        EObject sourceActivity = null;
        EObject targetActivity = null;
        if (Util.isInstanceOf(value, M2Element.InvocationAction) && !Util.isInstanceOf(owner, M2Element.ObjectNode)) {
            EObject iAction = (EObject)value;
            targetActivity = (EObject)iAction.eGet(M2Element.ActivityNode$activity);
            target = Util.instantiateEClass(M2Element.InputPin);
            this.adapter.add(iAction, M2Element.InvocationAction$argument, (Object)target, -1);
            this.monitorInvocationActionArgumentNM(iAction);
            pins = Util.getEList(iAction, M2Element.InvocationAction$argument);
            matchers = pins.stream().map(p -> p.eGet(M2Element.NamedElement$name).toString()).map(inputPinNameRegex::matcher).filter(Matcher::find).collect(Collectors.toList());
            usedSuffixes = matchers.stream().map(m -> m.group(1)).filter(s -> !s.isEmpty()).map(Integer::valueOf).collect(Collectors.toList());
            Collections.sort(usedSuffixes, Collections.reverseOrder(Integer::compare));
            name = "input";
            if (usedSuffixes.isEmpty() && !matchers.isEmpty()) {
                name = (String)name + "1";
            }
            if (!usedSuffixes.isEmpty()) {
                name = (String)name + ((Integer)usedSuffixes.get(0) + 1);
            }
            EObject eObject = tmp = !Util.isInstanceOf(iAction, M2Element.CallBehaviorAction) || iAction.eGet(M2Element.CallBehaviorAction$behavior) == null ? target : (EObject)target.eGet(M2Element.Element$syncElement);
            if (tmp == null) {
                tmp = target;
            }
            this.adapter.set(tmp, M2Element.NamedElement$name, name);
        } else {
            target = (EObject)value;
            targetActivity = (EObject)target.eGet(M2Element.ActivityNode$activity);
        }
        if (Util.isInstanceOf(owner, M2Element.CallAction) && !Util.isInstanceOf(value, M2Element.ObjectNode)) {
            EObject cAction = owner;
            sourceActivity = (EObject)cAction.eGet(M2Element.ActivityNode$activity);
            source = Util.instantiateEClass(M2Element.OutputPin);
            this.adapter.add(cAction, M2Element.CallAction$result, (Object)source, -1);
            this.monitorCallActionResultNM(cAction);
            pins = Util.getEList(cAction, M2Element.CallAction$result);
            matchers = pins.stream().map(p -> p.eGet(M2Element.NamedElement$name).toString()).map(outputPinNameRegex::matcher).filter(Matcher::find).collect(Collectors.toList());
            usedSuffixes = matchers.stream().map(m -> m.group(1)).filter(s -> !s.isEmpty()).map(Integer::valueOf).collect(Collectors.toList());
            Collections.sort(usedSuffixes, Collections.reverseOrder(Integer::compare));
            name = "output";
            if (usedSuffixes.isEmpty() && !matchers.isEmpty()) {
                name = (String)name + "1";
            }
            if (!usedSuffixes.isEmpty()) {
                name = (String)name + ((Integer)usedSuffixes.get(0) + 1);
            }
            EObject eObject = tmp = !Util.isInstanceOf(cAction, M2Element.CallBehaviorAction) || cAction.eGet(M2Element.CallBehaviorAction$behavior) == null ? source : (EObject)source.eGet(M2Element.Element$syncElement);
            if (tmp == null) {
                tmp = source;
            }
            this.adapter.set(tmp, M2Element.NamedElement$name, name);
        } else {
            source = owner;
            sourceActivity = Util.isInstanceOf(source, M2Element.ObjectNode) ? source.eContainer() : (EObject)source.eGet(M2Element.ActivityNode$activity);
        }
        if (!sourceActivity.equals(targetActivity)) {
            throw new MPInvalidException("MapleMBSE cannot create a objectflow between " + owner.eGet(M2Element.NamedElement$name) + " and  " + ((EObject)value).eGet(M2Element.NamedElement$name) + " because they have different owners");
        }
        this.doAdd(sourceActivity, M2Element.Activity$edge, objectFlow);
        this.doSet(objectFlow, M2Element.ActivityEdge$target, target, null);
        this.doSet(objectFlow, M2Element.ActivityEdge$source, source, null);
        this.monitorActivity(sourceActivity);
        this.monitorActivityEdge(objectFlow);
    }

    public void remove(EObject owner, EStructuralFeature feature, Object value) throws MPException {
        if (!Util.isInstanceOf(owner, M2Element.ActivityNode)) {
            throw new MPInvalidException("Invalid feature: " + feature + " for:" + owner);
        }
        if (!Util.isInstanceOf(value, M2Element.ActivityNode)) {
            throw new MPInvalidException("Invalid feature: " + feature + " for:" + value);
        }
        if (Util.isInstanceOf(owner, M2Element.CallAction)) {
            EObject node = owner;
            List<EObject> results = Util.getEList(node, M2Element.CallAction$result);
            for (EObject pin : results) {
                List<EObject> activityEdges = Util.getEList(pin, M2Element.ActivityNode$outgoing);
                EObject[] edges = new EObject[activityEdges.size()];
                edges = activityEdges.toArray(edges);
                for (int i = 0; i < edges.length; ++i) {
                    EObject invocation;
                    EObject tmp = (EObject)edges[i].eGet(M2Element.ActivityEdge$target);
                    if (!Util.isInstanceOf(tmp, M2Element.InputPin) || !(invocation = tmp.eContainer()).equals(value)) continue;
                    this.adapter.delete(edges[i]);
                }
            }
        } else {
            EObject node = owner;
            ArrayList<EObject> edgesToDelete = new ArrayList<EObject>();
            List<EObject> outgoingEdges = Util.getEList(node, M2Element.ActivityNode$outgoing);
            for (EObject edge : outgoingEdges) {
                EObject tmp = (EObject)edge.eGet(M2Element.ActivityEdge$target);
                if (Util.isInstanceOf(tmp, M2Element.InputPin)) {
                    EObject argument = tmp.eContainer();
                    if (!argument.equals(value)) continue;
                    edgesToDelete.add(edge);
                    continue;
                }
                if (!value.equals(edge.eGet(M2Element.ActivityEdge$target))) continue;
                edgesToDelete.add(edge);
            }
            EObject[] edges = new EObject[edgesToDelete.size()];
            edges = edgesToDelete.toArray(edges);
            for (int i = 0; i < edges.length; ++i) {
                this.adapter.delete(edges[i]);
            }
        }
    }

    public EModelElement getModificationCriteria() {
        return TwcPackage.eINSTANCE.getTwcClass_ActivityObjectFlow();
    }
}

