/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.maplembse.generic.uml.adapter;

import com.maplesoft.maplembse.generic.uml.adapter.M2Element;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.openmbee.mpspi.exceptions.MPIllegalStateException;
import org.openmbee.mpspi.modifier.MPNotificationModifier;
import org.openmbee.mpspi.svc.MPBaseAdapter;

public class Util {
    public static Logger LOGGER = Logger.getLogger(Util.class);
    private static Map<EClass, EStructuralFeature> eClassAndFeatureMap = new HashMap<EClass, EStructuralFeature>();
    private static Map<String, EClass> stringToEClassMap = new HashMap<String, EClass>();

    public static boolean isInstanceOf(Object obj, EClass eClass) {
        if (!(obj instanceof EObject)) {
            return false;
        }
        EObject eobj = (EObject)obj;
        return eClass.isSuperTypeOf(eobj.eClass());
    }

    public static boolean eq(Object o1, Object o2) {
        if (o1 == o2) {
            return true;
        }
        if (o1 == null) {
            return false;
        }
        return o1.equals(o2);
    }

    public static List<EObject> getEList(EObject eobj, EStructuralFeature feature) {
        if (eobj == null) {
            return Collections.emptyList();
        }
        Object o = eobj.eGet(feature);
        if (!(o instanceof List)) {
            return Collections.emptyList();
        }
        List list = (List)o;
        if (!list.isEmpty() && !(list.get(0) instanceof EObject)) {
            return Collections.emptyList();
        }
        List result = list;
        return result;
    }

    @Deprecated
    public static EObject instantiateEClass(String eClassString) {
        EPackage ePackage = M2Element.ePACKAGE;
        EFactory eFactory = ePackage.getEFactoryInstance();
        EClassifier eClassifier = ePackage.getEClassifier(eClassString);
        if (!(eClassifier instanceof EClass)) {
            return null;
        }
        return eFactory.create((EClass)eClassifier);
    }

    public static EObject instantiateEClass(EClass eClass) {
        EPackage ePackage = M2Element.ePACKAGE;
        EFactory eFactory = ePackage.getEFactoryInstance();
        EObject ret = eFactory.create(eClass);
        assert (Objects.nonNull(ret));
        return ret;
    }

    public static void addNotificationModifier(Object o, MPNotificationModifier adapter) {
        if (!(o instanceof EObject)) {
            return;
        }
        EList as = ((EObject)o).eAdapters();
        if (!as.contains((Object)adapter)) {
            as.add((Object)adapter);
        }
    }

    public static void removeNotificationModifier(Object o, MPNotificationModifier adapter) {
        if (!(o instanceof EObject)) {
            return;
        }
        EList as = ((EObject)o).eAdapters();
        if (as.contains((Object)adapter)) {
            as.remove((Object)adapter);
        }
    }

    public static EObject instantiateLiteral(EObject valueProperty) {
        Out<EClass> eClass = new Out<EClass>();
        Out<EStructuralFeature> feature = new Out<EStructuralFeature>();
        try {
            Util.getPropertyType(valueProperty, eClass, feature);
        }
        catch (MPIllegalStateException e) {
            return null;
        }
        return Util.instantiateEClass(eClass.get());
    }

    public static EObject instantiateLiteralWithDefaultValue(EObject valueProperty, MPBaseAdapter adapter) {
        assert (adapter != null && valueProperty != null);
        EObject defaultValue = (EObject)valueProperty.eGet(M2Element.Property$defaultValue);
        EObject literal = null;
        if (defaultValue != null) {
            EClass eClass = defaultValue.eClass();
            assert (eClass != null);
            literal = Util.instantiateEClass(eClass);
            EStructuralFeature feature = eClassAndFeatureMap.get(eClass);
            assert (feature != null);
            adapter.doSet(literal, feature, defaultValue.eGet(feature), null);
        } else {
            List<EObject> values;
            literal = Util.instantiateLiteral(valueProperty);
            assert (literal != null);
            EClass eClass = literal.eClass();
            EStructuralFeature feature = eClassAndFeatureMap.get(eClass);
            assert (feature != null);
            EObject datatype = (EObject)valueProperty.eGet(M2Element.TypedElement$type);
            if (Util.isInstanceOf(datatype, M2Element.Enumeration) && !(values = Util.getEList(datatype, M2Element.Enumeration$ownedLiteral)).isEmpty()) {
                adapter.doSet(literal, feature, (Object)values.get(0), null);
            }
        }
        return literal;
    }

    private static void getPropertyType(EObject property, Out<EClass> type, Out<EStructuralFeature> feature) throws MPIllegalStateException {
        EObject dataType = (EObject)property.eGet(M2Element.TypedElement$type);
        Util.findValueSpecificationByDataType(dataType, type, feature);
    }

    private static void findValueSpecificationByDataType(EObject dataType, Out<EClass> eClass, Out<EStructuralFeature> feature) throws MPIllegalStateException {
        if (!Util.isInstanceOf(dataType, M2Element.DataType)) {
            eClass.set(M2Element.LiteralString);
            feature.set(M2Element.LiteralString$value);
            return;
        }
        String name = (String)dataType.eGet(M2Element.NamedElement$name);
        EClass eclass = stringToEClassMap.get(name);
        if (eclass != null) {
            eClass.set(eclass);
            feature.set(eClassAndFeatureMap.get(eclass));
        } else if (Util.isInstanceOf(dataType, M2Element.Enumeration)) {
            eClass.set(M2Element.InstanceValue);
            feature.set(M2Element.InstanceValue$instance);
        } else {
            List<EObject> tmp = Util.getEList(dataType, M2Element.Classifier$general);
            if (tmp.isEmpty()) {
                eClass.set(M2Element.LiteralString);
                feature.set(M2Element.LiteralString$value);
                return;
            }
            if (tmp.size() != 1) {
                throw new MPIllegalStateException("Wrong number of basic types were found, MapleMBSE cannot initialize such element automatically.");
            }
            Util.findValueSpecificationByDataType(tmp.get(0), eClass, feature);
        }
    }

    private static boolean isProperty(EObject property) {
        if (!Util.isInstanceOf(property, M2Element.Property)) {
            return false;
        }
        return !Util.isInstanceOf(property, M2Element.Port);
    }

    private static boolean isRightAggregation(EObject property, String kind) {
        return M2Element.AggregationKind.getEEnumLiteral(kind).getInstance().equals(property.eGet(M2Element.Property$aggregation));
    }

    public static boolean isPartProperty(EObject property) {
        if (!Util.isProperty(property)) {
            return false;
        }
        if (property.eGet(M2Element.Property$association) == null) {
            return false;
        }
        if (!Util.isRightAggregation(property, "composite")) {
            return false;
        }
        return Util.isInstanceOf(property.eGet(M2Element.TypedElement$type), M2Element.Class);
    }

    public static boolean isReferenceProperty(EObject property) {
        if (!Util.isProperty(property)) {
            return false;
        }
        if (property.eGet(M2Element.Property$association) == null) {
            return false;
        }
        if (Util.isRightAggregation(property, "composite")) {
            return false;
        }
        return Util.isInstanceOf(property.eGet(M2Element.TypedElement$type), M2Element.Class);
    }

    public static boolean isValueProperty(EObject property) {
        if (!Util.isProperty(property)) {
            return false;
        }
        return property.eGet(M2Element.Property$association) == null;
    }

    public static boolean isConstraintProperty(EObject property) {
        if (!Util.isProperty(property)) {
            return false;
        }
        if (property.eGet(M2Element.Property$association) != null) {
            return false;
        }
        if (!Util.isRightAggregation(property, "composite")) {
            return false;
        }
        return Util.isInstanceOf(property.eGet(M2Element.TypedElement$type), M2Element.Class);
    }

    static {
        stringToEClassMap.put("Boolean", M2Element.LiteralBoolean);
        stringToEClassMap.put("Integer", M2Element.LiteralInteger);
        stringToEClassMap.put("Real", M2Element.LiteralReal);
        stringToEClassMap.put("String", M2Element.LiteralString);
        stringToEClassMap.put("UnlimitedNatural", M2Element.LiteralUnlimitedNatural);
        eClassAndFeatureMap.put(M2Element.LiteralBoolean, M2Element.LiteralBoolean$value);
        eClassAndFeatureMap.put(M2Element.LiteralInteger, M2Element.LiteralInteger$value);
        eClassAndFeatureMap.put(M2Element.LiteralReal, M2Element.LiteralReal$value);
        eClassAndFeatureMap.put(M2Element.LiteralString, M2Element.LiteralString$value);
        eClassAndFeatureMap.put(M2Element.LiteralUnlimitedNatural, M2Element.LiteralUnlimitedNatural$value);
        eClassAndFeatureMap.put(M2Element.InstanceValue, M2Element.InstanceValue$instance);
    }

    public static class Out<T> {
        private T _value = null;

        public T get() {
            return this._value;
        }

        public void set(T value) {
            this._value = value;
        }
    }
}

