/*
 * Decompiled with CFR 0.152.
 */
package com.nomagic.esi.serializer.akka;

import akka.actor.ActorRef;
import akka.actor.ExtendedActorSystem;
import akka.actor.Status;
import akka.serialization.JSerializer;
import com.esotericsoftware.kryo.Serializer;
import com.nomagic.esi.serializer.ClassRegistrarSerializer;
import com.nomagic.esi.serializer.ClassRegistration;
import com.nomagic.esi.serializer.ClassRepository;
import com.nomagic.esi.serializer.ISerializer;
import com.nomagic.esi.serializer.KryoSerializer;
import com.nomagic.esi.serializer.akka.a.a;
import com.typesafe.config.Config;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.None$;
import scala.Some;

public class AkkaSerializer
extends JSerializer {
    private static final Logger LOG = LoggerFactory.getLogger(AkkaSerializer.class);
    private final ExtendedActorSystem actorSystem;
    private final Config config;
    private ClassRegistrarSerializer serializerPool;

    public AkkaSerializer(ExtendedActorSystem extendedActorSystem) {
        try {
            this.actorSystem = extendedActorSystem;
            this.config = this.actorSystem.settings().config();
            this.registerAkkaClasses();
            if (LOG.isDebugEnabled()) {
                LOG.debug(String.format("%s initialized", ((Object)((Object)this)).getClass().getSimpleName()));
            }
        }
        catch (Throwable throwable) {
            LOG.error(String.format("Unable to create %s: %s", ((Object)((Object)this)).getClass().getSimpleName(), throwable.getMessage()), throwable);
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Iterable<ClassRegistration> createSet(Class<?>[] classArray, int n) {
        int n2 = n;
        ArrayList<ClassRegistration> arrayList = new ArrayList<ClassRegistration>(classArray.length);
        Class<?>[] classArray2 = classArray;
        int n3 = classArray.length;
        int n4 = 0;
        while (n4 < n3) {
            Class<?> clazz = classArray2[n4];
            if (clazz != null) {
                arrayList.add(new ClassRegistration(clazz, n2++));
            }
            ++n4;
        }
        return arrayList;
    }

    public Object fromBinaryJava(byte[] byArray, Class<?> clazz) {
        try {
            ISerializer iSerializer = this.getSerializerPool().getSerializer(com.nomagic.esi.common.a.c.a.b);
            return iSerializer.fromBinary(byArray);
        }
        catch (Throwable throwable) {
            block5: {
                block4: {
                    if (clazz != null) break block4;
                    LOG.error("Cannot deserialize bytes on unidentified type: " + throwable.getMessage(), throwable);
                    break block5;
                }
                LOG.error(String.format("Cannot deserialize class %s: %s", clazz, throwable.getMessage()), throwable);
            }
            throw new RuntimeException(throwable);
        }
    }

    public int getIntConfigValue(String string) {
        if (!this.config.hasPath(string)) {
            String string2 = "required configuration parameter missing: " + string;
            LOG.error(string2);
            throw new RuntimeException(string2);
        }
        return this.config.getInt(string);
    }

    public long getLongConfigValue(String string) {
        if (!this.config.hasPath(string)) {
            String string2 = "required configuration parameter missing: " + string;
            LOG.error(string2);
            throw new RuntimeException(string2);
        }
        return this.config.getLong(string);
    }

    private ClassRegistrarSerializer getSerializerPool() {
        if (this.serializerPool == null) {
            this.serializerPool = KryoSerializer.getInstance();
        }
        return this.serializerPool;
    }

    public int identifier() {
        return 256;
    }

    public boolean includeManifest() {
        return false;
    }

    private void registerAkkaClasses() {
        try {
            Class[] classArray = new Class[]{None$.class, Some.class, ActorRef.class, Class.forName("akka.actor.RepointableActorRef")};
            Iterable<ClassRegistration> iterable = this.createSet(classArray, 30);
            ClassRepository.INSTANCE.addRegistrations(iterable);
            ClassRepository.INSTANCE.addClassRegistration(new ClassRegistration(ActorRef.class, 901, (Serializer)new a(this.actorSystem)));
            ClassRepository.INSTANCE.addClassRegistration(new ClassRegistration(Status.Failure.class, -1));
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new RuntimeException(classNotFoundException);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] toBinary(Object object) {
        if (LOG.isTraceEnabled() && object != null) {
            LOG.trace("Serializing: " + object.getClass().getName());
        }
        try {
            ISerializer iSerializer = this.getSerializerPool().getSerializer(com.nomagic.esi.common.a.c.a.b);
            return iSerializer.toBinary(object);
        }
        catch (Throwable throwable) {
            String string2 = object != null ? object.getClass().getName() : "<Null object>";
            LOG.error("Cannot serialize class {}", (Object)string2, (Object)throwable);
            throw new RuntimeException(throwable);
        }
    }
}

