/*
 * Decompiled with CFR 0.152.
 */
package com.nomagic.esi.supervisor;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.Props;
import akka.pattern.Patterns;
import akka.util.Timeout;
import com.nomagic.esi.common.a.h;
import com.nomagic.esi.supervisor.ISupervisorFactory;
import com.nomagic.esi.supervisor.SupervisorActor;
import com.nomagic.esi.supervisor.a.a;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.concurrent.Await;
import scala.concurrent.Awaitable;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;

public class SupervisorFactory
implements ISupervisorFactory {
    private static final Logger LOG = LoggerFactory.getLogger(SupervisorFactory.class);
    private static final String PLUGINS_SUPERVISOR_NAME = "plugins";
    private final ActorSystem actorSystem;
    private volatile ActorRef esiSupervisor;
    private volatile ActorRef pluginSupervisor;

    SupervisorFactory(ActorSystem actorSystem) {
        this.actorSystem = actorSystem;
    }

    private synchronized ActorRef getEsiSupervisor() {
        if (this.esiSupervisor == null) {
            this.esiSupervisor = this.actorSystem.actorOf(Props.create(SupervisorActor.class, (Object[])new Object[0]), "esi");
        }
        return this.esiSupervisor;
    }

    private synchronized ActorRef getPluginSupervisor() {
        if (this.pluginSupervisor == null) {
            this.pluginSupervisor = this.actorSystem.actorOf(Props.create(SupervisorActor.class, (Object[])new Object[0]), PLUGINS_SUPERVISOR_NAME);
        }
        return this.pluginSupervisor;
    }

    @Override
    public ActorRef createEsiRootActor(Props props, String string) {
        return this.createSupervisedActor(this.getEsiSupervisor(), props, string);
    }

    @Override
    public ActorRef createPluginRootActor(Props props, String string) {
        return this.createSupervisedActor(this.getPluginSupervisor(), props, string);
    }

    private ActorRef createSupervisedActor(ActorRef actorRef, Props props, String string) {
        Timeout timeout = new Timeout(h.a, TimeUnit.MILLISECONDS);
        ActorRef actorRef2 = null;
        try {
            Future future = Patterns.ask((ActorRef)actorRef, (Object)new a(props, string), (Timeout)timeout);
            actorRef2 = (ActorRef)Await.result((Awaitable)future, (Duration)timeout.duration());
        }
        catch (Exception exception) {
            LOG.error(exception.getMessage(), (Throwable)exception);
        }
        return actorRef2;
    }
}

